/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.base;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u000f\u001a\u00020\u0006H&J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0004H\u0014J\u0012\u0010\u0017\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u001a\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0012\u0010\u0019\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0012\u0010\u001a\u001a\u00020\u00042\b\b\u0001\u0010\u001b\u001a\u00020\u0006H\u0014J\u0012\u0010\u001a\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0014J \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006 "}, d2={"Lcom/baijiayun/liveuibase/base/BaseScreenActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "addFragment", "", "layoutId", "", "fragment", "Landroidx/fragment/app/Fragment;", "addToBackStack", "", "fragmentTag", "", "tag", "findFragment", "getLayoutId", "hideFragment", "initScreenOrientation", "isDefaultOrientation", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "removeAllFragment", "removeFragment", "replaceFragment", "showFragment", "showToastMessage", "strRes", "message", "switchFragment", "from", "to", "liveuibase_release"})
public abstract class BaseScreenActivity
extends AppCompatActivity {
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.isDefaultOrientation()) {
            this.initScreenOrientation();
        }
        this.setContentView(this.getLayoutId());
    }

    public boolean isDefaultOrientation() {
        return true;
    }

    private final void initScreenOrientation() {
        this.setRequestedOrientation(DisplayUtils.isPad((Context)((Context)this)) ? 0 : 1);
    }

    protected void addFragment(int layoutId, @Nullable Fragment fragment, boolean addToBackStack, @Nullable String fragmentTag) {
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        if (fragmentTag == null) {
            Fragment fragment2 = fragment;
            Intrinsics.checkNotNull((Object)fragment2);
            transaction.add(layoutId, fragment2);
        } else {
            Fragment fragment3 = fragment;
            Intrinsics.checkNotNull((Object)fragment3);
            transaction.add(layoutId, fragment3, fragmentTag);
        }
        transaction.commitAllowingStateLoss();
    }

    protected void addFragment(int layoutId, @Nullable Fragment fragment, boolean addToBackStack) {
        this.addFragment(layoutId, fragment, addToBackStack, null);
    }

    protected void addFragment(int layoutId, @Nullable Fragment fragment, @Nullable String tag) {
        this.addFragment(layoutId, fragment, false, tag);
    }

    protected void addFragment(int layoutId, @Nullable Fragment fragment) {
        this.addFragment(layoutId, fragment, false);
    }

    @Nullable
    protected Fragment findFragment(int layoutId) {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"supportFragmentManager");
        FragmentManager fm = fragmentManager;
        return fm.findFragmentById(layoutId);
    }

    protected void removeFragment(@Nullable Fragment fragment) {
        if (fragment == null) {
            return;
        }
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        transaction.remove(fragment);
        transaction.commitAllowingStateLoss();
    }

    protected void removeAllFragment() {
        for (Fragment fragment : this.getSupportFragmentManager().getFragments()) {
            if (fragment == null) continue;
            this.getSupportFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
    }

    protected void hideFragment(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        if (!fragment.isAdded()) {
            return;
        }
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        transaction.hide(fragment);
        transaction.commitAllowingStateLoss();
    }

    protected void replaceFragment(int layoutId, @Nullable Fragment fragment) {
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        Fragment fragment2 = fragment;
        Intrinsics.checkNotNull((Object)fragment2);
        transaction.replace(layoutId, fragment2);
        transaction.commitAllowingStateLoss();
    }

    protected void showFragment(@Nullable Fragment fragment) {
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        Fragment fragment2 = fragment;
        Intrinsics.checkNotNull((Object)fragment2);
        transaction.show(fragment2);
        transaction.commitAllowingStateLoss();
    }

    protected void switchFragment(@NotNull Fragment from, @NotNull Fragment to, int layoutId) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        if (!to.isAdded()) {
            transaction.hide(from).add(layoutId, to).commit();
        } else {
            transaction.hide(from).show(to).commit();
        }
    }

    protected void showToastMessage(@Nullable String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        this.runOnUiThread(() -> BaseScreenActivity.showToastMessage$lambda$0(this, message));
    }

    protected void showToastMessage(@StringRes int strRes) {
        this.showToastMessage(this.getResources().getString(strRes));
    }

    public abstract int getLayoutId();

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void showToastMessage$lambda$0(BaseScreenActivity this$0, String $message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.isFinishing() || this$0.isDestroyed()) {
            return;
        }
        ToastCompat.showToastCenter((Context)((Context)this$0), (CharSequence)$message, (int)0);
    }
}

