/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.devicetesting;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.media.AudioManager;
import androidx.lifecycle.MutableLiveData;
import com.baijiayun.livecore.network.LPWebServer;
import com.baijiayun.liveuibase.base.BaseViewModel;
import com.baijiayun.liveuibase.devicetesting.DeviceTestingViewModel;
import com.baijiayun.network.model.ProgressModel;
import com.uber.autodispose.AutoDispose;
import com.uber.autodispose.ObservableSubscribeProxy;
import com.uber.autodispose.ScopeProvider;
import io.reactivex.Observable;
import io.reactivex.ObservableConverter;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import java.io.File;
import java.math.BigDecimal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002FGB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0004J\u000e\u0010:\u001a\u0002082\u0006\u0010\u000b\u001a\u00020\fJ \u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020@H\u0002J\f\u0010A\u001a\b\u0012\u0004\u0012\u00020/0\u000eJ\u000e\u0010B\u001a\u0002082\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010C\u001a\u0002082\u0006\u0010D\u001a\u00020/J\u000e\u0010E\u001a\u0002082\u0006\u00109\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0017\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\nR\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\nR!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0013\u001a\u0004\b\u001d\u0010\u0011R\u001a\u0010\u001f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\nR!\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0013\u001a\u0004\b$\u0010\u0011R\u001a\u0010&\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\b\"\u0004\b-\u0010\nR!\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0013\u001a\u0004\b0\u0010\u0011R!\u00102\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0013\u001a\u0004\b3\u0010\u0011R\u000e\u00105\u001a\u000206X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/baijiayun/liveuibase/devicetesting/DeviceTestingViewModel;", "Lcom/baijiayun/liveuibase/base/BaseViewModel;", "()V", "baseUrl", "", "cameraResult", "", "getCameraResult", "()Z", "setCameraResult", "(Z)V", "context", "Landroid/content/Context;", "downloadSpeed", "Landroidx/lifecycle/MutableLiveData;", "", "getDownloadSpeed", "()Landroidx/lifecycle/MutableLiveData;", "downloadSpeed$delegate", "Lkotlin/Lazy;", "earphoneState", "getEarphoneState", "earphoneState$delegate", "isRepeatCheck", "setRepeatCheck", "micResult", "getMicResult", "setMicResult", "netIp", "getNetIp", "netIp$delegate", "netResult", "getNetResult", "setNetResult", "netState", "Lcom/baijiayun/liveuibase/devicetesting/DeviceTestingViewModel$NetState;", "getNetState", "netState$delegate", "netType", "getNetType", "()Ljava/lang/String;", "setNetType", "(Ljava/lang/String;)V", "speakerResult", "getSpeakerResult", "setSpeakerResult", "testStep", "Lcom/baijiayun/liveuibase/devicetesting/DeviceTestingViewModel$TestStep;", "getTestStep", "testStep$delegate", "uploadSpeed", "getUploadSpeed", "uploadSpeed$delegate", "webServer", "Lcom/baijiayun/livecore/network/LPWebServer;", "downloadTest", "", "filePath", "getEarphoneStatus", "getSpeed", "startTime", "", "endTime", "size", "", "getTestStepChange", "setContext", "setTestStep", "step", "uploadNetTest", "NetState", "TestStep", "liveuibase_release"})
public final class DeviceTestingViewModel
extends BaseViewModel {
    @NotNull
    private final String baseUrl;
    private Context context;
    private LPWebServer webServer;
    @NotNull
    private final Lazy uploadSpeed$delegate = LazyKt.lazy((Function0)uploadSpeed.2.INSTANCE);
    @NotNull
    private final Lazy downloadSpeed$delegate = LazyKt.lazy((Function0)downloadSpeed.2.INSTANCE);
    @NotNull
    private final Lazy testStep$delegate = LazyKt.lazy((Function0)testStep.2.INSTANCE);
    @NotNull
    private final Lazy netState$delegate = LazyKt.lazy((Function0)netState.2.INSTANCE);
    @NotNull
    private final Lazy netIp$delegate = LazyKt.lazy((Function0)netIp.2.INSTANCE);
    @NotNull
    private final Lazy earphoneState$delegate = LazyKt.lazy((Function0)earphoneState.2.INSTANCE);
    private boolean netResult = true;
    private boolean cameraResult = true;
    private boolean speakerResult = true;
    private boolean micResult = true;
    @NotNull
    private String netType = "";
    private boolean isRepeatCheck;

    public DeviceTestingViewModel() {
        this.baseUrl = "http://www.baijiayun.com";
    }

    @NotNull
    public final MutableLiveData<Float> getUploadSpeed() {
        Lazy lazy = this.uploadSpeed$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<Float> getDownloadSpeed() {
        Lazy lazy = this.downloadSpeed$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    private final MutableLiveData<TestStep> getTestStep() {
        Lazy lazy = this.testStep$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<NetState> getNetState() {
        Lazy lazy = this.netState$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<String> getNetIp() {
        Lazy lazy = this.netIp$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<Boolean> getEarphoneState() {
        Lazy lazy = this.earphoneState$delegate;
        return (MutableLiveData)lazy.getValue();
    }

    public final boolean getNetResult() {
        return this.netResult;
    }

    public final void setNetResult(boolean bl) {
        this.netResult = bl;
    }

    public final boolean getCameraResult() {
        return this.cameraResult;
    }

    public final void setCameraResult(boolean bl) {
        this.cameraResult = bl;
    }

    public final boolean getSpeakerResult() {
        return this.speakerResult;
    }

    public final void setSpeakerResult(boolean bl) {
        this.speakerResult = bl;
    }

    public final boolean getMicResult() {
        return this.micResult;
    }

    public final void setMicResult(boolean bl) {
        this.micResult = bl;
    }

    @NotNull
    public final String getNetType() {
        return this.netType;
    }

    public final void setNetType(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.netType = string2;
    }

    public final boolean isRepeatCheck() {
        return this.isRepeatCheck;
    }

    public final void setRepeatCheck(boolean bl) {
        this.isRepeatCheck = bl;
    }

    public final void setContext(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.webServer = new LPWebServer(context2, this.baseUrl);
    }

    public final void setTestStep(@NotNull TestStep step) {
        Intrinsics.checkNotNullParameter((Object)((Object)step), (String)"step");
        this.getTestStep().setValue((Object)step);
    }

    @NotNull
    public final MutableLiveData<TestStep> getTestStepChange() {
        return this.getTestStep();
    }

    /*
     * WARNING - void declaration
     */
    public final void uploadNetTest(@NotNull String filePath) {
        void $this$autoDispose$iv;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        long startTime = System.currentTimeMillis();
        Observable observable = Observable.create(arg_0 -> DeviceTestingViewModel.uploadNetTest$lambda$0(filePath, arg_0)).flatMap(arg_0 -> DeviceTestingViewModel.uploadNetTest$lambda$1((Function1)new Function1<File, ObservableSource<? extends String>>(this){
            final /* synthetic */ DeviceTestingViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ObservableSource<? extends String> invoke(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                LPWebServer lPWebServer = DeviceTestingViewModel.access$getWebServer$p(this.this$0);
                if (lPWebServer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webServer");
                    lPWebServer = null;
                }
                return (ObservableSource)lPWebServer.testUploadNetSpeed(file);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"fun uploadNetTest(filePa\u2026e(ip)\n            }\n    }");
        Observable observable2 = observable;
        boolean $i$f$autoDispose = false;
        Object object = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        ((ObservableSubscribeProxy)object).subscribe(arg_0 -> DeviceTestingViewModel.uploadNetTest$lambda$2((Function1)new Function1<String, Unit>(this, startTime){
            final /* synthetic */ DeviceTestingViewModel this$0;
            final /* synthetic */ long $startTime;
            {
                this.this$0 = $receiver;
                this.$startTime = $startTime;
                super(1);
            }

            public final void invoke(String ip) {
                long endTime = System.currentTimeMillis();
                this.this$0.getUploadSpeed().postValue((Object)Float.valueOf(DeviceTestingViewModel.access$getSpeed(this.this$0, this.$startTime, endTime, 10)));
                this.this$0.getNetIp().postValue((Object)ip);
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void downloadTest(@NotNull String filePath) {
        void $this$autoDispose$iv;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        String url = this.baseUrl + "/appapi/detection/download?size=26214400";
        long startTime = System.currentTimeMillis();
        LPWebServer lPWebServer = this.webServer;
        if (lPWebServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webServer");
            lPWebServer = null;
        }
        Observable observable = lPWebServer.downloadFile(url, file).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"webServer.downloadFile(u\u2026dSchedulers.mainThread())");
        Observable observable2 = observable;
        boolean $i$f$autoDispose = false;
        Object object = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        ((ObservableSubscribeProxy)object).subscribe(arg_0 -> DeviceTestingViewModel.downloadTest$lambda$3((Function1)new Function1<ProgressModel, Unit>(this, startTime){
            final /* synthetic */ DeviceTestingViewModel this$0;
            final /* synthetic */ long $startTime;
            {
                this.this$0 = $receiver;
                this.$startTime = $startTime;
                super(1);
            }

            public final void invoke(ProgressModel progressModel) {
                if (progressModel.isComplete()) {
                    long endTime = System.currentTimeMillis();
                    this.this$0.getDownloadSpeed().postValue((Object)Float.valueOf(DeviceTestingViewModel.access$getSpeed(this.this$0, this.$startTime, endTime, 25)));
                }
            }
        }, arg_0));
    }

    private final float getSpeed(long startTime, long endTime, int size) {
        long sumTime = RangesKt.coerceAtLeast((long)((endTime - startTime) / (long)1000), (long)1L);
        int total = size * 1024 * 1024 * 8;
        long speed = (long)total / sumTime / (long)1000000;
        BigDecimal bigDecimal = new BigDecimal(speed);
        return bigDecimal.setScale(2).floatValue();
    }

    public final void getEarphoneStatus(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = context2.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        AudioManager audioManager = (AudioManager)object;
        if (audioManager.isWiredHeadsetOn()) {
            this.getEarphoneState().setValue((Object)true);
        }
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
        BluetoothAdapter bluetoothAdapter2 = bluetoothAdapter;
        if (bluetoothAdapter2.isEnabled()) {
            int a2dp = bluetoothAdapter2.getProfileConnectionState(2);
            int headset = bluetoothAdapter2.getProfileConnectionState(1);
            int health = bluetoothAdapter2.getProfileConnectionState(3);
            int flag = -1;
            if (a2dp == 2) {
                flag = a2dp;
            } else if (headset == 2) {
                flag = headset;
            } else if (health == 2) {
                flag = health;
            }
            if (flag != -1) {
                this.getEarphoneState().setValue((Object)true);
            }
        }
        this.getEarphoneState().setValue((Object)false);
    }

    private static final void uploadNetTest$lambda$0(String $filePath, ObservableEmitter it) {
        Intrinsics.checkNotNullParameter((Object)$filePath, (String)"$filePath");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        File file = new File($filePath);
        if (!file.exists()) {
            BufferedSink sink = Okio.buffer((Sink)Okio.sink$default((File)file, (boolean)false, (int)1, null));
            byte[] byteArray = new byte[8192];
            int fileSizeInBytes = 0xA00000;
            for (int bytesWritten = 0; bytesWritten < fileSizeInBytes; bytesWritten += byteArray.length) {
                sink.write(byteArray);
            }
            sink.close();
        }
        it.onNext((Object)file);
    }

    private static final ObservableSource uploadNetTest$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ObservableSource)$tmp0.invoke(p0);
    }

    private static final void uploadNetTest$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void downloadTest$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ LPWebServer access$getWebServer$p(DeviceTestingViewModel $this) {
        return $this.webServer;
    }

    public static final /* synthetic */ float access$getSpeed(DeviceTestingViewModel $this, long startTime, long endTime, int size) {
        return $this.getSpeed(startTime, endTime, size);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/baijiayun/liveuibase/devicetesting/DeviceTestingViewModel$TestStep;", "", "(Ljava/lang/String;I)V", "Start", "TestCamera", "TestSpeaker", "TestMic", "TestEnd", "liveuibase_release"})
    public static final class TestStep
    extends Enum<TestStep> {
        public static final /* enum */ TestStep Start = new TestStep();
        public static final /* enum */ TestStep TestCamera = new TestStep();
        public static final /* enum */ TestStep TestSpeaker = new TestStep();
        public static final /* enum */ TestStep TestMic = new TestStep();
        public static final /* enum */ TestStep TestEnd = new TestStep();
        private static final /* synthetic */ TestStep[] $VALUES;

        public static TestStep[] values() {
            return (TestStep[])$VALUES.clone();
        }

        public static TestStep valueOf(String value) {
            return Enum.valueOf(TestStep.class, value);
        }

        static {
            $VALUES = testStepArray = new TestStep[]{TestStep.Start, TestStep.TestCamera, TestStep.TestSpeaker, TestStep.TestMic, TestStep.TestEnd};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/baijiayun/liveuibase/devicetesting/DeviceTestingViewModel$NetState;", "", "(Ljava/lang/String;I)V", "None", "Wifi", "Mobile", "liveuibase_release"})
    public static final class NetState
    extends Enum<NetState> {
        public static final /* enum */ NetState None = new NetState();
        public static final /* enum */ NetState Wifi = new NetState();
        public static final /* enum */ NetState Mobile = new NetState();
        private static final /* synthetic */ NetState[] $VALUES;

        public static NetState[] values() {
            return (NetState[])$VALUES.clone();
        }

        public static NetState valueOf(String value) {
            return Enum.valueOf(NetState.class, value);
        }

        static {
            $VALUES = netStateArray = new NetState[]{NetState.None, NetState.Wifi, NetState.Mobile};
        }
    }
}

