/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.chat.messagesend;

import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPExpressionModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livecore.models.LPMessageAtUserModel;
import com.baijiayun.livecore.models.LPMessageReferenceModel;
import com.baijiayun.liveuibase.chat.messagesend.MessageSendContract;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageSendPresenter
implements MessageSendContract.Presenter {
    private MessageSendContract.View view;
    private RouterViewModel routerViewModel;
    private Map<String, LPExpressionModel> emojiMap;
    private Disposable disposableOfQuickReply;

    public MessageSendPresenter(MessageSendContract.View view) {
        this.view = view;
    }

    public void setView(MessageSendContract.View view) {
        this.view = view;
    }

    @Override
    public void sendMessage(String message, LPMessageReferenceModel referenceModel, Set<LPMessageAtUserModel> atUserList) {
        this.routerViewModel.getLiveRoom().getChatVM().sendMessage(message, referenceModel, atUserList);
        this.view.showMessageSuccess();
    }

    @Override
    public void sendEmoji(String emoji, LPMessageReferenceModel referenceModel, Set<LPMessageAtUserModel> atUserList) {
        this.routerViewModel.getLiveRoom().getChatVM().sendEmojiMessage(emoji, referenceModel, atUserList);
        this.view.showMessageSuccess();
    }

    @Override
    public void sendPicture(String path) {
        this.routerViewModel.getSendPictureMessage().setValue((Object)path);
        this.view.onPictureSend();
    }

    @Override
    public void sendMessageToUser(String message) {
        IUserModel toUser = this.getPrivateChatUser();
        this.routerViewModel.getLiveRoom().getChatVM().sendMessageToUser(toUser, message);
        this.view.showMessageSuccess();
    }

    @Override
    public void sendEmojiToUser(String emoji) {
        IUserModel toUser = this.getPrivateChatUser();
        this.routerViewModel.getLiveRoom().getChatVM().sendEmojiMessageToUser(toUser, emoji);
        this.view.showMessageSuccess();
    }

    @Override
    public void chooseEmoji() {
        this.view.showEmojiPanel();
    }

    @Override
    public void choosePrivateChatUser() {
        this.view.showPrivateChatUserPanel();
    }

    @Override
    public IUserModel getPrivateChatUser() {
        return (IUserModel)this.routerViewModel.getPrivateChatUser().getValue();
    }

    @Override
    public LPExpressionModel getSingleEmoji(String emojiName) {
        return this.emojiMap.get(emojiName);
    }

    @Override
    public void getChatQuickReplyList() {
        this.disposableOfQuickReply = this.routerViewModel.getLiveRoom().getChatVM().getObservableOfChatQuickReplyList().observeOn(AndroidSchedulers.mainThread()).subscribe(result -> this.view.setChatQuickReplyList((List<String>)result), throwable -> {});
    }

    @Override
    public boolean isPrivateChat() {
        return this.routerViewModel.getPrivateChatUser().getValue() != null;
    }

    @Override
    public boolean isLiveCanWhisper() {
        return this.routerViewModel.getLiveRoom().getChatVM().canWhisper();
    }

    @Override
    public boolean useSecretMsgSendForbid() {
        return this.routerViewModel.liveRoom.getPartnerConfig().useSecretMsgSendForbid;
    }

    @Override
    public boolean isAllForbidden() {
        return !this.routerViewModel.getLiveRoom().isTeacherOrAssistant() && !this.routerViewModel.getLiveRoom().isGroupTeacherOrAssistant() && this.routerViewModel.getLiveRoom().getChatVM().isChatForbidden();
    }

    @Override
    public boolean canWisperTeacherInForbidAllMode() {
        if (this.routerViewModel.getLiveRoom().isTeacherOrAssistant() || this.routerViewModel.getLiveRoom().isGroupTeacherOrAssistant()) {
            return true;
        }
        return this.routerViewModel.getLiveRoom().getPartnerConfig().canWisperTeacherInForbidAllMode == 1;
    }

    @Override
    public boolean canSendPicture() {
        if (this.routerViewModel.getLiveRoom().isTeacherOrAssistant() || this.routerViewModel.getLiveRoom().isGroupTeacherOrAssistant()) {
            return !this.routerViewModel.getLiveRoom().getPartnerConfig().disableLiveChatImage;
        }
        if (this.routerViewModel.getLiveRoom().getRoomInfo().roomType != LPConstants.LPRoomType.Multi) {
            return !this.routerViewModel.getLiveRoom().getPartnerConfig().disableLiveChatImage;
        }
        return false;
    }

    @Override
    public void setRouter(RouterViewModel routerViewModel2) {
        this.routerViewModel = routerViewModel2;
        this.initEmoji();
    }

    @Override
    public RouterViewModel getRouter() {
        return this.routerViewModel;
    }

    private void initEmoji() {
        this.emojiMap = new HashMap<String, LPExpressionModel>();
        List expressions = this.routerViewModel.getLiveRoom().getExpressions();
        for (LPExpressionModel lpExpressionModel : expressions) {
            this.emojiMap.put(lpExpressionModel.getBoxName(), lpExpressionModel);
        }
    }

    public void subscribe() {
    }

    public void unSubscribe() {
    }

    public void destroy() {
        RxUtils.dispose((Disposable)this.disposableOfQuickReply);
        this.routerViewModel = null;
        this.view = null;
    }

    public void onPrivateChatUserChange() {
        if (this.view != null) {
            this.view.showPrivateChatChange();
        }
    }
}

