/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.base;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.base.RouterListener;

public abstract class BaseTitleWindow
extends BaseWindow {
    protected ConstraintLayout clTitleContainer;
    protected RelativeLayout clContentContainer;
    protected ImageView ivTitleIcon;
    protected TextView tvTitleName;
    protected ImageView ivTitleClose;

    public BaseTitleWindow(Context context2) {
        super(context2);
        this.initView();
        this.onCreateTopView(this.context);
        this.onCreateContentView(this.context);
        this.initTitleContainer();
    }

    protected void initTitleContainer() {
        this.ivTitleIcon = (ImageView)this.view.findViewById(R.id.base_window_title_icon);
        this.ivTitleClose = (ImageView)this.view.findViewById(R.id.base_window_title_close);
        this.tvTitleName = (TextView)this.view.findViewById(R.id.base_window_title_name);
        this.ivTitleClose.setOnClickListener(v -> this.onCloseWindow());
    }

    private void initView() {
        this.clTitleContainer = (ConstraintLayout)this.view.findViewById(R.id.uibase_window_title_container);
        this.clContentContainer = (RelativeLayout)this.view.findViewById(R.id.uibase_window_content_container);
    }

    @Override
    protected View onCreateView(Context context2) {
        this.setNeedShowShadow(true);
        View view = View.inflate((Context)context2, (int)R.layout.uibase_window_common_layout, null);
        view.setBackground(ThemeDataUtil.getCommonWindowBg((Context)context2));
        return view;
    }

    protected void onCreateTopView(Context context2) {
        LayoutInflater.from((Context)context2).inflate(R.layout.uibase_window_common_title_layout, (ViewGroup)this.clTitleContainer);
    }

    protected abstract void onCreateContentView(Context var1);

    protected abstract void onCloseWindow();

    public void setRouterListener(RouterListener routerListener2) {
        this.routerListener = routerListener2;
    }

    public void setTitle(String name) {
        if (this.tvTitleName != null) {
            this.tvTitleName.setText((CharSequence)name);
        }
    }

    public void setIcon(Drawable iconDrawable) {
        if (this.ivTitleIcon != null) {
            this.ivTitleIcon.setImageDrawable(iconDrawable);
        }
    }
}

