/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.loading;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import androidx.annotation.RequiresApi;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;

public class ProgressBarWithNumber
extends ProgressBar {
    private static final int TEXT_SIZE_IN_SP = 14;
    private static final int DEFAULT_PADDING_TOP_IN_DP = 20;
    private static final int DEFAULT_PADDING_IN_DP = 20;
    private static final int DEFAULT_TRIANGLE_HEIGHT = 3;
    private static final int DEFAULT_TRIANGLE_HALF_WIDTH = 3;
    protected Paint mTextPaint;
    protected Paint trianglePaint;
    private int padding;
    private int triangleH;
    private int triangleHalfW;
    private Path trianglePath;

    public ProgressBarWithNumber(Context context2, AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public ProgressBarWithNumber(Context context2, AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public ProgressBarWithNumber(Context context2, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context2, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize((float)DisplayUtils.sp2px((Context)this.getContext(), (float)14.0f));
        this.padding = UtilsKt.getDp((int)20);
        this.setPadding(this.padding, UtilsKt.getDp((int)20), this.padding, 0);
        this.trianglePaint = new Paint();
        this.trianglePaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
        this.trianglePaint.setAntiAlias(true);
        this.trianglePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.triangleH = UtilsKt.getDp((int)3);
        this.triangleHalfW = UtilsKt.getDp((int)3);
        this.trianglePath = new Path();
        this.setLayerType(1, this.mTextPaint);
        this.setLayerType(1, this.trianglePaint);
        LayerDrawable layerDrawable = (LayerDrawable)this.getProgressDrawable();
        Drawable progressDrawable = layerDrawable.findDrawableByLayerId(16908301);
        Drawable secondProgressDrawable = layerDrawable.findDrawableByLayerId(16908303);
        int productColor = ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color);
        progressDrawable.setColorFilter(productColor, PorterDuff.Mode.SRC_IN);
        secondProgressDrawable.setColorFilter(productColor, PorterDuff.Mode.SRC_IN);
    }

    protected void onDraw(Canvas canvas) {
        float percent = (float)this.getProgress() * 1.0f / (float)this.getMax();
        String text = this.getProgress() + "%";
        float textWidth = this.mTextPaint.measureText(text);
        float textHeight = this.mTextPaint.descent() + this.mTextPaint.ascent();
        float progressedLength = (float)(this.getWidth() - 2 * this.padding) * percent;
        float x = progressedLength + (float)this.padding - 0.5f * textWidth;
        canvas.drawText(text, x, -textHeight + 2.0f, this.mTextPaint);
        float trianglePadding = this.getHeight() - 2 * this.triangleH;
        this.trianglePath.reset();
        this.trianglePath.moveTo(progressedLength + (float)this.padding, trianglePadding);
        this.trianglePath.lineTo(progressedLength + (float)this.padding - (float)this.triangleHalfW, trianglePadding - (float)this.triangleH);
        this.trianglePath.lineTo(progressedLength + (float)this.padding + (float)this.triangleHalfW, trianglePadding - (float)this.triangleH);
        this.trianglePath.lineTo(progressedLength + (float)this.padding, trianglePadding);
        this.trianglePath.close();
        canvas.drawPath(this.trianglePath, this.trianglePaint);
        super.onDraw(canvas);
    }

    public void setDescColor(String color2) {
        if (TextUtils.isEmpty((CharSequence)color2)) {
            this.mTextPaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
            this.trianglePaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
        } else {
            try {
                this.mTextPaint.setColor(Color.parseColor((String)color2));
                this.trianglePaint.setColor(Color.parseColor((String)color2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setProgressBarColor(String color2) {
        if (!TextUtils.isEmpty((CharSequence)color2)) {
            LayerDrawable layerDrawable = (LayerDrawable)this.getProgressDrawable();
            Drawable progressDrawable = layerDrawable.findDrawableByLayerId(16908301);
            Drawable secondProgressDrawable = layerDrawable.findDrawableByLayerId(16908303);
            progressDrawable.setColorFilter(Color.parseColor((String)color2), PorterDuff.Mode.SRC_IN);
            secondProgressDrawable.setColorFilter(Color.parseColor((String)color2), PorterDuff.Mode.SRC_IN);
        }
    }
}

