/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.ppt;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.window.ppt.PPTWindow;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.liveuibase.toolbox.browser.Tuple;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public class PPTTabLayer
extends BaseLayerOfProfessionalClass {
    private Drawable tabSelectedDrawable;
    private final Context context;
    private static final int TAB_WIDTH = 200;
    protected Drawable fullDrawable;
    protected Drawable fullResetDrawable;
    protected Drawable maxResetDrawable;
    private ImageView ivMaxFull;
    private ImageView ivMaxSync;

    public PPTTabLayer(@NotNull Context context) {
        this(context, null);
    }

    public PPTTabLayer(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PPTTabLayer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    public PPTTabLayer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.context = context;
    }

    private void initDrawables() {
        this.fullDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_title_full_to_full_layer);
        this.fullResetDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_title_full_reset_to_sync_layer);
        this.maxResetDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_title_max_reset_to_sync_layer);
    }

    @Override
    protected boolean isDestroyRouter() {
        return false;
    }

    public void refreshTabs() {
        if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
            return;
        }
        View rootView = View.inflate((Context)this.context, (int)R.layout.bjy_group_layout_ppt_tab, null);
        this.ivMaxFull = (ImageView)rootView.findViewById(R.id.window_titled_max_in_full_layer);
        this.ivMaxSync = (ImageView)rootView.findViewById(R.id.window_titled_max_in_sync_layer);
        LinearLayout titleContainer = (LinearLayout)rootView.findViewById(R.id.window_titled_title_container);
        this.removeAllViews();
        titleContainer.removeAllViews();
        ConcurrentLinkedQueue<PPTWindow> cacheWindows = this.router.getQueueByKey(EventKey.PPTWindows, PPTWindow.class);
        if (cacheWindows == null || cacheWindows.isEmpty()) {
            this.setVisibility(8);
            return;
        }
        PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
        if (fullPPTWindow == null && maxPPTWindow == null) {
            for (PPTWindow pptWindow : cacheWindows) {
                pptWindow.showTitle();
            }
            this.setVisibility(8);
            return;
        }
        ArrayList<PPTWindow> pptWindows = new ArrayList<PPTWindow>(cacheWindows);
        if (pptWindows.size() == 1) {
            PPTWindow pptWindow = (PPTWindow)pptWindows.get(0);
            if (pptWindow != null) {
                pptWindow.showTitle();
            }
            this.setVisibility(8);
            return;
        }
        for (PPTWindow pptWindow : pptWindows) {
            pptWindow.hideTitle();
        }
        this.setVisibility(0);
        if (this.tabSelectedDrawable == null) {
            this.tabSelectedDrawable = new DrawableBuilder().solidColor(1714501703).cornerRadii(UtilsKt.getDp((int)6), UtilsKt.getDp((int)6), 0, 0).build();
        }
        int count = pptWindows.size();
        int fullScreenWidth = this.router.getValueByKey(EventKey.FullScreenWidth, Integer.class, 0);
        int measuredWidth = fullScreenWidth - UtilsKt.getDp((int)100);
        int destWidth = UtilsKt.getDp((int)200);
        if (measuredWidth != 0 && destWidth * count > measuredWidth) {
            destWidth = measuredWidth / count;
        }
        int index = 0;
        View lastDiv = null;
        PPTWindow selectedPPTWindow = fullPPTWindow != null ? fullPPTWindow : maxPPTWindow;
        this.refreshBtn(fullPPTWindow != null);
        for (PPTWindow pptWindow : pptWindows) {
            View tab = View.inflate((Context)this.context, (int)R.layout.bjy_group_item_ppt_title, null);
            if (index == count - 1) {
                tab.findViewById(R.id.view_div).setVisibility(4);
            }
            if (pptWindow == selectedPPTWindow && (selectedPPTWindow.isMaxInSync() || selectedPPTWindow.isMaxInFull())) {
                tab.findViewById(R.id.view_div).setVisibility(4);
                if (lastDiv != null) {
                    lastDiv.setVisibility(4);
                }
                tab.setBackground(this.tabSelectedDrawable);
            } else {
                tab.setBackground(null);
            }
            ((TextView)tab.findViewById(R.id.tv_title)).setText((CharSequence)pptWindow.getDocName());
            tab.findViewById(R.id.iv_close).setOnClickListener(v -> {
                if (pptWindow.isMaxInSync() || pptWindow.isMaxInFull()) {
                    if (pptWindows.isEmpty() || pptWindows.size() <= 1) {
                        return;
                    }
                    ArrayList tempWindows = new ArrayList(pptWindows);
                    if (tempWindows.remove(pptWindow)) {
                        PPTWindow destPPTWindow = (PPTWindow)tempWindows.get(tempWindows.size() - 1);
                        if (destPPTWindow == pptWindow) {
                            return;
                        }
                        pptWindow.switchTab(destPPTWindow);
                    }
                }
                this.router.getSubjectByKey(EventKey.ClosePPTWindow).onNext((Object)new Tuple(pptWindow.getId()));
            });
            tab.setOnClickListener(v -> selectedPPTWindow.switchTab(pptWindow));
            titleContainer.addView(tab, destWidth, -1);
            lastDiv = tab.findViewById(R.id.view_div);
            ++index;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, UtilsKt.getDp((int)30));
        layoutParams.gravity = 48;
        this.addView(rootView, (ViewGroup.LayoutParams)layoutParams);
        this.ivMaxFull.setOnClickListener(v -> {
            selectedPPTWindow.setReceiveOrder(false);
            if (selectedPPTWindow.isMaxInFull()) {
                selectedPPTWindow.resetInFull();
            } else {
                selectedPPTWindow.maxInFull();
            }
        });
        this.ivMaxSync.setOnClickListener(v -> {
            selectedPPTWindow.setReceiveOrder(false);
            selectedPPTWindow.resetInSync();
        });
    }

    public void refreshBtn(boolean isFull) {
        if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
            return;
        }
        if (this.fullDrawable == null) {
            this.initDrawables();
        }
        if (isFull) {
            if (this.ivMaxSync != null) {
                this.ivMaxSync.setVisibility(4);
                this.ivMaxFull.setImageDrawable(this.fullResetDrawable);
            }
        } else if (this.ivMaxSync != null) {
            this.ivMaxSync.setVisibility(0);
            this.ivMaxSync.setImageDrawable(this.maxResetDrawable);
            this.ivMaxFull.setImageDrawable(this.fullDrawable);
        }
    }

    public void show(boolean isShow) {
        ConcurrentLinkedQueue<PPTWindow> cacheWindows = this.router.getQueueByKey(EventKey.PPTWindows, PPTWindow.class);
        if (cacheWindows == null || cacheWindows.isEmpty()) {
            this.setVisibility(8);
            return;
        }
        PPTWindow fullPPTWindow = this.router.getValueByKey(EventKey.FullScreenPPTWindow, PPTWindow.class);
        PPTWindow maxPPTWindow = this.router.getValueByKey(EventKey.MaxScreenPPTWindow, PPTWindow.class);
        if (fullPPTWindow == null && maxPPTWindow == null) {
            this.setVisibility(8);
            return;
        }
        this.setVisibility(isShow ? 0 : 8);
    }
}

