/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.multiupload;

import android.content.Context;
import android.text.InputFilter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiahulian.common.cropperv2.BJCommonImageCropHelper;
import com.baijiahulian.common.cropperv2.ThemeConfig;
import com.baijiahulian.common.cropperv2.model.PhotoInfo;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.multiupload.GridSpacingItemDecoration;
import com.baijiayun.groupclassui.window.multiupload.IMultiUploadListener;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.chat.LengthFilter;
import java.util.ArrayList;
import java.util.List;

public class MultiUploadWindow
extends InteractiveBaseWindow
implements IMultiUploadListener {
    private static final int LENGTH_LIMIT = 300;
    private ImgAdapter imgAdapter;
    private boolean isUploaded = false;
    private int imgCountLimit = 5;

    public MultiUploadWindow(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        RecyclerView recyclerView = (RecyclerView)this.$.id(R.id.recycler_view).view();
        this.imgAdapter = new ImgAdapter();
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.context, this.imgCountLimit));
        recyclerView.setAdapter((RecyclerView.Adapter)this.imgAdapter);
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.imgCountLimit, UtilsKt.getDp((int)6), false));
        EditText editText = (EditText)this.$.id(R.id.et_question).view();
        LengthFilter lengthFilter = new LengthFilter(this.context, 300);
        lengthFilter.setTip(this.context.getString(R.string.bjysc_enter_limit_less, new Object[]{300}));
        editText.setFilters(new InputFilter[]{lengthFilter});
    }

    public void showTitle(boolean showTitle) {
        this.$.id(R.id.title_container).visibility(showTitle ? 0 : 8);
    }

    public void showTitleIcon(boolean show) {
        this.$.id(R.id.tv_title_new).visibility(show ? 0 : 8);
    }

    public void setTitle(String title) {
        this.$.id(R.id.tv_title).text((CharSequence)title);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    protected View onCreateView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjysc_window_upload_multi, null);
    }

    @Override
    public String getContent() {
        return ((TextView)this.$.id(R.id.et_question).view()).getText().toString();
    }

    @Override
    public void setContent(String content) {
        this.$.id(R.id.et_question).text((CharSequence)content);
        this.$.id(R.id.tv_question).text((CharSequence)content);
    }

    @Override
    public List<String> getLocalImgPaths() {
        return this.imgAdapter.getLocalImgPaths();
    }

    @Override
    public List<String> getRemoteImgPaths() {
        return this.imgAdapter.getRemoteImgPaths();
    }

    @Override
    public void setRemoteImgPaths(List<String> imgPaths) {
        if (imgPaths == null || imgPaths.isEmpty()) {
            if (this.getLocalImgPaths() == null || this.getLocalImgPaths().isEmpty()) {
                this.$.id(R.id.recycler_view).gone();
            }
            this.imgAdapter.setRemoteData(new ArrayList<String>());
            return;
        }
        this.imgAdapter.setRemoteData(imgPaths);
    }

    @Override
    public void refresh() {
        this.$.id(R.id.recycler_view).visible();
        this.imgAdapter.notifyDataSetChanged();
    }

    @Override
    public void setUploaded(boolean isUploaded) {
        this.setUploaded(isUploaded, false);
    }

    @Override
    public void setUploaded(boolean isUploaded, boolean isFillParent) {
        this.isUploaded = isUploaded;
        if (isUploaded) {
            if (isFillParent) {
                this.$.id(R.id.et_question).visible().enable(false);
                this.$.id(R.id.tv_question).gone();
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.$.id(R.id.recycler_view).view().getLayoutParams();
                layoutParams.topToBottom = -1;
                layoutParams.bottomToBottom = 0;
            } else {
                this.$.id(R.id.et_question).gone();
                this.$.id(R.id.tv_question).visible();
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.$.id(R.id.recycler_view).view().getLayoutParams();
                layoutParams.bottomToBottom = -1;
                layoutParams.topToBottom = R.id.tv_question;
            }
        } else {
            this.$.id(R.id.et_question).visible().enable(true);
            this.$.id(R.id.tv_question).gone();
            ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.$.id(R.id.recycler_view).view().getLayoutParams();
            layoutParams.topToBottom = -1;
            layoutParams.bottomToBottom = 0;
        }
    }

    @Override
    public void setImgCountLimit(int imgCountLimit) {
        this.imgCountLimit = imgCountLimit;
    }

    static class AddViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivAdd;

        public AddViewHolder(@NonNull View itemView) {
            super(itemView);
            this.ivAdd = (ImageView)itemView.findViewById(R.id.iv_add);
        }
    }

    static class ImgViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivDelete;
        ImageView ivSrc;

        public ImgViewHolder(@NonNull View itemView) {
            super(itemView);
            this.ivDelete = (ImageView)itemView.findViewById(R.id.iv_delete);
            this.ivSrc = (ImageView)itemView.findViewById(R.id.iv);
        }
    }

    class ImgAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private final List<String> imgPaths = new ArrayList<String>();
        private final List<String> localImgPaths = new ArrayList<String>();
        private List<String> remoteImgPaths = new ArrayList<String>();
        private static final int VIEW_TYPE_IMG = 1;
        private static final int VIEW_TYPE_ADD = 2;

        ImgAdapter() {
        }

        public void setRemoteData(List<String> remoteImgPaths) {
            this.imgPaths.clear();
            this.localImgPaths.clear();
            this.remoteImgPaths = remoteImgPaths;
            this.imgPaths.addAll(remoteImgPaths);
            this.notifyDataSetChanged();
        }

        public List<String> getLocalImgPaths() {
            return this.localImgPaths;
        }

        public List<String> getRemoteImgPaths() {
            return this.remoteImgPaths;
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            if (viewType == 1) {
                View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjysc_item_img_upload, parent, false);
                DisplayUtils.setRoundCorner((View)view, (float)MultiUploadWindow.this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
                return new ImgViewHolder(view);
            }
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjysc_item_img_add, parent, false);
            DisplayUtils.setRoundCorner((View)view, (float)MultiUploadWindow.this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
            return new AddViewHolder(view);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            if (holder instanceof ImgViewHolder) {
                ImgViewHolder imgViewHolder = (ImgViewHolder)holder;
                String url = this.imgPaths.get(position);
                Glide.with((Context)MultiUploadWindow.this.context).load(url).into(imgViewHolder.ivSrc);
                imgViewHolder.ivDelete.setVisibility(MultiUploadWindow.this.isUploaded ? 4 : 0);
                imgViewHolder.ivDelete.setOnClickListener(v -> {
                    this.imgPaths.remove(url);
                    this.localImgPaths.remove(url);
                    this.remoteImgPaths.remove(url);
                    this.notifyDataSetChanged();
                });
                imgViewHolder.ivSrc.setOnClickListener(v -> MultiUploadWindow.this.iRouter.getSubjectByKey(EventKey.DisplayImgPreview).onNext((Object)url));
            } else {
                AddViewHolder addViewHolder = (AddViewHolder)holder;
                addViewHolder.ivAdd.setOnClickListener(v -> {
                    ThemeConfig.Builder builder = new ThemeConfig.Builder();
                    builder.setScreenOrientation(0).setMainElementsColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)MultiUploadWindow.this.context, (int)R.attr.base_theme_live_product_color));
                    BJCommonImageCropHelper.openImageMulti((Context)MultiUploadWindow.this.context, (int)(MultiUploadWindow.this.imgCountLimit - this.imgPaths.size()), (ThemeConfig)builder.build(), (BJCommonImageCropHelper.OnHandlerResultCallback)new BJCommonImageCropHelper.OnHandlerResultCallback(){

                        public void onHandlerSuccess(List<PhotoInfo> list) {
                            for (PhotoInfo photoInfo : list) {
                                ImgAdapter.this.localImgPaths.add(photoInfo.getPhotoPath());
                                ImgAdapter.this.imgPaths.add(photoInfo.getPhotoPath());
                            }
                            ImgAdapter.this.notifyDataSetChanged();
                        }

                        public void onHandlerFailure(String s) {
                            MultiUploadWindow.this.showToastMessage(s);
                        }
                    });
                });
            }
        }

        public int getItemCount() {
            int count = MultiUploadWindow.this.isUploaded ? this.imgPaths.size() : (this.imgPaths.isEmpty() ? 1 : (this.imgPaths.size() < MultiUploadWindow.this.imgCountLimit ? this.imgPaths.size() + 1 : MultiUploadWindow.this.imgCountLimit));
            return count;
        }

        public int getItemViewType(int position) {
            if (position < this.imgPaths.size()) {
                return 1;
            }
            return 2;
        }
    }
}

