/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.group;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.view.GestureDetectorCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.base.BaseRecyclerAdapter;
import com.baijiayun.groupclassui.base.BaseViewHolder;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import java.util.ArrayList;
import java.util.List;

public class UngroupUserAdapter
extends BaseRecyclerAdapter<IUserModel> {
    private static final String TAG = BaseRecyclerAdapter.class.getCanonicalName();
    private OnUserEventListener mOnUserEventListener;
    private List<IUserModel> mSelectedUser = new ArrayList<IUserModel>();
    private SparseBooleanArray selectedStateArray = new SparseBooleanArray();

    public UngroupUserAdapter(Context context) {
        super(context, R.layout.item_group_window_user);
    }

    @Override
    @NonNull
    public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_group_window_user, parent, false);
        Drawable selectedDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.mContext, (int)R.attr.base_theme_window_bg_color)).cornerRadius(this.mContext.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
        Drawable normalDrawable = new DrawableBuilder().solidColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.bjysc_transparent)).build();
        view.findViewById(R.id.item_group_user_root_container).setBackground((Drawable)new StateListDrawableBuilder().normal(normalDrawable).selected(selectedDrawable).build());
        return new BaseViewHolder(this.mContext, view);
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void convert(BaseViewHolder holder, IUserModel groupUser) {
        View view = holder.getRootView();
        view.setSelected(this.selectedStateArray.get(holder.getAdapterPosition()));
        UserListGestureListener gestureListener = new UserListGestureListener(view, holder.getAdapterPosition());
        GestureDetectorCompat gestureDetectorCompat = new GestureDetectorCompat(this.mContext.getApplicationContext(), (GestureDetector.OnGestureListener)gestureListener);
        view.setOnTouchListener((v, event) -> {
            gestureDetectorCompat.onTouchEvent(event);
            return true;
        });
        holder.setText(R.id.item_group_window_tv_name, UtilsKt.getEncodePhoneNumber((String)groupUser.getName()));
        Glide.with((Context)this.mContext.getApplicationContext()).load(groupUser.getAvatar()).apply(RequestOptions.circleCropTransform()).into((ImageView)holder.getView(R.id.item_group_window_iv_head));
    }

    @Override
    protected boolean isEnableListener() {
        return false;
    }

    public void setOnUserEventListener(OnUserEventListener onUserLongClickListener) {
        this.mOnUserEventListener = onUserLongClickListener;
    }

    public void clearSelectState() {
        this.mSelectedUser.clear();
        this.selectedStateArray.clear();
    }

    class UserListGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private int position;
        private View view;

        public UserListGestureListener(View view, int position) {
            this.position = position;
            this.view = view;
            Log.d((String)TAG, (String)("UserListGestureListener: " + position));
        }

        public boolean onSingleTapUp(MotionEvent e) {
            this.view.setSelected(!this.view.isSelected());
            if (this.view.isSelected()) {
                UngroupUserAdapter.this.mSelectedUser.add((IUserModel)UngroupUserAdapter.this.getData().get(this.position));
                UngroupUserAdapter.this.selectedStateArray.put(this.position, true);
            } else {
                UngroupUserAdapter.this.mSelectedUser.remove(UngroupUserAdapter.this.getData().get(this.position));
                UngroupUserAdapter.this.selectedStateArray.put(this.position, false);
            }
            if (UngroupUserAdapter.this.mOnUserEventListener != null) {
                UngroupUserAdapter.this.mOnUserEventListener.onUserSelected(UngroupUserAdapter.this.mSelectedUser);
            }
            return super.onSingleTapUp(e);
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
            if (UngroupUserAdapter.this.mOnUserEventListener != null) {
                UngroupUserAdapter.this.mOnUserEventListener.onUserLongClick(this.view, this.position, e.getRawX() - e.getX(), e.getRawY() - e.getY(), e.getRawX(), e.getRawY());
            }
        }
    }

    public static interface OnUserEventListener {
        public void onUserSelected(List<IUserModel> var1);

        public void onUserLongClick(View var1, int var2, float var3, float var4, float var5, float var6);
    }
}

