/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.bottommenu;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.dialog.HandsUpRemindPopupWindow;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.user.UserStatus;
import com.baijiayun.groupclassui.widget.ToggleSpeakerVolumeView;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.bottommenu.BottomMenuContract;
import com.baijiayun.groupclassui.window.bottommenu.BottomMenuPresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livecore.models.roomresponse.LPResCloudRecordModel;
import com.baijiayun.liveuibase.toolbox.zxyb.WritingBoardWrapper;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import com.baijiayun.liveuibase.utils.ToastUtil;
import com.baijiayun.liveuibase.widgets.common.DotProgressView;
import com.baijiayun.liveuibase.widgets.common.ProgressCircleView;
import com.zxyb.zxybbaselib.ble.entity.BleDevice;
import io.reactivex.android.schedulers.AndroidSchedulers;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class LeftMenuWindow
extends InteractiveBaseWindow
implements BottomMenuContract.View {
    private BottomMenuContract.Presenter presenter;
    private AnimatorSet animatorSet;
    private boolean isChatDialogShowing = false;
    private boolean isFloatChatWindowShowing;
    private ImageView ivMic;
    private ImageView ivCamera;
    private boolean isFirstCallRecordStatus = true;
    private Context context;
    private boolean eyeCareIsEnable = false;
    private HandsUpRemindPopupWindow handsUpRemindPopupWindow;
    private WritingBoardWrapper writingboardWrapper;

    public LeftMenuWindow(Context context) {
        super(context);
        this.context = context;
        this.animatorSet = new AnimatorSet();
        this.animatorSet.addListener((Animator.AnimatorListener)new AnimationSetListener(this.$.id(R.id.ll_bottom_container).view()));
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        lp.gravity = 0x800033;
        this.view.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.initView();
        this.initDrawable();
    }

    private void initDrawable() {
        this.$.id(R.id.ll_bottom).view().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeWidth(UtilsKt.getDp((int)1)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_bg_stroke_10)).build());
    }

    private void initView() {
        this.presenter = new BottomMenuPresenter(this, this.context);
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            this.showStudentView();
        }
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
            this.showTeacherView();
        }
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
            this.showAssistantView();
        }
        this.$.id(R.id.chat_container).visibility(this.iRouter.getLiveRoom().enableFixChatPanel1v1() ? 8 : 0);
        if (this.iRouter.getLiveRoom().getZXYBVM().enableUseHandWritingBoard() && (this.iRouter.getLiveRoom().getZXYBVM().getConnectType() != LPConstants.ZXYBConnectType.TYPE_BLE || !this.iRouter.getLiveRoom().getZXYBVM().getRecentBleDevices().isEmpty())) {
            this.$.id(R.id.window_bottom_writingboard_container).visible();
        }
        this.writingboardWrapper = new WritingBoardWrapper((AppCompatActivity)this.context, this.iRouter.getLiveRoom(), (ImageView)this.$.id(R.id.window_bottom_writingboard).view());
        WritingBoardWrapper.Config config = new WritingBoardWrapper.Config();
        config.setBleConnectResId(R.drawable.bjy_group_ic_ble_connected);
        config.setBleDisconnectResId(R.drawable.bjy_group_ic_ble_disconnected);
        config.setBleSleepResId(R.drawable.bjy_group_ic_ble_sleep);
        config.setUsbConnectResId(R.drawable.bjy_group_ic_usb_connected);
        config.setUsbDisconnectResId(R.drawable.bjy_group_ic_usb_disconnected);
        config.setUsbSleepResId(R.drawable.bjy_group_ic_usb_sleep);
        this.writingboardWrapper.setConfig(config);
        this.writingboardWrapper.setDeviceScanCallback(new WritingBoardWrapper.DeviceScanCallback(){

            public void onStartScan() {
                LeftMenuWindow.this.$.id(R.id.window_bottom_writingboard_progress).visible();
                DotProgressView dotProgressView = (DotProgressView)LeftMenuWindow.this.$.id(R.id.window_bottom_writingboard_progress).view();
                dotProgressView.invalidate();
            }

            public void onScanDevice(@Nullable BleDevice bleDevice) {
            }

            public void onStopScan() {
                LeftMenuWindow.this.$.id(R.id.window_bottom_writingboard_progress).gone();
            }
        });
        this.writingboardWrapper.setConnectStateCallback(connectState -> {
            if (connectState == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_SUCCESS) {
                this.$.id(R.id.window_bottom_writingboard_container).visible();
            }
            if (connectState == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_CONNECTING) {
                this.$.id(R.id.window_bottom_writingboard_progress).visible();
                DotProgressView dotProgressView = (DotProgressView)this.$.id(R.id.window_bottom_writingboard_progress).view();
                dotProgressView.invalidate();
            } else {
                this.$.id(R.id.window_bottom_writingboard_progress).gone();
            }
        });
        this.ivMic = (ImageView)this.$.id(R.id.iv_mic).view();
        this.ivCamera = (ImageView)this.$.id(R.id.iv_camera).view();
        this.ivMic.setSelected(true);
        this.ivCamera.setSelected(true);
        if (LPConstants.LPUserType.Assistant == this.iRouter.getLiveRoom().getCurrentUser().getType()) {
            this.iRouter.getLiveRoom().getRecorder().detachAVideo();
        } else if (this.iRouter.getLiveRoom().isClassStarted()) {
            this.iRouter.getLiveRoom().getRecorder().attachAVideo();
        }
        this.$.id(R.id.iv_userlist).clicked(v -> this.presenter.navigateToUserList());
        this.$.id(R.id.iv_chat).clicked(v -> {
            this.$.id(R.id.red_point_iv).invisible();
            this.presenter.navigateToChat();
        });
        this.$.id(R.id.iv_homework).clicked(v -> this.presenter.navigateToHomework());
        this.eyeCareIsEnable = this.iRouter.getSubjectValueByKey(EventKey.DisplayEyeCare, Boolean.class);
        ((ImageView)this.$.id(R.id.ct_eye_care).view()).setImageDrawable(ContextCompat.getDrawable((Context)this.view.getContext(), (int)(this.eyeCareIsEnable ? R.drawable.icon_group_eye_care_checked : R.drawable.icon_group_eye_care_normal)));
        this.$.id(R.id.ct_eye_care).clicked(v -> {
            this.presenter.navigateToEyeCare(!this.eyeCareIsEnable);
            this.eyeCareIsEnable = !this.eyeCareIsEnable;
            ((ImageView)this.$.id(R.id.ct_eye_care).view()).setImageDrawable(ContextCompat.getDrawable((Context)this.view.getContext(), (int)(this.eyeCareIsEnable ? R.drawable.icon_group_eye_care_checked : R.drawable.icon_group_eye_care_normal)));
        });
        this.$.id(R.id.container_status_bar_close).clicked(v -> this.presenter.exit());
        this.$.id(R.id.iv_speaker).clicked(v -> {
            ToggleSpeakerVolumeView volumeView = new ToggleSpeakerVolumeView(this.getView().getContext());
            volumeView.setListener(this::showSpeakerIcon);
            int iconSize = this.getView().getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_left_menu_width);
            PopupWindow popupWindow = new PopupWindow((View)volumeView, UtilsKt.getDp((int)148), UtilsKt.getDp((int)20));
            popupWindow.setOutsideTouchable(true);
            popupWindow.setFocusable(true);
            popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            popupWindow.showAsDropDown(this.$.id(R.id.iv_speaker).view(), iconSize, -(iconSize + popupWindow.getHeight()) / 2);
        });
        this.$.id(R.id.iv_courseware).clicked(v -> this.iRouter.getSubjectByKey(EventKey.CoursewareManageEnable).onNext((Object)true));
        this.$.id(R.id.activity_toolbar_box_image_1).clicked(v -> this.iRouter.getSubjectByKey(EventKey.ToolBox).onNext((Object)v));
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.$.id(R.id.ll_media_container).view().getLayoutParams();
            layoutParams.bottomMargin = UtilsKt.getDp((int)80);
        }
        if (this.iRouter.getLiveRoom().getPartnerConfig().disableRecordStatus()) {
            this.$.id(R.id.iv_record).gone();
        }
    }

    private void subscribe() {
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.DisPlayBleDialog).ofType(Boolean.class).filter(aBoolean -> aBoolean).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (this.writingboardWrapper != null) {
                this.writingboardWrapper.showBleDialogWithPermission();
            }
        }));
        this.compositeDisposable.add(this.$.id(R.id.iv_record).clicks().throttleFirst(1L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> this.presenter.changeRecordStatus()));
        this.compositeDisposable.add(this.$.id(R.id.fl_speak_wrapper).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(c -> this.presenter.speakApply()));
        this.compositeDisposable.add(this.$.id(R.id.iv_mic).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).subscribe(o -> {
            if (!this.iRouter.getLiveRoom().getOnlineUserVM().isActiveUser(this.iRouter.getLiveRoom().getCurrentUser())) {
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(this.iRouter.getLiveRoom().isClassStarted() ? R.string.bjysc_microphone_not_up_seat : R.string.bjysc_microphone_class_not_not_start));
                return;
            }
            this.iRouter.getPublishSubjectByKey(EventCode.AttachAudio).onNext((Object)(!this.iRouter.getLiveRoom().getRecorder().isAudioAttached() ? 1 : 0));
        }));
        this.compositeDisposable.add(this.$.id(R.id.iv_camera).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).subscribe(o -> {
            if (!this.iRouter.getLiveRoom().getOnlineUserVM().isActiveUser(this.iRouter.getLiveRoom().getCurrentUser())) {
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(this.iRouter.getLiveRoom().isClassStarted() ? R.string.bjysc_camera_not_up_seat : R.string.bjysc_camera_class_not_start));
                return;
            }
            this.iRouter.getPublishSubjectByKey(EventCode.AttachVideo).onNext((Object)(!this.iRouter.getLiveRoom().getRecorder().isVideoAttached() ? 1 : 0));
        }));
    }

    private void showSpeakerIcon(int volumeLevel, int min, int max) {
        int percent = (max - min) / 3 + 1;
        if (volumeLevel == min) {
            this.$.id(R.id.iv_speaker).image(R.drawable.ic_interactive_speaker_normal_0);
        } else if (volumeLevel <= percent) {
            this.$.id(R.id.iv_speaker).image(R.drawable.ic_interactive_speaker_normal_1);
        } else if (volumeLevel <= percent * 2) {
            this.$.id(R.id.iv_speaker).image(R.drawable.ic_interactive_speaker_normal_2);
        } else {
            this.$.id(R.id.iv_speaker).image(R.drawable.ic_interactive_speaker_normal_3);
        }
    }

    protected View onCreateView(Context context) {
        return LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_menu_left, null);
    }

    @Override
    public void showStudentView() {
        this.$.id(R.id.iv_courseware).gone();
        this.$.id(R.id.activity_toolbar_box_image).gone();
        this.$.id(R.id.activity_toolbar_box_image_1).gone();
        this.$.id(R.id.iv_record).gone();
        if (!this.iRouter.getLiveRoom().getPartnerConfig().enableStudentShowUserList) {
            this.$.id(R.id.iv_userlist).gone();
            this.$.id(R.id.fl_user).gone();
        }
        this.$.id(R.id.fl_speak_wrapper).visible();
        if (this.iRouter.getLiveRoom().getPartnerConfig().enableUseHomeWork == 1) {
            this.$.id(R.id.iv_homework).visible();
        }
    }

    @Override
    public void showTeacherView() {
        this.$.id(R.id.fl_speak_wrapper).gone();
    }

    @Override
    public void showAssistantView() {
        this.$.id(R.id.fl_speak_wrapper).gone();
        this.$.id(R.id.activity_toolbar_box_image).gone();
        this.$.id(R.id.activity_toolbar_box_image_1).gone();
    }

    @Override
    public void showRecordingStatus(LPResCloudRecordModel recordStatus) {
        String needShow;
        if (!this.isFirstCallRecordStatus && !TextUtils.isEmpty((CharSequence)(needShow = this.getNeedShowMessage(recordStatus)))) {
            new ToastUtil(this.context).setText(needShow).show();
        }
        if (this.isFirstCallRecordStatus && recordStatus.status == LPConstants.CloudRecordStatus.Recording.getStatus()) {
            this.isFirstCallRecordStatus = false;
        }
        if (recordStatus.status == LPConstants.CloudRecordStatus.Recording.getStatus()) {
            ((ImageView)this.$.id(R.id.iv_record).view()).setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_interactive_cloud_record_recording));
        } else {
            ((ImageView)this.$.id(R.id.iv_record).view()).setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_interactive_cloud_record_normal));
        }
    }

    @Override
    public void showForbidHandsUpStatus(boolean isForbidden) {
        if (!this.isAdmin() && !isForbidden) {
            this.showSpeakApplyNormal();
        } else {
            this.showSpeakApplyDisable();
        }
    }

    @Override
    public void showUserListWindowShowingStatus(boolean isShowing) {
        Drawable drawable2 = isShowing ? ContextCompat.getDrawable((Context)this.view.getContext(), (int)R.drawable.ic_interactive_user_list_on) : ContextCompat.getDrawable((Context)this.view.getContext(), (int)R.drawable.ic_interactive_user_list_off);
        ImageView imageView = (ImageView)this.$.id(R.id.iv_userlist).view();
        imageView.setImageDrawable(drawable2);
    }

    @Override
    public void showChatWindowShowingStatus(boolean isShowing) {
        Drawable drawable2;
        this.isChatDialogShowing = isShowing;
        if (this.view == null || this.view.getContext() == null) {
            return;
        }
        if (isShowing) {
            this.showChatWindowRedPoint(false);
            drawable2 = ContextCompat.getDrawable((Context)this.view.getContext(), (int)R.drawable.ic_interactive_chat_on);
        } else {
            drawable2 = ContextCompat.getDrawable((Context)this.view.getContext(), (int)R.drawable.bjy_group_ic_chat_off);
        }
        ImageView imageView = (ImageView)this.$.id(R.id.iv_chat).view();
        imageView.setImageDrawable(drawable2);
    }

    @Override
    public void showFloatChatWindowShowingStatus(boolean isShowing) {
        this.isFloatChatWindowShowing = isShowing;
    }

    @Override
    public void showGalleryModel(boolean isOn) {
    }

    @Override
    public void showStudyGalleryModel(LPConstants.StudyRoomMode studyRoomMode) {
    }

    @Override
    public void showChatWindowRedPoint(boolean isVisible) {
        this.$.id(R.id.red_point_iv).visibility(isVisible && !this.isChatDialogShowing && !this.isFloatChatWindowShowing ? 0 : 8);
    }

    @Override
    public void showShortTermClassAlreadyHasPlayback() {
        this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(R.string.bjysc_record_short_term));
    }

    @Override
    public void showCloudRecordHint() {
        this.getView().postDelayed(() -> {
            if (!this.presenter.showCloudRecord()) {
                return;
            }
            String hint = this.getView().getContext().getString(R.string.bjysc_record_on) + "\n" + this.getView().getContext().getString(R.string.bjysc_record_hint);
            TextView textView = new TextView(this.getView().getContext());
            textView.setText((CharSequence)hint);
            textView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.view.getContext(), (int)R.attr.base_theme_bottom_menu_text_color));
            textView.setLineSpacing((float)UtilsKt.getDp((int)10), 1.0f);
            ShadowUtil.ShadowGroup shadowGroup = ShadowUtil.initShadowView((Context)this.context, (View)textView);
            if (shadowGroup == null) {
                return;
            }
            ShadowUtil.setViewBoundShadow((View)shadowGroup.getShadowContainer());
            textView.setPadding(UtilsKt.getDp((int)10), UtilsKt.getDp((int)10), UtilsKt.getDp((int)10), UtilsKt.getDp((int)10));
            textView.setGravity(16);
            textView.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            PopupWindow window = new PopupWindow(shadowGroup.getContentView(), UtilsKt.getDp((int)376), UtilsKt.getDp((int)116));
            window.setOutsideTouchable(true);
            window.setFocusable(true);
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            int iconSize = this.getView().getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_left_menu_width);
            window.showAsDropDown(this.$.id(R.id.iv_record).view(), iconSize, -(iconSize + window.getHeight()) / 2);
        }, 1000L);
    }

    @Override
    public void showCloudRecordRestartDialog() {
        new CommonDialog(this.getView().getContext(), CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(this.getString(R.string.bjysc_record_restart_hint)).setPositive(this.getString(R.string.bjysc_record_continue), (dialog, which) -> this.presenter.continueCloudRecord()).setNegative(this.getString(R.string.bjysc_record_new), (dialog, which) -> this.presenter.startNewCloudRecord()).show();
    }

    @Override
    public void showMicStatus(boolean isMicOn) {
        if (this.ivMic != null) {
            this.ivMic.setSelected(!isMicOn);
        }
    }

    @Override
    public void showCameraStatus(boolean isCameraOn) {
        if (this.ivCamera != null) {
            this.ivCamera.setSelected(!isCameraOn);
        }
    }

    @Override
    public void showUserListStatus(boolean isShow) {
        this.$.id(R.id.window_bottom_menu_user_list).visibility(isShow ? 0 : 8);
    }

    @Override
    public void showSpeakApplyCountDown(int countDownTime, int total) {
        this.$.id(R.id.view_hand_countdown).visible();
        ((ProgressCircleView)this.$.id(R.id.view_hand_countdown).view()).setRatio((float)countDownTime / (float)total);
        this.$.id(R.id.iv_speak_apply).view().setEnabled(true);
        this.$.id(R.id.iv_speak_apply).view().setSelected(true);
    }

    @Override
    public void showSpeakApplyNormal() {
        this.$.id(R.id.iv_speak_apply).view().setEnabled(true);
        this.$.id(R.id.iv_speak_apply).view().setSelected(false);
        this.$.id(R.id.view_hand_countdown).invisible();
    }

    @Override
    public void showSpeakApplyDisable() {
        this.$.id(R.id.iv_speak_apply).view().setEnabled(false);
        this.$.id(R.id.iv_speak_apply).view().setSelected(false);
        this.$.id(R.id.view_hand_countdown).invisible();
    }

    @Override
    public void showHandsUpRemind(int count, String name) {
        View users = this.$.id(R.id.iv_userlist).view();
        if (DisplayUtils.isPad((Context)this.getView().getContext())) {
            this.$.id(R.id.iv_user_tip).text((CharSequence)String.valueOf(count));
        }
        this.$.id(R.id.iv_user_tip).visible();
        if (this.handsUpRemindPopupWindow == null) {
            this.handsUpRemindPopupWindow = new HandsUpRemindPopupWindow.Builder(this.getView().getContext()).build().setHandsUpCount(count, name).getPopupWindow();
        } else {
            this.handsUpRemindPopupWindow.setRemindText(count, name);
        }
        this.handsUpRemindPopupWindow.getContentView().measure(0, 0);
        int windowY = this.handsUpRemindPopupWindow.getContentView().getMeasuredHeight() / 2;
        int userY = -users.getMeasuredHeight() / 2;
        int offsetX = users.getMeasuredWidth() - UtilsKt.getDp((int)4);
        int offsetY = userY - windowY;
        this.handsUpRemindPopupWindow.getContentView().setOnClickListener(v -> {
            this.iRouter.getSubjectByKey(EventKey.DisplayUserList).onNext((Object)UserStatus.HandsupList);
            this.$.id(R.id.iv_user_tip).invisible();
            if (this.handsUpRemindPopupWindow != null && this.handsUpRemindPopupWindow.isShowing()) {
                this.handsUpRemindPopupWindow.dismiss();
            }
        });
        this.handsUpRemindPopupWindow.showAsDropDown(users, offsetX, offsetY);
    }

    @Override
    public void hideHandsUpCount() {
        this.$.id(R.id.iv_user_tip).invisible();
        if (this.handsUpRemindPopupWindow != null && this.handsUpRemindPopupWindow.isShowing()) {
            this.handsUpRemindPopupWindow.dismiss();
        }
    }

    @Override
    public void showCloudRecordButton(boolean cloudRecord) {
        this.$.id(R.id.iv_record).view().setVisibility(cloudRecord ? 0 : 8);
    }

    @Override
    public void showMuteAllStateChange(boolean mute) {
        if (mute) {
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_mute_all_tip));
        } else {
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_unmute_all_tip));
        }
    }

    @Override
    public void showBonusPointsAdd(Integer integer) {
    }

    public void setPresenter(BottomMenuContract.Presenter presenter2) {
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit && isActive) {
            this.setBasePresenter(this.presenter);
            this.subscribe();
        }
        return true;
    }

    @Override
    public void onDestroy() {
        if (this.animatorSet != null) {
            this.animatorSet.removeAllListeners();
            this.animatorSet.cancel();
            this.animatorSet = null;
        }
        if (this.writingboardWrapper != null) {
            this.writingboardWrapper.onDestroy();
        }
        super.onDestroy();
    }

    protected boolean onTouchEvent(View v, MotionEvent event) {
        return false;
    }

    private String getNeedShowMessage(LPResCloudRecordModel nowStatus) {
        return !this.isAdmin() ? "" : (nowStatus.operator == LPConstants.LPUserType.Teacher && !BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) ? "\u8001\u5e08" : (nowStatus.operator == LPConstants.LPUserType.Assistant && BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) ? "\u52a9\u6559" : "")) + "\u5df2" + (nowStatus.status == LPConstants.CloudRecordStatus.Recording.getStatus() ? "\u5f00\u542f" : "\u505c\u6b62") + "\u4e91\u7aef\u5f55\u5236";
    }

    private static class AnimationSetListener
    implements Animator.AnimatorListener {
        private WeakReference<View> weakReferenceView;
        private boolean needToChangeVisibility = true;

        AnimationSetListener(View view) {
            this.weakReferenceView = new WeakReference<View>(view);
        }

        public void onAnimationStart(Animator animation) {
            if (this.weakReferenceView.get() == null) {
                return;
            }
            View view = (View)this.weakReferenceView.get();
            if (view.getVisibility() == 8) {
                view.setVisibility(0);
                this.needToChangeVisibility = false;
            }
        }

        public void onAnimationEnd(Animator animation) {
            if (this.weakReferenceView.get() == null) {
                return;
            }
            View view = (View)this.weakReferenceView.get();
            if (view.getVisibility() == 0 && this.needToChangeVisibility) {
                view.setVisibility(8);
            }
            this.needToChangeVisibility = true;
        }

        public void onAnimationCancel(Animator animation) {
            this.needToChangeVisibility = true;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

