/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.user;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.user.IUserContract;
import com.baijiayun.groupclassui.user.OnlineUserPresenter;
import com.baijiayun.livebase.models.LPUserModel;

public class BlockListRecyclerViewAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private IUserContract listener;
    private OnlineUserPresenter presenter;

    BlockListRecyclerViewAdapter(OnlineUserPresenter presenter2, IUserContract listener) {
        this.presenter = presenter2;
        this.listener = listener;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjysc_item_kickout_user, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        LPUserModel userModel = (LPUserModel)this.presenter.getBlockList(position);
        holder.userNameTv.setText((CharSequence)userModel.getName());
        holder.ivRemoveBlocklist.setOnClickListener(view -> this.presenter.removeBlockList(userModel.number));
    }

    public int getItemCount() {
        return this.presenter.getBlockedUserListCount();
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView userNameTv;
        ImageView ivRemoveBlocklist;

        ViewHolder(View view) {
            super(view);
            this.userNameTv = (TextView)view.findViewById(R.id.tv_user_name);
            this.ivRemoveBlocklist = (ImageView)view.findViewById(R.id.iv_remove_blocklist);
            this.ivRemoveBlocklist.setVisibility(0);
        }
    }
}

