/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.container;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.container.StudyRoomContainer;
import com.baijiayun.groupclassui.container.VideoContainerListener;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.layer.StudyRoomLayer;
import com.baijiayun.groupclassui.layer.StudyRoomPlaceholderLayer;
import com.baijiayun.groupclassui.layer.VideoDragLayer;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPStudyUserStatus;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010$\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020 H\u0014J\b\u0010&\u001a\u00020 H\u0014J\b\u0010'\u001a\u00020 H\u0014J\b\u0010(\u001a\u00020 H\u0016J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\b\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020 H\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u0014H\u0016J\u0010\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\u001aH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/baijiayun/groupclassui/container/StudyRoomContainer;", "Lcom/baijiayun/groupclassui/layer/BaseLayerOfProfessionalClass;", "Lcom/baijiayun/groupclassui/container/VideoContainerListener;", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "TAG", "", "disposableOfFullSeat", "Lio/reactivex/disposables/Disposable;", "disposableOfTimer", "imgBtn", "Landroid/widget/ImageView;", "isFullSeat", "", "placeholderContainer", "Landroid/view/ViewGroup;", "studyRoomLayer", "Lcom/baijiayun/groupclassui/layer/StudyRoomLayer;", "studyRoomMode", "Lcom/baijiayun/livebase/context/LPConstants$StudyRoomMode;", "text", "Landroid/widget/TextView;", "videoDragLayer", "Lcom/baijiayun/groupclassui/layer/VideoDragLayer;", "addOuterLayer", "", "addPlaceholderViews", "changeContainerHeight", "getVideoDragLayer", "initVideo", "onDestroy", "onRoomActive", "onRoomInActive", "release", "sortList", "", "Lcom/baijiayun/livecore/models/LPStudyUserStatus;", "list", "startTimer", "subscribe", "switchLayoutMode", "isBoardLayout", "switchStudyRoomMode", "roomMode", "group-class_release"})
public final class StudyRoomContainer
extends BaseLayerOfProfessionalClass
implements VideoContainerListener {
    @NotNull
    private final String TAG;
    @NotNull
    private LPConstants.StudyRoomMode studyRoomMode;
    @Nullable
    private StudyRoomLayer studyRoomLayer;
    @Nullable
    private ViewGroup placeholderContainer;
    @Nullable
    private VideoDragLayer videoDragLayer;
    @Nullable
    private Disposable disposableOfFullSeat;
    @Nullable
    private Disposable disposableOfTimer;
    @Nullable
    private ImageView imgBtn;
    @Nullable
    private TextView text;
    private boolean isFullSeat;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    public StudyRoomContainer(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this._$_findViewCache = new LinkedHashMap();
        super(ctx);
        this.TAG = "StudyRoomContainer";
        this.studyRoomMode = LPConstants.StudyRoomMode.SelfStudy;
    }

    public StudyRoomContainer(@NotNull Context ctx, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this._$_findViewCache = new LinkedHashMap();
        super(ctx, attributeSet);
        this.TAG = "StudyRoomContainer";
        this.studyRoomMode = LPConstants.StudyRoomMode.SelfStudy;
    }

    public StudyRoomContainer(@NotNull Context ctx, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this._$_findViewCache = new LinkedHashMap();
        super(ctx, attributeSet, defStyleAttr);
        this.TAG = "StudyRoomContainer";
        this.studyRoomMode = LPConstants.StudyRoomMode.SelfStudy;
    }

    @Override
    protected void onRoomInActive() {
        super.onRoomInActive();
        this.release();
    }

    @Override
    protected void onRoomActive() {
        super.onRoomActive();
        this.changeContainerHeight(this.studyRoomMode);
    }

    private final void changeContainerHeight(LPConstants.StudyRoomMode studyRoomMode) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        ConstraintLayout.LayoutParams layoutParams2 = (ConstraintLayout.LayoutParams)layoutParams;
        if (studyRoomMode.isGalleryLayout()) {
            layoutParams2.bottomToTop = -1;
            layoutParams2.bottomToBottom = 0;
            this.setBackgroundColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_blackboard_color));
        } else {
            layoutParams2.bottomToTop = R.id.activity_group_class_sync_container;
            layoutParams2.bottomToBottom = -1;
            this.setBackgroundColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_room_bg_color));
        }
    }

    private final void subscribe() {
        this.disposableOfFullSeat = this.router.getSubjectByKey(EventKey.NoteSelfActive).subscribe(arg_0 -> StudyRoomContainer.subscribe$lambda$0((Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ StudyRoomContainer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Boolean it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                StudyRoomContainer.access$setFullSeat$p(this.this$0, it);
                ImageView imageView = StudyRoomContainer.access$getImgBtn$p(this.this$0);
                if (imageView != null) {
                    imageView.setVisibility(!StudyRoomContainer.access$getStudyRoomMode$p(this.this$0).isGalleryLayout() || StudyRoomContainer.access$isFullSeat$p(this.this$0) ? 8 : 0);
                }
            }
        }, arg_0));
        this.compositeDisposable.add(this.router.getLiveRoom().getStudyRoomVM().getObservableOfTimeRank().observeOn(AndroidSchedulers.mainThread()).map(arg_0 -> StudyRoomContainer.subscribe$lambda$1((Function1)new Function1<List<LPStudyUserStatus>, List<? extends LPStudyUserStatus>>(this){
            final /* synthetic */ StudyRoomContainer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final List<LPStudyUserStatus> invoke(@NotNull List<LPStudyUserStatus> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return StudyRoomContainer.access$sortList(this.this$0, it);
            }
        }, arg_0)).subscribe(arg_0 -> StudyRoomContainer.subscribe$lambda$2((Function1)new Function1<List<? extends LPStudyUserStatus>, Unit>(this){
            final /* synthetic */ StudyRoomContainer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(List<? extends LPStudyUserStatus> it) {
                StudyRoomContainer.access$getRouter$p$s664623482(this.this$0).getSubjectByKey(EventKey.StudyRankList).onNext(it);
            }
        }, arg_0)));
    }

    private final List<LPStudyUserStatus> sortList(List<? extends LPStudyUserStatus> list) {
        Collection collection = list;
        if (collection == null || collection.isEmpty()) {
            return list;
        }
        Collections.sort(list, (arg_0, arg_1) -> StudyRoomContainer.sortList$lambda$3(sortList.1.INSTANCE, arg_0, arg_1));
        LPStudyUserStatus temp = list.get(0);
        Iterator<LPStudyUserStatus> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            LPStudyUserStatus item = iterator.next();
            item.rank = index + 1;
            if (item.duration == temp.duration) {
                item.rank = temp.rank;
                continue;
            }
            temp = item;
        }
        return list;
    }

    @Override
    public void initVideo() {
        this.isFullSeat = false;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        StudyRoomLayer studyRoomLayer = this.studyRoomLayer = new StudyRoomLayer(context);
        if (studyRoomLayer != null) {
            studyRoomLayer.setLisenter(this);
        }
        this.videoDragLayer = new VideoDragLayer(this.getContext());
        StudyRoomLayer studyRoomLayer2 = this.studyRoomLayer;
        if (studyRoomLayer2 != null) {
            studyRoomLayer2.setVideoDragLayer(this.videoDragLayer);
        }
        this.post(() -> StudyRoomContainer.initVideo$lambda$4(this));
        this.addPlaceholderViews();
        this.addView((View)this.studyRoomLayer, new ViewGroup.LayoutParams(-1, -1));
        this.addOuterLayer();
        this.subscribe();
    }

    private final void addOuterLayer() {
        block0: {
            FrameLayout.LayoutParams imgParams = new FrameLayout.LayoutParams(-2, -2);
            imgParams.gravity = 17;
            ImageView imageView = this.imgBtn = new ImageView(this.getContext());
            Intrinsics.checkNotNull((Object)imageView);
            ImageView $this$addOuterLayer_u24lambda_u246 = imageView;
            boolean bl = false;
            $this$addOuterLayer_u24lambda_u246.setImageResource(R.drawable.sel_grab_seat);
            this.addView((View)$this$addOuterLayer_u24lambda_u246, (ViewGroup.LayoutParams)imgParams);
            $this$addOuterLayer_u24lambda_u246.setOnClickListener(arg_0 -> StudyRoomContainer.addOuterLayer$lambda$6$lambda$5(this, arg_0));
            FrameLayout.LayoutParams textParams = new FrameLayout.LayoutParams(-2, -2);
            this.text = new TextView(this.getContext());
            textParams.gravity = 49;
            textParams.topMargin = UtilsKt.getDp((int)8);
            textParams.width = UtilsKt.getDp((int)300);
            int topPadding = UtilsKt.getDp((int)10);
            TextView textView = this.text;
            if (textView == null) break block0;
            TextView $this$addOuterLayer_u24lambda_u247 = textView;
            boolean bl2 = false;
            $this$addOuterLayer_u24lambda_u247.setTextColor(-1);
            $this$addOuterLayer_u24lambda_u247.setPadding(0, topPadding, 0, topPadding);
            $this$addOuterLayer_u24lambda_u247.setGravity(17);
            this.addView((View)$this$addOuterLayer_u24lambda_u247, (ViewGroup.LayoutParams)textParams);
            $this$addOuterLayer_u24lambda_u247.setVisibility(8);
            $this$addOuterLayer_u24lambda_u247.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)$this$addOuterLayer_u24lambda_u247.getContext(), (int)R.attr.base_theme_live_product_color)).cornerRadius(UtilsKt.getDp((int)4)).build());
        }
    }

    private final void addPlaceholderViews() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.placeholderContainer = (ViewGroup)new StudyRoomPlaceholderLayer(context);
        int maxSpeaks = this.router.getLiveRoom().getMaxActiveUsers();
        for (int i = 0; i < maxSpeaks; ++i) {
            View emptyView = View.inflate((Context)this.getContext(), (int)R.layout.bjysc_layout_video_empty, null);
            ((AppCompatImageView)emptyView.findViewById(R.id.window_video_container_to_seat_placeholder)).setImageResource(R.drawable.base_ic_video_default_head);
            ((TextView)emptyView.findViewById(R.id.window_video_container_seat_name)).setText((CharSequence)this.getContext().getString(R.string.bjysc_study_room_video_empty));
            ViewGroup viewGroup = this.placeholderContainer;
            if (viewGroup == null) continue;
            viewGroup.addView(emptyView);
        }
        this.addView((View)this.placeholderContainer, 0, new ViewGroup.LayoutParams(-1, -1));
    }

    @Override
    @Nullable
    public VideoDragLayer getVideoDragLayer() {
        return this.videoDragLayer;
    }

    @Override
    public void switchStudyRoomMode(@NotNull LPConstants.StudyRoomMode roomMode) {
        Intrinsics.checkNotNullParameter((Object)roomMode, (String)"roomMode");
        this.studyRoomMode = roomMode;
        boolean hidePlaceholder = !roomMode.isGalleryLayout();
        ImageView imageView = this.imgBtn;
        if (imageView != null) {
            imageView.setVisibility(hidePlaceholder || this.isFullSeat ? 8 : 0);
        }
        ViewGroup viewGroup = this.placeholderContainer;
        if (viewGroup != null) {
            viewGroup.setVisibility(hidePlaceholder ? 8 : 0);
        }
        StudyRoomLayer studyRoomLayer = this.studyRoomLayer;
        if (studyRoomLayer != null) {
            studyRoomLayer.switchStudyRoomMode(roomMode);
        }
        this.changeContainerHeight(roomMode);
        RxUtils.Companion.dispose(this.disposableOfTimer);
        switch (WhenMappings.$EnumSwitchMapping$0[roomMode.ordinal()]) {
            case 1: {
                TextView textView = this.text;
                if (textView != null) {
                    TextView $this$switchStudyRoomMode_u24lambda_u248 = textView;
                    boolean bl = false;
                    $this$switchStudyRoomMode_u24lambda_u248.setVisibility(0);
                    $this$switchStudyRoomMode_u24lambda_u248.setText((CharSequence)$this$switchStudyRoomMode_u24lambda_u248.getContext().getString(R.string.bjysc_study_room_switch_self_study_tip));
                    this.startTimer();
                }
                break;
            }
            case 2: {
                TextView textView = this.text;
                if (textView != null) {
                    TextView $this$switchStudyRoomMode_u24lambda_u249 = textView;
                    boolean bl = false;
                    $this$switchStudyRoomMode_u24lambda_u249.setVisibility(0);
                    $this$switchStudyRoomMode_u24lambda_u249.setText((CharSequence)$this$switchStudyRoomMode_u24lambda_u249.getContext().getString(R.string.bjysc_study_room_switch_tutor_tip));
                    this.startTimer();
                }
                break;
            }
            default: {
                TextView textView = this.text;
                if (textView == null) break;
                textView.setVisibility(8);
            }
        }
    }

    private final void startTimer() {
        this.disposableOfTimer = Observable.timer((long)15L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> StudyRoomContainer.startTimer$lambda$10((Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ StudyRoomContainer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Long it) {
                TextView textView = StudyRoomContainer.access$getText$p(this.this$0);
                if (textView != null) {
                    textView.setVisibility(8);
                }
            }
        }, arg_0));
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.release();
    }

    @Override
    public void release() {
        block1: {
            RxUtils.Companion.dispose(this.disposableOfFullSeat);
            RxUtils.Companion.dispose(this.disposableOfTimer);
            this.removeAllViews();
            VideoDragLayer videoDragLayer = this.videoDragLayer;
            if (videoDragLayer != null) {
                videoDragLayer.onDestroy();
            }
            StudyRoomLayer studyRoomLayer = this.studyRoomLayer;
            if (studyRoomLayer == null) break block1;
            studyRoomLayer.onDestroy();
        }
    }

    @Override
    public void switchLayoutMode(boolean isBoardLayout) {
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void subscribe$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final List subscribe$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final int sortList$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void initVideo$lambda$4(StudyRoomContainer this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            VideoDragLayer videoDragLayer = this$0.videoDragLayer;
            if (videoDragLayer == null) break block0;
            videoDragLayer.setSeatContainerWidth(this$0.getMeasuredHeight());
        }
    }

    private static final void addOuterLayer$lambda$6$lambda$5(StudyRoomContainer this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.router.getLiveRoom().getOnlineUserVM().requestAddActiveUser(this$0.router.getLiveRoom().getCurrentUser());
    }

    private static final void startTimer$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setFullSeat$p(StudyRoomContainer $this, boolean bl) {
        $this.isFullSeat = bl;
    }

    public static final /* synthetic */ ImageView access$getImgBtn$p(StudyRoomContainer $this) {
        return $this.imgBtn;
    }

    public static final /* synthetic */ LPConstants.StudyRoomMode access$getStudyRoomMode$p(StudyRoomContainer $this) {
        return $this.studyRoomMode;
    }

    public static final /* synthetic */ boolean access$isFullSeat$p(StudyRoomContainer $this) {
        return $this.isFullSeat;
    }

    public static final /* synthetic */ List access$sortList(StudyRoomContainer $this, List list) {
        return $this.sortList(list);
    }

    public static final /* synthetic */ IRouter access$getRouter$p$s664623482(StudyRoomContainer $this) {
        return $this.router;
    }

    public static final /* synthetic */ TextView access$getText$p(StudyRoomContainer $this) {
        return $this.text;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LPConstants.StudyRoomMode.values().length];
            try {
                nArray[LPConstants.StudyRoomMode.SelfStudy.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.StudyRoomMode.Discuss.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

