/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.smallblackboard;

import android.app.Activity;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import android.os.Environment;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.baijiahulian.common.cropperv2.BJCommonImageCropHelper;
import com.baijiahulian.common.cropperv2.ThemeConfig;
import com.baijiahulian.common.cropperv2.model.PhotoInfo;
import com.baijiahulian.common.cropperv2.uikit.CircleColorView;
import com.baijiahulian.common.permission.AppPermissions;
import com.baijiahulian.common.utils.StringUtils;
import com.baijiayun.bjyutils.TimeUtilsKt;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.container.ShapePaint;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.model.SbbCloseWindowEvent;
import com.baijiayun.groupclassui.model.SbbStatusModel;
import com.baijiayun.groupclassui.window.BaseFixedRatioTitledWindow;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SbbExpandableListViewAdapter;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SbbStudentSelectView;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SbbUtils;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SmallBlackboardDialogUtil;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SmallBlackboardStatus;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPDocViewElementModel;
import com.baijiayun.livecore.models.LPGroupItem;
import com.baijiayun.livecore.models.LPShapeModel;
import com.baijiayun.livecore.models.LPSnippetPublishModel;
import com.baijiayun.livecore.models.LPSnippetPullReqModel;
import com.baijiayun.livecore.models.LPSnippetPullResModel;
import com.baijiayun.livecore.models.LPSnippetSubmitModel;
import com.baijiayun.livecore.models.LPWhiteboardViewInfo;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeDelModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeMultipleModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeSingleModel;
import com.baijiayun.livecore.ppt.smallblackboard.IWhiteboardViewCallback;
import com.baijiayun.livecore.ppt.smallblackboard.SmallBlackboardView;
import com.baijiayun.livecore.ppt.util.LPShapeConverter;
import com.baijiayun.livecore.ppt.whiteboard.OnDoubleTapListener2;
import com.baijiayun.livecore.ppt.whiteboard.ShapeDispatcher;
import com.baijiayun.livecore.ppt.whiteboard.Whiteboard;
import com.baijiayun.livecore.ppt.whiteboard.WhiteboardView;
import com.baijiayun.livecore.ppt.whiteboard.shape.DoodleShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.LaserShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.TextShape;
import com.baijiayun.livecore.viewmodels.impl.ShapeVM;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.toolbox.browser.Tuple;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class SmallBlackboardWindow
extends BaseFixedRatioTitledWindow
implements IWhiteboardViewCallback,
ShapePaint.IShapePaintListener,
WhiteboardView.LPShapeSendListener {
    public static final String SBB_ID_PREFIX = "s_0_";
    public static final String SBB_ID_INFIX = "_";
    private static final int MAX_AUTO_LOAD_COUNT = 20;
    public static final String FAKE_TEACHER_ID_PREFIX = "0_s_0";
    private static final String FAKE_TEACHER_NUMBER = "0";
    private static final String NUM_ZERO = "0";
    private SmallBlackboardView smallBlackboardView;
    private ShapePaint shapePaint;
    private ShapeDispatcher shapeDispatcher;
    private LiveRoom liveRoom;
    private ImageView uploadImgIv;
    private ImageView deleteIv;
    private ImageView prePageIV;
    private ImageView nextPageIv;
    private LinearLayout pageContainer;
    private EditText inputCountDownTimeEt;
    private LinearLayout inputTimeLl;
    private Button reselectBtn;
    private Button publishBtn;
    private Button revokeBtn;
    private Button takeBackBtn;
    private TextView takeBackCountingDownTv;
    private TextView pageTipTv;
    private RelativeLayout contentTopRl;
    private TextView currentReviewPageTv;
    private TextView sbbOwnerTv;
    private View groupLayout;
    private TextView tvGroupName;
    private CircleColorView circleColorView;
    private View viewContainer;
    private TextView tvGroupNameSbb;
    private CircleColorView circleColorViewSbb;
    private ImageView publishSbbToAllIv;
    private ImageView captureIv;
    private View ssbReviewStudentFl;
    private CheckBox showNickNameCheckbox;
    private Button commitBtn;
    private ExpandableListView commitExpandableListView;
    private SbbExpandableListViewAdapter adapter;
    private ShapeVM shapeVM;
    private String originWindowId;
    private String windowId;
    private String layer;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final List<SbbStatusModel> sbbAllList = new CopyOnWriteArrayList<SbbStatusModel>();
    private final List<SbbStatusModel> sbbOnSeatUserList = new CopyOnWriteArrayList<SbbStatusModel>();
    private final List<SbbStatusModel> sbbDownSeatUserList = new CopyOnWriteArrayList<SbbStatusModel>();
    private final Set<IUserModel> sbbAllSubmitSet = new HashSet<IUserModel>();
    private final List<String> layerList = new ArrayList<String>();
    private int countDownLeftTime;
    private int duration;
    private long timeStart;
    private Disposable timerDisposable;
    private Disposable previewUpdateCountingDown;
    private boolean isPublishToAll;
    private boolean isShowPaintOwnerEnable;
    private WhiteboardView whiteboardView;
    private Disposable disposableOfUploadImg;
    public String cursor = "";
    private Context context;
    private boolean toAll = true;
    private SbbStudentSelectView sbbStudentSelectView;
    private List<IUserModel> selectUsers = new ArrayList<IUserModel>();
    private Disposable disposableOfPermission;
    private boolean isTeacher;
    private boolean isCloseByTeacher;
    private boolean isLoadMore = false;
    private boolean hasMore = true;
    private long loadMoreTimeStamp = 0L;
    private int uploadImgX;
    private int uploadImgY;
    private boolean isUploadImageAdd = true;
    private SmallBlackboardStatus windowStatus = SmallBlackboardStatus.TEACHER_INIT;
    private boolean hasNotice = false;
    private boolean isRePublish = false;
    private int currentPage = 1;

    public SmallBlackboardWindow(Context context, ShapePaint shapePaint, boolean isPublishToAll, boolean isShowPaintOwnerEnable) {
        super(context);
        this.shapePaint = shapePaint;
        shapePaint.registerShapePaintListener(this);
        this.isPublishToAll = isPublishToAll;
        this.isShowPaintOwnerEnable = isShowPaintOwnerEnable;
        this.context = context;
        this.getView().addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                SmallBlackboardWindow.this.setWindowLayoutParams(v.getLayoutParams());
            }

            public void onViewDetachedFromWindow(View v) {
            }
        });
        this.attachLiveRoom();
        this.sbbOwnerTv = (TextView)this.getView().findViewById(R.id.sbb_window_owner_tv);
        this.viewContainer = this.getView().findViewById(R.id.layout_group_container);
        this.tvGroupNameSbb = (TextView)this.viewContainer.findViewById(R.id.tv_group_name);
        this.circleColorViewSbb = (CircleColorView)this.viewContainer.findViewById(R.id.view_group_color);
        if (BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && !isPublishToAll) {
            View footer = LayoutInflater.from((Context)context).inflate(R.layout.layout_small_blackboard_teacher_footer, (ViewGroup)this.rlFooterContainer);
            this.initFooterView(footer, true);
        } else {
            View footer = LayoutInflater.from((Context)context).inflate(R.layout.layout_small_blackboard_student_footer, (ViewGroup)this.rlFooterContainer);
            this.initFooterView(footer, false);
        }
        if (this.iRouter.getLiveRoom().isAudition()) {
            this.deleteIv.setEnabled(false);
            if (this.commitBtn != null) {
                this.commitBtn.setEnabled(false);
            }
        }
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit && isActive) {
            this.startObservable();
        }
        return true;
    }

    private void attachLiveRoom() {
        this.liveRoom = this.iRouter.getLiveRoom();
        this.shapeDispatcher = new ShapeDispatcher();
        this.shapeDispatcher.setIsInSbbMode(true);
        this.shapeDispatcher.setShowPaintOwnerEnable(this.isShowPaintOwnerEnable);
        this.shapeVM = this.liveRoom.newShapeVM((ShapeVM.LPShapeReceiverListener)this.shapeDispatcher);
        this.setOnWindowRepositionListener(new BaseWindow.OnWindowRepositionListener(){

            public void onWindowMove(int x, int y) {
                if (BaseUtilsKt.isTeacher((IUserModel)SmallBlackboardWindow.this.iRouter.getLiveRoom().getCurrentUser()) && SmallBlackboardWindow.this.isPublishToAll) {
                    SmallBlackboardWindow.this.iRouter.getSubjectByKey(EventKey.SbbRepositionWindow).onNext((Object)new Tuple("move", SmallBlackboardWindow.this.layer, x, y));
                }
            }

            public void OnWindowScale(int newWidth, int newHeight) {
                if (BaseUtilsKt.isTeacher((IUserModel)SmallBlackboardWindow.this.iRouter.getLiveRoom().getCurrentUser()) && SmallBlackboardWindow.this.isPublishToAll) {
                    SmallBlackboardWindow.this.iRouter.getSubjectByKey(EventKey.SbbRepositionWindow).onNext((Object)new Tuple("scale", SmallBlackboardWindow.this.layer, newWidth, newHeight));
                }
            }
        });
    }

    private void startObservable() {
        Disposable participateDisposable = this.iRouter.getLiveRoom().getToolBoxVM().getObservableOfSnippetParticipate().observeOn(AndroidSchedulers.mainThread()).filter(lpSnippetSubmitModel -> TextUtils.equals((CharSequence)lpSnippetSubmitModel.id, (CharSequence)this.getId())).filter(snippetSubmitModel -> BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && !this.isPublishToAll && this.layerList.size() < 20).subscribe(snippetSubmitModel -> this.sortSbbUser(new SbbStatusModel((IUserModel)snippetSubmitModel.from, SbbStatusModel.SbbStatus.NORMAL), false));
        Disposable submitDisposable = this.iRouter.getLiveRoom().getToolBoxVM().getObservableOfSnippetSubmit().observeOn(AndroidSchedulers.mainThread()).filter(lpSnippetSubmitModel -> TextUtils.equals((CharSequence)lpSnippetSubmitModel.id, (CharSequence)this.getId())).filter(snippetSubmitModel -> !this.isPublishToAll && !this.isCloseByTeacher && this.layerList.size() < 20).subscribe(snippetSubmitModel -> {
            if (BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())) {
                this.sortSbbUser(new SbbStatusModel((IUserModel)snippetSubmitModel.from, SbbStatusModel.SbbStatus.COMMIT), false);
            } else if (snippetSubmitModel.from.getNumber().equals(this.iRouter.getLiveRoom().getCurrentUser().getNumber())) {
                View tipRootView = SmallBlackboardDialogUtil.showTips(this.getView(), this.getView().getContext().getString(R.string.sbb_submit_close_tip, new Object[]{3}));
                TextView textView = (TextView)tipRootView.findViewById(R.id.lp_sbb_tip_content_tv);
                textView.setVisibility(this.isMinInSync ? 8 : 0);
                Disposable intervalDisposable = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).take(3L).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
                    textView.setVisibility(this.isMinInSync ? 8 : 0);
                    textView.setText((CharSequence)this.getView().getContext().getString(R.string.sbb_submit_close_tip, new Object[]{2L - aLong}));
                    if (aLong == 2L) {
                        this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, true));
                    }
                });
                this.disposables.add(intervalDisposable);
            }
        });
        this.disposables.add(this.iRouter.getLiveRoom().getToolBoxVM().getObservableOfSnippetPullRes().filter(lpSnippetPullResModel -> TextUtils.equals((CharSequence)lpSnippetPullResModel.id, (CharSequence)this.getId())).observeOn(AndroidSchedulers.mainThread()).filter(snippetPullResModel -> BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())).subscribe(lpSnippetPullResModel -> {
            this.cursor = SbbUtils.getLastUserNumber(lpSnippetPullResModel);
            this.addSbbUser((LPSnippetPullResModel)lpSnippetPullResModel);
            this.notifyList();
            this.isLoadMore = false;
            this.hasMore = lpSnippetPullResModel.hasMore;
        }));
        this.disposables.add(this.iRouter.getLiveRoom().getOnlineUserVM().getObservableOfOnGroupItem().observeOn(AndroidSchedulers.mainThread()).subscribe(lpGroupItem -> this.notifyList()));
        this.disposables.add(this.iRouter.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserAdd().filter(lpResRoomUserInModel -> !this.isPublishToAll && BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && !this.liveRoom.getCurrentUser().getNumber().equals(lpResRoomUserInModel.getUser().getNumber())).subscribe(lpResRoomUserInModel -> this.sortSbbUser(new SbbStatusModel(lpResRoomUserInModel.getUser()), true)));
        this.disposables.add(this.iRouter.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().filter(lpResRoomUserInModel -> !this.isPublishToAll && BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && !this.liveRoom.getCurrentUser().getNumber().equals(lpResRoomUserInModel.getUser().getNumber())).subscribe(lpResRoomUserInModel -> this.sortSbbUser(new SbbStatusModel(lpResRoomUserInModel.getUser()), true)));
        Disposable publishDisposable = this.iRouter.getLiveRoom().getToolBoxVM().getObservableOfSnippetPublish().filter(lpSnippetPublishModel -> TextUtils.equals((CharSequence)lpSnippetPublishModel.id, (CharSequence)this.getId())).observeOn(AndroidSchedulers.mainThread()).subscribe(snippetPublishModel -> {
            if (this.isPublishToAll) {
                if (snippetPublishModel.operate == 1) {
                    this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, true));
                }
                return;
            }
            LPConstants.LPUserType userType = this.iRouter.getLiveRoom().getCurrentUser().getType();
            if (userType == LPConstants.LPUserType.Teacher) {
                switch (snippetPublishModel.operate) {
                    case 0: {
                        this.showTips(this.getString(R.string.sbb_all_take_back), 1);
                        this.changeSbbStatus(SmallBlackboardStatus.ALL_COMMITTED);
                        break;
                    }
                    case 1: {
                        this.changeSbbStatus(SmallBlackboardStatus.TEACHER_REVIEW);
                        break;
                    }
                    case 2: {
                        this.smallBlackboardView.goToPage(0);
                        this.changeSbbStatus(SmallBlackboardStatus.TEACHER_TO_PUBLISH);
                    }
                }
            } else {
                switch (snippetPublishModel.operate) {
                    case 0: {
                        this.commitBtn.setEnabled(false);
                        this.isCloseByTeacher = true;
                        this.cancelCountDown();
                        this.requestSnippetSubmit();
                        this.showTips(this.getString(R.string.sbb_student_revoke_tip), 3);
                        if (this.iRouter != null && this.subSbbWindowCount() <= 0) {
                            this.iRouter.getSubjectByKey(EventKey.SbbShowToolBarWindow).onNext((Object)-1);
                            this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
                        }
                        Disposable timerDisposable = Observable.timer((long)3L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
                            if (this.iRouter != null) {
                                this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, true));
                            }
                        });
                        this.disposables.add(timerDisposable);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.cancelCountDown();
                        if (this.subSbbWindowCount() <= 0) {
                            this.iRouter.getSubjectByKey(EventKey.SbbShowToolBarWindow).onNext((Object)0);
                            this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
                        }
                        this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, true));
                        break;
                    }
                }
            }
        });
        Disposable closeDisposable = this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).observeOn(AndroidSchedulers.mainThread()).ofType(SbbCloseWindowEvent.class).filter(closeWindowEvent -> BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && !this.isPublishToAll).subscribe(closeWindowEvent -> {
            if (this.windowStatus == SmallBlackboardStatus.ALL_COMMITTED || this.windowStatus == SmallBlackboardStatus.EMPTY) {
                String layerUserNumber = closeWindowEvent.layer;
                IUserModel userModel = null;
                for (IUserModel model : this.sbbAllSubmitSet) {
                    if (!model.getNumber().equals(layerUserNumber)) continue;
                    userModel = model;
                    break;
                }
                if (userModel != null) {
                    if ("0".equals(layerUserNumber)) {
                        this.sbbAllList.add(0, new SbbStatusModel(userModel, SbbStatusModel.SbbStatus.NORMAL));
                        this.sortSbbUserInternal();
                    } else {
                        this.sortSbbUser(new SbbStatusModel(userModel, SbbStatusModel.SbbStatus.READ), true);
                    }
                }
                if (this.windowStatus == SmallBlackboardStatus.EMPTY) {
                    this.windowStatus = SmallBlackboardStatus.ALL_COMMITTED;
                    this.changeSbbStatus(this.windowStatus);
                }
                this.updateCurrentReviewTips();
                this.smallBlackboardView.goToPage(this.currentPage);
            }
        });
        Disposable classEndDisposable = this.iRouter.getLiveRoom().getObservableOfClassEnd().filter(integer -> this.isAdmin()).observeOn(AndroidSchedulers.mainThread()).subscribe(integer -> {
            this.requestSnippetPublish(0);
            this.cancelCountDown();
        });
        this.disposables.add(participateDisposable);
        this.disposables.add(submitDisposable);
        this.disposables.add(publishDisposable);
        this.disposables.add(closeDisposable);
        this.disposables.add(classEndDisposable);
    }

    private int subSbbWindowCount() {
        int count = this.iRouter.getValueByKey(EventKey.SbbWindowCount, Integer.class, 0);
        this.iRouter.setObjectByKey(EventKey.SbbWindowCount, Math.max(count - 1, 0));
        return Math.max(count - 1, 0);
    }

    public void initStatus(LPSnippetPullResModel snippetPullResModel, SmallBlackboardStatus status) {
        this.layerList.clear();
        this.sbbAllList.clear();
        this.sbbAllSubmitSet.clear();
        if (BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && !this.isPublishToAll) {
            LPUserModel userModel = (LPUserModel)this.iRouter.getLiveRoom().getCurrentUser();
            LPUserModel currentUserCopy = new LPUserModel();
            currentUserCopy.number = "0";
            currentUserCopy.name = userModel.name;
            currentUserCopy.userId = userModel.userId;
            if (!snippetPullResModel.isTeacherInPublishStatus) {
                this.layerList.add("0");
                this.sbbAllList.add(new SbbStatusModel((IUserModel)currentUserCopy, SbbStatusModel.SbbStatus.NORMAL));
            }
            this.initExpandableListView();
            this.addSbbUser(snippetPullResModel);
        } else {
            this.layerList.add(this.layer);
        }
        if (!this.isPublishToAll && snippetPullResModel.isActive) {
            this.duration = snippetPullResModel.duration;
            this.timeStart = snippetPullResModel.timeStart;
            this.startCountingDown(this.duration, this.timeStart);
        }
        this.smallBlackboardView.initData(this.layerList);
        if (snippetPullResModel.isTeacherInPublishStatus && this.layerList.size() > 0) {
            this.layer = this.layerList.get(0);
        }
        this.shapeVM.requestPageAllShape(this.windowId, 0, this.layer, true);
        if (this.layerList.isEmpty() && BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())) {
            status = SmallBlackboardStatus.EMPTY;
        }
        this.changeSbbStatus(status);
        if (status != SmallBlackboardStatus.PUBLISH_TO_ALL) {
            this.iRouter.getSubjectByKey(EventKey.SbbShowToolBarWindow).onNext((Object)1);
        }
    }

    public void init() {
        this.layerList.clear();
        this.sbbAllList.clear();
        this.sbbAllSubmitSet.clear();
        this.layerList.add("0");
        LPUserModel userModel = (LPUserModel)this.iRouter.getLiveRoom().getCurrentUser();
        LPUserModel currentUserCopy = new LPUserModel();
        currentUserCopy.number = "0";
        currentUserCopy.name = userModel.name;
        currentUserCopy.userId = userModel.userId;
        this.sbbAllList.add(new SbbStatusModel((IUserModel)currentUserCopy, SbbStatusModel.SbbStatus.NORMAL));
        this.smallBlackboardView.initData(this.layerList);
        this.initExpandableListView();
        this.changeSbbStatus(SmallBlackboardStatus.TEACHER_INIT);
    }

    @Override
    protected View onCreateView(Context context) {
        DEFAULT_MIN_SIZE = 192;
        this.otherSizeRatio = 1.875f;
        return super.onCreateView(context);
    }

    @Override
    protected void onCreateContentView(Context context) {
        View contentView = LayoutInflater.from((Context)context).inflate(R.layout.layout_sbb_window_content, (ViewGroup)this.rlContentContainer);
        if (this.smallBlackboardView == null) {
            this.smallBlackboardView = new SmallBlackboardView(context, (IWhiteboardViewCallback)this);
            this.smallBlackboardView.initViewpager(ThemeDataUtil.getResIdByAttributeId((Context)context, (int)R.attr.base_theme_blackboard_color));
            this.smallBlackboardView.setMaxPage(2);
            this.smallBlackboardView.setOnShapeSelectedListener(selected -> this.iRouter.getSubjectByKey(EventKey.Action2ShapeSelected).onNext((Object)selected));
        }
        this.ssbReviewStudentFl = contentView.findViewById(R.id.sbb_window_commit_status_root_ll);
        FrameLayout ssbContainer = (FrameLayout)contentView.findViewById(R.id.sbb_window_content_container);
        UtilsKt.removeViewFromParent((View)this.smallBlackboardView.getView());
        ssbContainer.addView(this.smallBlackboardView.getView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.initCommitStatusView(contentView);
    }

    @Override
    protected void onCreateFooterView(Context context) {
    }

    @Override
    protected void onCreateTopView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_sbb_top_title, (ViewGroup)this.rlTitleContainer);
        this.takeBackCountingDownTv = (TextView)this.rlTitleContainer.findViewById(R.id.sbb_counting_down_iv);
    }

    @Override
    protected void initTopTitleView() {
        this.ivClose = (ImageView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_close);
        this.ivMaxSync = (ImageView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_max_in_sync_layer);
        this.minIv = (ImageView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_min_in_sync_layer);
        this.ivMaxSync.setOnClickListener(l -> {
            this.isReceiveOrder = false;
            if (this.isMinInSync) {
                this.resetMinInSync();
            } else if (this.isMaxInSync) {
                this.resetInSync();
            } else {
                this.maxInSync();
            }
        });
        this.minIv.setOnClickListener(v -> this.minInSync());
    }

    private void initFooterView(View parent, boolean isTeacher) {
        this.isTeacher = isTeacher;
        if (isTeacher) {
            this.uploadImgIv = (ImageView)parent.findViewById(R.id.window_sbb_teacher_upload_image_iv);
            this.deleteIv = (ImageView)parent.findViewById(R.id.window_sbb_teacher_delete_iv);
            this.prePageIV = (ImageView)parent.findViewById(R.id.window_titled_prev_page);
            this.nextPageIv = (ImageView)parent.findViewById(R.id.window_titled_next_page);
            this.inputCountDownTimeEt = (EditText)parent.findViewById(R.id.sbb_count_down_et);
            this.pageContainer = (LinearLayout)parent.findViewById(R.id.sbb_page_tip_ll);
            this.pageTipTv = (TextView)parent.findViewById(R.id.window_center_pageNumber);
            this.reselectBtn = (Button)parent.findViewById(R.id.sbb_reselect_btn);
            this.publishBtn = (Button)parent.findViewById(R.id.sbb_publish_btn);
            this.revokeBtn = (Button)parent.findViewById(R.id.sbb_revoke_btn);
            this.takeBackBtn = (Button)parent.findViewById(R.id.sbb_take_back_btn);
            this.inputTimeLl = (LinearLayout)parent.findViewById(R.id.sbb_count_down_ll);
            this.publishSbbToAllIv = (ImageView)parent.findViewById(R.id.sbb_publish_iv);
            this.captureIv = (ImageView)parent.findViewById(R.id.sbb_capture_iv);
        } else {
            this.uploadImgIv = (ImageView)parent.findViewById(R.id.window_sbb_student_upload_image_iv);
            this.deleteIv = (ImageView)parent.findViewById(R.id.window_sbb_student_delete_iv);
            this.takeBackCountingDownTv = (TextView)parent.findViewById(R.id.sbb_student_counting_down_tv);
            this.showNickNameCheckbox = (CheckBox)parent.findViewById(R.id.sbb_show_nickname_cb);
            this.commitBtn = (Button)parent.findViewById(R.id.sbb_commit_btn);
            this.uploadImgIv.setOnClickListener(v -> this.selectImage());
        }
    }

    private void selectImage() {
        ThemeConfig.Builder builder = new ThemeConfig.Builder();
        builder.setMainElementsColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_product_color_50_press));
        BJCommonImageCropHelper.openImageMulti((Context)this.context, (int)10, (ThemeConfig)builder.build(), (BJCommonImageCropHelper.OnHandlerResultCallback)new BJCommonImageCropHelper.OnHandlerResultCallback(){

            public void onHandlerSuccess(List<PhotoInfo> list) {
                for (PhotoInfo photoInfo : list) {
                    SmallBlackboardWindow.this.sendImageShape(photoInfo);
                }
            }

            public void onHandlerFailure(String s) {
                SmallBlackboardWindow.this.iRouter.getSubjectByKey(EventKey.ReminderErrorMessage).onNext((Object)s);
            }
        });
    }

    private void sendImageShape(PhotoInfo photoInfo) {
        if (this.whiteboardView != null) {
            this.disposableOfUploadImg = this.iRouter.getLiveRoom().getCloudFileVM().requestUploadTemporaryImage(photoInfo.getPhotoPath()).observeOn(AndroidSchedulers.mainThread()).subscribe(lpUploadDocModel -> {
                if (this.view == null) {
                    return;
                }
                File file = new File(photoInfo.getPhotoPath());
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
                int width = options.outWidth;
                int height = options.outHeight;
                int measuredWidth = this.view.getMeasuredWidth();
                int measuredHeight = this.view.getMeasuredHeight();
                if (width == 0 || height == 0) {
                    width = measuredWidth / 2;
                    height = measuredHeight / 2;
                } else {
                    float ratio = (float)width * 1.0f / (float)height;
                    if ((double)height > 0.5 * (double)measuredHeight) {
                        height = (int)(0.5 * (double)measuredHeight);
                        width = (int)(ratio * (float)height);
                    }
                    if ((double)width > 0.5 * (double)measuredWidth) {
                        width = (int)(0.5 * (double)measuredWidth);
                        height = (int)((float)width / ratio);
                    }
                }
                lpUploadDocModel.width = width;
                lpUploadDocModel.height = height;
                this.whiteboardView.sendBitmapShape(lpUploadDocModel, this.uploadImgX, this.uploadImgY);
                int _20dp = UtilsKt.getDp((int)20);
                if (this.isUploadImageAdd && ((double)this.uploadImgX > 0.6 * (double)measuredWidth || (double)this.uploadImgY > 0.6 * (double)measuredHeight)) {
                    this.isUploadImageAdd = false;
                }
                if (this.isUploadImageAdd) {
                    this.uploadImgX += _20dp;
                    this.uploadImgY += _20dp;
                }
            });
        }
    }

    private void initCommitStatusView(View parent) {
        FrameLayout commitReviewToggleView = (FrameLayout)parent.findViewById(R.id.sbb_window_commit_status_toggle_fl);
        this.commitExpandableListView = (ExpandableListView)parent.findViewById(R.id.sbb_window_commit_status_rl);
        commitReviewToggleView.setOnClickListener(v -> {
            boolean visible = this.commitExpandableListView.getVisibility() == 0;
            this.commitExpandableListView.setVisibility(visible ? 8 : 0);
            this.$.id(R.id.sbb_window_commit_status_icon).image(visible ? R.drawable.ic_sbb_open : R.drawable.ic_sbb_close);
        });
        this.adapter = new SbbExpandableListViewAdapter();
        this.commitExpandableListView.setOnChildClickListener((parent1, v, groupPosition, childPosition, id2) -> {
            SbbStatusModel statusModel = (SbbStatusModel)this.adapter.getChild(groupPosition, childPosition);
            if (statusModel.sbbStatus == SbbStatusModel.SbbStatus.COMMIT) {
                statusModel.sbbStatus = SbbStatusModel.SbbStatus.READ;
                this.notifyList();
            }
            int position = groupPosition == 1 ? this.adapter.getActiveGroupCount() + childPosition + 1 : childPosition + 1;
            this.smallBlackboardView.goToPage(position);
            return false;
        });
        this.commitExpandableListView.setOnGroupClickListener((parent12, v, groupPosition, id2) -> {
            this.commitExpandableListView.setSelectedGroup(groupPosition);
            return false;
        });
        this.commitExpandableListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (!SmallBlackboardWindow.this.isLoadMore && scrollState == 0 && view.getLastVisiblePosition() == view.getCount() - 1) {
                    SmallBlackboardWindow.this.loadMore();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.contentTopRl = (RelativeLayout)parent.findViewById(R.id.sbb_window_content_top_rl);
        this.currentReviewPageTv = (TextView)parent.findViewById(R.id.sbb_current_page_owner_tv);
        this.groupLayout = parent.findViewById(R.id.rl_layout_group);
        this.tvGroupName = (TextView)parent.findViewById(R.id.tv_group_name);
        this.circleColorView = (CircleColorView)parent.findViewById(R.id.view_group_color);
    }

    private void changeSbbStatus(SmallBlackboardStatus blackboardStatus) {
        this.windowStatus = blackboardStatus;
        switch (blackboardStatus) {
            case TEACHER_INIT: {
                this.selectUsers.clear();
                this.rlFooterContainer.setVisibility(8);
                this.rlContentContainer.removeAllViews();
                this.sbbOwnerTv.setText((CharSequence)this.getString(R.string.small_blackboard));
                View initView = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_group_layout_sbb_window_init, (ViewGroup)this.rlContentContainer);
                initView.findViewById(R.id.sbb_few_iv).setOnClickListener(v -> {
                    this.toAll = false;
                    this.changeSbbStatus(SmallBlackboardStatus.TEACHER_SELECT);
                    this.sbbOwnerTv.setText((CharSequence)this.getString(R.string.bjy_group_sbb_few));
                });
                initView.findViewById(R.id.sbb_all_iv).setOnClickListener(v -> {
                    this.toAll = true;
                    this.changeSbbStatus(SmallBlackboardStatus.TEACHER_TO_PUBLISH);
                    this.sbbOwnerTv.setText((CharSequence)this.getString(R.string.bjy_group_sbb_all));
                });
                this.ivClose.setOnClickListener(v -> {
                    this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, this.isPublishToAll));
                    this.requestSnippetPublish(3);
                });
                break;
            }
            case TEACHER_SELECT: {
                if (!this.selectUsers.isEmpty()) {
                    List studentList = this.iRouter.getLiveRoom().getOnlineUserVM().getStudentList();
                    Iterator<IUserModel> iterator = this.selectUsers.iterator();
                    while (iterator.hasNext()) {
                        IUserModel userModel = iterator.next();
                        if (studentList.contains(userModel)) continue;
                        iterator.remove();
                    }
                }
                if (!this.sbbAllList.isEmpty() && "0".equals(this.sbbAllList.get((int)0).user.getNumber())) {
                    SbbStatusModel sbbStatusModel = this.sbbAllList.get(0);
                    this.sbbAllList.clear();
                    this.sbbAllList.add(sbbStatusModel);
                    this.sbbOnSeatUserList.clear();
                    this.sbbDownSeatUserList.clear();
                    this.sbbAllList.add(sbbStatusModel);
                }
                this.uploadImgIv.setVisibility(8);
                this.deleteIv.setVisibility(8);
                this.inputCountDownTimeEt.setVisibility(8);
                this.publishBtn.setVisibility(8);
                this.inputTimeLl.setVisibility(8);
                this.reselectBtn.setVisibility(8);
                this.publishSbbToAllIv.setVisibility(8);
                this.pageContainer.setVisibility(8);
                this.captureIv.setVisibility(8);
                this.revokeBtn.setVisibility(0);
                this.takeBackBtn.setVisibility(0);
                this.revokeBtn.setText((CharSequence)this.getString(R.string.bjy_group_sbb_previous_step));
                this.takeBackBtn.setText((CharSequence)this.getString(R.string.bjy_group_sbb_next_step));
                this.takeBackBtn.setEnabled(!this.selectUsers.isEmpty());
                this.revokeBtn.setOnClickListener(v -> {
                    this.sbbStudentSelectView.destroy();
                    this.changeSbbStatus(SmallBlackboardStatus.TEACHER_INIT);
                });
                this.takeBackBtn.setOnClickListener(v -> {
                    this.sbbStudentSelectView.destroy();
                    this.changeSbbStatus(SmallBlackboardStatus.TEACHER_TO_PUBLISH);
                    this.selectUsers = this.sbbStudentSelectView.getSelectUsers();
                });
                if (this.sbbStudentSelectView == null) {
                    this.sbbStudentSelectView = new SbbStudentSelectView(this.iRouter, this.rlContentContainer);
                }
                this.ivClose.setOnClickListener(v -> {
                    this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, this.isPublishToAll));
                    this.requestSnippetPublish(3);
                });
                this.sbbStudentSelectView.setSelectListener(users -> this.takeBackBtn.setEnabled(!users.isEmpty()));
                this.sbbStudentSelectView.createView();
                this.sbbStudentSelectView.setSelectList(this.selectUsers);
                this.rlFooterContainer.setVisibility(0);
                break;
            }
            case TEACHER_TO_PUBLISH: {
                this.rlContentContainer.removeAllViews();
                this.rlFooterContainer.setVisibility(0);
                this.onCreateContentView(this.context);
                if (BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && !this.isPublishToAll) {
                    this.initExpandableListView();
                }
                this.deleteIv.setVisibility(0);
                this.publishSbbToAllIv.setVisibility(8);
                this.captureIv.setVisibility(8);
                this.inputCountDownTimeEt.setVisibility(0);
                this.publishBtn.setVisibility(0);
                this.inputTimeLl.setVisibility(0);
                this.reselectBtn.setVisibility(0);
                this.revokeBtn.setVisibility(8);
                this.takeBackBtn.setVisibility(8);
                this.pageContainer.setVisibility(8);
                this.takeBackCountingDownTv.setVisibility(8);
                this.ssbReviewStudentFl.setVisibility(8);
                this.contentTopRl.setVisibility(8);
                this.reselectBtn.setText((CharSequence)this.getString(this.toAll ? R.string.bjy_group_sbb_previous_step : R.string.bjy_group_sbb_reselect));
                this.shapeDispatcher.setTouchAble(true);
                this.ivClose.setOnClickListener(v -> {
                    this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, this.isPublishToAll));
                    this.requestSnippetPublish(3);
                });
                this.reselectBtn.setOnClickListener(v -> this.changeSbbStatus(this.toAll ? SmallBlackboardStatus.TEACHER_INIT : SmallBlackboardStatus.TEACHER_SELECT));
                this.deleteIv.setOnClickListener(v -> this.clearAllShapeWithDialog());
                this.inputCountDownTimeEt.setOnFocusChangeListener((v, hasFocus) -> {
                    if (hasFocus && "0".equals(this.inputCountDownTimeEt.getText().toString()) && !this.hasNotice) {
                        this.showToastMessage(this.getString(R.string.sbb_input_count_down_tip));
                        this.hasNotice = true;
                    }
                });
                this.inputCountDownTimeEt.addTextChangedListener((TextWatcher)new SimpleTextWatcher(){

                    public void afterTextChanged(Editable s) {
                        if (!TextUtils.isEmpty((CharSequence)s.toString()) && Integer.parseInt(s.toString()) > 150) {
                            SmallBlackboardWindow.this.inputCountDownTimeEt.setText((CharSequence)"150");
                        }
                    }
                });
                Disposable publishDisposable = QueryPlus.with((View)this.rlFooterContainer).id(R.id.sbb_publish_btn).clicks().observeOn(AndroidSchedulers.mainThread()).throttleFirst(1L, TimeUnit.SECONDS).subscribe(o -> {
                    LPSnippetPublishModel snippetPublishModel = new LPSnippetPublishModel();
                    int duration = Integer.parseInt(this.inputCountDownTimeEt.getText().toString());
                    if (TextUtils.isEmpty((CharSequence)this.windowId)) {
                        this.windowId = SBB_ID_PREFIX + System.currentTimeMillis();
                    }
                    snippetPublishModel.id = this.windowId;
                    snippetPublishModel.toAll = this.toAll;
                    snippetPublishModel.duration = duration * 60;
                    snippetPublishModel.operate = 1;
                    snippetPublishModel.from = (LPUserModel)this.iRouter.getLiveRoom().getCurrentUser();
                    if (!this.toAll) {
                        ArrayList<LPSnippetPublishModel.User> users = new ArrayList<LPSnippetPublishModel.User>();
                        for (IUserModel userModel : this.selectUsers) {
                            users.add(new LPSnippetPublishModel.User(userModel.getUserId(), userModel.getNumber()));
                        }
                        snippetPublishModel.toUserList = users;
                    }
                    this.iRouter.getLiveRoom().getToolBoxVM().requestSnippetPublish(snippetPublishModel);
                    this.timeStart = System.currentTimeMillis() / 1000L;
                    this.duration = duration * 60;
                    this.startCountingDown(this.duration, this.timeStart);
                    this.clearEditText();
                });
                this.disposables.add(publishDisposable);
                break;
            }
            case TEACHER_REVIEW: {
                this.captureIv.setVisibility(0);
                this.publishSbbToAllIv.setVisibility(8);
                this.uploadImgIv.setVisibility(8);
                this.deleteIv.setVisibility(8);
                this.inputCountDownTimeEt.setVisibility(8);
                this.publishBtn.setVisibility(8);
                this.inputTimeLl.setVisibility(8);
                this.reselectBtn.setVisibility(8);
                this.revokeBtn.setVisibility(0);
                this.takeBackBtn.setVisibility(0);
                this.ssbReviewStudentFl.setVisibility(0);
                this.contentTopRl.setVisibility(0);
                this.shapeDispatcher.setTouchAble(false);
                this.updateCurrentReviewTips();
                this.updateFooterPageTips(this.currentPage);
                this.takeBackBtn.setText((CharSequence)this.getView().getContext().getString(R.string.sbb_take_back));
                this.revokeBtn.setText((CharSequence)this.getView().getContext().getString(R.string.sbb_revoke));
                this.ivClose.setOnClickListener(v -> SmallBlackboardDialogUtil.showDialog(this.getView(), this.getString(R.string.sbb_close_all_window_in_publish_status), v12 -> {
                    this.requestSnippetPublish(0);
                    this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, true));
                    this.requestSnippetPublish(3);
                }));
                this.captureIv.setOnClickListener(v -> this.capture());
                this.revokeBtn.setOnClickListener(v -> SmallBlackboardDialogUtil.showDialog(this.view, this.getString(R.string.sbb_revoke_hint), o -> {
                    this.requestSnippetPublish(2);
                    this.cancelCountDown();
                    this.takeBackCountingDownTv.setVisibility(8);
                    this.eraseAllShape();
                }));
                this.takeBackBtn.setOnClickListener(v -> SmallBlackboardDialogUtil.showDialog(this.getView(), this.getString(R.string.sbb_close_confirm), v1 -> {
                    this.requestSnippetPublish(0);
                    this.cancelCountDown();
                    this.takeBackCountingDownTv.setVisibility(8);
                    this.changeSbbStatus(SmallBlackboardStatus.ALL_COMMITTED);
                }));
                this.prePageIV.setOnClickListener(v -> this.smallBlackboardView.prePage());
                this.nextPageIv.setOnClickListener(v -> this.smallBlackboardView.nextPage());
                if (!this.isRePublish) {
                    this.startCountingDown(this.duration, this.timeStart);
                    this.takeBackCountingDownTv.setVisibility(0);
                } else {
                    this.takeBackCountingDownTv.setVisibility(8);
                }
                this.isRePublish = false;
                break;
            }
            case ALL_COMMITTED: {
                this.revokeBtn.setVisibility(0);
                this.takeBackBtn.setVisibility(0);
                this.contentTopRl.setVisibility(0);
                this.ssbReviewStudentFl.setVisibility(0);
                this.reselectBtn.setVisibility(8);
                this.updateCurrentReviewTips();
                this.updateFooterPageTips(this.currentPage);
                this.captureIv.setVisibility(0);
                this.publishSbbToAllIv.setVisibility(0);
                this.publishSbbToAllIv.setOnClickListener(v -> {
                    int position = -1;
                    for (int i = 0; i < this.layerList.size(); ++i) {
                        if (!this.layer.equals(this.layerList.get(i))) continue;
                        position = i;
                        break;
                    }
                    IUserModel userModel = null;
                    for (SbbStatusModel statusModel : this.sbbAllList) {
                        if (!statusModel.user.getNumber().equals(this.layer)) continue;
                        userModel = statusModel.user;
                        this.sbbAllList.remove(statusModel);
                        this.sbbOnSeatUserList.remove(statusModel);
                        this.sbbDownSeatUserList.remove(statusModel);
                        this.adapter.notifyDataSetChanged();
                        break;
                    }
                    this.layerList.remove(this.layer);
                    this.smallBlackboardView.initData(this.layerList);
                    if (position > 0) {
                        this.smallBlackboardView.prePage();
                    } else if (position == 0 && this.layerList.size() > 0) {
                        this.smallBlackboardView.goToPage(0);
                        this.layer = this.layerList.get(0);
                        this.updateCurrentReviewTips();
                        this.updateFooterPageTips(position + 1);
                    }
                    if (userModel != null) {
                        LPSnippetSubmitModel lpSnippetSubmitModel = new LPSnippetSubmitModel();
                        lpSnippetSubmitModel.id = this.windowId;
                        if (userModel instanceof LPUserModel) {
                            lpSnippetSubmitModel.from = (LPUserModel)userModel;
                        }
                        this.iRouter.getSubjectByKey(EventKey.SbbAddWindow).onNext((Object)lpSnippetSubmitModel);
                        this.sbbAllSubmitSet.add(userModel);
                    }
                    if (this.layerList.size() == 0) {
                        this.changeSbbStatus(SmallBlackboardStatus.EMPTY);
                    }
                });
                this.takeBackBtn.setText((CharSequence)this.getView().getContext().getString(R.string.sbb_republish));
                this.revokeBtn.setText((CharSequence)this.getView().getContext().getString(R.string.sbb_edit_again));
                this.takeBackBtn.setOnClickListener(v -> {
                    this.isRePublish = true;
                    LPSnippetPublishModel snippetPublishModel = new LPSnippetPublishModel();
                    if (TextUtils.isEmpty((CharSequence)this.windowId)) {
                        this.windowId = SBB_ID_PREFIX + System.currentTimeMillis();
                    }
                    snippetPublishModel.id = this.windowId;
                    snippetPublishModel.toAll = this.toAll;
                    snippetPublishModel.duration = 0;
                    snippetPublishModel.operate = 1;
                    snippetPublishModel.from = (LPUserModel)this.iRouter.getLiveRoom().getCurrentUser();
                    if (!this.toAll) {
                        ArrayList<LPSnippetPublishModel.User> users = new ArrayList<LPSnippetPublishModel.User>();
                        for (IUserModel userModel : this.selectUsers) {
                            users.add(new LPSnippetPublishModel.User(userModel.getUserId(), userModel.getNumber()));
                        }
                        snippetPublishModel.toUserList = users;
                    }
                    this.iRouter.getLiveRoom().getToolBoxVM().requestSnippetPublish(snippetPublishModel);
                    this.clearEditText();
                });
                this.revokeBtn.setOnClickListener(v -> {
                    this.smallBlackboardView.goToPage(0);
                    this.changeSbbStatus(SmallBlackboardStatus.TEACHER_TO_PUBLISH);
                    this.eraseAllShape();
                });
                this.shapeDispatcher.setTouchAble(true);
                this.ivClose.setOnClickListener(v -> {
                    this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, this.isPublishToAll));
                    this.requestSnippetPublish(3);
                });
                this.prePageIV.setOnClickListener(v -> this.smallBlackboardView.prePage());
                this.nextPageIv.setOnClickListener(v -> this.smallBlackboardView.nextPage());
                this.captureIv.setOnClickListener(v -> this.capture());
                for (SbbStatusModel statusModel : this.sbbAllList) {
                    if (statusModel.sbbStatus == SbbStatusModel.SbbStatus.READ) continue;
                    statusModel.sbbStatus = SbbStatusModel.SbbStatus.COMMIT;
                }
                this.adapter.notifyDataSetChanged();
                break;
            }
            case PUBLISH_TO_ALL: {
                this.uploadImgIv.setVisibility(8);
                this.deleteIv.setVisibility(8);
                this.takeBackCountingDownTv.setVisibility(8);
                this.cancelCountDown();
                this.shapeDispatcher.setTouchAble(true);
                if (BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())) {
                    View.OnClickListener onClickListener = v -> this.iRouter.getSubjectByKey(EventKey.SbbCloseWindow).onNext((Object)new SbbCloseWindowEvent(this.getId(), this.layer, true));
                    this.ivClose.setOnClickListener(onClickListener);
                    this.commitBtn.setOnClickListener(onClickListener);
                    this.commitBtn.setText((CharSequence)this.getView().getContext().getString(R.string.sbb_close));
                    this.showNickNameCheckbox.setVisibility(0);
                    this.showNickNameCheckbox.setOnClickListener(v -> this.iRouter.getSubjectByKey(EventKey.SbbShowName).onNext((Object)this));
                    this.setOnSingleTapListener(event -> {
                        if (this.iRouter == null) {
                            return;
                        }
                        this.iRouter.getSubjectByKey(EventKey.SbbBringToFront).onNext((Object)this.getId());
                    });
                    break;
                }
                this.ivClose.setVisibility(8);
                this.ivMaxSync.setVisibility(8);
                this.minIv.setVisibility(8);
                this.rlFooterContainer.setVisibility(8);
                break;
            }
            case STUDENT_WRITING: {
                this.ivClose.setVisibility(8);
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.ivMaxSync.getLayoutParams();
                layoutParams.addRule(11);
                this.deleteIv.setOnClickListener(v -> this.clearAllShapeWithDialog());
                this.commitBtn.setOnClickListener(v -> {
                    this.commitBtn.setEnabled(false);
                    this.cancelCountDown();
                    this.requestSnippetSubmit();
                    if (this.subSbbWindowCount() <= 0) {
                        this.iRouter.getSubjectByKey(EventKey.SbbShowToolBarWindow).onNext((Object)0);
                        this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
                    }
                });
                this.setAllowTouch(true);
                this.shapeDispatcher.setTouchAble(true);
                this.sbbOwnerTv.setText((CharSequence)this.getString(this.toAll ? R.string.bjy_group_sbb_all : R.string.bjy_group_sbb_few));
                break;
            }
            case EMPTY: {
                this.ssbReviewStudentFl.setVisibility(8);
                this.contentTopRl.setVisibility(8);
                this.takeBackBtn.setVisibility(8);
                this.revokeBtn.setVisibility(8);
                this.reselectBtn.setVisibility(8);
                break;
            }
        }
    }

    private void capture() {
        if (this.context instanceof Activity) {
            RxUtils.dispose((Disposable)this.disposableOfPermission);
            String[] permissions = new String[]{Build.VERSION.SDK_INT >= 33 ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.WRITE_EXTERNAL_STORAGE"};
            this.disposableOfPermission = AppPermissions.newPermissions((Activity)((Activity)this.context)).request(permissions).subscribe(aBoolean -> {
                if (aBoolean.booleanValue()) {
                    DisplayUtils.saveViewCapture((View)this.getView(), (String)Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath());
                    this.showTips(this.getString(R.string.sbb_capture_tip), 3);
                } else {
                    ToastCompat.showToast((Context)this.context, (CharSequence)this.context.getString(R.string.live_no_write_permission), (int)0);
                }
            });
        } else {
            DisplayUtils.saveViewCapture((View)this.getView(), (String)Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath());
            this.showTips(this.getString(R.string.sbb_capture_tip), 3);
        }
    }

    private void clearEditText() {
        Object value = this.iRouter.getSubjectByKey(EventKey.DrawTextEnable).getValue();
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            this.iRouter.getSubjectByKey(EventKey.ClearEditText).onNext((Object)true);
        }
    }

    private void startReviewPageUpdateCountingDown(String text) {
        this.currentReviewPageTv.setVisibility(0);
        this.currentReviewPageTv.setText((CharSequence)text);
        RxUtils.dispose((Disposable)this.previewUpdateCountingDown);
        this.previewUpdateCountingDown = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (aLong >= 3L) {
                this.currentReviewPageTv.setVisibility(4);
                RxUtils.dispose((Disposable)this.previewUpdateCountingDown);
            }
        });
    }

    private void updateCurrentReviewTips() {
        LPUserModel currentUser = this.getUserByLayer(this.layer);
        if (currentUser != null) {
            this.startReviewPageUpdateCountingDown(currentUser.getName());
        } else {
            this.currentReviewPageTv.setVisibility(4);
        }
        if (currentUser != null && currentUser.getType() != LPConstants.LPUserType.Teacher && currentUser.getType() != LPConstants.LPUserType.Assistant) {
            LPUserModel lpUserModel = this.convertGroupUser(currentUser.number);
            if (lpUserModel != null) {
                currentUser = lpUserModel;
            }
            if (currentUser.groupId != 0 && currentUser.groupItem != null) {
                this.groupLayout.setVisibility(0);
                this.tvGroupName.setText((CharSequence)currentUser.groupItem.name);
                this.circleColorView.setColor(Color.parseColor((String)currentUser.groupItem.color));
            } else {
                this.groupLayout.setVisibility(8);
            }
        } else {
            this.groupLayout.setVisibility(8);
        }
    }

    private void showTips(String content, int delay) {
        if (this.isMinInSync) {
            this.showToastMessage(content);
        } else {
            SmallBlackboardDialogUtil.showTips(this.view, content, delay);
        }
    }

    private void updateFooterPageTips(int currentPos) {
        if (this.pageContainer == null || this.windowStatus == SmallBlackboardStatus.TEACHER_TO_PUBLISH || this.windowStatus == SmallBlackboardStatus.TEACHER_INIT || this.windowStatus == SmallBlackboardStatus.TEACHER_SELECT) {
            return;
        }
        this.currentPage = currentPos;
        if (this.smallBlackboardView.getItemCount() <= 1) {
            this.pageContainer.setVisibility(8);
        } else {
            this.pageContainer.setVisibility(0);
            this.pageTipTv.setText((CharSequence)(currentPos + "/" + this.smallBlackboardView.getItemCount()));
        }
    }

    private void startCountingDown(int duration, long timeStart) {
        RxUtils.dispose((Disposable)this.timerDisposable);
        if (duration == 0) {
            this.takeBackCountingDownTv.setVisibility(8);
        } else {
            long time = System.currentTimeMillis() / 1000L - timeStart;
            this.countDownLeftTime = (int)((long)duration - time);
            if (this.countDownLeftTime <= 0) {
                this.onTimeToSubmit();
            } else {
                this.timerDisposable = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
                    --this.countDownLeftTime;
                    if (this.countDownLeftTime == 0) {
                        this.takeBackCountingDownTv.setVisibility(8);
                        this.onTimeToSubmit();
                        this.timerDisposable.dispose();
                        return;
                    }
                    if (BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())) {
                        this.takeBackCountingDownTv.setText((CharSequence)this.getView().getContext().getString(R.string.sbb_counting_down_sec_time, new Object[]{TimeUtilsKt.format24HoursTime((int)this.countDownLeftTime)}));
                    } else {
                        this.takeBackCountingDownTv.setText((CharSequence)TimeUtilsKt.format24HoursTime((int)this.countDownLeftTime));
                    }
                });
            }
            this.takeBackCountingDownTv.setVisibility(0);
        }
    }

    private void cancelCountDown() {
        RxUtils.dispose((Disposable)this.timerDisposable);
    }

    private void onTimeToSubmit() {
        this.isCloseByTeacher = true;
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
            this.requestSnippetPublish(0);
        }
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            this.requestSnippetSubmit();
        }
    }

    public void instantiateWhiteboardView(WhiteboardView whiteboardView, String layer, int width, int height) {
        if (!this.isTeacher) {
            this.whiteboardView = whiteboardView;
        }
        whiteboardView.setShapeSendListener((WhiteboardView.LPShapeSendListener)this);
        whiteboardView.setIdentity(layer + SBB_ID_INFIX + this.windowId, 0, 0);
        if (this.windowStatus == SmallBlackboardStatus.TEACHER_REVIEW) {
            whiteboardView.setTouchAble(false);
        }
        whiteboardView.setCustomShapeStrokeWidth(this.shapePaint.getCustomStrokeWidth());
        whiteboardView.setShapeStrokeWidth(this.shapePaint.getDoodleStrokeWidth());
        whiteboardView.setShapeColor(this.shapePaint.getShapeColor());
        whiteboardView.setPaintTextSize(this.shapePaint.getTextSize());
        whiteboardView.setCustomShapeType(this.shapePaint.getShapeType());
        whiteboardView.setPPTEditMode(this.shapePaint.getPPtEditMode());
        whiteboardView.setUserRole(this.liveRoom.getCurrentUser().getType());
        whiteboardView.setEnableEraseTeacherPaint(this.liveRoom.getPartnerConfig().enableEraseTeacherPaint);
        whiteboardView.setOnDoubleTapListener(new OnDoubleTapListener2(){

            public void onDoubleTapConfirmed() {
            }

            public void onDoubleTapOnShape(Shape shape) {
                SmallBlackboardWindow.this.iRouter.getSubjectByKey(EventKey.EditTextShape).onNext((Object)((TextShape)shape).getText());
            }
        });
        this.shapeDispatcher.addWhiteboard((Whiteboard)whiteboardView);
        this.shapeDispatcher.setWhiteboardWidthAndHeight(width, height);
        this.shapeVM.requestPageAllShape(this.windowId, 0, layer, true);
    }

    public void destroyWhiteboardView(WhiteboardView whiteboardView) {
        this.shapeDispatcher.removeWhiteboard((Whiteboard)whiteboardView);
    }

    public void onViewTap(View view, float x, float y) {
        if (this.iRouter != null) {
            this.iRouter.getSubjectByKey(EventKey.BgSingleTapConfirmed).onNext((Object)true);
        }
    }

    public void onPageChange(int position, String layer) {
        LPLogger.e((String)"yjm", (String)("shape onPageChange position=" + position + ", layer=" + layer));
        this.layer = layer;
        this.updateCurrentReviewTips();
        this.updateFooterPageTips(position + 1);
        if (position < this.sbbAllList.size() && this.sbbAllList.get((int)position).sbbStatus == SbbStatusModel.SbbStatus.COMMIT) {
            this.sbbAllList.get((int)position).sbbStatus = SbbStatusModel.SbbStatus.READ;
            this.adapter.notifyDataSetChanged();
        }
        this.shapeVM.requestPageAllShape(this.windowId, 0, layer, true);
    }

    @Override
    public void onShapeCustomStrokeWidthChange(float strokeWidth) {
        this.shapeDispatcher.setCustomShapeStrokeWidth(strokeWidth);
    }

    @Override
    public void onShapeDoodleStrokeWidthChange(float strokeWidth) {
        this.shapeDispatcher.setShapeStrokeWidth(strokeWidth);
    }

    @Override
    public void onShapeColorChange(int shapeColor) {
        this.shapeDispatcher.setPaintColor(shapeColor);
    }

    @Override
    public void onShapeTypeChange(LPConstants.ShapeType shapeType) {
        this.shapeDispatcher.setCustomShapeType(shapeType);
    }

    @Override
    public void onShapeEditModeChange(LPConstants.PPTEditMode pptEditMode) {
        this.shapeDispatcher.setPPTEditMode(pptEditMode);
    }

    @Override
    public void onShapeTextSizeChange(int textSize) {
        this.shapeDispatcher.setPaintTextSize(textSize);
    }

    @Override
    public void onSendDrawTextConfirmed(String beforeText, String content) {
        this.shapeDispatcher.sendDrawTextConfirmed(beforeText, content);
    }

    public void invalidateTextBoundary() {
        this.shapeDispatcher.invalidateCurrentPage();
    }

    public void sendShape(Shape shape, LPWhiteboardViewInfo whiteboardViewInfo) {
        LPResRoomShapeSingleModel model = new LPResRoomShapeSingleModel();
        model.shape = LPShapeConverter.getModelFromShape((Shape)shape, (int)whiteboardViewInfo.viewWidth, (int)whiteboardViewInfo.viewHeight, (int)whiteboardViewInfo.offsetWidth, (int)whiteboardViewInfo.offsetHeight, (int)(shape instanceof DoodleShape ? 0 : 1));
        model.docId = this.windowId;
        model.page = 0;
        model.layer = this.layer;
        model.shape.dashType = whiteboardViewInfo.dashType;
        this.shapeVM.requestShapeAdd(model, whiteboardViewInfo.hasAppend, true);
    }

    public boolean eraseShape(Shape shape, String docId, int page) {
        LPResRoomShapeDelModel lpResRoomShapeDelModel = new LPResRoomShapeDelModel();
        lpResRoomShapeDelModel.docId = this.windowId;
        lpResRoomShapeDelModel.page = page;
        lpResRoomShapeDelModel.shapeId = shape.id;
        lpResRoomShapeDelModel.layer = this.layer;
        this.shapeVM.eraseShape(lpResRoomShapeDelModel, true);
        return true;
    }

    public void shapeUpdate(List<Shape> shapes, LPWhiteboardViewInfo whiteboardViewInfo) {
        if (shapes == null || shapes.size() == 0) {
            return;
        }
        LPResRoomShapeMultipleModel multipleModel = new LPResRoomShapeMultipleModel();
        multipleModel.docId = this.windowId;
        multipleModel.layer = this.layer;
        ArrayList<LPShapeModel> shapeModels = new ArrayList<LPShapeModel>();
        for (Shape shape : shapes) {
            shapeModels.add(LPShapeConverter.getModelFromShape((Shape)shape, (int)whiteboardViewInfo.viewWidth, (int)whiteboardViewInfo.viewHeight, (int)whiteboardViewInfo.offsetWidth, (int)whiteboardViewInfo.offsetHeight, (int)1));
        }
        multipleModel.shapeList = shapeModels;
        this.shapeVM.requestShapeUpdate(multipleModel, true);
    }

    public void laserShapeUpdate(Shape shape, LPWhiteboardViewInfo whiteboardViewInfo) {
        if (shape == null) {
            return;
        }
        if (shape.isHoverTrace && !this.liveRoom.getPartnerConfig().livePainterShowTraceBeforeDraw) {
            return;
        }
        LPResRoomShapeSingleModel singleModel = new LPResRoomShapeSingleModel();
        singleModel.docId = this.windowId;
        singleModel.layer = this.layer;
        singleModel.shape = LPShapeConverter.getModelFromShape((Shape)shape, (int)whiteboardViewInfo.viewWidth, (int)whiteboardViewInfo.viewHeight, (int)whiteboardViewInfo.offsetWidth, (int)whiteboardViewInfo.offsetHeight, (int)1);
        if (shape.isHoverTrace && this.liveRoom.getPartnerConfig().livePainterShowTraceBeforeDraw) {
            singleModel.shape.setShapeType(LPConstants.ShapeType.Doodle);
            singleModel.shape.strokeStyle = LPShapeConverter.getColorHex((int)shape.getPaint().getColor());
        }
        if (shape instanceof LaserShape) {
            this.shapeVM.requestShapeLaserUpdate(singleModel, true);
        }
    }

    public void sendShapeAppend(Shape shape, LPWhiteboardViewInfo whiteboardViewInfo, int index) {
        LPResRoomShapeSingleModel model = new LPResRoomShapeSingleModel();
        model.docId = this.windowId;
        model.layer = this.layer;
        model.shape = LPShapeConverter.getModelFromShape((Shape)shape, (int)whiteboardViewInfo.viewWidth, (int)whiteboardViewInfo.viewHeight, (int)whiteboardViewInfo.offsetWidth, (int)whiteboardViewInfo.offsetHeight, (int)0);
        model.shape.index = index;
        model.shape.isEnd = whiteboardViewInfo.isEnd;
        this.shapeVM.requestShapeAppend(model, true);
    }

    public void setCurrentLayer(String windowId) {
        int index;
        if (windowId.startsWith(SBB_ID_PREFIX)) {
            this.windowId = this.originWindowId = windowId;
        } else {
            index = windowId.indexOf(SBB_ID_PREFIX);
            this.windowId = index != -1 ? windowId.substring(index) : windowId;
            this.originWindowId = windowId;
        }
        index = windowId.indexOf(SBB_ID_INFIX);
        if (index != -1) {
            this.layer = windowId.substring(0, index);
            if (!StringUtils.isNumeric((String)this.layer)) {
                this.layer = "0";
            }
        }
        if ("0".equals(this.layer) && !BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && windowId.startsWith(SBB_ID_PREFIX)) {
            this.layer = this.iRouter.getLiveRoom().getCurrentUser().getNumber();
        }
    }

    public void eraseShapes() {
        String deleteIds = this.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Assistant ? this.shapeDispatcher.eraseShapes(this.layer + SBB_ID_INFIX + this.windowId, 0) : (this.liveRoom.getPartnerConfig().enableEraseTeacherPaint ? this.shapeDispatcher.eraseShapes(this.layer + SBB_ID_INFIX + this.windowId, 0) : this.shapeDispatcher.eraseFilterShapes(this.layer + SBB_ID_INFIX + this.windowId, 0, new LPConstants.LPUserType[]{LPConstants.LPUserType.Teacher, LPConstants.LPUserType.Assistant}));
        if (TextUtils.isEmpty((CharSequence)deleteIds)) {
            return;
        }
        LPResRoomShapeDelModel model = new LPResRoomShapeDelModel();
        model.docId = this.windowId;
        model.page = 0;
        model.shapeId = deleteIds;
        model.layer = this.layer;
        this.shapeVM.eraseShape(model, true);
    }

    public void eraseAllShape() {
        LPResRoomShapeDelModel model = new LPResRoomShapeDelModel();
        model.docId = this.windowId;
        model.page = 0;
        model.layer = "all";
        model.shapeId = "";
        this.shapeVM.eraseShape(model, true);
    }

    public void setPPTEditMode(LPConstants.PPTEditMode editMode) {
        this.shapeDispatcher.setPPTEditMode(editMode);
    }

    private void requestSnippetPublish(int operate) {
        if (this.iRouter.getLiveRoom().isAudition()) {
            return;
        }
        LPSnippetPublishModel snippetPublishModel = new LPSnippetPublishModel();
        snippetPublishModel.from = (LPUserModel)this.iRouter.getLiveRoom().getCurrentUser();
        snippetPublishModel.operate = operate;
        if (TextUtils.isEmpty((CharSequence)this.windowId)) {
            this.windowId = SBB_ID_PREFIX + System.currentTimeMillis();
        }
        snippetPublishModel.id = this.windowId;
        snippetPublishModel.toAll = this.toAll;
        if (!this.toAll) {
            ArrayList<LPSnippetPublishModel.User> users = new ArrayList<LPSnippetPublishModel.User>();
            for (IUserModel userModel : this.selectUsers) {
                users.add(new LPSnippetPublishModel.User(userModel.getUserId(), userModel.getNumber()));
            }
            snippetPublishModel.toUserList = users;
        }
        this.iRouter.getLiveRoom().getToolBoxVM().requestSnippetPublish(snippetPublishModel);
    }

    private void requestSnippetSubmit() {
        LPSnippetSubmitModel submitModel = new LPSnippetSubmitModel();
        submitModel.from = (LPUserModel)this.iRouter.getLiveRoom().getCurrentUser();
        submitModel.id = this.windowId;
        this.iRouter.getLiveRoom().getToolBoxVM().requestSnippetSubmit(submitModel);
    }

    @Override
    public String getId() {
        if (TextUtils.isEmpty((CharSequence)this.originWindowId)) {
            this.originWindowId = this.windowId;
        }
        return this.originWindowId;
    }

    public static String getUserNumber(@NonNull String windowId) {
        int index = windowId.indexOf(SBB_ID_INFIX);
        if (index != -1) {
            return windowId.substring(0, index);
        }
        return "";
    }

    @Override
    public void onDestroy() {
        this.smallBlackboardView = null;
        if (this.shapePaint != null) {
            this.shapePaint.unregisterShapePaintListener(this);
        }
        if (this.shapeDispatcher != null) {
            this.shapeDispatcher.onDestroy();
        }
        if (this.liveRoom != null) {
            this.liveRoom = null;
        }
        this.disposables.clear();
        this.cancelCountDown();
        RxUtils.dispose((Disposable)this.previewUpdateCountingDown);
        RxUtils.dispose((Disposable)this.disposableOfPermission);
        RxUtils.dispose((Disposable)this.disposableOfUploadImg);
        super.onDestroy();
    }

    private LPUserModel getUserByLayer(String layer) {
        for (SbbStatusModel sbbStatusModel : this.sbbAllList) {
            if (!sbbStatusModel.user.getNumber().equals(layer)) continue;
            return (LPUserModel)sbbStatusModel.user;
        }
        return null;
    }

    public void setToAll(boolean toAll) {
        this.toAll = toAll;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmallBlackboardWindow)) {
            return false;
        }
        if (this.layer == null) {
            return false;
        }
        return this.layer.equals(((SmallBlackboardWindow)obj).layer);
    }

    public void showWindowOwnerName(LPDocViewElementModel model) {
        if (TextUtils.isEmpty((CharSequence)model.name)) {
            this.sbbOwnerTv.setText((CharSequence)this.getString(R.string.small_blackboard));
            this.viewContainer.setVisibility(8);
        } else {
            String userNum = model.docId.substring(0, model.docId.indexOf(SBB_ID_INFIX));
            LPUserModel lpUserModel = this.convertGroupUser(userNum);
            if (lpUserModel != null && lpUserModel.groupId != 0 && lpUserModel.groupItem != null) {
                this.viewContainer.setVisibility(0);
                this.tvGroupNameSbb.setText((CharSequence)lpUserModel.groupItem.name);
                this.circleColorViewSbb.setColor(Color.parseColor((String)lpUserModel.groupItem.color));
            } else {
                this.viewContainer.setVisibility(8);
            }
            this.sbbOwnerTv.setText((CharSequence)this.getView().getContext().getString(R.string.sbb_owner_name, new Object[]{UtilsKt.getEncodePhoneNumber((String)model.name)}));
        }
    }

    public boolean shouldShowOwnerName() {
        if (!this.isPublishToAll || this.showNickNameCheckbox == null) {
            return false;
        }
        return this.showNickNameCheckbox.isChecked();
    }

    private void clearAllShapeWithDialog() {
        SmallBlackboardDialogUtil.showDialog(this.getView(), this.getString(R.string.sbb_clear_all_shape_tip), v -> {
            LPResRoomShapeDelModel delModel = new LPResRoomShapeDelModel();
            delModel.docId = this.windowId;
            delModel.layer = this.layer;
            this.shapeVM.eraseAllShape(delModel, true);
        });
    }

    private void addSbbUser(LPSnippetPullResModel snippetPullResModel) {
        if (this.windowStatus == SmallBlackboardStatus.ALL_COMMITTED) {
            if (snippetPullResModel.userParticipatedList != null) {
                ArrayList<SbbStatusModel> statusModels = new ArrayList<SbbStatusModel>();
                for (IUserModel participateUser : snippetPullResModel.userParticipatedList) {
                    SbbStatusModel model = new SbbStatusModel(participateUser, SbbStatusModel.SbbStatus.COMMIT);
                    statusModels.add(model);
                }
                this.sortSbbUser(statusModels);
            }
        } else {
            SbbStatusModel model;
            ArrayList<SbbStatusModel> statusModels;
            if (snippetPullResModel.userParticipatedList != null) {
                statusModels = new ArrayList<SbbStatusModel>();
                for (IUserModel participateUser : snippetPullResModel.userParticipatedList) {
                    model = new SbbStatusModel(participateUser, SbbStatusModel.SbbStatus.NORMAL);
                    statusModels.add(model);
                }
                this.sortSbbUser(statusModels);
            }
            if (snippetPullResModel.userSubmittedList != null) {
                statusModels = new ArrayList();
                for (IUserModel submitUser : snippetPullResModel.userSubmittedList) {
                    model = new SbbStatusModel(submitUser, SbbStatusModel.SbbStatus.COMMIT);
                    statusModels.add(model);
                }
                this.sortSbbUser(statusModels);
            }
        }
    }

    private void sortSbbUser(SbbStatusModel model, boolean remainStatus) {
        SbbStatusModel removedModel = null;
        int index1 = this.sbbOnSeatUserList.indexOf(model);
        int index2 = this.sbbDownSeatUserList.indexOf(model);
        if (index1 >= 0) {
            removedModel = this.sbbOnSeatUserList.get(index1);
            this.sbbOnSeatUserList.remove(model);
        }
        if (index2 >= 0) {
            removedModel = this.sbbDownSeatUserList.get(index2);
            this.sbbDownSeatUserList.remove(index2);
        }
        if (remainStatus && removedModel != null) {
            model.sbbStatus = removedModel.sbbStatus;
        }
        if (this.isActiveUser(model.user)) {
            if (!this.sbbOnSeatUserList.contains(model)) {
                this.sbbOnSeatUserList.add(model);
            }
        } else if (!this.sbbDownSeatUserList.contains(model)) {
            this.sbbDownSeatUserList.add(model);
        }
        this.sortSbbUserInternal();
    }

    private boolean isActiveUser(IUserModel userModel) {
        List activeUserList = this.iRouter.getLiveRoom().getOnlineUserVM().getActiveUserList();
        for (IUserModel user : activeUserList) {
            if (!TextUtils.equals((CharSequence)user.getNumber(), (CharSequence)userModel.getNumber())) continue;
            return true;
        }
        return false;
    }

    private void sortSbbUser(List<SbbStatusModel> sbbStatusModelList) {
        for (SbbStatusModel model : sbbStatusModelList) {
            if (this.sbbAllList.contains(model)) continue;
            if (this.isActiveUser(model.user)) {
                if (this.sbbOnSeatUserList.contains(model)) continue;
                this.sbbOnSeatUserList.add(model);
                continue;
            }
            if (this.sbbDownSeatUserList.contains(model)) continue;
            this.sbbDownSeatUserList.add(model);
        }
        this.sortSbbUserInternal();
    }

    private void sortSbbUserInternal() {
        SbbStatusModel sbbTeacher = null;
        if (!this.sbbAllList.isEmpty() && "0".equals(this.sbbAllList.get((int)0).user.getNumber())) {
            sbbTeacher = this.sbbAllList.get(0);
        }
        this.sbbAllList.clear();
        if (sbbTeacher != null) {
            this.sbbAllList.add(sbbTeacher);
        }
        this.sbbAllList.addAll(this.sbbOnSeatUserList);
        this.sbbAllList.addAll(this.sbbDownSeatUserList);
        this.notifyList();
        this.layerList.clear();
        if (sbbTeacher != null) {
            this.layerList.add("0");
        }
        for (SbbStatusModel statusModel : this.sbbOnSeatUserList) {
            this.layerList.add(statusModel.user.getNumber());
        }
        for (SbbStatusModel statusModel : this.sbbDownSeatUserList) {
            this.layerList.add(statusModel.user.getNumber());
        }
        this.smallBlackboardView.initData(this.layerList);
        this.updateFooterPageTips(this.currentPage);
    }

    private void loadMore() {
        if (BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) && (this.hasMore || System.currentTimeMillis() - this.loadMoreTimeStamp > 5000L)) {
            LPSnippetPullReqModel pullReqModel = new LPSnippetPullReqModel(this.windowId);
            pullReqModel.count = 10;
            pullReqModel.cursor = this.cursor;
            List activeUserList = this.iRouter.getLiveRoom().getOnlineUserVM().getActiveUserList();
            ArrayList<String> activeUserNumbers = new ArrayList<String>();
            for (int i = 0; i < activeUserList.size(); ++i) {
                if (this.iRouter.getLiveRoom().getCurrentUser().equals(activeUserList.get(i))) continue;
                activeUserNumbers.add(((IUserModel)activeUserList.get(i)).getNumber());
            }
            pullReqModel.activedUser = activeUserNumbers.toArray(new String[0]);
            this.iRouter.getLiveRoom().getToolBoxVM().requestSnippetPullReq(pullReqModel);
            this.isLoadMore = true;
            this.loadMoreTimeStamp = System.currentTimeMillis();
        }
    }

    private LPUserModel convertGroupUser(String userNum) {
        List groupList = this.iRouter.getLiveRoom().getOnlineUserVM().getGroupList();
        for (LPGroupItem groupItem : groupList) {
            List userModelList = groupItem.userModelList;
            for (LPUserModel lpUserModel : userModelList) {
                if (!userNum.equals(lpUserModel.getNumber())) continue;
                lpUserModel.groupItem = groupItem.groupItemModel;
                return lpUserModel;
            }
        }
        return null;
    }

    private void convertGroupUser(List<SbbStatusModel> sbbStatusModels) {
        List groupList = this.iRouter.getLiveRoom().getOnlineUserVM().getGroupList();
        ArrayList<LPUserModel> userModels = new ArrayList<LPUserModel>();
        for (LPGroupItem groupItem : groupList) {
            List userModelList = groupItem.userModelList;
            for (LPUserModel lpUserModel : userModelList) {
                lpUserModel.groupItem = groupItem.groupItemModel;
                userModels.add(lpUserModel);
            }
        }
        for (SbbStatusModel statusModel : sbbStatusModels) {
            for (LPUserModel userModel : userModels) {
                LPUserModel lpUserModel;
                if (!statusModel.user.getNumber().equals(userModel.getNumber())) continue;
                lpUserModel = (LPUserModel)statusModel.user;
                lpUserModel.groupId = userModel.groupId;
                lpUserModel.groupItem = userModel.groupItem;
            }
        }
    }

    public void notifyList() {
        this.convertGroupUser(this.sbbOnSeatUserList);
        this.convertGroupUser(this.sbbDownSeatUserList);
        this.adapter.notifyDataSetChanged();
    }

    private void initExpandableListView() {
        this.convertGroupUser(this.sbbOnSeatUserList);
        this.convertGroupUser(this.sbbDownSeatUserList);
        this.adapter.setData(this.sbbOnSeatUserList, this.sbbDownSeatUserList);
        LinearLayout linearLayout = new LinearLayout(this.context);
        linearLayout.setOrientation(0);
        TextView textView = new TextView(this.context);
        textView.setTextSize(2, 16.0f);
        textView.setText((CharSequence)this.sbbAllList.get((int)0).user.getName());
        textView.setGravity(0x800003);
        textView.setMaxLines(1);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        int _4dp = UtilsKt.getDp((int)4);
        textView.setPadding(_4dp, _4dp, _4dp, _4dp);
        textView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
        linearLayout.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        linearLayout.setOnClickListener(v -> this.smallBlackboardView.goToPage(0));
        this.commitExpandableListView.addHeaderView((View)linearLayout);
        this.commitExpandableListView.setAdapter((ExpandableListAdapter)this.adapter);
        this.commitExpandableListView.expandGroup(0);
    }

    @Override
    public void maxInFull() {
        super.maxInFull();
        this.invalidateCurrentPage();
    }

    @Override
    public void resetInFull() {
        super.resetInFull();
        this.invalidateCurrentPage();
    }

    @Override
    public void maxInSync() {
        super.maxInSync();
        this.invalidateCurrentPage();
    }

    @Override
    public void resetInSync() {
        super.resetInSync();
        this.invalidateCurrentPage();
    }

    private void invalidateCurrentPage() {
        this.smallBlackboardView.getView().post(() -> {
            this.shapeDispatcher.setWhiteboardWidthAndHeight(this.smallBlackboardView.getView().getMeasuredWidth(), this.smallBlackboardView.getView().getMeasuredHeight());
            this.shapeVM.requestPageAllShape(this.windowId, 0, this.layer, true);
        });
    }

    @Override
    protected boolean canBringToForeground() {
        return true;
    }

    public void minSbbOwner() {
        if (this.sbbOwnerTv.getText().toString().equals(this.getString(R.string.bjy_group_sbb_multi))) {
            return;
        }
        List<SmallBlackboardWindow> smallBlackboardWindows = this.iRouter.getListByKey(EventKey.MinimizeWindows, SmallBlackboardWindow.class);
        if (smallBlackboardWindows.size() > 1) {
            this.sbbOwnerTv.setTag((Object)this.sbbOwnerTv.getText().toString());
            this.sbbOwnerTv.setText((CharSequence)this.getString(R.string.bjy_group_sbb_multi));
        }
    }

    public void resetMinSbbOwner() {
        Object tag = this.sbbOwnerTv.getTag();
        if (tag instanceof String && this.sbbOwnerTv.getText().toString().equals(this.getString(R.string.bjy_group_sbb_multi))) {
            this.sbbOwnerTv.setText((CharSequence)((String)tag));
        }
    }

    @Override
    public void minInSync() {
        List<SmallBlackboardWindow> smallBlackboardWindows = this.iRouter.getListByKey(EventKey.MinimizeWindows, SmallBlackboardWindow.class);
        smallBlackboardWindows.add(this);
        this.iRouter.setObjectByKey(EventKey.MinimizeWindows, smallBlackboardWindows);
        if (smallBlackboardWindows.size() > 1) {
            this.sbbOwnerTv.setTag((Object)this.sbbOwnerTv.getText().toString());
            this.sbbOwnerTv.setText((CharSequence)this.getString(R.string.bjy_group_sbb_multi));
            smallBlackboardWindows.get(0).minSbbOwner();
        }
        super.minInSync();
    }

    @Override
    public void resetMinInSync() {
        super.resetMinInSync();
        if (this.windowStatus == SmallBlackboardStatus.STUDENT_WRITING) {
            this.ivClose.setVisibility(8);
        }
    }

    public void resetMinInSyncWithoutEvent() {
        if (this.isMinInSync) {
            this.contentOuterContainer.setVisibility(0);
            this.rlFooterContainer.setVisibility(0);
            this.minIv.setVisibility(0);
            this.ivScale.setVisibility(0);
            this.ivClose.setVisibility(0);
        }
        this.ivMaxSync.setImageDrawable(this.maxDrawable);
        if (this.isMaxInSync) {
            this.maxInSync();
            this.ivMaxSync.setImageDrawable(this.maxResetDrawable);
        } else if (this.isMaxInFull) {
            this.maxInFull();
            this.ivMaxSync.setImageDrawable(this.fullResetDrawable);
        }
        this.isMinInSync = false;
        if (this.windowStatus == SmallBlackboardStatus.STUDENT_WRITING) {
            this.ivClose.setVisibility(8);
        }
    }
}

