/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.group;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.group.GroupedBean;
import com.baijiayun.groupclassui.window.group.GroupedUserAdapter;
import com.baijiayun.groupclassui.window.group.UngroupUserAdapter;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPDivideGroupModel;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GroupManageWindow
extends InteractiveBaseWindow {
    private RecyclerView rvUser;
    private RecyclerView rvGrouped;
    private GroupedUserAdapter groupedUserAdapter;
    private boolean isLongPress;
    private int columns = 2;
    private int maxGroupCount;
    private int currGroupCount = 0;
    private View dragingItemView;
    private FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
    private float originX;
    private float originY;
    private List<Disposable> disposables;

    @SuppressLint(value={"ClickableViewAccessibility"})
    public GroupManageWindow(final Context context, int groupCount) {
        super(context);
        this.view.setOnTouchListener((v, event) -> true);
        final Drawable selectedDrawable = ThemeDataUtil.getCommonWindowBg((Context)context);
        final Drawable normalDrawable = new DrawableBuilder().solidColor(ContextCompat.getColor((Context)context, (int)R.color.bjysc_transparent)).build();
        this.$.id(R.id.group_window_root_container).view().setBackground((Drawable)new StateListDrawableBuilder().normal(normalDrawable).selected(selectedDrawable).build());
        ArrayList<GroupedBean> groupedUsers = new ArrayList<GroupedBean>();
        ArrayList<IUserModel> ungroupUsers = new ArrayList<IUserModel>();
        this.rvGrouped = (RecyclerView)this.$.id(R.id.group_manage_window_rv_grouped).view();
        this.rvUser = (RecyclerView)this.$.id(R.id.group_window_rv_user).view();
        this.$.id(R.id.group_window_iv_close).clicked(v -> this.iRouter.getSubjectByKey(EventKey.GroupManageLayout).onNext((Object)false));
        this.$.id(R.id.group_manage_window_btn_create_group).clicked(v -> {
            if (this.groupedUserAdapter.getItemCount() == this.maxGroupCount) {
                this.showToastMessage("\u6700\u591a\u53ea\u80fd\u521b\u5efa" + this.maxGroupCount + "\u4e2a\u5206\u7ec4");
                return;
            }
            this.groupedUserAdapter.addData(new GroupedBean(new ArrayList<IUserModel>(), 0));
        });
        this.$.id(R.id.group_window_tv_all_dissolve).clicked(v -> this.iRouter.getSubjectByKey(EventKey.DisplayWindowAllDissolve).onNext((Object)true));
        this.$.id(R.id.group_window_tv_cancel).clicked(v -> this.iRouter.getSubjectByKey(EventKey.GroupManageLayout).onNext((Object)false)).view().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        this.$.id(R.id.group_window_tv_confirm).clicked(v -> {
            this.iRouter.getSubjectByKey(EventKey.GroupManageLayout).onNext((Object)false);
            LPDivideGroupModel model = new LPDivideGroupModel();
            HashMap<String, LPDivideGroupModel.GroupInfo> map = new HashMap<String, LPDivideGroupModel.GroupInfo>();
            List data = this.groupedUserAdapter.getData();
            for (int i = 0; i < data.size(); ++i) {
                LPDivideGroupModel.GroupInfo info = new LPDivideGroupModel.GroupInfo();
                GroupedBean bean = (GroupedBean)data.get(i);
                info.color = this.groupedUserAdapter.getBgColor(i);
                info.name = this.groupedUserAdapter.getGroupName(i);
                ArrayList<String> members = new ArrayList<String>();
                for (int j = 0; j < bean.getGroupUsers().size(); ++j) {
                    members.add(bean.getGroupUsers().get(j).getUserId());
                }
                info.members = members;
                map.put(String.valueOf(i), info);
            }
            model.groups = map;
            this.iRouter.getLiveRoom().requestDivideGroup(model);
        }).view().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_live_product_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        this.currGroupCount = groupCount;
        final UngroupUserAdapter ungroupUserAdapter = new UngroupUserAdapter(context);
        this.rvUser.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        ungroupUserAdapter.bindToRecyclerView(this.rvUser);
        this.rvUser.addOnItemTouchListener(new RecyclerView.OnItemTouchListener(){

            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                return GroupManageWindow.this.isLongPress;
            }

            public void onTouchEvent(RecyclerView rv, MotionEvent e) {
                Log.d((String)"\u5206\u7ec4", (String)("onTouchEvent: " + e.getRawX() + "..." + e.getRawY()));
                switch (e.getAction()) {
                    case 2: {
                        if (GroupManageWindow.this.dragingItemView == null) break;
                        ((GroupManageWindow)GroupManageWindow.this).params.leftMargin += (int)(e.getRawX() - GroupManageWindow.this.originX);
                        ((GroupManageWindow)GroupManageWindow.this).params.topMargin += (int)(e.getRawY() - GroupManageWindow.this.originY);
                        GroupManageWindow.this.dragingItemView.setLayoutParams((ViewGroup.LayoutParams)GroupManageWindow.this.params);
                        GroupManageWindow.this.originX = e.getRawX();
                        GroupManageWindow.this.originY = e.getRawY();
                        break;
                    }
                    case 1: {
                        GroupManageWindow.this.isLongPress = false;
                        GroupManageWindow.this.hideDragView();
                        View view = GroupManageWindow.this.rvGrouped.findChildViewUnder(e.getRawX(), e.getRawY());
                        if (view == null) break;
                        int position = GroupManageWindow.this.rvGrouped.getChildAdapterPosition(view);
                        IUserModel groupUser = (IUserModel)GroupManageWindow.this.dragingItemView.getTag();
                        GroupManageWindow.this.groupedUserAdapter.updateViewPager(position, groupUser);
                        ungroupUserAdapter.removeData(groupUser);
                        break;
                    }
                }
            }

            public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            }
        });
        ungroupUserAdapter.setOnUserEventListener(new UngroupUserAdapter.OnUserEventListener(){

            @Override
            public void onUserSelected(List<IUserModel> selectedUsers) {
                GroupManageWindow.this.iRouter.getSubjectByKey(EventKey.UngroupSelectedList).onNext(selectedUsers);
            }

            @Override
            public void onUserLongClick(View view, int position, float viewLeft, float viewTop, float rawX, float rawY) {
                Log.d((String)"\u5206\u7ec4", (String)("\u957f\u6309item\u7684\u4f4d\u7f6e= " + position + "....x=" + view.getX() + "....y=" + view.getY()));
                GroupManageWindow.this.isLongPress = true;
                GroupManageWindow.this.originX = rawX;
                GroupManageWindow.this.originY = rawY;
                if (GroupManageWindow.this.dragingItemView == null) {
                    GroupManageWindow.this.dragingItemView = LayoutInflater.from((Context)context).inflate(R.layout.item_group_window_user, null);
                    GroupManageWindow.this.dragingItemView.setBackground((Drawable)new StateListDrawableBuilder().normal(normalDrawable).selected(selectedDrawable).build());
                }
                GradientDrawable bgDrawable = new GradientDrawable();
                bgDrawable.setColor(context.getResources().getColor(R.color.bjysc_half_white));
                bgDrawable.setCornerRadius((float)UtilsKt.getDp((int)4));
                GroupManageWindow.this.dragingItemView.setBackgroundDrawable((Drawable)bgDrawable);
                IUserModel iUserModel = (IUserModel)ungroupUserAdapter.getData().get(position);
                GroupManageWindow.this.dragingItemView.setTag((Object)iUserModel);
                AppCompatImageView ivHead = (AppCompatImageView)GroupManageWindow.this.dragingItemView.findViewById(R.id.item_group_window_iv_head);
                TextView tvName = (TextView)GroupManageWindow.this.dragingItemView.findViewById(R.id.item_group_window_tv_name);
                Glide.with((Context)context.getApplicationContext()).load(iUserModel.getAvatar()).apply(RequestOptions.circleCropTransform()).into((ImageView)ivHead);
                tvName.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)iUserModel.getName()));
                ((GroupManageWindow)GroupManageWindow.this).params.width = view.getMeasuredWidth();
                ((GroupManageWindow)GroupManageWindow.this).params.height = view.getMeasuredHeight();
                ((GroupManageWindow)GroupManageWindow.this).params.leftMargin = (int)viewLeft;
                ((GroupManageWindow)GroupManageWindow.this).params.topMargin = (int)viewTop;
                ((ViewGroup)GroupManageWindow.this.view).addView(GroupManageWindow.this.dragingItemView, (ViewGroup.LayoutParams)GroupManageWindow.this.params);
            }
        });
        this.groupedUserAdapter = new GroupedUserAdapter(context, this.iRouter);
        this.rvGrouped.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, this.columns));
        this.rvGrouped.setAdapter((RecyclerView.Adapter)this.groupedUserAdapter);
        this.groupedUserAdapter.setData(groupedUsers);
        this.groupedUserAdapter.setOnEventListener(new GroupedUserAdapter.OnEventListener(){

            @Override
            public void closeGroup(int position, List<IUserModel> groupUsers) {
                GroupManageWindow.this.groupedUserAdapter.removeData(position);
                ungroupUserAdapter.addData(groupUsers);
            }

            @Override
            public void onUserExitGroup(List<IUserModel> list) {
                ungroupUserAdapter.addData(list);
            }
        });
        List speakQueueList = this.iRouter.getLiveRoom().getSpeakQueueVM().getSpeakQueueList();
        for (IMediaModel model : speakQueueList) {
            ungroupUsers.add(model.getUser());
        }
        this.maxGroupCount = ungroupUsers.size();
        ungroupUserAdapter.setData(ungroupUsers);
        if (groupCount != 0) {
            if (ungroupUsers.size() % groupCount == 0) {
                this.averageGroup(groupCount, ungroupUsers, groupedUsers);
            } else {
                this.randomGroup(groupCount, ungroupUsers, groupedUsers);
            }
        }
        this.disposables = new ArrayList<Disposable>();
        Disposable joinGroupDisposable = this.iRouter.getSubjectByKey(EventKey.JoiningGroupList).ofType(List.class).subscribe(list -> {
            ungroupUserAdapter.removeData(list);
            ungroupUserAdapter.clearSelectState();
        });
        this.disposables.add(joinGroupDisposable);
    }

    protected View onCreateView(Context context) {
        return LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_group_manage, null);
    }

    private void hideDragView() {
        ((ViewGroup)this.view).removeView(this.dragingItemView);
    }

    private void randomGroup(int groupCount, List<IUserModel> ungroupUsers, List<GroupedBean> groupedUsers) {
        int userCounts = ungroupUsers.size();
        if (userCounts % groupCount != 0) {
            int everyGroupUserCounts = userCounts / groupCount + 1;
            GroupedBean groupedBean = new GroupedBean();
            ArrayList<IUserModel> list = new ArrayList<IUserModel>();
            for (int j = 0; j < everyGroupUserCounts; ++j) {
                list.add(ungroupUsers.get(j));
            }
            groupedBean.setGroupUsers(list);
            groupedBean.setGroupPosition(this.currGroupCount - groupCount);
            groupedUsers.add(groupedBean);
            ungroupUsers.removeAll(list);
            this.randomGroup(--groupCount, ungroupUsers, groupedUsers);
        } else {
            this.averageGroup(groupCount, ungroupUsers, groupedUsers);
        }
    }

    private void averageGroup(int groupCount, List<IUserModel> ungroupUsers, List<GroupedBean> groupedUsers) {
        int everyGroupUserCounts = ungroupUsers.size() / groupCount;
        for (int i = 0; i < groupCount; ++i) {
            GroupedBean groupedBean = new GroupedBean();
            ArrayList<IUserModel> list = new ArrayList<IUserModel>();
            for (int j = i * everyGroupUserCounts; j < everyGroupUserCounts * (i + 1); ++j) {
                list.add(ungroupUsers.get(j));
            }
            groupedBean.setGroupPosition(this.currGroupCount - groupCount + i);
            groupedBean.setGroupUsers(list);
            groupedUsers.add(groupedBean);
        }
        this.groupedUserAdapter.notifyDataSetChanged();
        ungroupUsers.clear();
    }

    @Override
    public void onDestroy() {
        for (Disposable disposable : this.disposables) {
            RxUtils.dispose((Disposable)disposable);
        }
        this.disposables.clear();
        this.groupedUserAdapter.destroy();
        super.onDestroy();
    }
}

