/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.ScrollView;
import androidx.annotation.RequiresApi;

public class GroupManageScrollView
extends ScrollView {
    private final String TAG = GroupManageScrollView.class.getCanonicalName();
    private boolean mIsIntercept = true;
    private float currX;
    private float currY;

    public GroupManageScrollView(Context context) {
        super(context);
        this.init();
    }

    public GroupManageScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GroupManageScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public GroupManageScrollView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        super.onInterceptTouchEvent(ev);
        switch (ev.getAction()) {
            case 0: {
                this.currX = ev.getRawX();
                this.currY = ev.getRawY();
                this.mIsIntercept = false;
                break;
            }
            case 2: {
                float offsetX = Math.abs(ev.getRawX() - this.currX);
                float offsetY = Math.abs(ev.getRawY() - this.currY);
                Log.d((String)this.TAG, (String)("\u662f\u5426\u62e6\u622a\uff1fonInterceptTouchEvent: " + (offsetY > offsetX)));
                this.mIsIntercept = offsetY > offsetX;
                break;
            }
        }
        return this.mIsIntercept;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        switch (ev.getAction()) {
            case 0: {
                this.currX = ev.getRawX();
                this.currY = ev.getRawY();
                Log.d((String)this.TAG, (String)"\u5904\u7406 onTouchEvent:down");
                break;
            }
            case 2: {
                float offsetX = Math.abs(ev.getRawX() - this.currX);
                float offsetY = Math.abs(ev.getRawY() - this.currY);
                Log.d((String)this.TAG, (String)("onTouchEvent:move " + ev.getRawX() + "...." + ev.getRawY() + "....\u4e0a\u4e0b\u8ddd\u79bb=" + offsetY + "...\u5de6\u53f3\u8ddd\u79bb=" + offsetX));
                break;
            }
            case 1: {
                this.mIsIntercept = false;
                break;
            }
        }
        return true;
    }

    private void init() {
    }
}

