/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.container;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.model.VideoMenuControlModel;
import com.baijiayun.groupclassui.window.video.VideoMenuMoreWindow;
import com.baijiayun.groupclassui.window.video.VideoWindow;
import com.baijiayun.livebase.models.imodels.IUserModel;

public class VideoMenuContainer
extends BaseLayerOfProfessionalClass {
    private VideoMenuControlModel videoMenuControlModel;
    private VideoMenuMoreWindow menuMoreWindow;
    private int menuWidthDp;

    public VideoMenuContainer(@NonNull Context context) {
        this(context, null);
    }

    public VideoMenuContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoMenuContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public VideoMenuContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean isLayerInit = super.onRoomStatusChange(isRoomActive);
        if (isLayerInit && isRoomActive) {
            this.subscribe();
        }
        return true;
    }

    private void subscribe() {
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.HideVideoMenu).ofType(IUserModel.class).subscribe(iUserModel -> {
            if (this.getChildCount() > 0) {
                if (iUserModel.getUserId().equals(this.videoMenuControlModel.getVideoWindow().getUserId())) {
                    this.removeMenu();
                } else {
                    this.menuMoreWindow.repositionMenu();
                }
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.RepositionVideoMenu).subscribe(o -> {
            if (this.getChildCount() == 0) {
                return;
            }
            this.menuMoreWindow.repositionMenu();
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.StudyRoomSwitch).subscribe(o -> this.removeMenu()));
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean isConsume;
        if (this.getChildCount() > 0) {
            isConsume = true;
            this.videoMenuControlModel.getVideoWindow().setMenuState(false);
            this.removeAllViews();
            this.videoMenuControlModel = null;
            this.menuMoreWindow = null;
        } else {
            isConsume = false;
        }
        return super.onTouchEvent(event) || isConsume;
    }

    public void addMenu(VideoMenuControlModel videoMenuControlModel) {
        this.videoMenuControlModel = videoMenuControlModel;
        VideoWindow videoWindow = videoMenuControlModel.getVideoWindow();
        this.menuWidthDp = 80;
        if (videoWindow.isPPTAuthOn() || videoWindow.isAssistCameraOn() || videoWindow.isScreenShareOn() || videoWindow.isDrawAuthOn()) {
            this.menuWidthDp = 105;
        }
        if (this.router.getLiveRoom().getSpeakQueueVM().enableAttachPhoneCamera()) {
            this.menuWidthDp = 120;
        }
        this.menuMoreWindow = new VideoMenuMoreWindow(this.getContext(), this.menuWidthDp, videoMenuControlModel);
        View view = this.menuMoreWindow.getView();
        int[] viewSize = DisplayUtils.getUnDisplayViewSize((View)view);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(UtilsKt.getDp((int)this.menuWidthDp), viewSize[1]);
        params.leftMargin = videoMenuControlModel.getCurrX() - UtilsKt.getDp((int)this.menuWidthDp);
        params.topMargin = videoMenuControlModel.getCurrY();
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        boolean adjustWindow = this.adjustWindow(videoMenuControlModel, view, this.menuWidthDp);
        if (adjustWindow) {
            videoWindow.currentX = videoMenuControlModel.getCurrX() - videoWindow.getWindowPosition()[0];
            videoWindow.currentY = videoMenuControlModel.getCurrY() - videoWindow.getWindowPosition()[1];
            params = new FrameLayout.LayoutParams(UtilsKt.getDp((int)this.menuWidthDp), viewSize[1]);
            params.leftMargin = videoMenuControlModel.getCurrX() - UtilsKt.getDp((int)this.menuWidthDp);
            params.topMargin = videoMenuControlModel.getCurrY();
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.addView(view);
    }

    private boolean adjustWindow(VideoMenuControlModel videoMenuControlModel, View view, int menuWidthDp) {
        boolean adjust = false;
        int[] viewSize = DisplayUtils.getUnDisplayViewSize((View)view);
        int top = videoMenuControlModel.currY;
        int bottom = videoMenuControlModel.currY + viewSize[1];
        int left = (int)((float)(videoMenuControlModel.currX - viewSize[0] / 2) - UtilsKt.getDp((float)((float)menuWidthDp * 0.5f)));
        int right = (int)((float)(videoMenuControlModel.currX + viewSize[0] / 2) - UtilsKt.getDp((float)((float)menuWidthDp * 0.5f)));
        int offsetBottom = bottom - DisplayUtils.getScreenHeightPixels((Context)view.getContext());
        int offsetRight = right - DisplayUtils.getScreenWidthPixels((Context)view.getContext());
        int margin = UtilsKt.getDp((int)8);
        if (offsetBottom >= 0) {
            videoMenuControlModel.currY -= offsetBottom + margin;
            adjust = true;
        }
        if (offsetRight >= 0) {
            videoMenuControlModel.currX -= offsetRight + margin;
            adjust = true;
        }
        if (top <= 0) {
            videoMenuControlModel.currY += -top + margin;
            adjust = true;
        }
        if (left <= 0) {
            videoMenuControlModel.currX += -left + margin;
            adjust = true;
        }
        return adjust;
    }

    public void removeMenu() {
        if (this.getChildCount() > 0) {
            this.removeAllViews();
            this.videoMenuControlModel = null;
            this.menuMoreWindow = null;
        }
    }
}

