/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;

public class BaseViewHolder
extends RecyclerView.ViewHolder {
    private Context mContext;
    private View mContentView;
    private SparseArray<View> mViews;

    public BaseViewHolder(Context context, View itemView) {
        super(itemView);
        this.mContext = context;
        this.mContentView = itemView;
        this.mViews = new SparseArray();
    }

    public <T extends View> T getView(@IdRes int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (null == view) {
            view = this.mContentView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View getRootView() {
        return this.mContentView;
    }

    public void setVisibility(@IdRes int id2, boolean isShow) {
        View view = this.mContentView.findViewById(id2);
        view.setVisibility(isShow ? 0 : 8);
    }

    public void setText(@IdRes int id2, @StringRes int resId) {
        TextView tv = (TextView)this.mContentView.findViewById(id2);
        tv.setText(resId);
    }

    public void setText(@IdRes int id2, String content) {
        TextView tv = (TextView)this.mContentView.findViewById(id2);
        tv.setText((CharSequence)content);
    }

    public void setText(@IdRes int id2, CharSequence content) {
        TextView tv = (TextView)this.mContentView.findViewById(id2);
        tv.setText(content);
    }

    public void setText(@IdRes int id2, @StringRes int resId, String color2) {
        TextView tv = (TextView)this.mContentView.findViewById(id2);
        tv.setTextColor(Color.parseColor((String)color2));
        tv.setText(resId);
    }

    public void setText(@IdRes int id2, String content, String color2) {
        TextView tv = (TextView)this.mContentView.findViewById(id2);
        tv.setTextColor(Color.parseColor((String)color2));
        tv.setText((CharSequence)content);
    }

    public void setText(@IdRes int id2, CharSequence content, String color2) {
        TextView tv = (TextView)this.mContentView.findViewById(id2);
        tv.setTextColor(Color.parseColor((String)color2));
        tv.setText(content);
    }

    public String getText(@IdRes int id2) {
        TextView tv = (TextView)this.mContentView.findViewById(id2);
        return tv.getText().toString();
    }

    public void setSelected(@IdRes int id2, boolean isSelected) {
        View view = this.mContentView.findViewById(id2);
        view.setSelected(isSelected);
    }

    public void setTvDrawable(@IdRes int id2, int resId) {
        TextView tv = (TextView)this.mContentView.findViewById(id2);
        Drawable drawable2 = this.mContext.getResources().getDrawable(resId);
        drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
        tv.setCompoundDrawables(drawable2, null, null, null);
    }

    public void setBitmap(@IdRes int id2, Bitmap bitmap) {
        ImageView iv = (ImageView)this.mContentView.findViewById(id2);
        iv.setImageBitmap(bitmap);
    }

    public void setDrawable(@IdRes int id2, Drawable drawable2) {
        ImageView iv = (ImageView)this.mContentView.findViewById(id2);
        iv.setImageDrawable(drawable2);
    }

    public void click(@IdRes int id2, View.OnClickListener listener) {
        this.mContentView.findViewById(id2).setOnClickListener(listener);
    }

    public BaseViewHolder setImageResource(@IdRes int id2, @DrawableRes int resId) {
        ImageView iv = (ImageView)this.mContentView.findViewById(id2);
        iv.setImageResource(resId);
        return this;
    }

    public void setImageUrl(@IdRes int id2, String url) {
        ImageView iv = (ImageView)this.mContentView.findViewById(id2);
    }

    public void setGifUrl(@IdRes int id2, String url) {
        ImageView iv = (ImageView)this.mContentView.findViewById(id2);
    }

    public void setCircleImageUrl(@IdRes int id2, String url) {
        ImageView iv = (ImageView)this.mContentView.findViewById(id2);
    }
}

