/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.smallblackboard;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.window.toolbox.smallblackboard.SmallBlackboardDialog;
import com.baijiayun.livebase.utils.ThemeDataUtil;

public class SmallBlackboardDialogUtil {
    public static void showDialog(View rootView, String content, View.OnClickListener onConfirmClickListener) {
        SmallBlackboardDialogUtil.showDialog(rootView, content, onConfirmClickListener, null);
    }

    public static View showTips(View rootView, String content) {
        return SmallBlackboardDialogUtil.showTips(rootView, content, 0);
    }

    public static View showTips(View rootView, String content, int delay) {
        Drawable drawable2 = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)rootView.getContext(), (int)R.attr.base_theme_window_bg_color)).cornerRadius(rootView.getContext().getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeWidth(UtilsKt.getDp((int)1)).strokeColor(ContextCompat.getColor((Context)rootView.getContext(), (int)R.color.bjysc_bg_stroke_10)).build();
        LinearLayout linearLayout = new LinearLayout(rootView.getContext());
        linearLayout.setBackground(drawable2);
        linearLayout.setGravity(17);
        TextView textView = new TextView(rootView.getContext());
        int _12dp = UtilsKt.getDp((int)12);
        int _4dp = UtilsKt.getDp((int)4);
        textView.setId(R.id.lp_sbb_tip_content_tv);
        textView.setPadding(_12dp, _4dp, _12dp, _4dp);
        textView.setText((CharSequence)content);
        textView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)rootView.getContext(), (int)R.attr.base_theme_window_main_text_color));
        linearLayout.addView((View)textView);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(11);
        layoutParams.addRule(10);
        layoutParams.topMargin = UtilsKt.getDp((int)42);
        layoutParams.rightMargin = _12dp;
        ((ViewGroup)rootView).addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
        if (delay > 0) {
            rootView.postDelayed(() -> ((ViewGroup)rootView).removeView((View)linearLayout), (long)(delay * 1000));
        }
        return linearLayout;
    }

    public static void showDialog(View rootView, String content, View.OnClickListener onConfirmClickListener, View.OnClickListener onCancelClickListener) {
        if (!(rootView instanceof ViewGroup)) {
            return;
        }
        SmallBlackboardDialog dialog = new SmallBlackboardDialog(rootView.getContext()).setContent(content).setOnConfirmClickListener(v -> {
            SmallBlackboardDialogUtil.removeView(rootView, v);
            if (onConfirmClickListener != null) {
                onConfirmClickListener.onClick(v);
            }
        }).setOnCancelClickListener(v -> {
            SmallBlackboardDialogUtil.removeView(rootView, v);
            if (onCancelClickListener != null) {
                onCancelClickListener.onClick(v);
            }
        });
        ((ViewGroup)rootView).addView((View)dialog, new ViewGroup.LayoutParams(-1, -1));
    }

    private static void removeView(View rootView, View view) {
        while (view.getParent() != rootView) {
            ViewParent viewParent = view.getParent();
            if (!(viewParent instanceof View)) {
                return;
            }
            view = (View)view.getParent();
        }
        if (rootView instanceof ViewGroup) {
            ((ViewGroup)rootView).removeView(view);
        }
    }

    static PopupWindow showPopupWindow(View anchorView, String content) {
        PopupWindow popupWindow = new PopupWindow();
        popupWindow.setHeight(-2);
        popupWindow.setWidth(-2);
        popupWindow.setOutsideTouchable(true);
        popupWindow.setFocusable(true);
        popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        TextView textView = new TextView(anchorView.getContext());
        textView.setText((CharSequence)content);
        textView.setTextColor(Color.parseColor((String)"#ffededee"));
        popupWindow.setContentView((View)textView);
        return popupWindow;
    }
}

