/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.study;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.multiupload.IMultiUploadListener;
import com.baijiayun.groupclassui.window.multiupload.MultiUploadWindow;
import com.baijiayun.groupclassui.window.study.DisplayStudyQuestion;
import com.baijiayun.groupclassui.window.study.QuickQuestionState;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

public class QuickQuestionWindow
extends InteractiveBaseWindow {
    private Disposable disposableOfSubmitQuestion;
    private Disposable disposableOfQuestion;
    private Disposable disposableOfTutorAnswer;
    private Disposable disposableOfRecallQuestion;
    private ObjectAnimator objectAnimator;
    private final IMultiUploadListener multiUploadWindow;
    private boolean hasInit = false;
    private QuickQuestionState questionState = QuickQuestionState.Edit;
    private boolean isShowing = true;

    public QuickQuestionWindow(Context context) {
        super(context);
        this.multiUploadWindow = new MultiUploadWindow(context);
        DisplayUtils.setRoundCorner((View)this.view, (float)context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
        LinearLayout container2 = (LinearLayout)this.$.id(R.id.ll_container).view();
        container2.addView(this.multiUploadWindow.getView(), -1, -1);
        this.refreshQuestionState();
    }

    public QuickQuestionState getQuestionState() {
        return this.questionState;
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public void setShowing(boolean showing) {
        this.isShowing = showing;
    }

    public void refreshQuestionState() {
        this.disposableOfQuestion = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfQuestionNotAnswer().observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyRoomQuestionModel -> {
            this.$.id(R.id.layout_loading).gone();
            if (!"-1".equals(lpStudyRoomQuestionModel.getId())) {
                this.questionState = QuickQuestionState.Published;
                this.changeState();
                this.multiUploadWindow.setUploaded(true, true);
                this.multiUploadWindow.setContent(lpStudyRoomQuestionModel.getQuestionContent());
                this.multiUploadWindow.setRemoteImgPaths(lpStudyRoomQuestionModel.getQuestionPic());
            } else {
                this.questionState = QuickQuestionState.Edit;
                this.changeState();
                this.multiUploadWindow.setUploaded(false);
                this.multiUploadWindow.setContent("");
                this.multiUploadWindow.setRemoteImgPaths(lpStudyRoomQuestionModel.getQuestionPic());
                this.multiUploadWindow.refresh();
            }
            if (!this.hasInit) {
                this.hasInit = true;
                this.initView();
            }
        });
    }

    private void changeState() {
        switch (this.questionState) {
            case Edit: {
                this.$.id(R.id.tv_img_desc).visible();
                this.$.id(R.id.tv_cancel).visible().text((CharSequence)this.getString(R.string.bjysc_cancel)).enable(true);
                this.$.id(R.id.tv_publish).visible().text((CharSequence)this.getString(R.string.base_answer_publish));
                this.$.id(R.id.tv_question_replay_tip).gone();
                this.$.id(R.id.tv_question_record).gone();
                this.$.id(R.id.tv_question_wait_reply).gone();
                break;
            }
            case Published: {
                this.$.id(R.id.tv_img_desc).gone();
                this.$.id(R.id.tv_cancel).gone();
                this.$.id(R.id.tv_publish).visible().text((CharSequence)this.getString(R.string.bjysc_revoke));
                this.$.id(R.id.tv_question_replay_tip).gone();
                this.$.id(R.id.tv_question_wait_reply).text((CharSequence)this.getString(R.string.bjysc_study_room_question_published_please_wait)).visible();
                this.$.id(R.id.tv_question_record).gone();
                break;
            }
            case Replyed: {
                this.$.id(R.id.tv_img_desc).gone();
                this.$.id(R.id.tv_cancel).visible().text((CharSequence)this.getString(R.string.bjysc_revoke)).enable(false);
                this.$.id(R.id.tv_publish).gone();
                this.$.id(R.id.tv_question_wait_reply).gone();
                this.$.id(R.id.tv_question_replay_tip).text((CharSequence)this.getString(R.string.bjysc_study_room_question_replyed_please_check)).visible();
                this.$.id(R.id.tv_question_record).visible();
                break;
            }
        }
    }

    private void initView() {
        this.$.id(R.id.iv_close).clicked(v -> this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Quick_Question_Close));
        this.$.id(R.id.tv_cancel).clicked(v -> this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Quick_Question_Close));
        this.$.id(R.id.tv_publish).clicked(v -> {
            if (this.questionState == QuickQuestionState.Edit) {
                String content = this.multiUploadWindow.getContent();
                if (TextUtils.isEmpty((CharSequence)content) || content.length() < 10) {
                    this.showToastMessage(this.context.getString(R.string.bjysc_enter_limit_more, new Object[]{10}));
                    return;
                }
                this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Quick_Question_Close);
                RxUtils.dispose((Disposable)this.disposableOfSubmitQuestion);
                this.$.id(R.id.layout_loading).visible();
                this.objectAnimator = ObjectAnimator.ofFloat((Object)this.$.id(R.id.iv_loading).view(), (String)"rotation", (float[])new float[]{360.0f});
                this.objectAnimator.setRepeatCount(-1);
                this.objectAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.objectAnimator.setDuration(2000L);
                this.objectAnimator.start();
                this.questionState = QuickQuestionState.Publishing;
                this.disposableOfSubmitQuestion = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfSubmitQuestion(this.multiUploadWindow.getRemoteImgPaths(), content, this.multiUploadWindow.getLocalImgPaths()).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
                    String msg = aBoolean != false ? this.getString(R.string.bjysc_study_room_quick_question_publish_success) : this.getString(R.string.bjysc_study_room_quick_question_publish_fail);
                    this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)msg);
                    this.$.id(R.id.layout_loading).gone();
                    this.objectAnimator.cancel();
                    this.refreshQuestionState();
                });
            } else if (this.questionState == QuickQuestionState.Published) {
                this.disposableOfRecallQuestion = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfRecallQuestion().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
                    this.questionState = QuickQuestionState.Edit;
                    this.changeState();
                    this.multiUploadWindow.setUploaded(false);
                    this.multiUploadWindow.refresh();
                });
            }
        });
        this.$.id(R.id.tv_question_record).clicked(v -> {
            this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Quick_Question_Close);
            this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Question_Record_Open);
        });
        this.disposableOfTutorAnswer = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfTutorAnswer().observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyRoomTutorAnswerModel -> {
            if (lpStudyRoomTutorAnswerModel.answerType == 1) {
                if (this.isShowing) {
                    if (this.questionState == QuickQuestionState.Published) {
                        this.questionState = QuickQuestionState.Replyed;
                        this.changeState();
                    }
                } else {
                    this.refreshQuestionState();
                }
            }
        });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.disposableOfSubmitQuestion);
        RxUtils.dispose((Disposable)this.disposableOfQuestion);
        RxUtils.dispose((Disposable)this.disposableOfTutorAnswer);
        RxUtils.dispose((Disposable)this.disposableOfRecallQuestion);
        if (this.objectAnimator != null) {
            this.objectAnimator.cancel();
        }
    }

    protected View onCreateView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjysc_window_quick_question, null);
    }
}

