/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.study;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.multiupload.MultiUploadWindow;
import com.baijiayun.groupclassui.window.study.DisplayStudyQuestion;
import com.baijiayun.livecore.models.LPStudyRoomQuestionModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.List;

public class QuestionRecordWindow
extends InteractiveBaseWindow {
    private Disposable disposableOfQuestionList;
    private Disposable disposableOfTutorAnswer;

    public QuestionRecordWindow(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        DisplayUtils.setRoundCorner((View)this.view, (float)this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
        this.$.id(R.id.iv_close).clicked(v -> this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Question_Record_Close));
        View emptyView = View.inflate((Context)this.context, (int)R.layout.bjysc_layout_question_record_empty, null);
        LinearLayout container2 = (LinearLayout)this.$.id(R.id.ll_container).view();
        container2.addView(emptyView, -1, -1);
        this.initQuestionRecordViews();
    }

    private void initQuestionRecordViews() {
        LinearLayout container2 = (LinearLayout)this.$.id(R.id.ll_container).view();
        RxUtils.dispose((Disposable)this.disposableOfQuestionList);
        this.disposableOfQuestionList = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfQuestionAndAnswerList().observeOn(AndroidSchedulers.mainThread()).filter(lpStudyRoomQuestionModels -> !lpStudyRoomQuestionModels.isEmpty()).subscribe(lpStudyRoomQuestionModels -> this.addQuestionRecordViews(container2, (List<LPStudyRoomQuestionModel>)lpStudyRoomQuestionModels), Throwable::printStackTrace);
        this.disposableOfTutorAnswer = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfTutorAnswer().observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyRoomTutorAnswerModel -> {
            if (lpStudyRoomTutorAnswerModel.answerType == 1) {
                this.initQuestionRecordViews();
            }
        });
    }

    private void addQuestionRecordViews(LinearLayout container2, List<LPStudyRoomQuestionModel> lpStudyRoomQuestionModels) {
        container2.removeAllViews();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.leftMargin = layoutParams.rightMargin = UtilsKt.getDp((int)10);
        layoutParams.topMargin = layoutParams.bottomMargin = UtilsKt.getDp((int)8);
        for (int i = 0; i < lpStudyRoomQuestionModels.size(); ++i) {
            LinearLayout linearLayout = new LinearLayout(this.context);
            linearLayout.setOrientation(1);
            LPStudyRoomQuestionModel questionModel = lpStudyRoomQuestionModels.get(i);
            MultiUploadWindow questionWindow = new MultiUploadWindow(this.context);
            questionWindow.setUploaded(true);
            questionWindow.setTitle(this.context.getString(R.string.bjysc_study_room_question_time, new Object[]{questionModel.getCreateTime()}));
            questionWindow.setContent(questionModel.getQuestionContent());
            questionWindow.setRemoteImgPaths(questionModel.getQuestionPic());
            questionWindow.showTitle(true);
            MultiUploadWindow answerWindow = new MultiUploadWindow(this.context);
            answerWindow.setUploaded(true);
            answerWindow.setTitle(this.context.getString(R.string.bjysc_study_room_question_answer, new Object[]{questionModel.getAnswerAssistantName()}));
            answerWindow.setContent(questionModel.getAnswerContent());
            answerWindow.setRemoteImgPaths(questionModel.getAnswerPic());
            answerWindow.showTitle(true);
            if (i == 0) {
                answerWindow.showTitleIcon(true);
            }
            linearLayout.addView(questionWindow.getView(), -1, -2);
            linearLayout.addView(answerWindow.getView(), -1, -2);
            DisplayUtils.setRoundCorner((View)linearLayout, (float)this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
            container2.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.disposableOfQuestionList);
        RxUtils.dispose((Disposable)this.disposableOfTutorAnswer);
    }

    protected View onCreateView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjysc_window_question_record, null);
    }
}

