/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.group;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.groupclassui.R;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupManagePagerAdapter
extends PagerAdapter {
    private Context context;
    private ViewPager mViewPager;
    private List<IUserModel> groupUsers;
    private List<IUserModel> selectedUsers;
    private OnSelectedListener onSelectedListener;

    public GroupManagePagerAdapter(Context context, List<IUserModel> groupUsers) {
        this.context = context;
        this.groupUsers = groupUsers;
        this.selectedUsers = new ArrayList<IUserModel>();
    }

    public int getCount() {
        if (this.groupUsers == null) {
            return 0;
        }
        int count = 0;
        if (this.groupUsers.size() > 10) {
            count = 3;
        } else if (this.groupUsers.size() > 5) {
            count = 2;
        } else if (this.groupUsers.size() > 0) {
            count = 1;
        }
        return count;
    }

    public int getItemPosition(@NonNull Object object) {
        this.selectedUsers.clear();
        return -2;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container2, int position) {
        View item = LayoutInflater.from((Context)this.context).inflate(R.layout.item_group_manage_window_viewpager, container2, false);
        LinearLayout ll = (LinearLayout)item.findViewById(R.id.item_group_manage_window_viewpager_ll);
        List<IUserModel> rowUser = this.getUsers(position);
        int i = 0;
        while (i < rowUser.size()) {
            Drawable selectedDrawable = ThemeDataUtil.getCommonWindowBg((Context)this.context);
            Drawable normalDrawable = new DrawableBuilder().solidColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_transparent)).build();
            View usersView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_group_window_user, null);
            usersView.setBackground((Drawable)new StateListDrawableBuilder().normal(normalDrawable).selected(selectedDrawable).build());
            TextView tvName = (TextView)usersView.findViewById(R.id.item_group_window_tv_name);
            AppCompatImageView ivHead = (AppCompatImageView)usersView.findViewById(R.id.item_group_window_iv_head);
            tvName.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)rowUser.get(i).getName()));
            Glide.with((Context)this.context.getApplicationContext()).load(rowUser.get(i).getAvatar()).apply(RequestOptions.circleCropTransform()).into((ImageView)ivHead);
            int currIndex = i++;
            usersView.setOnClickListener(v -> {
                usersView.setSelected(!usersView.isSelected());
                if (usersView.isSelected()) {
                    this.selectedUsers.add((IUserModel)rowUser.get(currIndex));
                } else if (this.selectedUsers.size() > 0) {
                    this.selectedUsers.remove(rowUser.get(currIndex));
                }
                if (this.onSelectedListener != null) {
                    this.onSelectedListener.onSelected(this.selectedUsers);
                }
            });
            ll.addView(usersView);
        }
        container2.addView(item);
        return item;
    }

    public void destroyItem(@NonNull ViewGroup container2, int position, @NonNull Object object) {
        container2.removeView((View)object);
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public void bindToViewPager(ViewPager viewPager) {
        this.mViewPager = viewPager;
        viewPager.setAdapter((PagerAdapter)this);
    }

    public void addData(IUserModel groupUser) {
        if (this.groupUsers == null || groupUser == null) {
            return;
        }
        this.groupUsers.add(groupUser);
        this.notifyDataSetChanged();
    }

    public void addData(List<IUserModel> users) {
        if (this.groupUsers == null || users == null) {
            return;
        }
        this.groupUsers.addAll(users);
        this.notifyDataSetChanged();
    }

    public void removeData(List<IUserModel> users) {
        if (this.groupUsers == null || users == null) {
            return;
        }
        this.groupUsers.removeAll(users);
        this.notifyDataSetChanged();
    }

    public int getCurrentItem() {
        if (this.mViewPager == null) {
            return -1;
        }
        return this.mViewPager.getCurrentItem();
    }

    public List<IUserModel> getGroupUsers() {
        return this.groupUsers;
    }

    private List<IUserModel> getUsers(@IntRange(from=0L, to=2L) int position) {
        List<IUserModel> tempUsers = new ArrayList<IUserModel>();
        switch (position) {
            case 0: {
                if (this.groupUsers.size() <= 5) {
                    tempUsers = this.groupUsers;
                }
                if (this.groupUsers.size() <= 5) break;
                tempUsers = this.groupUsers.subList(0, 5);
                break;
            }
            case 1: {
                if (this.groupUsers.size() <= 10) {
                    tempUsers = this.groupUsers.subList(5, this.groupUsers.size());
                }
                if (this.groupUsers.size() <= 10) break;
                tempUsers = this.groupUsers.subList(5, 10);
                break;
            }
            case 2: {
                tempUsers = this.groupUsers.subList(10, this.groupUsers.size());
                break;
            }
        }
        return tempUsers;
    }

    public void setOnSelectedListener(OnSelectedListener onSelectedListener) {
        this.onSelectedListener = onSelectedListener;
    }

    public static interface OnSelectedListener {
        public void onSelected(List<IUserModel> var1);
    }
}

