/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.bottommenu;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.dialog.HandsUpRemindPopupWindow;
import com.baijiayun.groupclassui.dialog.StudyHangDialog;
import com.baijiayun.groupclassui.dialog.StudyRankDialog;
import com.baijiayun.groupclassui.dialog.TimerNoteDialog;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.user.UserStatus;
import com.baijiayun.groupclassui.widget.ToggleSpeakerVolumeView;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.bottommenu.BottomMenuContract;
import com.baijiayun.groupclassui.window.bottommenu.BottomMenuPresenter;
import com.baijiayun.groupclassui.window.study.DisplayStudyQuestion;
import com.baijiayun.groupclassui.window.study.QuestionNewWindow;
import com.baijiayun.groupclassui.window.study.QuestionSelectWindow;
import com.baijiayun.groupclassui.window.study.StudyModeWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livebase.widgets.dialog.NoteDialog;
import com.baijiayun.livecore.listener.OnCountDownListener;
import com.baijiayun.livecore.models.LPStudyRoomTutorAnswerModel;
import com.baijiayun.livecore.models.LPStudyRoomTutorModel;
import com.baijiayun.livecore.models.roomresponse.LPResCloudRecordModel;
import com.baijiayun.liveuibase.toolbox.bonuspoints.BonusPointsPopupWindow;
import com.baijiayun.liveuibase.toolbox.zxyb.WritingBoardWrapper;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import com.baijiayun.liveuibase.utils.ToastUtil;
import com.baijiayun.liveuibase.widgets.common.DotProgressView;
import com.baijiayun.liveuibase.widgets.common.ProgressCircleView;
import com.zxyb.zxybbaselib.ble.entity.BleDevice;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class BottomMenuWindow
extends InteractiveBaseWindow
implements BottomMenuContract.View {
    private BottomMenuContract.Presenter presenter;
    private AnimatorSet animatorSet = new AnimatorSet();
    private boolean isChatDialogShowing = false;
    private boolean isFloatChatWindowShowing;
    private ImageView ivMic;
    private ImageView ivCamera;
    private boolean isFirstCallRecordStatus = true;
    private boolean eyeCareIsEnable = false;
    private StudyModeWindow studyModeWindow;
    private HandsUpRemindPopupWindow handsUpRemindPopupWindow;
    private PopupWindow recordTipPopupWindow;
    private StudyHangDialog studyHangDialog;
    private Disposable disposableOfReEnter;
    private QuestionNewWindow questionNewWindow;
    private Disposable disposableOfTimer;
    private WritingBoardWrapper writingboardWrapper;
    private BonusPointsPopupWindow bonusPointsPopupWindow;
    private Disposable disposableOfBonusPointsTimer;

    public BottomMenuWindow(Context context) {
        super(context);
        this.animatorSet.addListener((Animator.AnimatorListener)new AnimationSetListener(this.$.id(R.id.window_bottom_menu_container).view()));
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == null || this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
            lp.gravity = 0x800055;
            lp.bottomMargin = (int)((float)DisplayUtils.getNavigationBarHeight((Activity)((AppCompatActivity)context)) + context.getResources().getDimension(R.dimen.bjysc_bottom_menu_window_margin_bottom));
            this.view.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_record).view(), R.drawable.ic_interactive_cloud_record_normal);
        this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_mute_all_student).view(), R.drawable.ic_close_all_stu_mic);
        this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_unmute_all_student).view(), R.drawable.ic_open_all_stu_mic);
        this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_forbid_hands_up).view(), R.drawable.ic_interactive_forbid_handsup_off);
        this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_user_list).view(), R.drawable.ic_interactive_user_list_off);
        this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_homework_enter).view(), R.drawable.base_ic_homework_enter);
        this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_bonus_points).view(), R.drawable.bjy_group_ic_bonus_points);
        this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_user_chat).view(), R.drawable.bjy_group_ic_chat_off);
        if (this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
            this.$.id(R.id.window_bottom_menu_record).gone();
            this.$.id(R.id.window_bottom_menu_mute_all_student).gone();
            this.$.id(R.id.window_bottom_menu_unmute_all_student).gone();
            this.$.id(R.id.window_bottom_menu_study_rank).visible();
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_study_rank).view(), R.drawable.bjysc_ic_study_rank);
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_gallery).view(), R.drawable.bjysc_ic_mode_study);
            if (DisplayUtils.isPad((Context)this.getView().getContext())) {
                this.$.id(R.id.window_bottom_menu_gallery).text((CharSequence)this.view.getContext().getString(R.string.bjysc_study_room_mode_study));
            }
            if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student || this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Visitor) {
                this.$.id(R.id.window_bottom_menu_study_hang).visible();
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_quick_question).view(), R.drawable.bjysc_ic_study_quick_question);
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_study_hang).view(), R.drawable.bjysc_ic_study_hang);
            }
        } else {
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_gallery).view(), R.drawable.ic_interactive_gallery);
        }
        if (this.iRouter.getLiveRoom().getPartnerConfig().disableRecordStatus()) {
            this.$.id(R.id.window_bottom_menu_record).gone();
        }
        if (!this.iRouter.getLiveRoom().getPartnerConfig().enableOperateAllMic) {
            this.$.id(R.id.window_bottom_menu_mute_all_student).gone();
            this.$.id(R.id.window_bottom_menu_unmute_all_student).gone();
        }
        if (!this.iRouter.getLiveRoom().getPartnerConfig().enableSwitchRoomLayout) {
            this.$.id(R.id.window_bottom_menu_gallery).gone();
        }
        if (!this.iRouter.getLiveRoom().getPartnerConfig().enableForbidRaiseHand) {
            this.$.id(R.id.window_bottom_menu_forbid_hands_up).gone();
        }
        if (this.iRouter.getLiveRoom().getToolBoxVM().enableUseBonusPoints()) {
            this.$.id(R.id.window_bottom_menu_bonus_points).visible();
        } else {
            this.$.id(R.id.window_bottom_menu_bonus_points).gone();
        }
    }

    @SuppressLint(value={"NewApi"})
    private void initView() {
        this.presenter = new BottomMenuPresenter(this, this.context);
        this.setBasePresenter(this.presenter);
        ShadowUtil.setViewBoundShadow((View)this.view.findViewById(R.id.window_bottom_menu_container_copy));
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            this.showStudentView();
        }
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
            this.showTeacherView();
        }
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
            this.showAssistantView();
        }
        if (this.iRouter.getLiveRoom().getZXYBVM().enableUseHandWritingBoard() && (this.iRouter.getLiveRoom().getZXYBVM().getConnectType() != LPConstants.ZXYBConnectType.TYPE_BLE || !this.iRouter.getLiveRoom().getZXYBVM().getRecentBleDevices().isEmpty())) {
            this.$.id(R.id.window_bottom_writingboard_container).visible();
        }
        this.writingboardWrapper = new WritingBoardWrapper((AppCompatActivity)this.context, this.iRouter.getLiveRoom(), (ImageView)this.$.id(R.id.window_bottom_writingboard).view());
        WritingBoardWrapper.Config config = new WritingBoardWrapper.Config();
        config.setBleConnectResId(R.drawable.bjy_group_ic_ble_connected);
        config.setBleDisconnectResId(R.drawable.bjy_group_ic_ble_disconnected);
        config.setBleSleepResId(R.drawable.bjy_group_ic_ble_sleep);
        config.setUsbConnectResId(R.drawable.bjy_group_ic_usb_connected);
        config.setUsbDisconnectResId(R.drawable.bjy_group_ic_usb_disconnected);
        config.setUsbSleepResId(R.drawable.bjy_group_ic_usb_sleep);
        this.writingboardWrapper.setConfig(config);
        this.writingboardWrapper.setDeviceScanCallback(new WritingBoardWrapper.DeviceScanCallback(){

            public void onStartScan() {
                BottomMenuWindow.this.$.id(R.id.window_bottom_writingboard_progress).visible();
                DotProgressView dotProgressView = (DotProgressView)BottomMenuWindow.this.$.id(R.id.window_bottom_writingboard_progress).view();
                dotProgressView.invalidate();
            }

            public void onScanDevice(@Nullable BleDevice bleDevice) {
            }

            public void onStopScan() {
                BottomMenuWindow.this.$.id(R.id.window_bottom_writingboard_progress).gone();
            }
        });
        this.writingboardWrapper.setConnectStateCallback(connectState -> {
            if (connectState == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_SUCCESS) {
                this.$.id(R.id.window_bottom_writingboard_container).visible();
            }
            if (connectState == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_CONNECTING) {
                this.$.id(R.id.window_bottom_writingboard_progress).visible();
                DotProgressView dotProgressView = (DotProgressView)this.$.id(R.id.window_bottom_writingboard_progress).view();
                dotProgressView.invalidate();
            } else {
                this.$.id(R.id.window_bottom_writingboard_progress).gone();
            }
        });
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.DisPlayBleDialog).ofType(Boolean.class).filter(aBoolean -> aBoolean).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (this.writingboardWrapper != null) {
                this.writingboardWrapper.showBleDialogWithPermission();
            }
        }));
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_menu_gallery).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
                if (!this.iRouter.getLiveRoom().getStudyRoomVM().enableDiscussMode() && !this.iRouter.getLiveRoom().getStudyRoomVM().enableTutorMode()) {
                    return;
                }
                this.studyModeWindow = new StudyModeWindow(this.context, this.iRouter);
                this.studyModeWindow.setOutsideTouchable(true);
                this.studyModeWindow.setFocusable(true);
                this.studyModeWindow.setItemClickListener(studyRoomMode -> {
                    boolean enableSingleTutor = this.iRouter.getLiveRoom().getStudyRoomVM().enableSingleTutor();
                    List tutorModels = this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomCurrentTutorGroup();
                    if (enableSingleTutor && !tutorModels.isEmpty()) {
                        this.endTutorHelp(tutorModels, studyRoomMode);
                    } else {
                        this.switchStudyRoomMode(studyRoomMode);
                    }
                });
                this.studyModeWindow.show(this.$.id(R.id.window_bottom_menu_gallery).view());
            } else if (this.presenter.isMediaCoursewarePlaying()) {
                new CommonDialog(this.context, CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(this.context.getString(R.string.bjy_group_switch_layout_tips)).setSubtitleDisplayText(this.context.getString(R.string.bjy_group_switch_layout_detail)).setPositive(this.context.getString(R.string.bjysc_confirm), (dialog, which) -> {
                    this.presenter.navigateToGalleryMode();
                    this.iRouter.getSubjectByKey(EventKey.closeMediaPlayerWindow).onNext((Object)true);
                    dialog.dismiss();
                }).setNegative(this.context.getString(R.string.bjysc_cancel), (dialog, which) -> dialog.dismiss()).show();
            } else {
                this.presenter.navigateToGalleryMode();
            }
        }));
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_question_container).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            QuestionSelectWindow questionSelectWindow = new QuestionSelectWindow(this.context, this.iRouter, this.$.id(R.id.red_point_iv_question).view().getVisibility() == 0);
            questionSelectWindow.setOutsideTouchable(true);
            questionSelectWindow.setFocusable(true);
            questionSelectWindow.setItemClickListener(position -> {
                if (position == 0) {
                    this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Quick_Question_Open);
                } else {
                    this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Question_Record_Open);
                }
            });
            questionSelectWindow.show(this.$.id(R.id.window_bottom_question_container).view());
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).ofType(DisplayStudyQuestion.class).observeOn(AndroidSchedulers.mainThread()).subscribe(displayStudyQuestion -> {
            if (displayStudyQuestion == DisplayStudyQuestion.Question_Record_Open) {
                this.$.id(R.id.red_point_iv_question).gone();
            }
        }));
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_menu_record).clicks().throttleFirst(1L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (!this.iRouter.getLiveRoom().isClassStarted()) {
                this.showToastMessage(BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser()) ? "\u8bf7\u5148\u70b9\u51fb\u5f00\u59cb\u4e0a\u8bfe\u6309\u94ae" : "\u8bfe\u7a0b\u672a\u5f00\u59cb");
            } else {
                this.presenter.changeRecordStatus();
            }
        }));
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_menu_forbid_hands_up).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> this.presenter.changeForbidHandsUpStatus()));
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_speak_wrapper).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(c -> {
            if (!this.canHandsUp()) {
                return;
            }
            this.presenter.speakApply();
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.StudyRoomSwitch).ofType(LPConstants.StudyRoomMode.class).subscribe(studyRoomMode -> {
            if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
                this.showStudentView();
            }
            this.showStudyGalleryModel((LPConstants.StudyRoomMode)studyRoomMode);
        }));
        this.compositeDisposable.add(this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfTutorAnswer().observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyRoomTutorAnswerModel -> {
            if (lpStudyRoomTutorAnswerModel.answerType == 1) {
                this.$.id(R.id.red_point_iv_question).visible();
                this.questionNewWindow = new QuestionNewWindow(this.context, this.iRouter);
                this.questionNewWindow.setItemClickListener(position -> {
                    this.iRouter.getSubjectByKey(EventKey.DisplayStudyQuestion).onNext((Object)DisplayStudyQuestion.Question_Record_Open);
                    this.questionNewWindow.dismiss();
                    RxUtils.dispose((Disposable)this.disposableOfTimer);
                });
                this.questionNewWindow.show(this.$.id(R.id.window_bottom_question_container).view());
                RxUtils.dispose((Disposable)this.disposableOfTimer);
                this.disposableOfTimer = Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> this.questionNewWindow.dismiss());
            } else if (lpStudyRoomTutorAnswerModel.answerType == 2) {
                final TimerNoteDialog timerNoteDialog = new TimerNoteDialog();
                timerNoteDialog.setHasTimer(true);
                timerNoteDialog.setMainText(this.getString(R.string.bjysc_study_room_question_enter_1v1_tutor));
                timerNoteDialog.setAssistantText(this.getString(R.string.bjysc_study_room_question_enter_1v1_tutor_assistant_tip));
                timerNoteDialog.setPositiveText(this.context.getString(R.string.bjysc_study_room_question_enter_1v1_tutor_countdown, new Object[]{5}));
                timerNoteDialog.setOnPositiveClickListener((dialog, checked) -> {
                    timerNoteDialog.dismissAllowingStateLoss();
                    this.iRouter.getSubjectByKey(EventKey.StudyReEnterRoom).onNext((Object)lpStudyRoomTutorAnswerModel.studentCode);
                });
                timerNoteDialog.setCountDownListener(new OnCountDownListener((LPStudyRoomTutorAnswerModel)lpStudyRoomTutorAnswerModel){
                    final /* synthetic */ LPStudyRoomTutorAnswerModel val$lpStudyRoomTutorAnswerModel;
                    {
                        this.val$lpStudyRoomTutorAnswerModel = lPStudyRoomTutorAnswerModel;
                    }

                    public void onTimeOut() {
                        timerNoteDialog.dismissAllowingStateLoss();
                        BottomMenuWindow.this.iRouter.getSubjectByKey(EventKey.StudyReEnterRoom).onNext((Object)this.val$lpStudyRoomTutorAnswerModel.studentCode);
                    }

                    public void onTimeCountDown(int counter, int timeOut) {
                        timerNoteDialog.setText(BottomMenuWindow.this.context.getString(R.string.bjysc_study_room_question_enter_1v1_tutor_countdown, new Object[]{timeOut - counter}));
                    }
                });
                timerNoteDialog.setWidth(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_dialog_container_width));
                timerNoteDialog.setHeight(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_dialog_container_height));
                if (this.context instanceof FragmentActivity) {
                    FragmentActivity activity = (FragmentActivity)this.context;
                    timerNoteDialog.show(activity.getSupportFragmentManager(), "enter1v1");
                }
            }
        }));
        this.ivMic = (ImageView)this.$.id(R.id.window_bottom_mic).view();
        this.ivCamera = (ImageView)this.$.id(R.id.window_bottom_camera).view();
        this.ivMic.setSelected(true);
        this.ivCamera.setSelected(true);
        this.$.id(R.id.window_bottom_menu_user_list).clicked(v -> {
            this.presenter.navigateToUserList();
            this.$.id(R.id.window_bottom_menu_user_count).invisible();
        });
        this.$.id(R.id.window_bottom_menu_user_chat).clicked(v -> {
            this.$.id(R.id.red_point_iv).visibility(4);
            this.presenter.navigateToChat();
        });
        this.$.id(R.id.window_bottom_menu_homework_enter).clicked(v -> this.presenter.navigateToHomework());
        this.$.id(R.id.window_bottom_menu_bonus_points).clicked(v -> this.presenter.navigateToBonusPoints());
        if (DisplayUtils.isPad((Context)this.context)) {
            if (this.isAdmin()) {
                this.$.id(R.id.window_bottom_menu_bonus_points).text((CharSequence)this.getString(R.string.base_bonus_points_rank));
            } else {
                this.$.id(R.id.window_bottom_menu_bonus_points).text((CharSequence)this.getString(R.string.base_my_bonus_points));
            }
        }
        this.$.id(R.id.window_bottom_menu_btn).clicked(v -> this.changeBottomMenuVisibility());
        this.$.id(R.id.window_bottom_menu_btn_copy).clicked(v -> this.changeBottomMenuVisibility());
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_menu_mute_all_student).clicks().throttleFirst(1000L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(c -> this.presenter.quickMuteAllStudentMic(true)));
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_menu_unmute_all_student).clicks().throttleFirst(1000L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(c -> this.presenter.quickMuteAllStudentMic(false)));
        this.$.id(R.id.window_bottom_menu_study_rank).clicked(v -> {
            if (this.context instanceof FragmentActivity) {
                FragmentActivity activity = (FragmentActivity)this.context;
                StudyRankDialog studyRankDialog = new StudyRankDialog();
                BehaviorSubject subjectByKey = this.iRouter.getSubjectByKey(EventKey.StudyRankList);
                List userStatuses = (List)subjectByKey.getValue();
                if (userStatuses != null) {
                    studyRankDialog.setStudyRankList(userStatuses);
                }
                studyRankDialog.show(activity.getSupportFragmentManager(), ((Object)((Object)studyRankDialog)).getClass().getSimpleName());
            }
        });
        this.$.id(R.id.window_bottom_menu_study_hang).clicked(v -> {
            if (this.context instanceof FragmentActivity) {
                if (this.studyHangDialog != null && this.studyHangDialog.isAdded()) {
                    return;
                }
                boolean isForHelping = this.iRouter.getSubjectValueByKey(EventKey.StudyStatusForHelping, Boolean.class, false);
                String tutorId = this.iRouter.getSubjectValueByKey(EventKey.StudyStatusTutor, String.class, "");
                if (isForHelping || !TextUtils.isEmpty((CharSequence)tutorId)) {
                    LPLogger.e((String)"\u5728\u6c42\u52a9\u4e2d,\u8f85\u5bfc\u4e2d...\u4e0d\u80fd\u6302\u673a");
                    return;
                }
                FragmentActivity activity = (FragmentActivity)this.context;
                this.studyHangDialog = new StudyHangDialog();
                this.studyHangDialog.setRouter(this.iRouter);
                this.studyHangDialog.setEndHangListener(v1 -> {
                    if (this.studyHangDialog != null) {
                        this.studyHangDialog.dismissAllowingStateLoss();
                    }
                    this.iRouter.setObjectByKey(EventKey.StudyStatusHangUp, false);
                    this.iRouter.getPublishSubjectByKey(EventCode.PublishDefaultStream).onNext((Object)true);
                    this.iRouter.getLiveRoom().getStudyRoomVM().requestHangUp(false, this.iRouter.getLiveRoom().getCurrentUser().getNumber());
                });
                this.studyHangDialog.show(activity.getSupportFragmentManager(), ((Object)((Object)this.studyHangDialog)).getClass().getSimpleName());
                this.iRouter.setObjectByKey(EventKey.StudyStatusHangUp, true);
                this.iRouter.getLiveRoom().getStudyRoomVM().requestHangUp(true, this.iRouter.getLiveRoom().getCurrentUser().getNumber());
            }
        });
        this.initDrawable();
        this.$.id(R.id.window_bottom_speaker).clicked(v -> {
            ToggleSpeakerVolumeView volumeView = new ToggleSpeakerVolumeView(this.getView().getContext());
            volumeView.setListener(this::showSpeakerIcon);
            PopupWindow popupWindow = new PopupWindow((View)volumeView, UtilsKt.getDp((int)148), UtilsKt.getDp((int)20));
            popupWindow.setOutsideTouchable(true);
            popupWindow.setFocusable(true);
            popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            popupWindow.showAsDropDown(this.$.id(R.id.window_bottom_speaker).view(), 0, -UtilsKt.getDp((int)60));
        });
        this.eyeCareIsEnable = (Boolean)this.iRouter.getSubjectByKey(EventKey.DisplayEyeCare).getValue();
        this.$.id(R.id.ct_eye_care).view().setSelected(this.eyeCareIsEnable);
        this.$.id(R.id.ct_eye_care).clicked(v -> {
            this.presenter.navigateToEyeCare(!this.eyeCareIsEnable);
            this.eyeCareIsEnable = !this.eyeCareIsEnable;
            this.$.id(R.id.ct_eye_care).view().setSelected(this.eyeCareIsEnable);
        });
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_mic).clicks().throttleFirst(1L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (!this.iRouter.getLiveRoom().getOnlineUserVM().isActiveUser(this.iRouter.getLiveRoom().getCurrentUser())) {
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(this.iRouter.getLiveRoom().isClassStarted() ? R.string.bjysc_microphone_not_up_seat : R.string.bjysc_microphone_class_not_not_start));
                return;
            }
            if (!this.iRouter.getLiveRoom().getPartnerConfig().enableStudentOpenMic && this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
                if (this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
                    String tutorId = this.iRouter.getSubjectValueByKey(EventKey.StudyStatusTutor, String.class, "");
                    if (TextUtils.isEmpty((CharSequence)tutorId) && (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.Tutor || this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.SelfStudy) && this.ivMic.isSelected()) {
                        this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(R.string.bjysc_hands_up_pls));
                        return;
                    }
                } else if (this.ivMic.isSelected()) {
                    this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(R.string.bjysc_hands_up_pls));
                    return;
                }
            }
            this.iRouter.getPublishSubjectByKey(EventCode.AttachAudio).onNext((Object)(!this.iRouter.getLiveRoom().getRecorder().isAudioAttached() ? 1 : 0));
        }));
        this.compositeDisposable.add(this.$.id(R.id.window_bottom_camera).clicks().throttleFirst(1L, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (!this.iRouter.getLiveRoom().getOnlineUserVM().isActiveUser(this.iRouter.getLiveRoom().getCurrentUser())) {
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(this.iRouter.getLiveRoom().isClassStarted() ? R.string.bjysc_camera_not_up_seat : R.string.bjysc_camera_class_not_start));
                return;
            }
            if (!this.iRouter.getLiveRoom().isClassStarted()) {
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(R.string.bjysc_camera_class_not_start));
                return;
            }
            if (this.iRouter.getLiveRoom().getRecorder().isScreenSharing()) {
                this.iRouter.getSubjectByKey(EventKey.CloseScreenShare).onNext((Object)true);
                return;
            }
            this.iRouter.getPublishSubjectByKey(EventCode.AttachVideo).onNext((Object)(!this.iRouter.getLiveRoom().getRecorder().isVideoAttached() ? 1 : 0));
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.StudyStatusForHelping).observeOn(AndroidSchedulers.mainThread()).ofType(Boolean.class).subscribe(aBoolean -> this.showStudyHangUpState(aBoolean == false)));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.StudyStatusTutor).observeOn(AndroidSchedulers.mainThread()).ofType(String.class).subscribe(s -> this.showStudyHangUpState(TextUtils.isEmpty((CharSequence)s))));
    }

    @SuppressLint(value={"NewApi"})
    private void showStudyHangUpState(boolean isEnable) {
        if (!isEnable) {
            TextView textView = (TextView)this.$.id(R.id.window_bottom_menu_study_hang).view();
            textView.setTextColor(-7829368);
            Context context = textView.getContext();
            Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.bjysc_ic_study_hang);
            if (drawable2 != null) {
                int size = context.getResources().getDimensionPixelSize(R.dimen.bjysc_toolbar_item_width);
                drawable2.setTint(-7829368);
                drawable2.setBounds(0, 0, size, size);
                textView.setCompoundDrawables(drawable2, null, null, null);
            }
        } else {
            TextView textView = (TextView)this.$.id(R.id.window_bottom_menu_study_hang).view();
            textView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)textView.getContext(), (int)R.attr.base_theme_bottom_menu_text_color));
            Context context = textView.getContext();
            Drawable drawable3 = ContextCompat.getDrawable((Context)context, (int)R.drawable.bjysc_ic_study_hang);
            if (drawable3 != null) {
                int size = context.getResources().getDimensionPixelSize(R.dimen.bjysc_toolbar_item_width);
                drawable3.setTint(-6313803);
                drawable3.setBounds(0, 0, size, size);
                textView.setCompoundDrawables(drawable3, null, null, null);
            }
        }
    }

    private void switchStudyRoomMode(LPConstants.StudyRoomMode studyRoomMode) {
        if (studyRoomMode == LPConstants.StudyRoomMode.Tutor) {
            this.iRouter.setObjectByKey(EventKey.StudyReEnterRoom, true);
            this.disposableOfReEnter = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfReEnterInfo().observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyReEnterInfo -> this.iRouter.getSubjectByKey(EventKey.StudyReEnterRoom).onNext((Object)lpStudyReEnterInfo.code), throwable -> {});
        } else if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher && this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.Tutor) {
            this.iRouter.setObjectByKey(EventKey.StudyReEnterRoom, true);
            this.disposableOfReEnter = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfReEnterInfo().observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyReEnterInfo -> this.iRouter.getSubjectByKey(EventKey.StudyReEnterRoom).onNext((Object)lpStudyReEnterInfo.code), throwable -> {});
        }
        this.iRouter.getLiveRoom().getStudyRoomVM().switchStudyRoomMode(studyRoomMode);
    }

    private void endTutorHelp(List<LPStudyRoomTutorModel> lpStudyRoomTutorModels, LPConstants.StudyRoomMode studyRoomMode) {
        NoteDialog noteDialog = new NoteDialog();
        noteDialog.setMainText(this.context.getString(R.string.bjysc_study_switch_mode_tutor_end_tip));
        noteDialog.setHideAssistantText(true);
        noteDialog.setOnPositiveClickListener((dialog, checked) -> {
            if (lpStudyRoomTutorModels != null && !lpStudyRoomTutorModels.isEmpty()) {
                for (LPStudyRoomTutorModel lpStudyRoomTutorModel : lpStudyRoomTutorModels) {
                    this.iRouter.getLiveRoom().getStudyRoomVM().requestTutorEnd(lpStudyRoomTutorModel.tutorId);
                }
            } else {
                LPLogger.e((String)"lpStudyRoomTutorModels == null or empty");
            }
            this.switchStudyRoomMode(studyRoomMode);
            dialog.dismissAllowingStateLoss();
        });
        noteDialog.setOnNegativeClickListener((dialog, checked) -> dialog.dismissAllowingStateLoss());
        noteDialog.setWidth(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_dialog_container_width));
        noteDialog.setHeight(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_dialog_container_height));
        FragmentActivity activity = (FragmentActivity)this.context;
        noteDialog.show(activity.getSupportFragmentManager(), "endTutorHelp");
    }

    private void initDrawable() {
        this.view.findViewById(R.id.window_bottom_menu_container).setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_bg_stroke_10)).strokeWidth(UtilsKt.getDp((int)1)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        this.view.findViewById(R.id.window_bottom_menu_container_copy).setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_bg_stroke_10)).strokeWidth(UtilsKt.getDp((int)1)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
    }

    private boolean canHandsUp() {
        String tutorId = this.iRouter.getSubjectValueByKey(EventKey.StudyStatusTutor, String.class, "");
        return !this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout() || !TextUtils.isEmpty((CharSequence)tutorId) || !this.iRouter.getLiveRoom().getOnlineUserVM().isActiveUser(this.iRouter.getLiveRoom().getCurrentUser());
    }

    private void showSpeakerIcon(int volumeLevel, int min, int max) {
        if (this.$ == null) {
            return;
        }
        int percent = (max - min) / 3 + 1;
        if (volumeLevel == min) {
            this.$.id(R.id.window_bottom_speaker).image(R.drawable.ic_interactive_speaker_normal_0);
        } else if (volumeLevel <= percent) {
            this.$.id(R.id.window_bottom_speaker).image(R.drawable.ic_interactive_speaker_normal_1);
        } else if (volumeLevel <= percent * 2) {
            this.$.id(R.id.window_bottom_speaker).image(R.drawable.ic_interactive_speaker_normal_2);
        } else {
            this.$.id(R.id.window_bottom_speaker).image(R.drawable.ic_interactive_speaker_normal_3);
        }
    }

    protected View onCreateView(Context context) {
        return LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_bottom_menu, null);
    }

    @Override
    public void showStudentView() {
        this.$.id(R.id.window_bottom_menu_record).gone();
        this.$.id(R.id.window_bottom_menu_forbid_hands_up).gone();
        if (this.iRouter.getLiveRoom().getPartnerConfig().enableUseHomeWork == 1) {
            if (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout()) {
                this.$.id(R.id.window_bottom_menu_homework_enter).gone();
            } else {
                this.$.id(R.id.window_bottom_menu_homework_enter).visible();
            }
        }
        if (this.iRouter.getLiveRoom().getStudyRoomVM().enableTutorOutside()) {
            this.$.id(R.id.window_bottom_question_container).visible();
        }
        if (!this.iRouter.getLiveRoom().getPartnerConfig().enableStudentShowUserList || this.iRouter.getLiveRoom().getRoomInfo().newGroupLive == 1) {
            this.$.id(R.id.window_bottom_menu_user_list).gone();
            this.$.id(R.id.window_bottom_menu_user_container).gone();
        }
        this.$.id(R.id.window_bottom_menu_gallery).gone();
        this.$.id(R.id.window_bottom_menu_mute_all_student).gone();
        this.$.id(R.id.window_bottom_menu_unmute_all_student).gone();
    }

    @Override
    public void showTeacherView() {
        this.$.id(R.id.window_bottom_speak_wrapper).gone();
    }

    @Override
    public void showAssistantView() {
        this.$.id(R.id.window_bottom_speak_wrapper).gone();
    }

    @Override
    public void showRecordingStatus(LPResCloudRecordModel recordStatus) {
        String needShow;
        if (!this.isFirstCallRecordStatus && !TextUtils.isEmpty((CharSequence)(needShow = this.getNeedShowMessage(recordStatus)))) {
            new ToastUtil(this.context).setText(needShow).show();
        }
        if (this.isFirstCallRecordStatus && recordStatus.status == LPConstants.CloudRecordStatus.Recording.getStatus()) {
            this.isFirstCallRecordStatus = false;
        }
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
            if (recordStatus.status != LPConstants.CloudRecordStatus.Stopped.getStatus()) {
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_record).view(), R.drawable.ic_interactive_cloud_record_recording);
            } else {
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_record).view(), R.drawable.ic_interactive_cloud_record_normal);
            }
        }
        if (recordStatus.status == LPConstants.CloudRecordStatus.Paused.getStatus()) {
            if (DisplayUtils.isPad((Context)this.getView().getContext()) && this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
                ((TextView)this.$.id(R.id.window_bottom_menu_record).text(R.string.bjysc_record_paused).view()).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.view.getContext(), (int)R.attr.base_theme_live_product_color));
            }
        } else if (recordStatus.status == LPConstants.CloudRecordStatus.Stopped.getStatus()) {
            if (DisplayUtils.isPad((Context)this.getView().getContext()) && this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
                ((TextView)this.$.id(R.id.window_bottom_menu_record).text(R.string.bjysc_record).view()).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.view.getContext(), (int)R.attr.base_theme_bottom_menu_text_color));
            }
        } else if (recordStatus.status == LPConstants.CloudRecordStatus.Recording.getStatus() && DisplayUtils.isPad((Context)this.getView().getContext()) && this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
            ((TextView)this.$.id(R.id.window_bottom_menu_record).text(R.string.bjysc_record_recording).view()).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.view.getContext(), (int)R.attr.base_theme_live_product_color));
        }
    }

    @Override
    public void showForbidHandsUpStatus(boolean isForbidden) {
        if (isForbidden) {
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_forbid_hands_up).view(), R.drawable.ic_interactive_forbid_handsup_on);
            if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT && DisplayUtils.isPad((Context)this.getView().getContext())) {
                this.$.id(R.id.window_bottom_menu_forbid_hands_up).text(R.string.bjysc_un_forbid_hands_up);
            }
        } else {
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_forbid_hands_up).view(), R.drawable.ic_interactive_forbid_handsup_off);
            if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT && DisplayUtils.isPad((Context)this.getView().getContext())) {
                this.$.id(R.id.window_bottom_menu_forbid_hands_up).text(R.string.bjysc_forbid_hands_up);
            }
        }
        this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)(isForbidden ? this.getString(R.string.bjysc_toast_hands_up_forbidden) : this.getString(R.string.bjysc_toast_hands_up_allowed)));
        if (!this.isAdmin() && !isForbidden) {
            this.showSpeakApplyNormal();
        } else {
            this.showSpeakApplyDisable();
        }
    }

    @Override
    public void showUserListWindowShowingStatus(boolean isShowing) {
        if (isShowing) {
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_user_list).view(), R.drawable.ic_interactive_user_list_on);
        } else {
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_user_list).view(), R.drawable.ic_interactive_user_list_off);
        }
    }

    @Override
    public void showChatWindowShowingStatus(boolean isShowing) {
        this.isChatDialogShowing = isShowing;
        if (this.view.getContext() == null) {
            return;
        }
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
            if (isShowing) {
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_user_chat).view(), R.drawable.ic_interactive_chat_on);
            } else {
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_user_chat).view(), R.drawable.bjy_group_ic_chat_off);
            }
        }
    }

    @Override
    public void showFloatChatWindowShowingStatus(boolean isShowing) {
        this.isFloatChatWindowShowing = isShowing;
    }

    @Override
    public void showGalleryModel(boolean isOn) {
        if (this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
            return;
        }
        if (isOn) {
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_gallery).view(), R.drawable.ic_interactive_gallery);
            if (DisplayUtils.isPad((Context)this.getView().getContext())) {
                this.$.id(R.id.window_bottom_menu_gallery).text((CharSequence)this.view.getContext().getString(R.string.bjysc_gallery_layout));
            }
        } else {
            this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_gallery).view(), R.drawable.ic_interactive_board);
            if (DisplayUtils.isPad((Context)this.getView().getContext())) {
                this.$.id(R.id.window_bottom_menu_gallery).text((CharSequence)this.view.getContext().getString(R.string.bjysc_board_layout));
            }
        }
    }

    @Override
    public void showStudyGalleryModel(LPConstants.StudyRoomMode studyRoomMode) {
        if (!this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
            return;
        }
        switch (studyRoomMode) {
            case SelfStudy: {
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_gallery).view(), R.drawable.bjysc_ic_mode_study);
                if (!DisplayUtils.isPad((Context)this.getView().getContext())) break;
                this.$.id(R.id.window_bottom_menu_gallery).text((CharSequence)this.view.getContext().getString(R.string.bjysc_study_room_mode_study));
                break;
            }
            case Discuss: {
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_gallery).view(), R.drawable.bjysc_ic_mode_discuss);
                if (!DisplayUtils.isPad((Context)this.getView().getContext())) break;
                this.$.id(R.id.window_bottom_menu_gallery).text((CharSequence)this.view.getContext().getString(R.string.bjysc_study_room_mode_discuss));
                break;
            }
            default: {
                this.changeTextDrawableSize((TextView)this.$.id(R.id.window_bottom_menu_gallery).view(), R.drawable.bjysc_ic_mode_tutor);
                if (!DisplayUtils.isPad((Context)this.getView().getContext())) break;
                this.$.id(R.id.window_bottom_menu_gallery).text((CharSequence)this.view.getContext().getString(R.string.bjysc_study_room_mode_tutor));
            }
        }
    }

    @Override
    public void showChatWindowRedPoint(boolean isVisible) {
        this.$.id(R.id.red_point_iv).visibility(isVisible && !this.isChatDialogShowing && !this.isFloatChatWindowShowing ? 0 : 4);
    }

    @Override
    public void showShortTermClassAlreadyHasPlayback() {
        this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getString(R.string.bjysc_record_short_term));
    }

    @Override
    public void showCloudRecordHint() {
        this.getView().postDelayed(() -> {
            if (this.getView() == null || this.isDestroy()) {
                return;
            }
            if (!this.presenter.showCloudRecord()) {
                return;
            }
            String hint = this.getView().getContext().getString(R.string.bjysc_record_on) + "\n" + this.getView().getContext().getString(R.string.bjysc_record_hint);
            TextView textView = new TextView(this.getView().getContext());
            textView.setText((CharSequence)hint);
            textView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.view.getContext(), (int)R.attr.base_theme_bottom_menu_text_color));
            textView.setLineSpacing((float)UtilsKt.getDp((int)10), 1.0f);
            ShadowUtil.ShadowGroup shadowGroup = ShadowUtil.initShadowView((Context)this.context, (View)textView);
            if (shadowGroup == null) {
                return;
            }
            ShadowUtil.setViewBoundShadow((View)shadowGroup.getShadowContainer());
            textView.setPadding(UtilsKt.getDp((int)10), UtilsKt.getDp((int)10), UtilsKt.getDp((int)10), UtilsKt.getDp((int)10));
            textView.setGravity(16);
            textView.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.recordTipPopupWindow = new PopupWindow(shadowGroup.getContentView(), UtilsKt.getDp((int)376), UtilsKt.getDp((int)116));
            this.recordTipPopupWindow.setOutsideTouchable(true);
            this.recordTipPopupWindow.setFocusable(true);
            this.recordTipPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.recordTipPopupWindow.showAsDropDown(this.$.id(R.id.window_bottom_menu_record).view(), -UtilsKt.getDp((int)180), (int)this.getView().getContext().getResources().getDimension(R.dimen.bjysc_bottom_menu_record_pupup_offset));
        }, 1000L);
    }

    @Override
    public void showCloudRecordRestartDialog() {
        new CommonDialog(this.getView().getContext(), CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(this.getString(R.string.bjysc_record_restart_hint)).setPositive(this.getString(R.string.bjysc_record_continue), (dialog, which) -> this.presenter.continueCloudRecord()).setNegative(this.getString(R.string.bjysc_record_new), (dialog, which) -> this.presenter.startNewCloudRecord()).show();
    }

    @Override
    public void showMicStatus(boolean isMicOn) {
        if (this.ivMic != null) {
            this.ivMic.setSelected(!isMicOn);
        }
    }

    @Override
    public void showCameraStatus(boolean isCameraOn) {
        if (this.ivCamera != null) {
            this.ivCamera.setSelected(!isCameraOn);
        }
    }

    @Override
    public void showUserListStatus(boolean isShow) {
        this.$.id(R.id.window_bottom_menu_user_container).visibility(isShow ? 0 : 8);
    }

    @Override
    public void showSpeakApplyCountDown(int countDownTime, int total) {
        this.$.id(R.id.window_bottom_hand_countdown).visible();
        ((ProgressCircleView)this.$.id(R.id.window_bottom_hand_countdown).view()).setRatio((float)countDownTime / (float)total);
        this.$.id(R.id.window_bottom_speak_apply).view().setEnabled(true);
        this.$.id(R.id.window_bottom_speak_apply).view().setSelected(true);
    }

    @Override
    public void showSpeakApplyNormal() {
        if (this.canHandsUp()) {
            this.$.id(R.id.window_bottom_speak_apply).view().setEnabled(true);
            this.$.id(R.id.window_bottom_speak_apply).view().setSelected(false);
        }
        this.$.id(R.id.window_bottom_hand_countdown).invisible();
    }

    @Override
    public void showSpeakApplyDisable() {
        this.$.id(R.id.window_bottom_speak_apply).view().setEnabled(false);
        this.$.id(R.id.window_bottom_speak_apply).view().setSelected(false);
        this.$.id(R.id.window_bottom_hand_countdown).invisible();
    }

    @Override
    public void showHandsUpRemind(int count, String name) {
        View users = this.$.id(R.id.window_bottom_menu_user_container).view();
        if (DisplayUtils.isPad((Context)this.getView().getContext())) {
            this.$.id(R.id.window_bottom_menu_user_count).text((CharSequence)String.valueOf(count));
        }
        this.$.id(R.id.window_bottom_menu_user_count).visible();
        if (this.handsUpRemindPopupWindow == null) {
            this.handsUpRemindPopupWindow = new HandsUpRemindPopupWindow.Builder(this.getView().getContext()).build().setHandsUpCount(count, name).getPopupWindow();
        } else {
            this.handsUpRemindPopupWindow.setRemindText(count, name);
        }
        this.handsUpRemindPopupWindow.getContentView().measure(0, 0);
        int offsetX = -UtilsKt.getDp((int)6);
        int offsetY = -(this.handsUpRemindPopupWindow.getContentView().getMeasuredHeight() + users.getMeasuredHeight() - UtilsKt.getDp((int)6));
        this.handsUpRemindPopupWindow.getContentView().setOnClickListener(v -> {
            this.iRouter.getSubjectByKey(EventKey.DisplayUserList).onNext((Object)UserStatus.HandsupList);
            this.$.id(R.id.window_bottom_menu_user_count).invisible();
            if (this.handsUpRemindPopupWindow != null && this.handsUpRemindPopupWindow.isShowing()) {
                this.handsUpRemindPopupWindow.dismiss();
            }
        });
        this.handsUpRemindPopupWindow.showAsDropDown(users, offsetX, offsetY);
    }

    @Override
    public void hideHandsUpCount() {
        this.$.id(R.id.window_bottom_menu_user_count).invisible();
        if (this.handsUpRemindPopupWindow != null && this.handsUpRemindPopupWindow.isShowing()) {
            this.handsUpRemindPopupWindow.dismiss();
        }
    }

    @Override
    public void showCloudRecordButton(boolean cloudRecord) {
        this.$.id(R.id.window_bottom_menu_record).view().setVisibility(cloudRecord ? 0 : 8);
    }

    @Override
    public void showMuteAllStateChange(boolean mute) {
        if (mute) {
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_mute_all_tip));
        } else {
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_unmute_all_tip));
        }
    }

    @Override
    public void showBonusPointsAdd(Integer integer) {
        if (this.bonusPointsPopupWindow != null) {
            this.bonusPointsPopupWindow.dismiss();
        }
        this.bonusPointsPopupWindow = new BonusPointsPopupWindow(this.context, integer.intValue());
        this.bonusPointsPopupWindow.setOnDismissListener(() -> RxUtils.dispose((Disposable)this.disposableOfBonusPointsTimer));
        this.bonusPointsPopupWindow.show(this.$.id(R.id.window_bottom_menu_bonus_points).view());
        RxUtils.dispose((Disposable)this.disposableOfBonusPointsTimer);
        this.disposableOfBonusPointsTimer = Observable.timer((long)2L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (this.bonusPointsPopupWindow != null) {
                this.bonusPointsPopupWindow.dismiss();
            }
        });
    }

    private void changeBottomMenuVisibility() {
        ObjectAnimator animatorAlpha;
        ObjectAnimator animatorTranslation;
        View bottomMenu = this.$.id(R.id.window_bottom_menu_container).view();
        bottomMenu.setPivotX((float)bottomMenu.getWidth());
        this.animatorSet.cancel();
        if (bottomMenu.getVisibility() == 0) {
            animatorTranslation = ObjectAnimator.ofFloat((Object)bottomMenu, (String)"scaleX", (float[])new float[]{bottomMenu.getScaleX(), 0.2f});
            animatorAlpha = ObjectAnimator.ofFloat((Object)bottomMenu, (String)"alpha", (float[])new float[]{bottomMenu.getAlpha(), 0.0f});
            this.$.id(R.id.window_bottom_menu_btn).image(R.drawable.ic_interactive_bottom_menu_off);
            this.$.id(R.id.window_bottom_menu_container_copy).visible();
            this.$.id(R.id.window_bottom_menu_btn_copy).image(R.drawable.ic_interactive_bottom_menu_off);
        } else {
            animatorTranslation = ObjectAnimator.ofFloat((Object)bottomMenu, (String)"scaleX", (float[])new float[]{bottomMenu.getScaleX(), 1.0f});
            animatorAlpha = ObjectAnimator.ofFloat((Object)bottomMenu, (String)"alpha", (float[])new float[]{bottomMenu.getAlpha(), 1.0f});
            this.$.id(R.id.window_bottom_menu_btn).image(R.drawable.ic_interactive_bottom_menu_on);
            this.$.id(R.id.window_bottom_menu_container_copy).invisible();
            this.$.id(R.id.window_bottom_menu_btn_copy).image(R.drawable.ic_interactive_bottom_menu_on);
        }
        this.animatorSet.play((Animator)animatorTranslation).with((Animator)animatorAlpha);
        this.animatorSet.setDuration(300L);
        this.animatorSet.start();
    }

    public void setPresenter(BottomMenuContract.Presenter presenter2) {
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit) {
            if (isActive) {
                this.initView();
            } else {
                this.onDestroy();
            }
        }
        return true;
    }

    @Override
    protected void unSubscribe() {
        super.unSubscribe();
        RxUtils.dispose((Disposable)this.disposableOfReEnter);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.animatorSet != null) {
            this.animatorSet.removeAllListeners();
            this.animatorSet.cancel();
            this.animatorSet = null;
        }
        if (this.recordTipPopupWindow != null) {
            this.recordTipPopupWindow.dismiss();
            this.recordTipPopupWindow = null;
        }
        RxUtils.dispose((Disposable)this.disposableOfReEnter);
        RxUtils.dispose((Disposable)this.disposableOfTimer);
        RxUtils.dispose((Disposable)this.disposableOfBonusPointsTimer);
        if (this.writingboardWrapper != null) {
            this.writingboardWrapper.onDestroy();
        }
    }

    protected boolean onTouchEvent(View v, MotionEvent event) {
        return false;
    }

    private void changeTextDrawableSize(TextView textView, @DrawableRes int drawableRes) {
        Context context = textView.getContext();
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableRes);
        if (drawable2 != null) {
            int size = context.getResources().getDimensionPixelSize(R.dimen.bjysc_toolbar_item_width);
            drawable2.setBounds(0, 0, size, size);
            textView.setCompoundDrawables(drawable2, null, null, null);
        }
    }

    private String getNeedShowMessage(LPResCloudRecordModel nowStatus) {
        String s = "";
        if (!this.isAdmin()) {
            return s;
        }
        if (nowStatus.status == LPConstants.CloudRecordStatus.Recording.getStatus()) {
            s = this.getString(R.string.bjy_group_bottom_menu_cloud_record_enable);
            if (nowStatus.operator == LPConstants.LPUserType.Teacher && !BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())) {
                s = this.getString(R.string.bjy_group_bottom_menu_teacher_started_cloud_record);
            } else if (nowStatus.operator == LPConstants.LPUserType.Assistant && BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())) {
                s = this.getString(R.string.bjy_group_bottom_menu_assistant_started_cloud_record);
            }
        } else {
            s = this.getString(R.string.bjy_group_bottom_menu_cloud_record_disable);
            if (nowStatus.operator == LPConstants.LPUserType.Teacher && !BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())) {
                s = this.getString(R.string.bjy_group_bottom_menu_teacher_stopped_cloud_record);
            } else if (nowStatus.operator == LPConstants.LPUserType.Assistant && BaseUtilsKt.isTeacher((IUserModel)this.iRouter.getLiveRoom().getCurrentUser())) {
                s = this.getString(R.string.bjy_group_bottom_menu_assistant_stopped_cloud_record);
            }
        }
        return s;
    }

    private static class AnimationSetListener
    implements Animator.AnimatorListener {
        private WeakReference<View> weakReferenceView;
        private boolean needToChangeVisibility = true;

        AnimationSetListener(View view) {
            this.weakReferenceView = new WeakReference<View>(view);
        }

        public void onAnimationStart(Animator animation) {
            if (this.weakReferenceView.get() == null) {
                return;
            }
            View view = (View)this.weakReferenceView.get();
            if (view.getVisibility() == 8) {
                view.setVisibility(0);
                this.needToChangeVisibility = false;
            }
        }

        public void onAnimationEnd(Animator animation) {
            if (this.weakReferenceView.get() == null) {
                return;
            }
            View view = (View)this.weakReferenceView.get();
            if (view.getVisibility() == 0 && this.needToChangeVisibility) {
                view.setVisibility(8);
            }
            this.needToChangeVisibility = true;
        }

        public void onAnimationCancel(Animator animation) {
            this.needToChangeVisibility = true;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

