/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.blackboard;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android_serialport_api.XYDataPacket;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.container.ShapePaint;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.global.RouterListener;
import com.baijiayun.groupclassui.window.blackboard.BlackboardScrollView;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPDocExtraModel;
import com.baijiayun.livecore.models.LPMotionEvent;
import com.baijiayun.livecore.models.LPShapeModel;
import com.baijiayun.livecore.models.LPWhiteboardViewInfo;
import com.baijiayun.livecore.models.roomresponse.LPMockClearCacheModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomDocUpdateModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeDelModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeMultipleModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeSingleModel;
import com.baijiayun.livecore.ppt.util.LPShapeConverter;
import com.baijiayun.livecore.ppt.whiteboard.OnDoubleTapListener2;
import com.baijiayun.livecore.ppt.whiteboard.Whiteboard;
import com.baijiayun.livecore.ppt.whiteboard.WhiteboardView;
import com.baijiayun.livecore.ppt.whiteboard.shape.BitmapShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.DoodleShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.LaserShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.TextShape;
import com.baijiayun.livecore.viewmodels.impl.LPShapeViewModel;
import com.baijiayun.livecore.viewmodels.impl.ShapeVM;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BlackImageWindow
implements ShapePaint.IShapePaintListener {
    private BlackboardScrollView scrollView;
    private IRouter iRouter;
    private WhiteboardView whiteboardView;
    private int whiteBoardHeight;
    private ShapeVM shapeVM;
    private ShapeVM.LPShapeReceiverListener lpShapeReceiverListener;
    private List<Shape> bitmapShapes = new ArrayList<Shape>();
    private ShapePaint shapePaint;
    private Disposable paintAuthDisposable;
    private float ratio = 0.0f;
    private final LPMotionEvent lpMotionEvent = new LPMotionEvent();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private Disposable disposableOfBdsRepaint;
    private Context context;

    public BlackImageWindow(Context context) {
        if (context instanceof RouterListener) {
            this.iRouter = ((RouterListener)context).getRouter();
            this.iRouter.getSubjectByKey(EventKey.BitmapShapeList).onNext(this.bitmapShapes);
        }
        this.scrollView = this.onCreateView(context);
        this.context = context;
    }

    public void setShapePaint(ShapePaint shapePaint) {
        this.shapePaint = shapePaint;
        shapePaint.registerShapePaintListener(this);
    }

    private int getBlackboardPages() {
        return this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE ? this.iRouter.getLiveRoom().getPartnerConfig().live1v1BlackboardPages : this.iRouter.getLiveRoom().getPartnerConfig().liveBlackboardPages;
    }

    public void setOnTouchEvent(XYDataPacket xyDataPacket) {
        if (this.whiteboardView != null) {
            float singlePageHeight = 1.0f * (float)this.whiteBoardHeight / (float)this.getBlackboardPages();
            if (xyDataPacket.ty >= singlePageHeight) {
                xyDataPacket.ty = singlePageHeight;
            }
            xyDataPacket.ty += (float)Math.round(this.ratio * (float)this.scrollView.getScrollViewHeight());
            this.lpMotionEvent.setXyDataPacket(xyDataPacket);
            this.whiteboardView.onTouchEvent(this.lpMotionEvent);
        }
    }

    public void gotoPrevPage() {
        int remainPages = this.getBlackboardPages() - 1;
        int page = (int)Math.floor(this.ratio * (float)remainPages);
        if (page > 0) {
            this.sendScrollSignal((float)(--page) * 1.0f / (float)remainPages);
        }
    }

    public void gotoNextPage() {
        int remainPages = this.getBlackboardPages() - 1;
        int page = (int)Math.floor(this.ratio * (float)remainPages);
        if (page < remainPages) {
            this.sendScrollSignal((float)(++page) * 1.0f / (float)remainPages);
        }
    }

    public void bdsRepaintShape(String docId) {
        this.shapeVM.bdsRepaintShape(docId, this.getBlackboardPages(), this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE ? 1.3333334f : 2.0f);
    }

    public void initListener() {
        if (this.lpShapeReceiverListener != null) {
            return;
        }
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Teacher) {
            this.scrollView.setForbidScroll();
        }
        this.lpShapeReceiverListener = new ShapeVM.LPShapeReceiverListener(){

            public void updateShapeInfo(LPResRoomShapeSingleModel lpResRoomShapeSingleModel) {
                if (lpResRoomShapeSingleModel.userId.equals(BlackImageWindow.this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
                    BlackImageWindow.this.iRouter.getSubjectByKey(EventKey.ClearToolbarWindow).onNext((Object)true);
                }
                if ("0".equals(lpResRoomShapeSingleModel.docId)) {
                    final Shape shape = LPShapeConverter.getShapeFromModel((LPShapeModel)lpResRoomShapeSingleModel.shape, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)BlackImageWindow.this.whiteboardView.getMeasuredHeight(), (int)0, (int)0);
                    if (shape instanceof BitmapShape) {
                        BlackImageWindow.this.bitmapShapes.add(shape);
                        String url = AliCloudImageUtil.getScaledUrl((String)lpResRoomShapeSingleModel.shape.url, (String)"m_lfit", (int)1080, (int)1080);
                        Glide.with((Context)BlackImageWindow.this.whiteboardView.getContext()).asBitmap().load(url).into((Target)new SimpleTarget<Bitmap>(){

                            public void onResourceReady(@NotNull Bitmap resource, Transition<? super Bitmap> transition) {
                                AliYunLogHelper.getInstance().addDebugLog("bitmap shape size=" + resource.getAllocationByteCount() / 1024 + "kb");
                                if (BlackImageWindow.this.iRouter != null) {
                                    ((BitmapShape)shape).setBitmap(resource);
                                    BlackImageWindow.this.iRouter.getSubjectByKey(EventKey.BitmapShapeList).onNext((Object)BlackImageWindow.this.bitmapShapes);
                                    BlackImageWindow.this.whiteboardView.onShapeAdd(shape);
                                }
                            }
                        });
                    } else {
                        BlackImageWindow.this.whiteboardView.onShapeAdd(shape);
                    }
                }
            }

            public void updateShape(LPResRoomShapeMultipleModel lpResRoomShapeMultipleModel) {
                if ("0".equals(lpResRoomShapeMultipleModel.docId)) {
                    ArrayList<Shape> allList = new ArrayList<Shape>();
                    for (LPShapeModel model : lpResRoomShapeMultipleModel.shapeList) {
                        Shape shape = LPShapeConverter.getShapeFromModel((LPShapeModel)model, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)BlackImageWindow.this.whiteboardView.getMeasuredHeight(), (int)0, (int)0);
                        if (shape == null) continue;
                        allList.add(shape);
                    }
                    BlackImageWindow.this.whiteboardView.onShapesUpdate(allList);
                }
            }

            public void deleteAllShape(LPResRoomShapeDelModel lpResRoomShapeDelModel) {
                if ("0".equals(lpResRoomShapeDelModel.docId)) {
                    BlackImageWindow.this.whiteboardView.onShapeClear();
                    BlackImageWindow.this.bitmapShapes.clear();
                }
            }

            public void deleteAllShape(LPMockClearCacheModel lpMockClearCacheModel) {
            }

            public void deleteShape(LPResRoomShapeDelModel lpResRoomShapeDelModel) {
                if ("0".equals(lpResRoomShapeDelModel.docId)) {
                    this.deleteShape((Whiteboard)BlackImageWindow.this.whiteboardView, lpResRoomShapeDelModel.shapeId);
                }
            }

            private void deleteShape(Whiteboard whiteboard, String shapeIds) {
                whiteboard.onShapeDelete(shapeIds);
                this.deleteBitmapShape(shapeIds);
            }

            private void deleteBitmapShape(String shapeId) {
                String[] toDeleteShapeArray;
                if (BlackImageWindow.this.bitmapShapes.isEmpty() || TextUtils.isEmpty((CharSequence)shapeId)) {
                    return;
                }
                Iterator iterator = BlackImageWindow.this.bitmapShapes.iterator();
                block0: for (String toDeleteShape : toDeleteShapeArray = shapeId.split(",")) {
                    while (iterator.hasNext()) {
                        Shape shape = (Shape)iterator.next();
                        if (!toDeleteShape.equals(shape.id)) continue;
                        iterator.remove();
                        continue block0;
                    }
                }
            }

            public void drawAllShape(final LPResRoomShapeMultipleModel lpResRoomShapeMultipleModel) {
                if ("0".equals(lpResRoomShapeMultipleModel.docId)) {
                    Shape shape;
                    final ArrayList<Shape> shapes = new ArrayList<Shape>();
                    if (lpResRoomShapeMultipleModel.shapeList == null) {
                        return;
                    }
                    for (LPShapeModel model : lpResRoomShapeMultipleModel.shapeList) {
                        shape = LPShapeConverter.getShapeFromModel((LPShapeModel)model, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)BlackImageWindow.this.whiteBoardHeight, (int)0, (int)0);
                        if (shape instanceof BitmapShape) {
                            BlackImageWindow.this.bitmapShapes.add(shape);
                            shapes.add(shape);
                            String url = AliCloudImageUtil.getScaledUrl((String)model.url, (String)"m_lfit", (int)1080, (int)1080);
                            Glide.with((Context)BlackImageWindow.this.whiteboardView.getContext()).asBitmap().load(url).into((Target)new SimpleTarget<Bitmap>(){

                                public void onResourceReady(@NotNull Bitmap resource, Transition<? super Bitmap> transition) {
                                    AliYunLogHelper.getInstance().addDebugLog("bitmap shape size=" + resource.getAllocationByteCount() / 1024 + "kb");
                                    ((BitmapShape)shape).setBitmap(resource);
                                    if (BlackImageWindow.this.getView() != null) {
                                        BlackImageWindow.this.getView().post(() -> {
                                            if (BlackImageWindow.this.whiteboardView != null && shapes.size() == lpResRoomShapeMultipleModel2.shapeList.size()) {
                                                BlackImageWindow.this.whiteboardView.onShapeAll((List)shapes);
                                            }
                                        });
                                    }
                                }
                            });
                            continue;
                        }
                        if (shape == null) continue;
                        if (shape instanceof DoodleShape) {
                            ((DoodleShape)shape).isEnd = true;
                        }
                        shapes.add(shape);
                    }
                    if (BlackImageWindow.this.bitmapShapes.isEmpty()) {
                        BlackImageWindow.this.whiteboardView.onShapeAll(shapes);
                    }
                    if (lpResRoomShapeMultipleModel.shapeAppendList != null) {
                        for (LPShapeModel model : lpResRoomShapeMultipleModel.shapeAppendList) {
                            shape = LPShapeConverter.getShapeFromModel((LPShapeModel)model, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)BlackImageWindow.this.whiteboardView.getMeasuredHeight(), (int)0, (int)0);
                            if (!(shape instanceof DoodleShape)) continue;
                            BlackImageWindow.this.whiteboardView.onShapeAppend((DoodleShape)shape, model.smooth);
                        }
                    }
                }
            }

            public void appendShape(LPResRoomShapeSingleModel lpResRoomShapeAppendModel) {
                Shape shape;
                if ("0".equals(lpResRoomShapeAppendModel.docId) && (shape = LPShapeConverter.getShapeFromModel((LPShapeModel)lpResRoomShapeAppendModel.shape, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)BlackImageWindow.this.whiteboardView.getMeasuredHeight(), (int)0, (int)0)) instanceof DoodleShape) {
                    BlackImageWindow.this.whiteboardView.onShapeAppend((DoodleShape)shape, lpResRoomShapeAppendModel.shape.smooth);
                }
            }
        };
        this.shapeVM = this.iRouter.getLiveRoom().newShapeVM(this.lpShapeReceiverListener);
        this.shapeVM.requestPageAllShape("0", 0);
        if (!BaseUtilsKt.isAdmin((LiveRoom)this.iRouter.getLiveRoom())) {
            this.paintAuthDisposable = this.iRouter.getLiveRoom().getSpeakQueueVM().getPublishSubjectOfStudentDrawingAuth().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
                this.whiteboardView.setTouchAble(aBoolean.booleanValue());
                if (!aBoolean.booleanValue()) {
                    this.whiteboardView.touchEnd();
                }
            });
        }
        this.disposableOfBdsRepaint = ((LPShapeViewModel)this.shapeVM).getPublishSubjectOfBdsRepaint().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)(aBoolean != false ? this.context.getString(R.string.bjy_group_open_bds_fail) : this.context.getString(R.string.bjy_group_open_bds_success))));
    }

    public void scrollTo(float ratio) {
        this.ratio = ratio;
        this.scrollView.smoothScrollTo(0, Math.round(ratio * (float)this.scrollView.getScrollViewHeight()));
    }

    private BlackboardScrollView onCreateView(Context context) {
        final BlackboardScrollView scrollView = new BlackboardScrollView(context);
        FrameLayout.LayoutParams scrollParams = new FrameLayout.LayoutParams(-1, -1);
        scrollView.setLayoutParams((ViewGroup.LayoutParams)scrollParams);
        scrollView.setFillViewport(true);
        scrollView.setOverScrollMode(2);
        scrollView.setSmoothScrollingEnabled(true);
        this.whiteboardView = new WhiteboardView(context);
        this.whiteboardView.onShapeClear();
        this.whiteboardView.setZoomable(false);
        this.whiteboardView.setPCBlackboard(true);
        if (this.iRouter != null) {
            this.whiteboardView.setUserRole(this.iRouter.getLiveRoom().getCurrentUser().getType());
            this.whiteboardView.setEnableStudentOperatePaint(this.iRouter.getLiveRoom().getPartnerConfig().enableStudentOperatePaint);
        }
        this.whiteboardView.setAdjustViewBounds(true);
        this.whiteboardView.setShowPaintOwnerEnable(true);
        this.whiteboardView.setDrawingRectShapePaintColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_window_main_text_color));
        this.whiteboardView.setOnBitmapShapeListener(bitmapShape -> this.iRouter.getSubjectByKey(EventKey.BitmapShapeSelected).onNext((Object)bitmapShape));
        this.whiteboardView.setOnDoubleTapListener(new OnDoubleTapListener2(){

            public void onDoubleTapConfirmed() {
            }

            public void onDoubleTapOnShape(Shape shape) {
                BlackImageWindow.this.iRouter.getSubjectByKey(EventKey.EditTextShape).onNext((Object)((TextShape)shape).getText());
            }
        });
        this.whiteboardView.setOnViewTapListener((view, x, y) -> {
            if (this.iRouter != null) {
                this.iRouter.getSubjectByKey(EventKey.BgSingleTapConfirmed).onNext((Object)true);
            }
        });
        this.whiteboardView.setShapeSendListener(new WhiteboardView.LPShapeSendListener(){

            public void sendShape(Shape shape, LPWhiteboardViewInfo whiteboardViewInfo) {
                LPResRoomShapeSingleModel model = new LPResRoomShapeSingleModel();
                model.shape = LPShapeConverter.getModelFromShape((Shape)shape, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)BlackImageWindow.this.whiteboardView.getMeasuredHeight(), (int)whiteboardViewInfo.offsetWidth, (int)whiteboardViewInfo.offsetHeight, (int)(shape instanceof DoodleShape ? 0 : 1));
                model.docId = "0";
                model.page = 0;
                model.shape.dashType = whiteboardViewInfo.dashType;
                BlackImageWindow.this.shapeVM.requestShapeAdd(model, whiteboardViewInfo.hasAppend);
            }

            public boolean eraseShape(Shape shape, String docId, int page) {
                BlackImageWindow.this.shapeVM.eraseShape(new LPResRoomShapeDelModel("0", page, shape.id));
                return true;
            }

            public void shapeUpdate(List<Shape> shapes, LPWhiteboardViewInfo whiteboardViewInfo) {
                if (shapes == null || shapes.size() == 0) {
                    return;
                }
                LPResRoomShapeMultipleModel multipleModel = new LPResRoomShapeMultipleModel();
                ArrayList<LPShapeModel> shapeModels = new ArrayList<LPShapeModel>();
                for (Shape shape : shapes) {
                    shapeModels.add(LPShapeConverter.getModelFromShape((Shape)shape, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)BlackImageWindow.this.whiteboardView.getMeasuredHeight(), (int)whiteboardViewInfo.offsetWidth, (int)whiteboardViewInfo.offsetHeight, (int)1));
                }
                multipleModel.shapeList = shapeModels;
                multipleModel.docId = "0";
                multipleModel.page = 0;
                BlackImageWindow.this.shapeVM.requestShapeUpdate(multipleModel);
            }

            public void laserShapeUpdate(Shape shape, LPWhiteboardViewInfo whiteboardViewInfo) {
                if (shape == null) {
                    return;
                }
                if (shape.isHoverTrace && !((BlackImageWindow)BlackImageWindow.this).iRouter.getLiveRoom().getPartnerConfig().livePainterShowTraceBeforeDraw) {
                    return;
                }
                LPResRoomShapeSingleModel singleModel = new LPResRoomShapeSingleModel();
                singleModel.shape = LPShapeConverter.getModelFromShape((Shape)shape, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)(BlackImageWindow.this.whiteboardView.getMeasuredHeight() / BlackImageWindow.this.getBlackboardPages()), (int)whiteboardViewInfo.offsetWidth, (int)(whiteboardViewInfo.offsetHeight + Math.round(BlackImageWindow.this.ratio * (float)scrollView.getScrollViewHeight())), (int)1);
                if (shape.isHoverTrace && ((BlackImageWindow)BlackImageWindow.this).iRouter.getLiveRoom().getPartnerConfig().livePainterShowTraceBeforeDraw) {
                    singleModel.shape.setShapeType(LPConstants.ShapeType.Doodle);
                    singleModel.shape.strokeStyle = LPShapeConverter.getColorHex((int)shape.getPaint().getColor());
                }
                singleModel.docId = "0";
                singleModel.page = 0;
                if (shape instanceof LaserShape) {
                    BlackImageWindow.this.shapeVM.requestShapeLaserUpdate(singleModel);
                }
            }

            public void sendShapeAppend(Shape shape, LPWhiteboardViewInfo whiteboardViewInfo, int index) {
                LPResRoomShapeSingleModel model = new LPResRoomShapeSingleModel();
                model.shape = LPShapeConverter.getModelFromShape((Shape)shape, (int)BlackImageWindow.this.whiteboardView.getMeasuredWidth(), (int)BlackImageWindow.this.whiteboardView.getMeasuredHeight(), (int)whiteboardViewInfo.offsetWidth, (int)whiteboardViewInfo.offsetHeight, (int)0);
                model.docId = "0";
                model.page = 0;
                model.shape.index = index;
                model.shape.isEnd = whiteboardViewInfo.isEnd;
                BlackImageWindow.this.shapeVM.requestShapeAppend(model);
            }
        });
        this.whiteboardView.setOnShapeSelectedListener(selected -> this.iRouter.getSubjectByKey(EventKey.Action2ShapeSelected).onNext((Object)selected));
        LinearLayout linearLayout = new LinearLayout(context);
        scrollView.addView((View)linearLayout, -1, -1);
        linearLayout.addView((View)this.whiteboardView, -1, -1);
        scrollView.setScrollViewListener(new BlackboardScrollView.ScrollViewListener(){

            @Override
            public void onScrollChanged(ScrollView scrollView, int x, int y, int oldx, int oldy) {
            }

            @Override
            public void onScrollStopped(float ratio) {
                BlackImageWindow.this.ratio = ratio;
                BlackImageWindow.this.sendScrollSignal(ratio);
            }
        });
        return scrollView;
    }

    private void sendScrollSignal(float ratio) {
        if (this.iRouter != null && this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
            LPResRoomDocUpdateModel lpResRoomDocUpdateModel = new LPResRoomDocUpdateModel();
            lpResRoomDocUpdateModel.docId = "0";
            LPDocExtraModel lpDocExtraModel = new LPDocExtraModel();
            lpDocExtraModel.page = 0;
            lpDocExtraModel.step = 0;
            lpDocExtraModel.scrollTop = String.valueOf(ratio);
            lpResRoomDocUpdateModel.docUpdateExtraModel = lpDocExtraModel;
            this.iRouter.getLiveRoom().getDocListVM().requestDocUpdate(lpResRoomDocUpdateModel);
        }
    }

    public View getView() {
        return this.scrollView;
    }

    public void eraseShapes() {
        String deleteIds = this.whiteboardView.eraseShapes();
        if (TextUtils.isEmpty((CharSequence)deleteIds)) {
            return;
        }
        this.shapeVM.eraseShape(new LPResRoomShapeDelModel("0", 0, deleteIds));
    }

    public void setPPTEditMode(LPConstants.PPTEditMode editMode) {
        this.whiteboardView.setPPTEditMode(editMode);
    }

    public void eraseBitmapShape(String shapeId) {
        if (TextUtils.isEmpty((CharSequence)shapeId) || this.shapeVM == null) {
            return;
        }
        this.shapeVM.eraseShape(new LPResRoomShapeDelModel("0", 0, shapeId));
    }

    public void eraseAll() {
        if (this.shapeVM == null) {
            return;
        }
        this.shapeVM.eraseAllShape(new LPResRoomShapeDelModel("0", 0));
    }

    public WhiteboardView getWhiteboardView() {
        return this.whiteboardView;
    }

    public void initWhiteBoardHeight(int height) {
        this.whiteBoardHeight = height;
        this.whiteboardView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, height));
    }

    public void onDestroy() {
        this.scrollView = null;
        this.iRouter = null;
        if (this.shapePaint != null) {
            this.shapePaint.unregisterShapePaintListener(this);
        }
        this.whiteboardView.destroy();
        this.whiteboardView = null;
        if (this.shapeVM != null) {
            ((LPShapeViewModel)this.shapeVM).removeShapeReceiver(this.lpShapeReceiverListener);
        }
        this.shapeVM = null;
        this.lpShapeReceiverListener = null;
        if (this.bitmapShapes != null) {
            this.bitmapShapes.clear();
        }
        this.bitmapShapes = null;
        RxUtils.dispose((Disposable)this.disposables);
        RxUtils.dispose((Disposable)this.paintAuthDisposable);
        RxUtils.dispose((Disposable)this.disposableOfBdsRepaint);
    }

    @Override
    public void onShapeCustomStrokeWidthChange(float strokeWidth) {
        this.whiteboardView.setCustomShapeStrokeWidth(strokeWidth);
    }

    @Override
    public void onShapeDoodleStrokeWidthChange(float strokeWidth) {
        this.whiteboardView.setShapeStrokeWidth(strokeWidth);
    }

    @Override
    public void onShapeColorChange(int shapeColor) {
        this.whiteboardView.setShapeColor(shapeColor);
    }

    @Override
    public void onShapeTypeChange(LPConstants.ShapeType shapeType) {
        this.whiteboardView.setCustomShapeType(shapeType);
    }

    @Override
    public void onShapeEditModeChange(LPConstants.PPTEditMode pptEditMode) {
        this.whiteboardView.setPPTEditMode(pptEditMode);
    }

    @Override
    public void onShapeTextSizeChange(int textSize) {
        this.whiteboardView.setPaintTextSize(textSize);
    }

    @Override
    public void onSendDrawTextConfirmed(String beforeText, String content) {
        this.whiteboardView.sendDrawTextConfirmed(beforeText, content);
    }
}

