/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.user;

import android.text.TextUtils;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.base.BaseGroupPresenter;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.user.IUserInteractionListener;
import com.baijiayun.groupclassui.user.ReplaceUserWithStatus;
import com.baijiayun.groupclassui.user.UserStatus;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPAwardUserInfo;
import com.baijiayun.livecore.models.LPForbidUserModel;
import com.baijiayun.livecore.models.LPGroupItem;
import com.baijiayun.livecore.models.LPMediaModel;
import com.baijiayun.livecore.models.LPStudyRoomTutorModel;
import com.baijiayun.livecore.models.launch.LPAwardConfig;
import com.baijiayun.livecore.viewmodels.SpeakQueueVM;
import com.baijiayun.livecore.wrapper.LPPlayer;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.ReplaySubject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OnlineUserPresenter
implements BaseGroupPresenter {
    private static final int FORBID_CHAT_DURATION = 86400;
    private IRouter router;
    private IUserInteractionListener listener;
    private List<IUserModel> activeUserList = new ArrayList<IUserModel>();
    private List<IUserModel> unActiveUserList = new ArrayList<IUserModel>();
    private List<IUserModel> blockedUserList = new ArrayList<IUserModel>();
    private HashMap<String, LPAwardUserInfo> awardRecord = new HashMap();
    private long lastRquestAwardTime = 0L;
    private CompositeDisposable disposables;
    private boolean isLoading = false;

    public OnlineUserPresenter(IUserInteractionListener listener) {
        this.listener = listener;
    }

    @Override
    public void setRouter(IRouter router) {
        this.router = router;
    }

    public IRouter getRouter() {
        return this.router;
    }

    public void subscribe() {
        this.disposables = new CompositeDisposable();
        if (BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
            this.router.getLiveRoom().getChatVM().requestForbidList();
        }
        this.router.getLiveRoom().getOnlineUserVM().loadMoreUser();
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfOnlineUser().observeOn(AndroidSchedulers.mainThread()).subscribe(iUserModels -> {
            this.isLoading = false;
            if (this.listener != null) {
                this.listener.notifyOnlineUserDataSetChange();
            }
        }));
        SpeakQueueVM speakQueueVM = this.router.getLiveRoom().getSpeakQueueVM();
        this.disposables.add(speakQueueVM.getObservableOfSpeakApply().mergeWith((ObservableSource)speakQueueVM.getObservableOfSpeakApplyDeny()).observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModel -> {
            if (this.listener != null) {
                this.listener.notifyHandsUpUserDataSetChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfOnGroupItem().toFlowable(BackpressureStrategy.LATEST).observeOn(AndroidSchedulers.mainThread()).subscribe(lpGroupItems -> {
            if (this.listener != null) {
                this.listener.notifyHandsUpUserDataSetChange();
                this.listener.notifyOnlineUserDataSetChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getObservableOfForbidRaiseHand().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (this.listener != null) {
                this.listener.notifyForbidHandUp((boolean)aBoolean);
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getChatVM().getObservableOfForbidChat().observeOn(AndroidSchedulers.mainThread()).subscribe(iForbidChatModel -> {
            this.updateForbidChatStatus(iForbidChatModel.getForbidUser().getUserId(), iForbidChatModel.getDuration() > 0L);
            if (this.listener != null) {
                this.listener.notifyForbidStatus();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getChatVM().getObservableOfForbidList().observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomForbidListModel -> {
            if (lpResRoomForbidListModel.userList == null) {
                return;
            }
            for (LPForbidUserModel forbidUserModel : lpResRoomForbidListModel.userList) {
                if (forbidUserModel.duration <= 0) continue;
                this.updateForbidChatStatus(forbidUserModel.userId, true);
            }
            if (this.listener != null) {
                this.listener.notifyForbidStatus();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfBlockedUser().observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomBlockedUserModel -> {
            if (this.listener != null) {
                this.listener.notifyOnlineUserDataSetChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserAdd().observeOn(AndroidSchedulers.mainThread()).subscribe(userModel -> {
            if (this.listener != null) {
                this.listener.notifyOnlineUserDataSetChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().observeOn(AndroidSchedulers.mainThread()).subscribe(userModel -> {
            if (this.listener != null) {
                this.listener.notifyOnlineUserDataSetChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakResponse().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            if (this.listener != null) {
                this.listener.notifyHandsUpUserDataSetChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getSpeakQueueVM().getObservableOfMediaPublish().filter(iMediaModel -> iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera).observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModel -> {
            if (this.listener != null) {
                this.listener.notifyOnlineUserDataSetChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfBlockedUserList().observeOn(AndroidSchedulers.mainThread()).subscribe(blockUserList -> {
            if (this.listener != null) {
                this.listener.notifyOnlineUserDataSetChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfOnLineUserCount().observeOn(AndroidSchedulers.mainThread()).subscribe(onUserCount -> {
            if (this.listener != null) {
                this.listener.notifyOnlineUserCountChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfAward().observeOn(AndroidSchedulers.mainThread()).subscribe(lpInteractionAwardModel -> {
            HashMap recordAward = lpInteractionAwardModel.value.getRecordAward();
            this.awardRecord.putAll(recordAward);
            if (this.listener != null) {
                this.listener.notifyUserDataChange();
            }
        }));
        this.disposables.add(this.router.getSubjectByKey(EventKey.StudyRoomSwitch).ofType(LPConstants.StudyRoomMode.class).subscribe(studyRoomMode -> {
            if (this.listener != null) {
                this.listener.notifyStudyRoomSwitch();
                this.listener.notifyUserDataChange();
            }
        }));
        Observable observableOfCameraOn = this.router.getLiveRoom().getRecorder().getObservableOfCameraOn().toObservable();
        Observable observableOfMicOn = this.router.getLiveRoom().getRecorder().getObservableOfMicOn().toObservable();
        Observable observableOfMediaPublish = this.router.getLiveRoom().getSpeakQueueVM().getObservableOfMediaPublish().filter(mediaModel -> mediaModel.getUser().getType() != LPConstants.LPUserType.Teacher);
        Observable publishSubjectOfDrawingAuth = this.router.getLiveRoom().getSpeakQueueVM().getPublishSubjectOfDrawingAuth();
        ReplaySubject publishSubjectOfStudentPPTAuth = this.router.getLiveRoom().getDocListVM().getPublishSubjectOfStudentPPTAuth();
        ReplaySubject publishSubjectOfStudentScreenShare = this.router.getLiveRoom().getMediaVM().getPublishSubjectOfStudentScreenShare();
        Observable observableOfTutorStart = this.router.getLiveRoom().getStudyRoomVM().getObservableOfStudyRoomTutorStart();
        Observable observableOfTutorEnd = this.router.getLiveRoom().getStudyRoomVM().getObservableOfStudyRoomTutorEnd();
        Observable observableOfGroupAward = this.router.getLiveRoom().getToolBoxVM().getObservableOfGroupAward();
        this.disposables.add(Observable.mergeArray((ObservableSource[])new ObservableSource[]{observableOfMediaPublish, publishSubjectOfDrawingAuth, publishSubjectOfStudentPPTAuth, publishSubjectOfStudentScreenShare, observableOfCameraOn, observableOfMicOn, observableOfGroupAward, observableOfTutorStart, observableOfTutorEnd}).throttleLatest(1000L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (this.listener != null) {
                this.listener.notifyUserDataChange();
            }
        }));
    }

    public void unSubscribe() {
    }

    public int getAllUserCount() {
        return this.router.getLiveRoom().getOnlineUserVM().getAllCount();
    }

    public int getHandsUpUserCount() {
        return this.router.getLiveRoom().getSpeakQueueVM().getApplyList().size();
    }

    public IUserModel getUser(int position) {
        return this.router.getLiveRoom().getOnlineUserVM().getUser(position);
    }

    public IUserModel getUpUser(int position) {
        return this.activeUserList.get(position);
    }

    public void removeBlockList(String userNumber) {
        this.router.getLiveRoom().getOnlineUserVM().freeBlockedUser(userNumber);
    }

    public IUserModel getBlockList(int position) {
        return this.blockedUserList.get(position);
    }

    public int getUpUserCount() {
        this.activeUserList.clear();
        this.activeUserList.addAll(this.router.getLiveRoom().getOnlineUserVM().getActiveUserList());
        return this.activeUserList.size();
    }

    public int getDownUserCount() {
        this.unActiveUserList.clear();
        this.unActiveUserList.addAll(this.router.getLiveRoom().getOnlineUserVM().getUnActiveUserList());
        return this.isLoading ? this.unActiveUserList.size() + 1 : this.unActiveUserList.size();
    }

    public int getBlockedUserListCount() {
        this.blockedUserList.clear();
        this.blockedUserList.addAll(this.router.getLiveRoom().getOnlineUserVM().getBlockedUserList());
        return this.blockedUserList.size();
    }

    public IUserModel getDownUser(int position) {
        if (!this.isLoading) {
            return this.unActiveUserList.get(position);
        }
        if (position == this.unActiveUserList.size()) {
            return null;
        }
        return this.unActiveUserList.get(position);
    }

    public void updateGroupInfo(int groupId) {
        this.router.getLiveRoom().getOnlineUserVM().loadMoreUser(groupId);
    }

    public List<LPGroupItem> getClassifyGroupList(List<IUserModel> userModels, boolean adjustQueue) {
        ArrayList groupList = new ArrayList(this.router.getLiveRoom().getOnlineUserVM().getGroupList());
        ArrayList<LPGroupItem> groupItems = new ArrayList<LPGroupItem>();
        for (LPGroupItem lpGroupItem : groupList) {
            LPGroupItem groupItem = new LPGroupItem(lpGroupItem.id);
            groupItem.groupItemModel = lpGroupItem.groupItemModel;
            groupItem.userModelList = new ArrayList(lpGroupItem.userModelList);
            groupItems.add(groupItem);
        }
        HashSet<String> userNums = new HashSet<String>();
        LinkedHashMap<String, IUserModel> userModelMap = new LinkedHashMap<String, IUserModel>();
        for (IUserModel userModel : userModels) {
            userNums.add(userModel.getNumber());
            if (!adjustQueue) continue;
            userModelMap.put(userModel.getNumber(), userModel);
        }
        Iterator groupItemIterator = groupItems.iterator();
        while (groupItemIterator.hasNext()) {
            LPGroupItem lpGroupItem = (LPGroupItem)groupItemIterator.next();
            Iterator iterator = lpGroupItem.userModelList.iterator();
            while (iterator.hasNext()) {
                IUserModel user;
                LPUserModel userModel = (LPUserModel)iterator.next();
                if (!userNums.contains(userModel.getNumber())) {
                    iterator.remove();
                    continue;
                }
                if (!adjustQueue || !((user = (IUserModel)userModelMap.get(userModel.getNumber())) instanceof LPUserModel)) continue;
                ((LPUserModel)user).groupId = lpGroupItem.id;
            }
            if (!lpGroupItem.userModelList.isEmpty()) continue;
            groupItemIterator.remove();
        }
        if (adjustQueue) {
            for (LPGroupItem lpGroupItem : groupItems) {
                lpGroupItem.userModelList.clear();
                LPUserModel studentUser = null;
                for (String key : userModelMap.keySet()) {
                    IUserModel userModel = (IUserModel)userModelMap.get(key);
                    if (!(userModel instanceof LPUserModel) || lpGroupItem.id != userModel.getGroup()) continue;
                    if (userModel.getType() == LPConstants.LPUserType.Teacher) {
                        lpGroupItem.userModelList.add(0, (LPUserModel)userModel);
                        continue;
                    }
                    if (userModel.getType() == LPConstants.LPUserType.Assistant) {
                        if (studentUser == null) {
                            lpGroupItem.userModelList.add((LPUserModel)userModel);
                            continue;
                        }
                        int index = lpGroupItem.userModelList.indexOf(studentUser);
                        lpGroupItem.userModelList.add(index, (LPUserModel)userModel);
                        continue;
                    }
                    if (studentUser == null) {
                        studentUser = (LPUserModel)userModel;
                    }
                    lpGroupItem.userModelList.add((LPUserModel)userModel);
                }
            }
        }
        return groupItems;
    }

    public List<LPGroupItem> getActiveGroupList() {
        return this.getClassifyGroupList(this.activeUserList, true);
    }

    public List<LPGroupItem> getUnActiveGroupList() {
        return this.getClassifyGroupList(this.unActiveUserList, false);
    }

    public LPGroupItem getGroupItem(int groupId) {
        List groupList = this.router.getLiveRoom().getOnlineUserVM().getGroupList();
        int size = groupList.size();
        for (int i = 0; i < size; ++i) {
            LPGroupItem lpGroupItem = (LPGroupItem)groupList.get(i);
            if (lpGroupItem.id != groupId) continue;
            return lpGroupItem;
        }
        return null;
    }

    public IUserModel getHandsUpUser(int position) {
        return (IUserModel)this.router.getLiveRoom().getSpeakQueueVM().getApplyList().get(position);
    }

    public void agreeSpeakApply(IUserModel requestUser) {
        List curList = this.router.getLiveRoom().getOnlineUserVM().getActiveUserList();
        if (curList != null) {
            boolean isActive = false;
            IUserModel tea = null;
            for (IUserModel iUserModel : curList) {
                if (iUserModel.getType() == LPConstants.LPUserType.Teacher) {
                    tea = iUserModel;
                }
                if (!iUserModel.getUserId().equals(requestUser.getUserId())) continue;
                isActive = true;
            }
            curList.remove(tea);
            if (curList.size() >= this.router.getLiveRoom().getMaxActiveUsers()) {
                if (isActive) {
                    this.router.getLiveRoom().getSpeakQueueVM().agreeSpeakApply(requestUser.getUserId());
                    return;
                }
                ReplaceUserWithStatus replaceUserWithStatus = new ReplaceUserWithStatus(requestUser);
                replaceUserWithStatus.isHandsUp = true;
                this.router.getPublishSubjectByKey(EventCode.UserWhenFullActiveAdd).onNext((Object)replaceUserWithStatus);
                if (this.listener != null) {
                    this.listener.notifyCurrentSeatFull();
                }
                return;
            }
        }
        this.router.getLiveRoom().getSpeakQueueVM().agreeSpeakApply(requestUser.getUserId());
    }

    public void disagreeSpeakApply(String userId) {
        this.router.getLiveRoom().getSpeakQueueVM().disagreeSpeakApply(userId);
    }

    public void forbidChat(IUserModel forbidUser) {
        this.router.getLiveRoom().getChatVM().forbidChat(forbidUser, 86400L);
    }

    public void unForbidChat(IUserModel unForbidUser) {
        this.router.getLiveRoom().getChatVM().forbidChat(unForbidUser, -1L);
    }

    public void updateForbidChatStatus(String userId, boolean isForbid) {
        LPUserModel userModel = (LPUserModel)this.router.getLiveRoom().getOnlineUserVM().getUserById(userId);
        if (userModel != null) {
            userModel.isForbidChat = isForbid;
        }
        for (IUserModel iUserModel : this.router.getLiveRoom().getOnlineUserVM().getActiveUserList()) {
            if (!iUserModel.getUserId().equals(userId)) continue;
            ((LPUserModel)iUserModel).isForbidChat = isForbid;
            break;
        }
    }

    public boolean isAdmin() {
        return BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom());
    }

    public boolean isMediaGroup() {
        return this.router.getLiveRoom().getOnlineUserVM().isMediaGroup();
    }

    public IUserModel getCurrentUser() {
        return this.router.getLiveRoom().getCurrentUser();
    }

    public void kickOutUser(IUserModel userModel) {
        this.router.getSubjectByKey(EventKey.KickOutConfirm).onNext((Object)userModel);
    }

    public void requestForbidRaiseHand(boolean isForbid) {
        this.router.getLiveRoom().requestForbidRaiseHand(isForbid);
    }

    private boolean containStudentOrAssist() {
        List activeUserList = this.router.getLiveRoom().getOnlineUserVM().getActiveUserList();
        for (IUserModel iUserModel : activeUserList) {
            if (iUserModel.getType() != LPConstants.LPUserType.Student && iUserModel.getType() != LPConstants.LPUserType.Assistant) continue;
            return true;
        }
        return false;
    }

    public boolean enable1v1TeacherOffStage() {
        return this.router.getLiveRoom().getOnlineUserVM().enable1v1TeacherOffStage();
    }

    public void upOrDownFromSeatContainer(IUserModel userModel, boolean isShowOnSeatContainer) {
        if (isShowOnSeatContainer) {
            List curList = this.router.getLiveRoom().getOnlineUserVM().getActiveUserList();
            ArrayList<IUserModel> curNewList = new ArrayList<IUserModel>();
            if (curList != null) {
                for (IUserModel iUserModel : curList) {
                    if (iUserModel.getType() == LPConstants.LPUserType.Teacher && !this.enable1v1TeacherOffStage()) continue;
                    curNewList.add(iUserModel);
                }
                int count = this.router.getLiveRoom().getMaxActiveUsers();
                if (this.enable1v1TeacherOffStage()) {
                    ++count;
                }
                if (curNewList.size() >= count) {
                    this.router.getPublishSubjectByKey(EventCode.UserWhenFullActiveAdd).onNext((Object)new ReplaceUserWithStatus(userModel));
                    if (this.listener != null) {
                        this.listener.notifyCurrentSeatFull();
                    }
                    return;
                }
            }
            if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE && this.containStudentOrAssist() && !this.enable1v1TeacherOffStage()) {
                this.router.getPublishSubjectByKey(EventCode.UserWhenFullActiveAdd).onNext((Object)new ReplaceUserWithStatus(userModel));
                if (this.listener != null) {
                    this.listener.notifyCurrentSeatFull();
                    return;
                }
            }
            LPUserModel lpUserModel = (LPUserModel)userModel;
            this.router.getLiveRoom().getOnlineUserVM().requestAddActiveUser((IUserModel)lpUserModel);
        } else {
            this.router.getLiveRoom().getOnlineUserVM().requestRemoveActiveUser(userModel);
        }
    }

    public void getForbidRaiseHandUp() {
        if (this.listener != null) {
            this.listener.notifyForbidHandUp(this.router.getLiveRoom().getForbidRaiseHandStatus());
        }
    }

    public boolean isOnVideoSeat(IUserModel userModel) {
        return this.router.getLiveRoom().getOnlineUserVM().isActiveUser(userModel);
    }

    public LPMediaModel getMediaModel(IUserModel userModel) {
        LPPlayer player = this.router.getLiveRoom().getPlayer();
        if (player != null) {
            return (LPMediaModel)player.getChmUserMediaModel().get(userModel.getUserId());
        }
        return null;
    }

    public boolean isSelfVideoOn() {
        return this.router.getLiveRoom().getRecorder().isVideoAttached();
    }

    public boolean isSelfAudioOn() {
        return this.router.getLiveRoom().getRecorder().isAudioAttached();
    }

    public void controlRemoteSpeak(String userId, boolean isVideoOn, boolean isAudioOn) {
        if (userId.equals(this.router.getLiveRoom().getCurrentUser().getUserId())) {
            this.router.getPublishSubjectByKey(EventCode.AttachVideo).onNext((Object)isVideoOn);
            this.router.getPublishSubjectByKey(EventCode.AttachAudio).onNext((Object)isAudioOn);
        } else {
            this.router.getLiveRoom().getSpeakQueueVM().controlRemoteUser(userId, isVideoOn, isAudioOn);
        }
    }

    public boolean isStudyGalleryMode() {
        return this.router.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout();
    }

    public boolean isSelfStudyMode() {
        return this.router.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.SelfStudy;
    }

    public boolean hasPPTAuth(IUserModel userModel) {
        if (userModel.getType() == LPConstants.LPUserType.Teacher || userModel.getType() == LPConstants.LPUserType.Assistant) {
            return true;
        }
        List authList = this.router.getLiveRoom().getDocListVM().getStudentPPTAuthList();
        return authList != null && authList.contains(userModel.getNumber());
    }

    public boolean isSingleTutorUser(IUserModel userModel) {
        List roomTutorModels = this.router.getLiveRoom().getStudyRoomVM().getStudyRoomCurrentTutorGroup();
        for (LPStudyRoomTutorModel lpStudyRoomTutorModel : roomTutorModels) {
            if (!TextUtils.equals((CharSequence)lpStudyRoomTutorModel.from, (CharSequence)userModel.getUserId()) && !TextUtils.equals((CharSequence)lpStudyRoomTutorModel.to, (CharSequence)userModel.getUserId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasScreenShare(IUserModel userModel) {
        if (userModel.getType() == LPConstants.LPUserType.Teacher || userModel.getType() == LPConstants.LPUserType.Assistant) {
            return true;
        }
        List screenShareList = this.router.getLiveRoom().getMediaVM().getStudentScreenShareList();
        return screenShareList != null && screenShareList.contains(userModel.getNumber());
    }

    public void changePPTPaint(boolean grandPPT, String userNumber) {
        this.router.getLiveRoom().getSpeakQueueVM().requestStudentDrawingAuthChange(grandPPT, userNumber);
    }

    public void changePPTAuth(boolean grandPPT, String userNumber) {
        this.router.getLiveRoom().getDocListVM().requestStudentPPTAuthChange(grandPPT, userNumber);
    }

    public void changeScreenShare(boolean grandPPT, IUserModel userModel) {
        this.router.getLiveRoom().getMediaVM().requestStudentScreenShareChange(grandPPT, userModel);
    }

    public void requestAward(IUserModel userModel, String key) {
        if (!this.router.getLiveRoom().isClassStarted()) {
            return;
        }
        String userNumber = userModel.getNumber();
        long currentTime = System.currentTimeMillis();
        boolean canAward = BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom());
        if (canAward && currentTime - this.lastRquestAwardTime > 3000L) {
            LPAwardUserInfo userInfo = this.awardRecord.get(userNumber);
            if (userInfo == null) {
                Map<String, Integer> typeCount = this.getTypeCount();
                typeCount.put(key, 1);
                userInfo = new LPAwardUserInfo(1, typeCount);
            } else {
                Integer keyCount;
                ++userInfo.count;
                if (userInfo.typeCount == null) {
                    userInfo.typeCount = this.getTypeCount();
                }
                if ((keyCount = (Integer)userInfo.typeCount.get(key)) == null) {
                    userInfo.typeCount.put(key, 1);
                } else {
                    userInfo.typeCount.put(key, keyCount + 1);
                }
            }
            userInfo.name = userModel.getName();
            this.awardRecord.put(userNumber, userInfo);
            this.router.getLiveRoom().getToolBoxVM().requestAward(userNumber, key, this.awardRecord);
            this.lastRquestAwardTime = currentTime;
        }
    }

    private Map<String, Integer> getTypeCount() {
        LPAwardConfig[] awardConfigs;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (LPAwardConfig lpAwardConfig : awardConfigs = this.router.getLiveRoom().getToolBoxVM().getAwardConfigs()) {
            if (lpAwardConfig.isEnable != 1) continue;
            map.put(lpAwardConfig.key, 0);
        }
        return map;
    }

    public int getAwardGroupCount(int group) {
        Integer count = (Integer)this.router.getLiveRoom().getToolBoxVM().getAwardGroupMap().get(group);
        return count == null ? 0 : count;
    }

    public int getAwardCount(String userNumber) {
        LPAwardUserInfo lpAwardUserInfo = this.awardRecord.get(userNumber);
        return lpAwardUserInfo == null ? 0 : lpAwardUserInfo.count;
    }

    public LPAwardConfig[] getAwardConfigs() {
        return this.router.getLiveRoom().getToolBoxVM().getAwardConfigs();
    }

    public void closeWindow() {
        this.router.getSubjectByKey(EventKey.DisplayUserList).onNext((Object)UserStatus.Close);
    }

    public void showBlockedUserFreeAllUI() {
        if (this.listener != null) {
            this.listener.showBlockedUserFreeAllUI();
        }
    }

    public void setBlockedUserFreeAll() {
        this.router.getLiveRoom().getOnlineUserVM().freeAllBlockedUser();
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void loadMore() {
        this.isLoading = true;
        this.router.getLiveRoom().getOnlineUserVM().loadMoreUser();
    }

    public String getTeacherCustomLabelText() {
        return TextUtils.isEmpty((CharSequence)this.router.getLiveRoom().getCustomizeTeacherLabel()) ? "\u4e3b\u8bb2" : this.router.getLiveRoom().getCustomizeTeacherLabel();
    }

    public String getAssistantCustomLabelText() {
        return TextUtils.isEmpty((CharSequence)this.router.getLiveRoom().getCustomizeAssistantLabel()) ? "\u52a9\u6559" : this.router.getLiveRoom().getCustomizeAssistantLabel();
    }

    public void destroy() {
        RxUtils.dispose((Disposable)this.disposables);
    }
}

