/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.container;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.bottommenu.BottomMenuWindow;
import com.baijiayun.groupclassui.window.bottommenu.LeftMenuWindow;
import com.baijiayun.livebase.context.LPConstants;

public class MenuContainer
extends BaseLayerOfProfessionalClass {
    private final String TAG = MenuContainer.class.getCanonicalName();
    private InteractiveBaseWindow bottomMenuWindow;

    public MenuContainer(@NonNull Context context) {
        this(context, null);
    }

    public MenuContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MenuContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public MenuContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean isLayerInit = super.onRoomStatusChange(isRoomActive);
        if (isLayerInit) {
            if (isRoomActive) {
                this.initTemplate();
            } else {
                this.release();
            }
        }
        return true;
    }

    public void initTemplate() {
        if (this.router == null || this.router.getLiveRoom() == null) {
            return;
        }
        if (this.router.getLiveRoom().isAudition()) {
            return;
        }
        if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
            this.bottomMenuWindow = new LeftMenuWindow(this.getContext());
            this.addView(this.bottomMenuWindow.getView(), layoutParams);
        } else {
            this.bottomMenuWindow = new BottomMenuWindow(this.getContext());
            this.addView(this.bottomMenuWindow.getView());
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.release();
    }

    private void release() {
        this.compositeDisposable.clear();
        if (this.bottomMenuWindow != null) {
            this.bottomMenuWindow.onDestroy();
        }
        this.bottomMenuWindow = null;
    }
}

