/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.user;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiahulian.common.cropperv2.uikit.CircleColorView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.user.IUserContract;
import com.baijiayun.groupclassui.user.OnlineUserPresenter;
import com.baijiayun.groupclassui.util.InteractiveUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.GroupItem;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPGroupItem;
import com.baijiayun.livecore.models.LPMediaModel;
import com.baijiayun.livecore.models.launch.LPAwardConfig;
import com.baijiayun.liveuibase.widgets.dialog.AwardPopupWindow;
import java.util.ArrayList;
import java.util.List;

public class ActiveGroupExpandAdapter
extends BaseExpandableListAdapter {
    private final OnlineUserPresenter presenter;
    private final IUserContract listener;
    protected List<LPGroupItem> lpGroupItems;
    private final String[] color = new String[]{"#FF607D", "#BE21E9", "#35CD3B", "#EE87FF", "#775FCF", "#AB8678", "#3D5AFE", "#03A9F4", "#C3FFA6", "#F44336", "#7ED321", "#FB9D3E", "#795548", "#FFEB3B", "#FFAE8E", "#E91E63"};
    private AwardPopupWindow awardPopupWindow;
    private LPAwardConfig availableAward = null;

    public ActiveGroupExpandAdapter(OnlineUserPresenter presenter2, IUserContract listener) {
        this.presenter = presenter2;
        this.listener = listener;
        this.lpGroupItems = new ArrayList<LPGroupItem>();
    }

    public void setDatas(List<LPGroupItem> lpGroupItems) {
        this.lpGroupItems = lpGroupItems;
        this.notifyDataSetChanged();
    }

    public int getGroupCount() {
        return this.lpGroupItems.size();
    }

    public int getChildrenCount(int groupPosition) {
        Object group = this.getGroup(groupPosition);
        if (group == null) {
            return 0;
        }
        LPGroupItem lpGroupItem = (LPGroupItem)group;
        return lpGroupItem.userModelList == null ? 0 : lpGroupItem.userModelList.size();
    }

    public Object getGroup(int groupPosition) {
        if (groupPosition >= this.lpGroupItems.size()) {
            return null;
        }
        return this.lpGroupItems.get(groupPosition);
    }

    public Object getChild(int groupPosition, int childPosition) {
        Object group = this.getGroup(groupPosition);
        if (group == null) {
            return null;
        }
        LPGroupItem lpGroupItem = (LPGroupItem)group;
        if (lpGroupItem.userModelList.isEmpty() && lpGroupItem.userModelList.size() <= childPosition) {
            return null;
        }
        return lpGroupItem.userModelList.get(childPosition);
    }

    public long getGroupId(int groupPosition) {
        Object group = this.getGroup(groupPosition);
        if (group == null) {
            return 0L;
        }
        LPGroupItem lpGroupItem = (LPGroupItem)group;
        return lpGroupItem.id;
    }

    public long getChildId(int groupPosition, int childPosition) {
        Object child = this.getChild(groupPosition, childPosition);
        if (child == null) {
            return 0L;
        }
        LPUserModel lpUserModel = (LPUserModel)child;
        long id2 = 0L;
        try {
            id2 = Long.parseLong(lpUserModel.number);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return id2;
    }

    public boolean hasStableIds() {
        return true;
    }

    protected boolean isActiveGroup() {
        return true;
    }

    @SuppressLint(value={"SetTextI18n"})
    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        GroupHolder groupHolder;
        if (convertView == null) {
            groupHolder = new GroupHolder();
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_group_layout_group_info, parent, false);
            groupHolder.tvGroupName = (TextView)convertView.findViewById(R.id.tv_group_name);
            groupHolder.tvGroupAwardCount = (TextView)convertView.findViewById(R.id.tv_group_award_count);
            groupHolder.ivGroupAward = convertView.findViewById(R.id.iv_group_award);
            groupHolder.tvGroupExpand = (TextView)convertView.findViewById(R.id.tv_group_expand);
            groupHolder.viewGroupColor = (CircleColorView)convertView.findViewById(R.id.view_group_color);
            groupHolder.rlLayoutGroup = (RelativeLayout)convertView.findViewById(R.id.rl_layout_group);
            convertView.setTag((Object)groupHolder);
        } else {
            groupHolder = (GroupHolder)convertView.getTag();
        }
        Object group = this.getGroup(groupPosition);
        if (group != null) {
            LPGroupItem lpGroupItem = (LPGroupItem)group;
            if (lpGroupItem.id == 0 || lpGroupItem.groupItemModel == null) {
                AbsListView.LayoutParams layoutParams = new AbsListView.LayoutParams(-1, 1);
                groupHolder.rlLayoutGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                groupHolder.rlLayoutGroup.setVisibility(8);
                groupHolder.tvGroupExpand.setVisibility(8);
                groupHolder.ivGroupAward.setVisibility(8);
                groupHolder.tvGroupAwardCount.setVisibility(8);
            } else {
                groupHolder.tvGroupExpand.setVisibility(0);
                groupHolder.rlLayoutGroup.setVisibility(0);
                groupHolder.tvGroupExpand.setSelected(isExpanded);
                groupHolder.ivGroupAward.setVisibility(this.presenter.isAdmin() ? 0 : 8);
                groupHolder.tvGroupAwardCount.setVisibility(this.presenter.isAdmin() ? 0 : 8);
                groupHolder.tvGroupAwardCount.setText((CharSequence)String.valueOf(this.presenter.getAwardGroupCount(lpGroupItem.id)));
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)groupHolder.viewGroupColor.getLayoutParams();
                params.leftMargin = 0;
                AbsListView.LayoutParams layoutParams = new AbsListView.LayoutParams(-1, parent.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_window_user_content_height));
                groupHolder.rlLayoutGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                GroupItem groupItem = lpGroupItem.groupItemModel;
                groupHolder.tvGroupName.setText((CharSequence)(groupItem.name + "(" + lpGroupItem.userModelList.size() + ")"));
                if (!TextUtils.isEmpty((CharSequence)groupItem.color)) {
                    groupHolder.viewGroupColor.setColor(Color.parseColor((String)groupItem.color));
                } else {
                    groupHolder.viewGroupColor.setColor(Color.parseColor((String)this.color[(groupItem.id - 1) % 16]));
                }
            }
        }
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        GroupChildHolder groupChildHolder;
        if (convertView == null) {
            groupChildHolder = new GroupChildHolder();
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjysc_item_online_user, parent, false);
            groupChildHolder.tvUserName = (TextView)convertView.findViewById(R.id.tv_user_name);
            groupChildHolder.tvUserLabel = (TextView)convertView.findViewById(R.id.tv_user_label);
            groupChildHolder.userContainer = (LinearLayout)convertView.findViewById(R.id.ll_user_container);
            groupChildHolder.awardContainer = (LinearLayout)convertView.findViewById(R.id.ll_award_container);
            groupChildHolder.tvAward = (TextView)convertView.findViewById(R.id.tv_user_award);
            groupChildHolder.ivAwardIcon = (ImageView)convertView.findViewById(R.id.bjysc_online_user_award_icon);
            groupChildHolder.ivCamera = (ImageView)convertView.findViewById(R.id.iv_user_camera);
            groupChildHolder.ivMic = (ImageView)convertView.findViewById(R.id.iv_user_mic);
            groupChildHolder.ivPPTPaint = (ImageView)convertView.findViewById(R.id.iv_user_ppt_paint);
            groupChildHolder.ivPPTAuth = (ImageView)convertView.findViewById(R.id.iv_user_ppt_auth);
            groupChildHolder.ivChat = (ImageView)convertView.findViewById(R.id.iv_user_chat);
            groupChildHolder.ivScreenShare = (ImageView)convertView.findViewById(R.id.iv_user_screen_share);
            groupChildHolder.ivSpeakStauts = (ImageView)convertView.findViewById(R.id.iv_user_speak_status);
            groupChildHolder.ivKickout = (ImageView)convertView.findViewById(R.id.iv_user_kickout);
            convertView.setTag((Object)groupChildHolder);
        } else {
            groupChildHolder = (GroupChildHolder)convertView.getTag();
        }
        Object child = this.getChild(groupPosition, childPosition);
        if (child != null) {
            boolean isVideoOn;
            boolean isAudioOn;
            LPUserModel userModel = (LPUserModel)child;
            int visibility = userModel.getType() == LPConstants.LPUserType.Student ? 0 : 4;
            groupChildHolder.awardContainer.setVisibility(visibility);
            groupChildHolder.ivKickout.setVisibility(visibility);
            groupChildHolder.ivChat.setVisibility(visibility);
            int studyRoomVisible = this.presenter.isStudyGalleryMode() || userModel.getType() != LPConstants.LPUserType.Student ? 4 : 0;
            groupChildHolder.ivPPTPaint.setVisibility(studyRoomVisible);
            groupChildHolder.ivPPTAuth.setVisibility(studyRoomVisible);
            groupChildHolder.ivScreenShare.setVisibility(studyRoomVisible);
            if (userModel.getType() == LPConstants.LPUserType.Teacher) {
                groupChildHolder.userContainer.setVisibility(4);
                groupChildHolder.tvUserLabel.setText((CharSequence)this.presenter.getTeacherCustomLabelText());
                groupChildHolder.tvUserLabel.setBackground(ThemeDataUtil.getCustomLabelBg((Context)parent.getContext(), (int)ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)parent.getContext(), (int)R.attr.base_theme_live_product_color)));
                groupChildHolder.tvUserLabel.setVisibility(0);
                if (this.presenter.enable1v1TeacherOffStage()) {
                    groupChildHolder.userContainer.setVisibility(0);
                } else {
                    groupChildHolder.userContainer.setVisibility(4);
                }
            } else if (userModel.getType() == LPConstants.LPUserType.Assistant) {
                groupChildHolder.userContainer.setVisibility(0);
                groupChildHolder.tvUserLabel.setText((CharSequence)this.presenter.getAssistantCustomLabelText());
                groupChildHolder.tvUserLabel.setBackground(ThemeDataUtil.getCustomLabelBg((Context)parent.getContext(), (int)ThemeDataUtil.getColorFromThemConfigByColorId((Context)parent.getContext(), (int)R.color.bjy_base_assistant_custom_label_bg_color)));
                groupChildHolder.tvUserLabel.setVisibility(0);
            } else {
                groupChildHolder.userContainer.setVisibility(0);
                groupChildHolder.tvUserLabel.setVisibility(8);
            }
            if (!this.presenter.isAdmin()) {
                groupChildHolder.userContainer.setVisibility(8);
            }
            groupChildHolder.ivMic.setVisibility(this.isActiveGroup() ? 0 : 8);
            groupChildHolder.ivCamera.setVisibility(this.isActiveGroup() ? 0 : 8);
            groupChildHolder.tvUserName.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)userModel.getName()));
            LPMediaModel mediaModel = this.presenter.getMediaModel((IUserModel)userModel);
            if (this.isSelf((IUserModel)userModel)) {
                isAudioOn = this.presenter.isSelfAudioOn();
                isVideoOn = this.presenter.isSelfVideoOn();
            } else {
                isAudioOn = mediaModel != null && mediaModel.audioOn;
                isVideoOn = mediaModel != null && mediaModel.videoOn;
            }
            boolean singleTutorUser = this.presenter.isSingleTutorUser((IUserModel)userModel);
            groupChildHolder.ivSpeakStauts.setEnabled(userModel.getEndType() != LPConstants.LPEndType.PC_H5 && !singleTutorUser);
            if (!this.isActiveGroup() || userModel.getEndType() == LPConstants.LPEndType.PC_H5) {
                groupChildHolder.ivPPTPaint.setEnabled(false);
                groupChildHolder.ivPPTAuth.setEnabled(false);
                groupChildHolder.ivScreenShare.setEnabled(false);
                groupChildHolder.tvAward.setTextColor(ContextCompat.getColor((Context)groupChildHolder.tvAward.getContext(), (int)R.color.base_icon_color));
            } else {
                groupChildHolder.ivPPTPaint.setEnabled(true);
                groupChildHolder.ivPPTAuth.setEnabled(true);
                groupChildHolder.ivScreenShare.setEnabled(true);
                groupChildHolder.ivMic.setEnabled(!this.presenter.isSelfStudyMode() && !singleTutorUser);
                groupChildHolder.ivCamera.setEnabled(!singleTutorUser);
                groupChildHolder.tvAward.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)groupChildHolder.tvAward.getContext(), (int)R.attr.base_theme_window_main_text_color));
            }
            groupChildHolder.ivCamera.setSelected(!isVideoOn);
            groupChildHolder.ivMic.setSelected(!isAudioOn);
            groupChildHolder.ivPPTPaint.setSelected(!InteractiveUtils.hasDrawingAuth(this.presenter.getRouter().getLiveRoom(), (IUserModel)userModel));
            groupChildHolder.ivPPTAuth.setSelected(!this.presenter.hasPPTAuth((IUserModel)userModel));
            groupChildHolder.ivScreenShare.setSelected(!this.presenter.hasScreenShare((IUserModel)userModel));
            groupChildHolder.ivSpeakStauts.setSelected(!this.presenter.isOnVideoSeat((IUserModel)userModel));
            groupChildHolder.ivChat.setSelected(userModel.isForbidChat);
            groupChildHolder.tvAward.setText((CharSequence)String.valueOf(this.presenter.getAwardCount(userModel.number)));
            this.initAward(parent.getContext(), userModel, groupChildHolder);
            groupChildHolder.awardContainer.setOnClickListener(v -> {
                if (this.availableAward == null) {
                    if (this.awardPopupWindow == null) {
                        this.awardPopupWindow = new AwardPopupWindow(parent.getContext(), this.presenter::requestAward);
                    }
                    this.awardPopupWindow.setUserModel((IUserModel)userModel);
                    this.awardPopupWindow.show((View)groupChildHolder.ivAwardIcon);
                } else {
                    this.presenter.requestAward((IUserModel)userModel, this.availableAward.key);
                }
            });
            groupChildHolder.ivCamera.setOnClickListener(v -> this.presenter.controlRemoteSpeak(userModel.userId, groupChildHolder.ivCamera.isSelected(), !groupChildHolder.ivMic.isSelected()));
            groupChildHolder.ivMic.setOnClickListener(v -> this.presenter.controlRemoteSpeak(userModel.userId, !groupChildHolder.ivCamera.isSelected(), groupChildHolder.ivMic.isSelected()));
            groupChildHolder.ivPPTAuth.setOnClickListener(v -> this.presenter.changePPTAuth(groupChildHolder.ivPPTAuth.isSelected(), userModel.number));
            groupChildHolder.ivPPTPaint.setOnClickListener(v -> this.presenter.changePPTPaint(groupChildHolder.ivPPTPaint.isSelected(), userModel.number));
            groupChildHolder.ivScreenShare.setOnClickListener(v -> this.presenter.changeScreenShare(groupChildHolder.ivScreenShare.isSelected(), (IUserModel)userModel));
            groupChildHolder.ivChat.setOnClickListener(v -> {
                if (userModel.isForbidChat) {
                    this.listener.unForbidChat((IUserModel)userModel);
                } else {
                    this.listener.forbidChat((IUserModel)userModel);
                }
            });
            groupChildHolder.ivSpeakStauts.setOnClickListener(v -> this.listener.upOrDownSeatContainer((IUserModel)userModel, !this.presenter.isOnVideoSeat((IUserModel)userModel)));
            groupChildHolder.ivKickout.setOnClickListener(v -> this.listener.kickUserOut((IUserModel)userModel));
        }
        return convertView;
    }

    private void initAward(Context context, LPUserModel lpUserModel, GroupChildHolder groupChildHolder) {
        LPAwardConfig[] awardConfigs = this.presenter.getAwardConfigs();
        if (awardConfigs == null) {
            return;
        }
        int enableAwardTypeCount = 0;
        LPAwardConfig awardConfig = null;
        for (LPAwardConfig lpAwardConfig : awardConfigs) {
            if (lpAwardConfig.isEnable != 1) continue;
            awardConfig = lpAwardConfig;
            ++enableAwardTypeCount;
        }
        if (enableAwardTypeCount <= 1 && awardConfig != null) {
            if (!this.isActiveGroup() && lpUserModel.getEndType() == LPConstants.LPEndType.PC_H5) {
                groupChildHolder.awardContainer.setEnabled(false);
                groupChildHolder.ivAwardIcon.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.bjysc_user_ic_award_disable));
            } else {
                groupChildHolder.ivAwardIcon.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.bjysc_user_ic_award));
            }
            this.availableAward = awardConfig;
        } else {
            if (!this.isActiveGroup() && lpUserModel.getEndType() == LPConstants.LPEndType.PC_H5) {
                groupChildHolder.awardContainer.setEnabled(false);
                groupChildHolder.ivAwardIcon.setImageResource(R.drawable.bjysc_ic_user_list_award_default_disable);
            } else {
                groupChildHolder.ivAwardIcon.setImageResource(R.drawable.bjysc_ic_user_list_award_default);
            }
            this.availableAward = null;
        }
    }

    private boolean isSelf(IUserModel userModel) {
        return TextUtils.equals((CharSequence)userModel.getUserId(), (CharSequence)this.presenter.getCurrentUser().getUserId());
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return false;
    }

    static class GroupChildHolder {
        TextView tvUserName;
        TextView tvUserLabel;
        LinearLayout userContainer;
        LinearLayout awardContainer;
        TextView tvAward;
        ImageView ivAwardIcon;
        ImageView ivCamera;
        ImageView ivMic;
        ImageView ivPPTPaint;
        ImageView ivPPTAuth;
        ImageView ivChat;
        ImageView ivScreenShare;
        ImageView ivSpeakStauts;
        ImageView ivKickout;

        GroupChildHolder() {
        }
    }

    static class GroupHolder {
        TextView tvGroupName;
        TextView tvGroupExpand;
        TextView tvGroupAwardCount;
        View ivGroupAward;
        CircleColorView viewGroupColor;
        RelativeLayout rlLayoutGroup;

        GroupHolder() {
        }
    }
}

