/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.base.BaseGroupPresenter;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.widget.DragRelativeLayout;
import com.baijiayun.groupclassui.window.toolbar.DrawLineMode;
import com.baijiayun.groupclassui.window.toolbar.ToolbarBaseWindow;
import com.baijiayun.groupclassui.window.toolbar.ToolbarContract;
import com.baijiayun.groupclassui.window.toolbar.ToolbarPresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.baijiayun.liveuibase.widgets.common.CheckImageView;
import com.baijiayun.liveuibase.widgets.toolbar.BaseGraphMenuWindow;
import com.baijiayun.liveuibase.widgets.toolbar.ColorSelectData;
import io.reactivex.android.schedulers.AndroidSchedulers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ToolbarWindow
extends ToolbarBaseWindow
implements ToolbarContract.ToolbarView {
    static final int TOOL_WINDOW_TOP_MARGIN_BIG = 40;
    static final int TOOL_WINDOW_TOP_MARGIN_SMALL = 4;
    private boolean isFullScreen;
    private ToolbarContract.ToolbarPresenter presenter;
    private CheckImageView eraseIv;
    private boolean isSelectEraseMode = false;
    public static Map<BaseUIConstant.SelectSrc, Integer> preColorCache = new HashMap<BaseUIConstant.SelectSrc, Integer>();

    public void setPresenter(BaseGroupPresenter presenter2) {
    }

    public FrameLayout.LayoutParams getParams() {
        if (this.view == null) {
            return null;
        }
        return (FrameLayout.LayoutParams)this.view.getLayoutParams();
    }

    public ToolbarWindow(Context context, boolean isFullScreen) {
        super(context);
        this.isFullScreen = isFullScreen;
        this.presenter = new ToolbarPresenter(this);
        this.presenter.setRouter(this.iRouter);
        this.initDrawable();
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student || isFullScreen) {
            this.$.id(R.id.activity_toolbar_split_line).view().setVisibility(8);
            this.$.id(R.id.activity_toolbar_courseware_image).view().setVisibility(8);
            this.$.id(R.id.toolbox_container).view().setVisibility(8);
        }
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student || this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Visitor) {
            this.$.id(R.id.activity_toolbar_laser_image).visibility(8);
        }
        if (isFullScreen && (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant)) {
            this.$.id(R.id.activity_toolbar_laser_image).visibility(8);
        }
        this.eraseIv = (CheckImageView)this.$.id(R.id.activity_toolbar_eraser_image).view();
        this.$.id(R.id.toolbar_ppt_auth_img).clicked(v -> {
            boolean isChecked = ((CheckImageView)this.$.id(R.id.toolbar_ppt_auth_img).view()).isChecked();
            this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)isChecked);
            this.notifyItemSelected(R.id.toolbar_ppt_auth_img, isChecked);
        });
        this.setEraseMode(false);
        this.$.id(R.id.activity_toolbar_selector_image).clicked(v -> {
            boolean isChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_selector_image).view()).isChecked();
            if (isChecked) {
                this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
            } else {
                this.presenter.selectMode(true);
            }
            this.notifyItemSelected(R.id.activity_toolbar_selector_image, isChecked);
        });
        this.$.id(R.id.activity_toolbar_brush_image).clicked(v -> {
            boolean isChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_brush_image).view()).isChecked();
            if (isChecked) {
                this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
            } else {
                ArrayList<Object> clickData = new ArrayList<Object>();
                clickData.add((Object)DrawLineMode.LINE_MODE);
                clickData.add(this.$.id(R.id.activity_toolbar_brush_image).view());
                this.presenter.lineDrawMode(clickData);
            }
            this.notifyItemSelected(R.id.activity_toolbar_brush_image, isChecked);
        });
        this.$.id(R.id.activity_toolbar_marker_image).clicked(v -> {
            boolean isChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_marker_image).view()).isChecked();
            if (isChecked) {
                this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
            } else {
                ArrayList<Object> clickData = new ArrayList<Object>();
                clickData.add((Object)DrawLineMode.MARKER_MODE);
                clickData.add(this.$.id(R.id.activity_toolbar_marker_image).view());
                this.presenter.lineDrawMode(clickData);
            }
            this.notifyItemSelected(R.id.activity_toolbar_marker_image, isChecked);
        });
        this.$.id(R.id.activity_toolbar_graph_image).clicked(v -> {
            CheckImageView checkImageView = (CheckImageView)this.$.id(R.id.activity_toolbar_graph_image).view();
            boolean isChecked = checkImageView.isChecked();
            if (isChecked) {
                this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
            } else {
                v.setTag(null);
                this.iRouter.getSubjectByKey(EventKey.GraphMenuEnable).onNext((Object)v);
            }
            this.notifyItemSelected(R.id.activity_toolbar_graph_image, isChecked);
        });
        this.$.id(R.id.activity_toolbar_laser_image).clicked(v -> {
            boolean isChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_laser_image).view()).isChecked();
            if (isChecked) {
                this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
            }
            this.notifyItemSelected(R.id.activity_toolbar_laser_image, isChecked);
        });
        ((CheckImageView)this.$.id(R.id.activity_toolbar_laser_image).view()).setOnCheckedChangeListener(isChecked -> this.iRouter.getSubjectByKey(EventKey.LaserDrawEnable).onNext((Object)isChecked));
        this.$.id(R.id.activity_toolbar_word_image).clicked(v -> {
            boolean isChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_word_image).view()).isChecked();
            if (isChecked) {
                this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
            } else {
                this.iRouter.getSubjectByKey(EventKey.DrawTextEnable).onNext((Object)this.$.id(R.id.activity_toolbar_word_image).view());
            }
            this.notifyItemSelected(R.id.activity_toolbar_word_image, isChecked);
        });
        this.$.id(R.id.activity_toolbar_eraser_image).clicked(v -> {
            boolean isChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_eraser_image).view()).isChecked();
            if (this.isSelectEraseMode) {
                this.iRouter.getSubjectByKey(EventKey.GraphSelectEraseMode).onNext((Object)true);
                this.isSelectEraseMode = false;
                this.setEraseMode(false);
            } else {
                this.iRouter.getSubjectByKey(EventKey.GraphEraseMode).onNext((Object)(!isChecked ? 1 : 0));
                this.setEraseMode(false);
                this.eraseIv.setChecked(true);
                this.notifyItemSelected(R.id.activity_toolbar_eraser_image, isChecked);
            }
        });
        this.$.id(R.id.activity_toolbar_eraser_all).visibility(this.isAdmin() ? 0 : 8).clicked(v -> this.iRouter.getSubjectByKey(EventKey.GraphEraseAll).onNext((Object)true));
        this.$.id(R.id.activity_toolbar_courseware_image).clicked(v -> this.iRouter.getSubjectByKey(EventKey.CoursewareManageEnable).onNext((Object)true));
        this.$.id(R.id.activity_toolbar_box_image).clicked(v -> {
            boolean isChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_box_image).view()).isChecked();
            this.iRouter.getSubjectByKey(EventKey.ToolBox).onNext((Object)v);
            this.notifyItemSelected(R.id.activity_toolbar_box_image, isChecked);
        });
        this.$.id(R.id.activity_toolbar_roll_call_tip).background(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_live_product_color)).oval().build());
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE && this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
            this.$.id(R.id.activity_toolbar_box_image).gone();
        }
    }

    @Override
    protected View onCreateView(Context context) {
        this.view = new DragRelativeLayout(context);
        LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_activity_brush_toolbar, (ViewGroup)this.view);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
            layoutParams.gravity = 0x800005;
        } else {
            layoutParams.gravity = 8388629;
            this.view.findViewById(R.id.activity_toolbar_courseware_image).setVisibility(8);
            this.view.findViewById(R.id.activity_toolbar_split_line).setVisibility(8);
            this.view.findViewById(R.id.toolbox_container).setVisibility(8);
        }
        if (this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
            this.view.findViewById(R.id.toolbox_container).setVisibility(8);
        }
        layoutParams.rightMargin = UtilsKt.getDp((int)4);
        layoutParams.topMargin = this.isAdmin() ? UtilsKt.getDp((int)4) : UtilsKt.getDp((int)40);
        this.view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return this.view;
    }

    private void initDrawable() {
        this.view.findViewById(R.id.bjysc_toolbar_root_container).setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeWidth(UtilsKt.getDp((int)1)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_bg_stroke_10)).build());
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit) {
            if (isActive) {
                this.subscribe();
            } else {
                this.resetToolbar();
                this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)false);
                this.compositeDisposable.clear();
            }
        }
        return true;
    }

    private GradientDrawable getDrawable(int color2) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setCornerRadius(3.0f);
        drawable2.setColor(color2);
        return drawable2;
    }

    private void subscribe() {
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.DrawColorChange).ofType(ColorSelectData.class).subscribe(colorSelectData -> {
            if (colorSelectData == null) {
                return;
            }
            preColorCache.put(colorSelectData.getSelectSrc(), colorSelectData.getSelectColor());
            this.updatePreColor(colorSelectData.getSelectSrc(), colorSelectData.getSelectColor());
        }));
        Object color2 = this.iRouter.getValueByKey(EventKey.DrawColorAllChange, Object.class);
        if (color2 instanceof Integer) {
            this.initToolbarItemBackgroundColor((Integer)color2);
        } else {
            this.initToolbarItemBackgroundColor(Color.parseColor((String)"#1e5eff"));
        }
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.DrawColorAllChange).ofType(String.class).subscribe(colorString -> this.initToolbarItemBackgroundColor(Color.parseColor((String)colorString))));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.GraphDrawEnable).ofType(BaseGraphMenuWindow.OnShapeChangeModel.class).subscribe(model -> this.view.post(() -> {
            CheckImageView checkImageView = (CheckImageView)this.$.id(R.id.activity_toolbar_graph_image).view();
            checkImageView.setCheckedDrawable(model.getSelectDrawable());
            checkImageView.setUnCheckedDrawable(model.getNormalDrawable());
            this.updateChecked(R.id.activity_toolbar_graph_image, model.isInitDrawable());
            this.lastImageId = R.id.activity_toolbar_graph_image;
        })));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.EditTextShape).ofType(String.class).subscribe(s -> {
            this.iRouter.getSubjectByKey(EventKey.DrawTextEnable).onNext((Object)true);
            this.notifyItemSelected(R.id.activity_toolbar_word_image, false);
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).filter(o -> o instanceof Boolean && (Boolean)o != false).subscribe(o -> {
            this.resetToolbar();
            this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)"");
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.LaserShowState).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(isShow -> {
            boolean isReset;
            if (this.isFullScreen) {
                return;
            }
            boolean bl = isReset = this.lastImageId == R.id.activity_toolbar_laser_image;
            if (isShow.booleanValue()) {
                this.$.id(R.id.activity_toolbar_laser_image).visibility(0);
                ((CheckImageView)this.$.id(R.id.activity_toolbar_laser_image).view()).setChecked(false);
            } else {
                this.$.id(R.id.activity_toolbar_laser_image).visibility(8);
                if (isReset) {
                    this.iRouter.getSubjectByKey(EventKey.ResetToolbarStatus).onNext((Object)true);
                }
            }
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.Action2ShapeSelected).observeOn(AndroidSchedulers.mainThread()).ofType(Boolean.class).subscribe(aBoolean -> {
            this.isSelectEraseMode = aBoolean;
            this.setEraseMode(this.isSelectEraseMode);
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.ToolbarItemSelected).observeOn(AndroidSchedulers.mainThread()).ofType(HashMap.class).subscribe(hashMap -> {
            Map.Entry entry = hashMap.entrySet().iterator().next();
            this.updateChecked((Integer)entry.getKey(), (Boolean)entry.getValue());
        }));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.ShowRollCallDot).observeOn(AndroidSchedulers.mainThread()).ofType(Boolean.class).filter(aBoolean -> this.isAdmin()).subscribe(aBoolean -> this.$.id(R.id.activity_toolbar_roll_call_tip).visibility(aBoolean != false && this.$.id(R.id.toolbox_container).view().getVisibility() == 0 ? 0 : 8)));
        this.compositeDisposable.add(this.iRouter.getSubjectByKey(EventKey.ZXYBSoftKey).ofType(Integer.class).observeOn(AndroidSchedulers.mainThread()).subscribe(this::doSoftKeyCallBack));
    }

    private void resetToolbar() {
        if (this.lastImageId != -1) {
            if (this.$.id(this.lastImageId).view() instanceof CheckImageView) {
                ((CheckImageView)this.$.id(this.lastImageId).view()).setChecked(false);
            } else {
                this.$.id(this.lastImageId).view().setSelected(false);
            }
            this.$.id(this.lastImageId).view().setBackground(null);
        }
        this.iRouter.getSubjectByKey(EventKey.ToolbarItemSelected).onNext((Object)false);
    }

    private void doSoftKeyCallBack(int keyCode) {
        switch (keyCode) {
            case 101: {
                break;
            }
            case 102: {
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                boolean isSelectChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_selector_image).view()).isChecked();
                if (isSelectChecked) break;
                this.presenter.selectMode(true);
                this.notifyItemSelected(R.id.activity_toolbar_selector_image, false);
                break;
            }
            case 105: {
                boolean isBrushChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_brush_image).view()).isChecked();
                if (isBrushChecked) break;
                ArrayList<Object> clickData = new ArrayList<Object>();
                clickData.add((Object)DrawLineMode.LINE_MODE);
                clickData.add(this.$.id(R.id.activity_toolbar_brush_image).view());
                clickData.add("");
                this.presenter.lineDrawMode(clickData);
                this.notifyItemSelected(R.id.activity_toolbar_brush_image, false);
                break;
            }
            case 106: {
                boolean isMarkChecked = ((CheckImageView)this.$.id(R.id.activity_toolbar_marker_image).view()).isChecked();
                if (isMarkChecked) break;
                ArrayList<Object> clickData = new ArrayList<Object>();
                clickData.add((Object)DrawLineMode.MARKER_MODE);
                clickData.add(this.$.id(R.id.activity_toolbar_marker_image).view());
                clickData.add("");
                this.presenter.lineDrawMode(clickData);
                this.notifyItemSelected(R.id.activity_toolbar_marker_image, false);
                break;
            }
            case 107: {
                CheckImageView checkImageView = (CheckImageView)this.$.id(R.id.activity_toolbar_graph_image).view();
                boolean isGrapImageChecked = checkImageView.isChecked();
                if (isGrapImageChecked) break;
                checkImageView.setTag((Object)false);
                this.iRouter.getSubjectByKey(EventKey.GraphMenuEnable).onNext((Object)checkImageView);
                this.notifyItemSelected(R.id.activity_toolbar_graph_image, false);
                break;
            }
            case 108: {
                if (this.eraseIv.isChecked()) break;
                this.eraseIv.performClick();
                break;
            }
            case 109: {
                break;
            }
            case 110: {
                break;
            }
            case 111: {
                break;
            }
            case 112: {
                break;
            }
        }
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    private void setEraseMode(boolean isSelectEraseMode) {
        if (isSelectEraseMode) {
            this.eraseIv.setCheckedDrawable(this.context.getResources().getDrawable(R.drawable.base_ic_toolbar_delete_select));
            this.eraseIv.setUnCheckedDrawable(this.context.getResources().getDrawable(R.drawable.base_ic_toolbar_delete_normal));
        } else {
            this.eraseIv.setCheckedDrawable(this.context.getResources().getDrawable(R.drawable.base_ic_toolbar_erase_select));
            this.eraseIv.setUnCheckedDrawable(this.context.getResources().getDrawable(R.drawable.base_ic_toolbar_erase_normal));
        }
        this.eraseIv.setChecked(this.eraseIv.isChecked());
    }

    private void updateChecked(int checkId, boolean isChecked) {
        if (this.$.id(checkId).view() instanceof CheckImageView) {
            ((CheckImageView)this.$.id(checkId).view()).setChecked(!isChecked);
        } else {
            this.$.id(checkId).view().setSelected(!isChecked);
        }
        boolean needBg = !isChecked && checkId != R.id.activity_toolbar_graph_image;
        this.$.id(checkId).view().setBackground(needBg ? ContextCompat.getDrawable((Context)this.context, (int)R.drawable.tool_bar_check_layer_bg) : null);
        if (this.lastImageId != checkId && this.$.id(this.lastImageId).view() != null) {
            if (this.$.id(this.lastImageId).view() instanceof CheckImageView && this.lastImageId != checkId) {
                ((CheckImageView)this.$.id(this.lastImageId).view()).setChecked(false);
            } else {
                this.$.id(this.lastImageId).view().setSelected(!this.$.id(this.lastImageId).view().isSelected());
            }
        }
        if (this.lastImageId != -1 && this.lastImageId != checkId) {
            this.$.id(this.lastImageId).view().setBackground(null);
        }
        this.lastImageId = isChecked ? -1 : checkId;
    }

    private void notifyItemSelected(int checkId, boolean isChecked) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(checkId, isChecked);
        this.iRouter.getSubjectByKey(EventKey.ToolbarItemSelected).onNext(map);
    }

    private void initToolbarItemBackgroundColor(int color2) {
        this.$.id(R.id.activity_toolbar_word_color).view().setBackground((Drawable)this.getDrawable(color2));
        this.$.id(R.id.activity_toolbar_brush_color).view().setBackground((Drawable)this.getDrawable(color2));
        this.$.id(R.id.activity_toolbar_graph_color).view().setBackground((Drawable)this.getDrawable(color2));
        this.$.id(R.id.activity_toolbar_marker_color).view().setBackground((Drawable)this.getDrawable(color2));
        for (Map.Entry<BaseUIConstant.SelectSrc, Integer> entry : preColorCache.entrySet()) {
            this.updatePreColor(entry.getKey(), entry.getValue());
        }
    }

    private void updatePreColor(BaseUIConstant.SelectSrc selectSrc, int color2) {
        GradientDrawable selectDrawable = this.getDrawable(color2);
        switch (selectSrc) {
            case Text: {
                this.$.id(R.id.activity_toolbar_word_color).view().setBackground((Drawable)selectDrawable);
                break;
            }
            case Brush: {
                this.$.id(R.id.activity_toolbar_brush_color).view().setBackground((Drawable)selectDrawable);
                break;
            }
            case Graph: {
                this.$.id(R.id.activity_toolbar_graph_color).view().setBackground((Drawable)selectDrawable);
                break;
            }
            case Marker: {
                this.$.id(R.id.activity_toolbar_marker_color).view().setBackground((Drawable)selectDrawable);
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.compositeDisposable.clear();
        preColorCache.clear();
    }

    public void setOnUpdateLayoutParamsListener(DragRelativeLayout.OnUpdateLayoutParamsListener listener) {
        ((DragRelativeLayout)this.view).setOnUpdateLayoutParamsListener(listener);
    }

    public void setDragParam(int width, int height) {
        ((DragRelativeLayout)this.view).setDragParams(width, height);
    }

    public void updateView(boolean showPPTAuth, boolean showBrush, boolean showToolBox) {
        this.$.id(R.id.toolbar_ppt_auth).visibility(showPPTAuth ? 0 : 8);
        this.$.id(R.id.brush_container).visibility(showBrush ? 0 : 8);
        this.$.id(R.id.toolbox_container).visibility(showToolBox ? 0 : 8);
    }
}

