/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.AudioManager;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.baijiayun.groupclassui.R;
import com.baijiayun.livebase.utils.ThemeDataUtil;

public class ToggleSpeakerVolumeView
extends View {
    private int max;
    private int min;
    private int current;
    @ColorInt
    private int bgColor;
    @ColorInt
    private int curColor;
    private RectF rect;
    private Paint paint;
    private AudioManager mAudioManager;
    private OnTouchSpeakVolumeChangeListener listener;

    public ToggleSpeakerVolumeView(Context context) {
        this(context, null);
    }

    public ToggleSpeakerVolumeView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ToggleSpeakerVolumeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public ToggleSpeakerVolumeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public void setListener(OnTouchSpeakVolumeChangeListener listener) {
        this.listener = listener;
    }

    private void init() {
        this.setLayerType(2, this.paint);
        this.bgColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.bjysc_half_black);
        this.curColor = ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color);
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        if (this.mAudioManager != null) {
            this.max = this.mAudioManager.getStreamMaxVolume(0);
            this.min = 0;
            this.current = this.mAudioManager.getStreamVolume(0);
        }
        this.rect = new RectF();
        this.rect.top = 0.0f;
        this.rect.left = 0.0f;
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        this.rect.right = width;
        this.rect.bottom = height;
        this.paint.setColor(this.bgColor);
        canvas.drawRoundRect(this.rect, (float)(height / 2), (float)(height / 2), this.paint);
        this.rect.right = (float)this.current / (float)this.max * (float)width;
        this.paint.setColor(this.curColor);
        canvas.drawRoundRect(this.rect, (float)(height / 2), (float)(height / 2), this.paint);
        if (this.current > this.min && this.current < this.max) {
            canvas.drawRect((float)(height / 2), 0.0f, this.rect.right, (float)height, this.paint);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 2: {
                float x = event.getX();
                int newCur = Math.max(this.min, Math.min(this.max, (int)(x / (float)this.getWidth() * (float)this.max)));
                if (this.current == newCur) break;
                this.current = newCur;
                this.invalidate();
                if (this.mAudioManager != null) {
                    this.mAudioManager.setStreamVolume(0, this.current, 0);
                }
                if (this.listener == null) break;
                this.listener.onVolumeChange(this.current, this.min, this.max);
                break;
            }
        }
        return true;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mAudioManager == null) {
            return super.onKeyDown(keyCode, event);
        }
        switch (keyCode) {
            case 24: {
                this.mAudioManager.adjustStreamVolume(0, 1, 0);
                ++this.current;
                this.invalidate();
                return true;
            }
            case 25: {
                this.mAudioManager.adjustStreamVolume(0, -1, 0);
                --this.current;
                this.invalidate();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @FunctionalInterface
    public static interface OnTouchSpeakVolumeChangeListener {
        public void onVolumeChange(int var1, int var2, int var3);
    }
}

