/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.global;

import androidx.annotation.VisibleForTesting;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.liveuibase.widgets.toolbar.BaseGraphMenuWindow;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RouterImpl
implements IRouter {
    private HashMap<EventKey, Subject<?>> routerMap;
    private HashMap<EventCode, Subject<?>> publishMap;
    private HashMap<EventKey, Object> routerStore;
    private LiveRoom liveRoom;

    RouterImpl(LiveRoom liveRoom) {
        this.liveRoom = liveRoom;
        this.routerMap = new HashMap();
        this.publishMap = new HashMap();
        this.routerStore = new HashMap();
    }

    @Override
    public <T> BehaviorSubject<T> getSubjectByKey(EventKey key) {
        BehaviorSubject publishSubject = (BehaviorSubject)this.routerMap.get((Object)key);
        if (publishSubject == null) {
            publishSubject = BehaviorSubject.create();
            this.routerMap.put(key, (Subject<?>)publishSubject);
        }
        return publishSubject;
    }

    @Override
    public <T> PublishSubject<T> getPublishSubjectByKey(EventCode key) {
        PublishSubject publishSubject = (PublishSubject)this.publishMap.get((Object)key);
        if (publishSubject == null) {
            publishSubject = PublishSubject.create();
            this.publishMap.put(key, (Subject<?>)publishSubject);
        }
        return publishSubject;
    }

    @Override
    public <T> T getValueByKey(EventKey key, Class<T> targetClass) {
        return this.objParse(this.routerStore.get((Object)key), targetClass);
    }

    @Override
    public <T> T getValueByKey(EventKey key, Class<T> targetClass, T defaultValue) {
        T rst = this.getValueByKey(key, targetClass);
        return rst == null ? defaultValue : rst;
    }

    @Override
    public <K, V> Map<K, V> getMapValueByKey(EventKey eventKey, Class<K> keyClass, Class<V> valueClass) {
        Map tmpRst = this.getValueByKey(eventKey, Map.class);
        if (tmpRst != null) {
            HashMap<K, V> rst = new HashMap<K, V>();
            for (Map.Entry entry : tmpRst.entrySet()) {
                K key = this.objParse(entry.getKey(), keyClass);
                V value = this.objParse(entry.getValue(), valueClass);
                if (key == null || value == null) continue;
                rst.put(key, value);
            }
            return rst;
        }
        return new HashMap();
    }

    @Override
    public <T> List<T> getListByKey(EventKey key, Class<T> targetClass) {
        List value = this.getValueByKey(key, ArrayList.class);
        if (value != null) {
            ArrayList<T> rst = new ArrayList<T>();
            for (Object item : value) {
                T target = this.objParse(item, targetClass);
                if (target == null) continue;
                rst.add(target);
            }
            return rst;
        }
        return new ArrayList();
    }

    @Override
    public <T> Set<T> getSetByKey(EventKey key, Class<T> targetClass) {
        Set value = this.getValueByKey(key, HashSet.class);
        if (value != null) {
            HashSet<T> rst = new HashSet<T>();
            for (Object item : value) {
                T target = this.objParse(item, targetClass);
                if (target == null) continue;
                rst.add(target);
            }
            return rst;
        }
        return new HashSet();
    }

    private <T> T objParse(Object value, Class<T> targetClass) {
        try {
            if (targetClass.isInstance(value)) {
                return targetClass.cast(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setObjectByKey(EventKey key, Object object) {
        this.routerStore.put(key, object);
    }

    @Override
    public <T> ConcurrentLinkedQueue<T> getQueueByKey(EventKey key, Class<T> targetClass) {
        ConcurrentLinkedQueue value = this.getValueByKey(key, ConcurrentLinkedQueue.class);
        if (value != null) {
            ConcurrentLinkedQueue<T> rst = new ConcurrentLinkedQueue<T>();
            for (Object item : value) {
                T target = this.objParse(item, targetClass);
                if (target == null) continue;
                rst.add(target);
            }
            return rst;
        }
        return new ConcurrentLinkedQueue();
    }

    @Override
    public <T> T getSubjectValueByKey(EventKey key, Class<T> targetClass) {
        Subject<?> subject = this.routerMap.get((Object)key);
        if (subject == null) {
            return null;
        }
        BehaviorSubject behaviorSubject = (BehaviorSubject)subject;
        return this.objParse(behaviorSubject.getValue(), targetClass);
    }

    @Override
    public <T> T getSubjectValueByKey(EventKey key, Class<T> targetClass, T defaultValue) {
        T parseValue = this.getSubjectValueByKey(key, targetClass);
        return parseValue == null ? defaultValue : parseValue;
    }

    @Override
    public LiveRoom getLiveRoom() {
        return this.liveRoom;
    }

    @Override
    public void setLiveRoom(LiveRoom liveRoom) {
        this.liveRoom = liveRoom;
    }

    public void release() {
        if (this.liveRoom != null) {
            this.liveRoom.quitRoom();
            this.liveRoom = null;
        }
        this.routerMap.clear();
        this.publishMap.clear();
        this.routerStore.clear();
    }

    public void clear() {
        this.routerStore.clear();
        this.publishMap.clear();
        Iterator<Map.Entry<EventKey, Subject<?>>> iterator = this.routerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EventKey, Subject<?>> next = iterator.next();
            if (next.getKey() == EventKey.ReminderMessage || next.getKey() == EventKey.ReminderErrorMessage || next.getKey() == EventKey.ReminderBlackboardPage || next.getKey() == EventKey.GraphDrawEnable) continue;
            iterator.remove();
        }
        Object value = this.getSubjectByKey(EventKey.GraphDrawEnable).getValue();
        if (value instanceof BaseGraphMenuWindow.OnShapeChangeModel) {
            BaseGraphMenuWindow.OnShapeChangeModel model = (BaseGraphMenuWindow.OnShapeChangeModel)value;
            model.setInitDrawable(true);
        }
    }

    @VisibleForTesting
    public static void main(String[] args) {
    }
}

