/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.studyreport;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.base.BaseGroupDialogFragment;
import com.baijiayun.groupclassui.window.studyreport.StudyReportDialogContract;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.liveuibase.zxing.ZxingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudyReportDialogFragment
extends BaseGroupDialogFragment
implements StudyReportDialogContract.View {
    private StudyReportDialogContract.Presenter presenter;
    private LiveRoom liveRoom;
    public static final int HEIGHT_MARGIN_LANDSCAPE = 12;
    public static final int WIDTH_DEFAULT = 540;

    protected int getLayoutId() {
        return R.layout.bjy_fragment_study_report;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        this.$.id(R.id.bjy_group_close_study_report_text).clicked(v -> this.presenter.closeStudyReportDialog());
        this.$.id(R.id.bjy_group_close_study_report_image).clicked(v -> this.presenter.closeStudyReportDialog());
        this.initUrl();
    }

    public void setPresenter(StudyReportDialogContract.Presenter presenter2) {
        this.presenter = presenter2;
        this.liveRoom = presenter2.getLiveRoom();
    }

    @Override
    @NonNull
    @NotNull
    public Dialog onCreateDialog(@androidx.annotation.Nullable @Nullable Bundle savedInstanceState) {
        Dialog dialog = new Dialog((Context)this.getActivity(), R.style.BJYGroupDialogStyle);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setBackgroundDrawable(ThemeDataUtil.getCommonWindowBg((Context)this.getContext()));
    }

    @Override
    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.windowAnimations = R.style.BJYGroupLiveBaseSendMsgDialogAnim;
        windowParams.gravity = 17;
        int height = this.getContext() == null ? 0 : DisplayUtils.getScreenHeightPixels((Context)this.getContext()) - DisplayUtils.getStatusBarHeight((Activity)this.getActivity());
        int width = DisplayUtils.getScreenWidthPixels((Context)this.getContext());
        windowParams.width = UtilsKt.getDp((int)540);
        windowParams.height = Math.min(height, width) - UtilsKt.getDp((int)12);
    }

    public void initUrl() {
        String params = "?room_id=" + this.liveRoom.getRoomInfo().roomId + "&user_number=" + this.liveRoom.getCurrentUser().getNumber();
        String host = LPConstants.HOSTS_WEB[LiveSDK.getDeployType().getType()];
        String url = host.concat("web/room/studyReport").concat(params);
        this.$.id(R.id.bjy_group_study_report_url).clicked(v -> this.presenter.openStudyReportBrowser(url)).text((CharSequence)url);
        this.$.id(R.id.bjy_group_copy_study_report_url).clicked(v -> this.presenter.copyStudyReportUrl(url));
        this.$.id(R.id.bjy_group_study_report_qrcode).setBitmap(ZxingUtils.generateQRCodeBitmap((String)url, (int)150, (int)150));
    }
}

