/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.chat;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.imodels.IMessageModel;
import com.baijiayun.liveuibase.widgets.chat.FloatChatMessageCommonAdapter;

public class FloatChatMessageAdapter
extends FloatChatMessageCommonAdapter {
    private final IRouter router;

    public FloatChatMessageAdapter(Context context, IRouter router) {
        super(context, router.getLiveRoom());
        this.router = router;
    }

    public void setItemViewClickListener(View itemView) {
        itemView.setOnClickListener(v -> this.router.getSubjectByKey(EventKey.DisplayChat).onNext((Object)true));
    }

    public Drawable setItemBackground() {
        int dp6 = UtilsKt.getDp((int)6);
        return new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_bg_color)).strokeColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.bjysc_bg_stroke_10)).strokeWidth(UtilsKt.getDp((int)1)).cornerRadius(dp6).build();
    }

    @NonNull
    public FloatChatMessageCommonAdapter.TextViewHolder createTextViewHolder(ViewGroup parent) {
        return new TextViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_group_item_float_chat_text, parent, false));
    }

    @NonNull
    public FloatChatMessageCommonAdapter.ImageViewHolder createImageViewHolder(ViewGroup parent) {
        return new ImageViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_group_item_float_chat_image, parent, false));
    }

    public int maxChatCount() {
        return 3;
    }

    public int setDisplayTime() {
        return 5000;
    }

    public boolean shouldNameAppendToTextContent() {
        return true;
    }

    public boolean filterWhenMsgAdd(@NonNull IMessageModel message) {
        return true;
    }

    static class ImageViewHolder
    extends FloatChatMessageCommonAdapter.ImageViewHolder {
        public ImageViewHolder(@NonNull View itemView) {
            super(itemView);
            this.setContentImageView((ImageView)itemView.findViewById(R.id.float_img_msg_iv));
            this.setUserNameTextView((TextView)itemView.findViewById(R.id.float_chat_user_tv));
        }
    }

    static class TextViewHolder
    extends FloatChatMessageCommonAdapter.TextViewHolder {
        public TextViewHolder(@NonNull View itemView) {
            super(itemView);
            this.setContentTextView((TextView)itemView.findViewById(R.id.float_chat_content_tv));
        }
    }
}

