/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.chat;

import android.content.Context;
import android.text.TextUtils;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.chat.IChatContract;
import com.baijiayun.groupclassui.chat.OnChatFilterListener;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPExpressionModel;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.LPChatMessageParser;
import com.baijiayun.livecore.models.LPMessageModel;
import com.baijiayun.livecore.models.LPMessageTranslateModel;
import com.baijiayun.livecore.models.imodels.IMessageModel;
import com.baijiayun.liveuibase.widgets.courseware.models.UploadingImageModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public class ChatPresenter
implements IChatContract.Presenter {
    private static final int DEFAULT_MESSAGE_POOL_SIZE = 500;
    private IRouter router;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private IChatContract.View listener;
    private LinkedBlockingQueue<UploadingImageModel> imageMessageUploadingQueue;
    private List<IMessageModel> messageModelList = new CopyOnWriteArrayList<IMessageModel>();
    private List<IMessageModel> imageMessageModelList = new CopyOnWriteArrayList<IMessageModel>();
    private OnChatFilterListener mOnChatFilterListener;
    private long lastUserInUserOutTimestamp = 0L;
    private Map<String, String> expressions;
    private boolean isDestroy = false;
    private Context context;

    ChatPresenter(IChatContract.View listener, Context context) {
        this.context = context;
        this.listener = listener;
        this.imageMessageUploadingQueue = new LinkedBlockingQueue();
        this.expressions = new HashMap<String, String>();
    }

    @Override
    public void setRouter(IRouter router) {
        this.router = router;
    }

    public void subscribe() {
        this.unSubscribe();
        this.isDestroy = false;
        for (LPExpressionModel lpExpressionModel : this.router.getLiveRoom().getExpressions()) {
            this.expressions.put("[" + lpExpressionModel.name + "]", lpExpressionModel.url);
            this.expressions.put("[" + lpExpressionModel.key + "]", lpExpressionModel.url);
            this.expressions.put("[" + lpExpressionModel.name + "]", lpExpressionModel.url);
        }
        this.compositeDisposable.add(this.router.getLiveRoom().getChatVM().getObservableOfNotifyDataChange().filter(iMessageModels -> iMessageModels.size() > 0).observeOn(AndroidSchedulers.mainThread()).subscribe(iMessageModels -> {
            this.messageModelList.clear();
            this.imageMessageModelList.clear();
            this.messageModelList.addAll((Collection<IMessageModel>)iMessageModels);
            for (IMessageModel msg : iMessageModels) {
                if (msg.getMessageType() != LPConstants.MessageType.Image) continue;
                this.imageMessageModelList.add(msg);
            }
            this.listener.notifyMessageDataSetChange();
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getChatVM().getObservableOfReceiveMessage().observeOn(AndroidSchedulers.mainThread()).subscribe(iMessageModel -> {
            this.trimMessagePool();
            this.messageModelList.add((IMessageModel)iMessageModel);
            if (iMessageModel.getMessageType() == LPConstants.MessageType.Image) {
                this.imageMessageModelList.add((IMessageModel)iMessageModel);
            }
            if (iMessageModel.getMessageType() == LPConstants.MessageType.Image && iMessageModel.getFrom().equals(this.router.getLiveRoom().getCurrentUser())) {
                UploadingImageModel toRemoveModel = null;
                for (IMessageModel iMessageModel2 : this.imageMessageUploadingQueue) {
                    if (!iMessageModel.getUrl().equals(((UploadingImageModel)iMessageModel2).getUploadUrl())) continue;
                    toRemoveModel = (UploadingImageModel)iMessageModel2;
                    break;
                }
                if (toRemoveModel != null) {
                    this.imageMessageUploadingQueue.remove(toRemoveModel);
                    this.messageModelList.remove(toRemoveModel);
                    this.imageMessageModelList.remove(toRemoveModel);
                }
            }
            if (!iMessageModel.getFrom().equals(this.router.getLiveRoom().getCurrentUser())) {
                boolean displayChat = this.router.getSubjectValueByKey(EventKey.DisplayChat, Boolean.class, false);
                if (displayChat) {
                    this.router.getSubjectByKey(EventKey.NewMsgCount).onNext((Object)0);
                } else {
                    int newMsgCount = this.router.getSubjectValueByKey(EventKey.NewMsgCount, Integer.class, 0);
                    this.router.getSubjectByKey(EventKey.NewMsgCount).onNext((Object)(newMsgCount + 1));
                }
            }
            this.listener.notifyMessageItemInsert(this.getMessageCount() - 1, iMessageModel.getFrom().equals(this.router.getLiveRoom().getCurrentUser()));
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getChatVM().getObservableOfReceiveTranslateMessage().observeOn(AndroidSchedulers.mainThread()).subscribe(lpMessageTranslateModel -> this.listener.notifyTranslateMessage((LPMessageTranslateModel)lpMessageTranslateModel)));
        this.compositeDisposable.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfOnlineUser().observeOn(AndroidSchedulers.mainThread()).subscribe(iUserModels -> this.listener.notifyOnlineUserCountChange()));
        this.compositeDisposable.add(this.router.getLiveRoom().getChatVM().getObservableOfForbidAllChatStatus().observeOn(AndroidSchedulers.mainThread()).subscribe(lPRoomForbidChatResult -> this.listener.notifyForbidStatus(lPRoomForbidChatResult.isForbid)));
        this.compositeDisposable.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfUserIn().observeOn(AndroidSchedulers.mainThread()).filter(userInModel -> !this.router.getLiveRoom().getCurrentUser().equals(userInModel.getUser())).filter(userInModel -> {
            if (userInModel.getUser().getType() == LPConstants.LPUserType.Assistant) {
                return this.router.getLiveRoom().getPartnerConfig().enableTipAssistantInOutRoom;
            }
            if (userInModel.getUser().getType() == LPConstants.LPUserType.Student) {
                return this.router.getLiveRoom().getPartnerConfig().enableStudentShowInOutTip;
            }
            return true;
        }).filter(userInModel -> userInModel.getUser().getGroup() == this.router.getLiveRoom().getCurrentUser().getGroup()).subscribe(userInModel -> {
            this.messageModelList.add(this.constructFakeUserInAndOutMsg(userInModel.getUser(), true));
            this.listener.notifyMessageItemInsert(this.getMessageCount() - 1, true);
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfUserOut().observeOn(AndroidSchedulers.mainThread()).filter(userModel -> !userModel.equals(this.router.getLiveRoom().getCurrentUser())).filter(userModel -> {
            if (userModel.getType() == LPConstants.LPUserType.Assistant) {
                return this.router.getLiveRoom().getPartnerConfig().enableTipAssistantInOutRoom;
            }
            if (userModel.getType() == LPConstants.LPUserType.Student) {
                return this.router.getLiveRoom().getPartnerConfig().enableStudentShowInOutTip;
            }
            return true;
        }).filter(userModel -> userModel.getGroup() == this.router.getLiveRoom().getCurrentUser().getGroup()).subscribe(userModel -> {
            this.messageModelList.add(this.constructFakeUserInAndOutMsg((IUserModel)userModel, false));
            this.listener.notifyMessageItemInsert(this.getMessageCount() - 1, true);
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfOnLineUserCount().observeOn(AndroidSchedulers.mainThread()).subscribe(onUserCount -> {
            if (this.listener != null) {
                this.listener.notifyOnlineUserCountChange();
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getChatVM().getObservableOfMsgRevoke().observeOn(AndroidSchedulers.mainThread()).subscribe(lpMessageRevoke -> {
            if (lpMessageRevoke.messageId == null) {
                return;
            }
            for (IMessageModel iMessageModel : this.imageMessageModelList) {
                if (!lpMessageRevoke.messageId.equals(iMessageModel.getId())) continue;
                this.imageMessageModelList.remove(iMessageModel);
                break;
            }
            int index = -1;
            for (int i = 0; i < this.messageModelList.size(); ++i) {
                IMessageModel iMessageModel = this.messageModelList.get(i);
                if (!lpMessageRevoke.messageId.equals(iMessageModel.getId())) continue;
                index = i;
                this.messageModelList.remove(iMessageModel);
                break;
            }
            this.listener.notifyMessageItemRemove(index);
        }));
    }

    IMessageModel constructFakeUserInAndOutMsg(IUserModel userModel, boolean isIn) {
        LPMessageModel messageModel = new LPMessageModel();
        StringBuilder sb = new StringBuilder();
        sb.append(UtilsKt.getEncodePhoneNumber((String)userModel.getName()));
        if (userModel.getType() == LPConstants.LPUserType.Teacher) {
            sb.append(" [ ").append(this.context.getString(R.string.lp_override_role_teacher)).append(" ] ");
        } else if (userModel.getType() == LPConstants.LPUserType.Assistant) {
            sb.append(" [ ").append(this.context.getString(R.string.bjysc_role_assistant)).append(" ] ");
        }
        if (isIn) {
            sb.append(String.format(" %s", this.context.getString(R.string.base_live_enter_room)));
            messageModel.id = "fake_message_user_in";
        } else {
            sb.append(String.format(" %s", this.context.getString(R.string.base_live_leave_room)));
            messageModel.id = "fake_message_user_out";
        }
        if (System.currentTimeMillis() - this.lastUserInUserOutTimestamp > 60000L) {
            messageModel.newTime = new Date();
            this.lastUserInUserOutTimestamp = System.currentTimeMillis();
        }
        messageModel.content = sb.toString();
        return messageModel;
    }

    void sendTextMessage(String message) {
        boolean isFilter;
        if (this.mOnChatFilterListener != null && (isFilter = this.mOnChatFilterListener.onChatFilterListener(message))) {
            return;
        }
        this.router.getLiveRoom().getChatVM().sendMessage(message);
    }

    void sendEmojiMessage(String emoji) {
        this.router.getLiveRoom().getChatVM().sendEmojiMessage(emoji);
    }

    @Override
    public void sendTranslateMessage(String message, String messageId, String classId, String userId, String fromLanguage, String toLanguage) {
        this.router.getLiveRoom().getChatVM().sendTranslateMessage(message, messageId, classId, userId, fromLanguage, toLanguage);
    }

    int getMessageCount() {
        return this.messageModelList.size();
    }

    IMessageModel getMessage(int pos) {
        if (pos < 0 || pos >= this.messageModelList.size()) {
            return null;
        }
        return this.messageModelList.get(pos);
    }

    int translateMessage(LPMessageTranslateModel translateModel) {
        int pos = -1;
        for (int i = 0; i < this.messageModelList.size(); ++i) {
            if (this.messageModelList.get(i) == null || this.messageModelList.get(i).getFrom() == null || !(this.messageModelList.get(i).getFrom().getUserId() + this.messageModelList.get(i).getTimestamp().getTime()).equals(translateModel.messageId) || translateModel.content == null) continue;
            pos = i;
            break;
        }
        if (pos < 0 || pos >= this.messageModelList.size()) {
            return -1;
        }
        LPMessageModel messageModel = (LPMessageModel)this.messageModelList.get(pos);
        if (translateModel.code == 0) {
            messageModel.setContent(messageModel.getContent().split("-@translate@-")[0] + "-@translate@-" + translateModel.result);
        } else if (translateModel.code == 1) {
            String tips = Locale.getDefault().getCountry().equalsIgnoreCase("cn") ? "\u7ffb\u8bd1\u5931\u8d25" : "Translate Fail!";
            messageModel.setContent(messageModel.getContent() + "-@translate@-" + tips);
        }
        this.messageModelList.set(pos, (IMessageModel)messageModel);
        return pos;
    }

    public IUserModel getCurrentUser() {
        if (this.router.getLiveRoom() == null) {
            return new LPUserModel();
        }
        return this.router.getLiveRoom().getCurrentUser();
    }

    int getOnlineUserCount() {
        return this.router.getLiveRoom().getOnlineUserVM().getAllCount();
    }

    boolean enableFixChatPanel1v1() {
        return this.router.getLiveRoom().enableFixChatPanel1v1();
    }

    void forbidChat(boolean isForbid) {
        this.router.getLiveRoom().getChatVM().requestForbidAllChat(isForbid);
    }

    void reUploadImage() {
        this.continueUploadQueue();
    }

    void sendImageMessage(String path) {
        if (this.isDestroy) {
            return;
        }
        UploadingImageModel model = new UploadingImageModel(path, this.getCurrentUser(), null);
        this.imageMessageUploadingQueue.offer(model);
        this.messageModelList.add((IMessageModel)model);
        this.continueUploadQueue();
    }

    void showMessageSendFragment(String message) {
        this.router.getSubjectByKey(EventKey.ShowMessageSendFragment).onNext((Object)message);
    }

    private void continueUploadQueue() {
        UploadingImageModel model = this.imageMessageUploadingQueue.peek();
        if (model == null || !TextUtils.isEmpty((CharSequence)model.getUploadUrl())) {
            return;
        }
        this.listener.notifyMessageItemInsert(this.getMessageCount() - 1, true);
        this.compositeDisposable.add(this.router.getLiveRoom().getChatVM().getObservableOfUploadImage(model.getUrl()).subscribe(uploadModel -> {
            String imageContent = LPChatMessageParser.toImageMessage((String)uploadModel.url);
            if (this.router != null) {
                this.router.getLiveRoom().getChatVM().sendImageMessageToUser(null, imageContent, uploadModel.width, uploadModel.height);
                model.setUploadUrl(uploadModel.url);
            }
            this.continueUploadQueue();
        }, throwable -> {
            if (this.isDestroy) {
                return;
            }
            model.setStatus(1);
            this.listener.notifyMessageDataSetChange();
        }));
    }

    boolean getForbidAllChatStatus() {
        return this.router.getLiveRoom().getChatVM().isChatForbidden();
    }

    void closeChatWindow() {
        this.router.getSubjectByKey(EventKey.DisplayChat).onNext((Object)false);
    }

    private void trimMessagePool() {
        if (this.messageModelList.size() <= 500) {
            return;
        }
        for (int i = this.messageModelList.size() - 500; i > 0; --i) {
            IMessageModel removedMsg;
            if ("fake_message_user_in".equals(this.messageModelList.get(i).getId()) || "fake_message_user_out".equals(this.messageModelList.get(i).getId()) || (removedMsg = this.messageModelList.remove(0)).getMessageType() != LPConstants.MessageType.Image) continue;
            this.imageMessageModelList.remove(removedMsg);
        }
    }

    public void unSubscribe() {
        this.compositeDisposable.clear();
        this.isDestroy = true;
    }

    public void destroy() {
        this.unSubscribe();
        this.listener = null;
        this.router = null;
        if (this.imageMessageUploadingQueue != null) {
            this.imageMessageUploadingQueue.clear();
        }
        this.imageMessageUploadingQueue = null;
        this.messageModelList.clear();
        this.imageMessageModelList.clear();
        this.mOnChatFilterListener = null;
    }

    void setOnChatFilterListener(OnChatFilterListener listener) {
        this.mOnChatFilterListener = listener;
    }

    List<String> getChatImageUrls() {
        ArrayList<String> imageList = new ArrayList<String>();
        for (IMessageModel messageModel : this.imageMessageModelList) {
            imageList.add(messageModel.getUrl());
        }
        return imageList;
    }

    int getIndexOfChatImage(String url) {
        int index = 0;
        for (IMessageModel messageModel : this.imageMessageModelList) {
            if (url.equals(messageModel.getUrl())) break;
            ++index;
        }
        return index;
    }

    @Override
    public Map<String, String> getExpressions() {
        return this.expressions;
    }

    @Override
    public int getRecallStatus(IMessageModel message) {
        if (this.router.getLiveRoom().getCurrentUser().getNumber().equals(message.getFrom().getNumber())) {
            return 1;
        }
        if (this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant || this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
            return 2;
        }
        return 0;
    }

    @Override
    public void getQuickReplyList() {
        this.compositeDisposable.add(this.router.getLiveRoom().getChatVM().getObservableOfChatQuickReplyList().observeOn(AndroidSchedulers.mainThread()).subscribe(result -> this.listener.notifyQuickReplyList((List<String>)result), throwable -> {}));
    }

    @Override
    public void reCallMessage(IMessageModel message) {
        this.router.getLiveRoom().getChatVM().requestMsgRevoke(message.getId(), message.getFrom().getUserId());
    }
}

