/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.base;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.groupclassui.base.BaseViewHolder;
import java.util.List;

public abstract class BaseRecyclerAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder> {
    protected Context mContext;
    private RecyclerView recyclerView;
    private SparseArray<OnItemClickListener> mOnItemClickListeners;
    private SparseArray<OnItemLongClickListener> mOnItemLongClickListeners;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private List<T> mList;
    private int mResId;

    public BaseRecyclerAdapter(Context context, List<T> list, @LayoutRes int resId) {
        this.mContext = context;
        this.mList = list;
        this.mResId = resId;
        this.mOnItemClickListeners = new SparseArray();
        this.mOnItemLongClickListeners = new SparseArray();
    }

    public BaseRecyclerAdapter(Context context, @LayoutRes int resId) {
        this(context, null, resId);
    }

    public int getItemCount() {
        return this.mList != null ? this.mList.size() : 0;
    }

    @NonNull
    public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(this.mResId, parent, false);
        return new BaseViewHolder(this.mContext, view);
    }

    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position) {
        this.convert(holder, this.mList.get(position));
    }

    protected abstract void convert(BaseViewHolder var1, T var2);

    public void bindToRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        recyclerView.setAdapter((RecyclerView.Adapter)this);
    }

    protected abstract boolean isEnableListener();

    public void setData(List<T> list) {
        if (this.mList != null) {
            this.mList.clear();
        }
        this.mList = list;
        this.notifyDataSetChanged();
    }

    public List<T> getData() {
        return this.mList;
    }

    public void addData(T t) {
        if (this.mList == null || t == null) {
            return;
        }
        this.mList.add(t);
        this.notifyItemInserted(this.mList.size() - 1);
    }

    public void addData(List<T> list) {
        if (this.mList == null || list == null) {
            return;
        }
        this.mList.addAll(list);
        this.notifyItemRangeChanged(this.mList.size() - list.size(), list.size());
    }

    public void removeData(int position) {
        if (null == this.mList) {
            return;
        }
        if (this.mList.size() == 0 || position >= this.mList.size()) {
            return;
        }
        this.mList.remove(position);
        this.notifyItemRemoved(position);
    }

    public void removeData(T t) {
        if (null == this.mList) {
            return;
        }
        int position = this.mList.indexOf(t);
        if (position == -1) {
            return;
        }
        this.mList.remove(position);
        this.notifyDataSetChanged();
    }

    public void removeData(List<T> list) {
        if (null == this.mList) {
            return;
        }
        if (!this.mList.containsAll(list)) {
            return;
        }
        this.mList.removeAll(list);
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
    }

    public static interface OnItemTouchListener {
        public void onItmTouch(int var1, int var2);
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(View var1, int var2);
    }

    public static interface OnItemClickListener {
        public void onItemCLick(View var1, int var2);
    }

    public static interface OnChildClickListener {
        public void onClick(View var1, int var2);
    }
}

