/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.network;

import com.baijiayun.livebase.models.LPDataModel;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.network.webscoket.IBJNetworkClient;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.ConcurrentHashMap;

public class BJYWSServer {
    protected static final String LP_WS_KEY_MESSAGE_TYPE = "message_type";
    protected ConcurrentHashMap<String, ResponseListener> responseListeners = new ConcurrentHashMap();
    protected Gson gson;

    protected void onMessage(IBJNetworkClient bjWebSocketClient, JsonObject jsonObject) {
        LPDataModel model;
        String key = jsonObject.get(LP_WS_KEY_MESSAGE_TYPE).getAsString();
        ResponseListener responseListener = this.responseListeners.get(key);
        if (responseListener == null) {
            return;
        }
        Class clazz = responseListener.clazz;
        if (clazz == null) {
            return;
        }
        if (LPJsonModel.class.equals((Object)clazz)) {
            LPJsonModel jsonModel = new LPJsonModel();
            jsonModel.data = jsonObject;
            model = jsonModel;
        } else {
            model = (LPDataModel)this.gson.fromJson((JsonElement)jsonObject, clazz);
        }
        OnResponseModelListener lis = responseListener.listener;
        if (lis != null) {
            lis.onResponseModel(model);
        }
    }

    public <T> void registerResponseListenerAndModel(Class<T> clazz, OnResponseModelListener<T> lis, String responseKey) {
        ResponseListener responseListener = new ResponseListener();
        responseListener.responseKey = responseKey;
        responseListener.clazz = clazz;
        responseListener.listener = lis;
        this.responseListeners.put(responseKey, responseListener);
    }

    public <T> void unregisterResponseListener(String responseKey) {
        this.responseListeners.remove(responseKey);
    }

    public static class ResponseListener {
        public String responseKey;
        public Class clazz;
        public OnResponseModelListener listener;
    }

    public static interface OnResponseModelListener<T> {
        public void onResponseModel(T var1);

        public void onError(Exception var1);
    }
}

