/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import com.baijiayun.livebase.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0015J0\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0014J\u0010\u0010\u001f\u001a\u00020\u00142\b\b\u0001\u0010 \u001a\u00020\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/baijiayun/livebase/widgets/view/RoundImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "height", "", "mPaint", "Landroid/graphics/Paint;", "oval", "Landroid/graphics/RectF;", "ratio", "width", "init", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "", "left", "top", "right", "bottom", "setCircleBackgroundColor", "color", "livebase_release"})
public final class RoundImageView
extends AppCompatImageView {
    private final float ratio;
    private float width;
    private float height;
    private Paint mPaint;
    private RectF oval;

    public RoundImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.ratio = 1.0f;
    }

    public RoundImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
        this.init(context, null);
    }

    public RoundImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
        this.init(context, attrs);
    }

    public final void setCircleBackgroundColor(@ColorInt int color2) {
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint = null;
        }
        paint.setColor(color2);
    }

    @SuppressLint(value={"CustomViewStyleable"})
    private final void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RoundImageView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026styleable.RoundImageView)");
        TypedArray typedArray2 = typedArray;
        int color2 = typedArray2.getResourceId(R.styleable.RoundImageView_circle_background, 0);
        typedArray2.recycle();
        this.mPaint = new Paint();
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint = null;
        }
        paint.setStyle(Paint.Style.FILL);
        Paint paint2 = this.mPaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint2 = null;
        }
        paint2.setAntiAlias(true);
        Paint paint3 = this.mPaint;
        if (paint3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint3 = null;
        }
        paint3.setStrokeWidth(4.0f);
        Paint paint4 = this.mPaint;
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint4 = null;
        }
        paint4.setColor(color2 == 0 ? -1 : ContextCompat.getColor((Context)context, (int)color2));
        this.oval = new RectF();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.width = this.getMeasuredWidth();
        this.height = this.getMeasuredWidth();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(@NotNull Canvas canvas) {
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float x = this.getWidth();
        float y = this.getHeight();
        float radius = y / (float)2;
        RectF rectF = this.oval;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oval");
            rectF = null;
        }
        rectF.set(x / (float)2 - radius, y / (float)2 - radius, x / (float)2 + radius, y / (float)2 + radius);
        RectF rectF2 = this.oval;
        if (rectF2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"oval");
            rectF2 = null;
        }
        if ((paint = this.mPaint) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint = null;
        }
        canvas.drawArc(rectF2, -90.0f, 360.0f * this.ratio, false, paint);
        super.onDraw(canvas);
    }
}

