/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.dialog.preview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.StyleRes;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.widgets.dialog.preview.PreviewViewpager;
import com.baijiayun.livebase.widgets.view.FullWidthImageView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0003)*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0014J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0014J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\u001a\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0014J\u0016\u0010&\u001a\u00020\u001a2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0(H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/baijiayun/livebase/widgets/dialog/preview/PictureWatcherFragment;", "Lcom/baijiayun/livebase/base/BaseDialogFragment;", "()V", "defaultBackground", "Landroid/graphics/drawable/Drawable;", "getDefaultBackground", "()Landroid/graphics/drawable/Drawable;", "setDefaultBackground", "(Landroid/graphics/drawable/Drawable;)V", "isShowPage", "", "pictureUrls", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "position", "", "viewPager", "Lcom/baijiayun/livebase/widgets/dialog/preview/PreviewViewpager;", "getViewPager", "()Lcom/baijiayun/livebase/widgets/dialog/preview/PreviewViewpager;", "setViewPager", "(Lcom/baijiayun/livebase/widgets/dialog/preview/PreviewViewpager;)V", "whiteboardUrl", "getLayoutId", "init", "", "savedInstanceState", "Landroid/os/Bundle;", "arguments", "view", "Landroid/view/View;", "onCreate", "onDestroy", "onViewCreated", "setWindowParams", "windowParams", "Landroid/view/WindowManager$LayoutParams;", "updateWhiteboardBg", "weakReference", "Ljava/lang/ref/WeakReference;", "Companion", "PicturePagerAdapter", "ViewHolder", "livebase_release"})
public final class PictureWatcherFragment
extends BaseDialogFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<String> pictureUrls = new ArrayList();
    private int position;
    private boolean isShowPage;
    @Nullable
    private String whiteboardUrl = "";
    @Nullable
    private PreviewViewpager viewPager;
    @Nullable
    private Drawable defaultBackground;
    @NotNull
    private static final String URLS = "urls";
    @NotNull
    private static final String POSITION = "position";
    @NotNull
    private static final String IS_SHOW_PAGE = "is_show_page";
    @NotNull
    private static final String WHITEBOARD_URL = "whiteboard_url";
    @NotNull
    private static final String STYLE_RES = "style_res";

    @Nullable
    public final PreviewViewpager getViewPager() {
        return this.viewPager;
    }

    public final void setViewPager(@Nullable PreviewViewpager previewViewpager) {
        this.viewPager = previewViewpager;
    }

    @Nullable
    public final Drawable getDefaultBackground() {
        return this.defaultBackground;
    }

    public final void setDefaultBackground(@Nullable Drawable drawable2) {
        this.defaultBackground = drawable2;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        int style2 = bundle != null ? bundle.getInt(STYLE_RES, R.style.DialogTheme) : R.style.DialogTheme;
        this.setStyle(1, style2);
        this.setCancelable(false);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.layout_picture_watcher;
    }

    @Override
    protected void init(@Nullable Bundle savedInstanceState, @Nullable Bundle arguments) {
        this.hideTitleBar();
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.init(view);
    }

    public final void init(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            Bundle $this$init_u24lambda_u240 = bundle;
            boolean bl = false;
            ArrayList list = $this$init_u24lambda_u240.getStringArrayList(URLS);
            if (list != null) {
                this.pictureUrls.addAll(list);
            }
            this.position = $this$init_u24lambda_u240.getInt(POSITION);
            this.isShowPage = $this$init_u24lambda_u240.getBoolean(IS_SHOW_PAGE);
            this.whiteboardUrl = $this$init_u24lambda_u240.getString(WHITEBOARD_URL, "");
        }
        if (this.defaultBackground == null) {
            CharSequence charSequence = this.whiteboardUrl;
            if (charSequence == null || charSequence.length() == 0) {
                this.contentBackgroundColor(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.base_transparent));
            } else {
                this.updateWhiteboardBg(new WeakReference<View>(view));
            }
        } else {
            view.setBackground(this.defaultBackground);
        }
        TextView tvPage = (TextView)view.findViewById(R.id.tv_page);
        ImageView ivClose = (ImageView)view.findViewById(R.id.iv_close);
        PreviewViewpager previewViewpager = this.viewPager = (PreviewViewpager)view.findViewById(R.id.picture_view_page);
        if (previewViewpager != null) {
            previewViewpager.setAdapter(new PicturePagerAdapter((List<String>)this.pictureUrls));
        }
        if (this.isShowPage) {
            ivClose.setVisibility(0);
            ivClose.setOnClickListener(arg_0 -> PictureWatcherFragment.init$lambda$1(this, arg_0));
            tvPage.setVisibility(0);
            tvPage.setText((CharSequence)("" + (this.position + 1) + '/' + this.pictureUrls.size()));
            PreviewViewpager previewViewpager2 = this.viewPager;
            if (previewViewpager2 != null) {
                previewViewpager2.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(tvPage, this){
                    final /* synthetic */ TextView $tvPage;
                    final /* synthetic */ PictureWatcherFragment this$0;
                    {
                        this.$tvPage = $tvPage;
                        this.this$0 = $receiver;
                    }

                    public void onPageSelected(int position) {
                        this.$tvPage.setText((CharSequence)("" + (position + 1) + '/' + PictureWatcherFragment.access$getPictureUrls$p(this.this$0).size()));
                    }
                });
            }
        } else {
            tvPage.setVisibility(8);
            ivClose.setVisibility(8);
        }
        PreviewViewpager previewViewpager3 = this.viewPager;
        if (previewViewpager3 != null) {
            previewViewpager3.setCurrentItem(this.position);
        }
    }

    @Override
    protected void setWindowParams(@NotNull WindowManager.LayoutParams windowParams) {
        Intrinsics.checkNotNullParameter((Object)windowParams, (String)"windowParams");
        WindowManager.LayoutParams it = windowParams;
        boolean bl = false;
        it.width = -1;
        it.height = -1;
        it.dimAmount = 0.85f;
        it.windowAnimations = R.style.BJYViewBigPicAnim;
    }

    private final void updateWhiteboardBg(WeakReference<View> weakReference) {
        Glide.with((Context)this.requireContext()).asBitmap().load(this.whiteboardUrl).into((Target)new SimpleTarget<Bitmap>(this, weakReference){
            final /* synthetic */ PictureWatcherFragment this$0;
            final /* synthetic */ WeakReference<View> $weakReference;
            {
                this.this$0 = $receiver;
                this.$weakReference = $weakReference;
            }

            public void onResourceReady(@NotNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                this.this$0.setDefaultBackground((Drawable)new BitmapDrawable(this.this$0.requireContext().getResources(), resource));
                View view = (View)this.$weakReference.get();
                if (view != null) {
                    view.setBackground(this.this$0.getDefaultBackground());
                }
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                if (errorDrawable == null) {
                    PictureWatcherFragment.access$showToast(this.this$0, PictureWatcherFragment.access$getWhiteboardUrl$p(this.this$0));
                }
            }
        });
    }

    @Override
    public void onDestroy() {
        PreviewViewpager previewViewpager = this.viewPager;
        if (previewViewpager != null) {
            previewViewpager.clearOnPageChangeListeners();
        }
        super.onDestroy();
    }

    private static final void init$lambda$1(PictureWatcherFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismissAllowingStateLoss();
    }

    public static final /* synthetic */ ArrayList access$getPictureUrls$p(PictureWatcherFragment $this) {
        return $this.pictureUrls;
    }

    public static final /* synthetic */ void access$showToast(PictureWatcherFragment $this, String msg) {
        $this.showToast(msg);
    }

    public static final /* synthetic */ String access$getWhiteboardUrl$p(PictureWatcherFragment $this) {
        return $this.whiteboardUrl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\b\u0003\u0010\u0012\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/baijiayun/livebase/widgets/dialog/preview/PictureWatcherFragment$Companion;", "", "()V", "IS_SHOW_PAGE", "", "POSITION", "STYLE_RES", "URLS", "WHITEBOARD_URL", "newInstance", "Lcom/baijiayun/livebase/widgets/dialog/preview/PictureWatcherFragment;", "pictureUrls", "", "position", "", "isShowPage", "", "whiteboardUrl", "styleRes", "livebase_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PictureWatcherFragment newInstance(@NotNull List<String> pictureUrls, int position, boolean isShowPage, @Nullable String whiteboardUrl, @StyleRes int styleRes) {
            Intrinsics.checkNotNullParameter(pictureUrls, (String)"pictureUrls");
            Bundle args = new Bundle();
            PictureWatcherFragment fragment = new PictureWatcherFragment();
            args.putStringArrayList(PictureWatcherFragment.URLS, new ArrayList(pictureUrls));
            args.putInt(PictureWatcherFragment.POSITION, position);
            args.putBoolean(PictureWatcherFragment.IS_SHOW_PAGE, isShowPage);
            args.putString(PictureWatcherFragment.WHITEBOARD_URL, whiteboardUrl);
            args.putInt(PictureWatcherFragment.STYLE_RES, styleRes);
            fragment.setArguments(args);
            return fragment;
        }

        public static /* synthetic */ PictureWatcherFragment newInstance$default(Companion companion, List list, int n, boolean bl, String string2, int n2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                string2 = null;
            }
            if ((n3 & 0x10) != 0) {
                n2 = R.style.DialogTheme;
            }
            return companion.newInstance(list, n, bl, string2, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/baijiayun/livebase/widgets/dialog/preview/PictureWatcherFragment$PicturePagerAdapter;", "Landroidx/viewpager/widget/PagerAdapter;", "urls", "", "", "(Lcom/baijiayun/livebase/widgets/dialog/preview/PictureWatcherFragment;Ljava/util/List;)V", "destroyItem", "", "container", "Landroid/view/ViewGroup;", "position", "", "object", "", "getCount", "instantiateItem", "isViewFromObject", "", "view", "Landroid/view/View;", "livebase_release"})
    public final class PicturePagerAdapter
    extends PagerAdapter {
        @NotNull
        private final List<String> urls;

        public PicturePagerAdapter(List<String> urls) {
            Intrinsics.checkNotNullParameter(urls, (String)PictureWatcherFragment.URLS);
            this.urls = urls;
        }

        public int getCount() {
            return this.urls.size();
        }

        public boolean isViewFromObject(@NotNull View view, @NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            return Intrinsics.areEqual((Object)view, (Object)((ViewHolder)object).getRootView());
        }

        @NotNull
        public Object instantiateItem(@NotNull ViewGroup container, int position) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Context context = PictureWatcherFragment.this.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            Context context2 = context;
            View view = LayoutInflater.from((Context)context2).inflate(R.layout.item_picture_watcher, container, false);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            ViewHolder viewHolder = new ViewHolder(view);
            Glide.with((Context)context2).load(AliCloudImageUtil.getScaledUrl(this.urls.get(position), "m_mfit", DisplayUtils.getScreenWidthPixels((Context)context2), DisplayUtils.getScreenHeightPixels((Context)context2))).into((ImageView)viewHolder.getPhotoView());
            viewHolder.getPhotoView().setOnClickListener(arg_0 -> PicturePagerAdapter.instantiateItem$lambda$0(PictureWatcherFragment.this, arg_0));
            container.addView(viewHolder.getRootView());
            return viewHolder;
        }

        public void destroyItem(@NotNull ViewGroup container, int position, @NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            ViewHolder viewHolder = (ViewHolder)object;
            Glide.with((Context)PictureWatcherFragment.this.requireContext()).clear((View)viewHolder.getPhotoView());
            container.removeView(viewHolder.getRootView());
        }

        private static final void instantiateItem$lambda$0(PictureWatcherFragment this$0, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (this$0.getFragmentManager() != null) {
                this$0.dismissAllowingStateLoss();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/baijiayun/livebase/widgets/dialog/preview/PictureWatcherFragment$ViewHolder;", "", "rootView", "Landroid/view/View;", "(Landroid/view/View;)V", "photoView", "Lcom/baijiayun/livebase/widgets/view/FullWidthImageView;", "getPhotoView", "()Lcom/baijiayun/livebase/widgets/view/FullWidthImageView;", "getRootView", "()Landroid/view/View;", "livebase_release"})
    public static final class ViewHolder {
        @NotNull
        private final View rootView;
        @NotNull
        private final FullWidthImageView photoView;

        public ViewHolder(@NotNull View rootView) {
            Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
            this.rootView = rootView;
            View view = this.rootView.findViewById(R.id.item_photo_view);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView.findViewById(R.id.item_photo_view)");
            this.photoView = (FullWidthImageView)view;
        }

        @NotNull
        public final View getRootView() {
            return this.rootView;
        }

        @NotNull
        public final FullWidthImageView getPhotoView() {
            return this.photoView;
        }
    }
}

