/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.dialog.custom_webpage;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.ProgressBar;
import androidx.appcompat.app.AlertDialog;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.view.webview.BJWebViewImpl;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;

public class BaseWebViewDialogFragment
extends BaseDialogFragment {
    private boolean isDestroyed = false;
    private static final String WINDOW_NAME = "bjlapp";
    protected BJWebViewImpl mWebView;
    private AlertDialog dialog;

    @Override
    protected int getLayoutId() {
        return R.layout.bjy_base_fragment_webpage;
    }

    @Override
    protected void init(Bundle savedInstanceState, Bundle arguments) {
        if (this.getArguments() != null) {
            this.initWebClient();
            this.loadUrl(this.getArguments().getString("url"));
        }
        this.setCancelable(false);
    }

    public void setCloseBtnStatus(boolean show) {
        if (show) {
            if (this.isQueryPlusNull()) {
                return;
            }
            this.editable(true);
            this.editText(this.getString(R.string.live_quiz_close));
            this.editClick(v -> this.showCloseDlg());
        } else {
            this.editable(false);
        }
    }

    private void showCloseDlg() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        this.dialog = builder.setMessage(R.string.live_quiz_dialog_tip).setPositiveButton(R.string.live_quiz_dialog_confirm, (dialog12, which) -> {
            dialog12.dismiss();
            this.closeDialogFragment();
        }).setNegativeButton(R.string.live_quiz_dialog_cancel, (dialog1, which) -> dialog1.dismiss()).create();
        this.dialog.show();
        this.dialog.getButton(-1).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.getContext(), R.attr.base_theme_live_product_color));
        this.dialog.getButton(-2).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.getContext(), R.attr.base_theme_live_product_color));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebClient() {
        this.mWebView = (BJWebViewImpl)this.$.id(R.id.base_webview).view();
        this.mWebView.enableJavaScript((Object)this, WINDOW_NAME);
        this.mWebView.enableCache();
        this.setCloseBtnStatus(true);
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                ((ProgressBar)BaseWebViewDialogFragment.this.$.id(R.id.pb_web_view_quiz).view()).setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }

            public void onReceivedTitle(WebView webView, String s) {
                super.onReceivedTitle(webView, s);
                BaseWebViewDialogFragment.this.title(s);
            }
        });
        this.mWebView.setWebViewClient(new BJWebViewImpl.BJWebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                BaseWebViewDialogFragment.this.$.id(R.id.pb_web_view_quiz).visible();
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (BaseWebViewDialogFragment.this.isDestroyed) {
                    return;
                }
                BaseWebViewDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                if (error.getErrorCode() != -11) {
                    BaseWebViewDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                if (errorCode != -11) {
                    BaseWebViewDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
                }
            }
        });
    }

    public void loadUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            WebView webView = (WebView)this.$.id(R.id.base_webview).view();
            webView.loadUrl(url);
        }
    }

    @Override
    public void onDestroy() {
        this.mWebView.destroy();
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
        super.onDestroy();
        this.isDestroyed = true;
    }

    protected void closeDialogFragment() {
    }
}

