/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.context;

import androidx.annotation.NonNull;
import com.baijiayun.livebase.context.LPException;
import com.baijiayun.network.HttpException;
import com.google.gson.JsonObject;

public class LPError
extends Throwable {
    public static final int CODE_ERROR_NETWORK_FAILURE = -1001;
    public static final int CODE_ERROR_NETWORK_MOBILE = -1002;
    public static final int CODE_ERROR_HTTP = -1004;
    public static final int CODE_ERROR_INVALID_PARAMS = -1006;
    public static final int CODE_ERROR_ROOMSERVER_FAILED = -1007;
    public static final int CODE_ERROR_OPEN_AUDIO_RECORD_FAILED = -1008;
    public static final int CODE_ERROR_OPEN_AUDIO_CAMERA_FAILED = -1009;
    public static final int CODE_ERROR_MAX_STUDENT = -1010;
    public static final int CODE_ERROR_ROOMSERVER_LOSE_CONNECTION = -1011;
    public static final int CODE_ERROR_LOGIN_CONFLICT = -1013;
    public static final int CODE_ERROR_PERMISSION_DENY = -1014;
    public static final int CODE_ERROR_STATUS_ERROR = -1015;
    public static final int CODE_ERROR_MEDIA_PLAY_FAILED = -1016;
    public static final int CODE_ERROR_MESSAGE_SEND_FORBID = -1017;
    public static final int CODE_ERROR_LOGIN_KICK_OUT = -1018;
    public static final int CODE_ERROR_FORBID_RAISE_HAND = -1019;
    public static final int CODE_ERROR_INVALID_SIGNAL_KEY = -1020;
    public static final int CODE_ERROR_INVALID_SIGNAL_VALUE = -1021;
    public static final int CODE_ERROR_SIGNAL_FREQUENCY_TOO_HIGH = -1022;
    public static final int CODE_ERROR_INVALID_USER_ROLE = -1023;
    public static final int CODE_ERROR_INVALID_ARGUMENT = -1024;
    public static final int CODE_WARNING_PLAYER_LAG = -1025;
    public static final int CODE_WARNING_PLAYER_MEDIA_SUBSCRIBE_TIME_OUT = -1026;
    public static final int CODE_ERROR_QUESTION_SEND_FORBID = -1028;
    public static final int CODE_ERROR_OUTOF_VIDEO_RESOLUTION_LOW = -1029;
    public static final int CODE_ERROR_OUTOF_VIDEO_RESOLUTION_HIGH = -1030;
    public static final int CODE_ERROR_LOGIN_UNIQUE_CONFLICT = -1031;
    public static final int CODE_ERROR_LOGIN_AUDITION = -1032;
    public static final int CODE_ERROR_HOST_UNKNOW = -1033;
    public static final int CODE_ERROR_MASTERSERVER_LOSE_CONNECTION = -1034;
    public static final int CODE_ERROR_NO_CAMERA_PERMISSION = -1035;
    public static final int CODE_ERROR_EXCEED_MAX_STREAM_NUMBER = -1036;
    public static final int CODE_ERROR_CLASS_EXPIRED = -1037;
    public static final int CODE_ERROR_CLASS_NOT_STARTED = -1038;
    public static final int CODE_ERROR_STUDENT_BACKSTAGE = -1039;
    public static final int CODE_ERROR_STUDENT_UNAVAILABLE = -1040;
    public static final int CODE_ERROR_STUDENT_OCCUPIED = -1041;
    public static final int CODE_ERROR_SCREEN_SHARE = -1042;
    public static final int CODE_ERROR_CAMERA_SHARE = -1043;
    public static final int CODE_ERROR_LOGOUT_CLASS_ROOM_CLOSE = -1044;
    public static final int CODE_ERROR_LOGOUT_PRESENTER_LEAVE = -1045;
    public static final int CODE_ERROR_RED_PACKET_LOW_SENSITIVITY = -1046;
    public static final int CODE_ERROR_LOGIN_KICK_OUT_WITHOUT_BLOCK = -1047;
    public static final int CODE_ERROR_FILE_LOAD_NO_MORE = -1048;
    public static final int CODE_ERROR_CLASS_END_KICK_OUT_TIPS = -1049;
    public static final int CODE_ERROR_KICK_OUT_WITH_API = -1050;
    public static final int CODE_ERROR_RESOLUTION_CHANGE_WITH_SCREEN_SHARING = -1051;
    public static final int CODE_ERROR_DEVICE_NOT_SUPPORTED = -2000;
    public static final int CODE_ERROR_WEBRTC_TYPE_NOT_SUPPORT = -2001;
    public static final int CODE_ERROR_ENTER_ROOM_FORBIDDEN = -2002;
    public static final int CODE_ERROR_NEW_SMALL_COURSE = -2003;
    public static final int CODE_ERROR_ADD_WHITE_BOARD = -2004;
    public static final int CODE_ERROR_DELETE_WHITE_BOARD = -2005;
    public static final int CODE_ERROR_NOT_SUPPORT_MULTI_WHITE_BOARD = -2006;
    public static final int CODE_ERROR_ANIMPPT_LOAD_TIMEOUT = -2007;
    public static final int CODE_UPLOAD_IJK_LOG_FAIL = -2008;
    public static final int CODE_ERROR_DOWNLOAD_FILE = -2009;
    public static final int CODE_ERROR_DOWNLOAD_EXPIRED = -2010;
    public static final int IJK_UNKNOWN_ERROR = -10000;
    public static final int IJK_LOOP_PLAY_RESTART_ERROR = -10001;
    public static final int IJK_HTTP_LOAD_ERROR = -10002;
    public static final int IJK_LOCAL_UNKNOWN_ERROR = -10003;
    public static final int IJK_PREPARE_ERROR = 10080;
    public static final int IJK_OPEN_VIDEO_ERROR = 10081;
    private int code;
    public String message;
    private String auditionEndLink;
    private Throwable exception;
    private JsonObject params;

    public LPError(int code) {
        this.code = code;
        this.message = "";
    }

    public LPError(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public LPError(int code, Throwable e) {
        this.code = code;
        this.exception = e;
        this.message = e.getMessage();
    }

    public LPError(int code, String message, String auditionEndLink) {
        this.code = code;
        this.message = message;
        this.auditionEndLink = auditionEndLink;
    }

    public static LPError getNewError(int code) {
        return new LPError(code);
    }

    public static LPError getNewError(int code, String message) {
        return new LPError(code, message);
    }

    public static LPError getNewError(Throwable e) {
        if (e instanceof LPException) {
            LPException exception = (LPException)e;
            LPError error = new LPError(exception.getErrorCode(), exception.getMessage());
            error.setException(e);
            return error;
        }
        if (e instanceof HttpException) {
            HttpException exception = (HttpException)e;
            LPError error = new LPError(exception.getCode(), exception.getMessage());
            error.setException(e);
            return error;
        }
        return new LPError(-1004, e);
    }

    public static LPError getNewError(int code, Throwable e) {
        return new LPError(code, e);
    }

    public static LPError getNewError(int code, String message, String auditionEndLink) {
        return new LPError(code, message, auditionEndLink);
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setAuditionEndLink(String auditionEndLink) {
        this.auditionEndLink = auditionEndLink;
    }

    public String getAuditionEndLink() {
        return this.auditionEndLink;
    }

    public JsonObject getParams() {
        return this.params;
    }

    public void setParams(JsonObject params) {
        this.params = params;
    }

    public boolean shouldRetry() {
        return this.code > -256;
    }

    @Override
    @NonNull
    public String toString() {
        return "LPError{code=" + this.code + ", message='" + this.message + '\'' + ", exception=" + this.exception + ", params=" + this.params + '}';
    }
}

