/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.enums.ResStateType;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.utils.ThemeDataUtil;

public class StateTextView
extends AppCompatTextView {
    private int stateTextColor;
    private int unStateTextColor;
    private ResStateType stateType;
    private int bgType;
    private Context context;

    public StateTextView(Context context) {
        this(context, null);
    }

    public StateTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StateTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BJYStateTextView);
        this.stateTextColor = typedArray.getResourceId(R.styleable.BJYStateTextView_bjlive_stateTextColor, 0);
        this.unStateTextColor = typedArray.getResourceId(R.styleable.BJYStateTextView_bjlive_unStateTextColor, 0);
        this.stateType = ResStateType.valueOf((int)typedArray.getInt(R.styleable.BJYStateTextView_bjlive_stateType, 0));
        this.bgType = typedArray.getInt(R.styleable.BJYStateTextView_bjlive_bgType, 0);
        typedArray.recycle();
        this.notifyView();
    }

    public void notifyView() {
        if (this.stateType == null) {
            if (this.stateTextColor != 0) {
                this.setTextColor(ThemeDataUtil.getColorFromThemConfigByColorId(this.getContext(), this.stateTextColor));
            }
            if (this.unStateTextColor != 0) {
                this.setTextColor(ThemeDataUtil.getColorFromThemConfigByColorId(this.getContext(), this.unStateTextColor));
            }
        } else {
            this.setTextColor(DisplayUtils.getColorStateList((int)ThemeDataUtil.getColorFromThemConfigByColorId(this.getContext(), this.stateTextColor), (int)ThemeDataUtil.getColorFromThemConfigByColorId(this.getContext(), this.unStateTextColor), (ResStateType)this.stateType));
        }
        if (this.bgType == 1) {
            this.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_live_product_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_dialog_positive_text_color));
        } else if (this.bgType == 2) {
            this.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_dialog_negative_text_color));
        } else if (this.bgType == 3) {
            Drawable selecteDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_live_product_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
            Drawable drawable2 = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
            this.setBackground((Drawable)new StateListDrawableBuilder().normal(drawable2).selected(selecteDrawable).build());
        } else if (this.bgType == 4) {
            Drawable drawable3 = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_live_product_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
            Drawable disableDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId(this.context, R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
            this.setBackground((Drawable)new StateListDrawableBuilder().normal(drawable3).disabled(disableDrawable).build());
        }
    }

    public int getStateTextColor() {
        return this.stateTextColor;
    }

    public StateTextView setStateTextColor(int stateTextColor) {
        this.stateTextColor = stateTextColor;
        return this;
    }

    public int getUnStateTextColor() {
        return this.unStateTextColor;
    }

    public StateTextView setUnStateTextColor(int unStateTextColor) {
        this.unStateTextColor = unStateTextColor;
        return this;
    }

    public ResStateType getStateType() {
        return this.stateType;
    }

    public StateTextView setStateType(ResStateType stateType) {
        this.stateType = stateType;
        return this;
    }
}

