/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LPKVOSubject<T> {
    T parameter;
    private ConcurrentLinkedQueue<OnParameterChangedListener<T>> mParameterChangedListeners;

    public LPKVOSubject() {
        this(null);
    }

    public LPKVOSubject(T parameter) {
        this.parameter = parameter;
    }

    public void setParameter(T parameter) {
        this.parameter = parameter;
        this.notifyParameterChanged();
    }

    public void setParameterWithoutNotify(T parameter) {
        this.parameter = parameter;
    }

    public T getParameter() {
        return this.parameter;
    }

    public Flowable<T> newObservableOfParameterChanged() {
        return Flowable.create(new LPKVOFlowableOnSubscribe(this), (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    void notifyParameterChanged() {
        if (this.mParameterChangedListeners != null && this.mParameterChangedListeners.size() > 0) {
            Flowable.fromIterable(this.mParameterChangedListeners).subscribe(listener -> listener.onParameterChanged(this.getParameter()));
        }
    }

    protected void registerParameterChangedListener(OnParameterChangedListener<T> listener) {
        if (this.mParameterChangedListeners == null) {
            this.mParameterChangedListeners = new ConcurrentLinkedQueue();
        }
        if (listener != null) {
            this.mParameterChangedListeners.add(listener);
        }
    }

    protected void unregisterParameterChangedListener(OnParameterChangedListener<T> listener) {
        if (this.mParameterChangedListeners != null) {
            this.mParameterChangedListeners.remove(listener);
        }
    }

    protected static class LPKVOFlowableOnSubscribe<T>
    implements FlowableOnSubscribe<T> {
        WeakReference<LPKVOSubject<T>> mParameter;

        LPKVOFlowableOnSubscribe(LPKVOSubject<T> mParameter) {
            assert (mParameter != null);
            this.mParameter = new WeakReference<LPKVOSubject<LPKVOSubject<T>>>(mParameter);
        }

        public void subscribe(FlowableEmitter<T> flowableEmitter) {
            LPKVOSubject parameter = (LPKVOSubject)this.mParameter.get();
            if (parameter == null) {
                return;
            }
            OnParameterChangedListener<Object> listener = arg_0 -> flowableEmitter.onNext(arg_0);
            parameter.registerParameterChangedListener(listener);
            flowableEmitter.setCancellable(() -> {
                if (this.mParameter == null) {
                    return;
                }
                LPKVOSubject param = (LPKVOSubject)this.mParameter.get();
                if (param == null) {
                    return;
                }
                param.unregisterParameterChangedListener(listener);
            });
        }
    }

    protected static interface OnParameterChangedListener<T> {
        public void onParameterChanged(T var1);
    }
}

