/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.FileObserver;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.provider.MediaStore;
import android.util.Log;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ScreenRecordDetector {
    private static final String TAG = "ScreenRecordDetector";
    private static final long EVENT_FILTER_THRESHOLD = 3000L;
    private static final long SCAN_TIME_RANGE = 30000L;
    private static final long QUERY_TIME_RANGE = 60000L;
    private static final long MIN_RECORD_SIZE = 10240L;
    private static final long MIN_TEMP_RECORD_SIZE = 1024L;
    private static final long TEMP_FILE_CHECK_DELAY = 500L;
    private static final long FINAL_FILE_CHECK_DELAY = 500L;
    private static final long NEW_RECORD_THRESHOLD = 5000L;
    private static final String[] RECORD_FILE_KEYWORDS = new String[]{"record", "screen", "capture", "\u5f55\u5c4f", "\u5f55\u5236"};
    private static final String[] COMMON_RECORD_DIRS = new String[]{Environment.getExternalStorageDirectory() + "/Movies/ScreenRecords/", Environment.getExternalStorageDirectory() + "/DCIM/\u5f55\u5c4f/", Environment.getExternalStorageDirectory() + "/\u5f55\u5c4f/", Environment.getExternalStorageDirectory() + "/Videos/\u5c4f\u5e55\u5f55\u5236/", Environment.getExternalStorageDirectory() + "/Videos/ScreenRecordings/", Environment.getExternalStorageDirectory() + "/Pictures/ScreenRecords/", Environment.getExternalStorageDirectory() + "/Pictures/Screenshots/", Environment.getDataDirectory() + "/media/Movies/ScreenRecords/", Environment.getDataDirectory() + "/media/DCIM/\u5f55\u5c4f/"};
    private static final String[] TEMP_RECORD_DIRS = new String[]{Environment.getExternalStorageDirectory() + "/Android/data/com.android.screenrecorder/cache/", Environment.getExternalStorageDirectory() + "/Movies/.ScreenRecord/", Environment.getExternalStorageDirectory() + "/DCIM/.ScreenRecord/", Environment.getExternalStorageDirectory() + "/.cache/ScreenRecord/", Environment.getExternalStorageDirectory() + "/Android/data/com.miui.screenrecorder/cache/", Environment.getExternalStorageDirectory() + "/Android/data/com.huawei.screenrecorder/cache/", Environment.getExternalStorageDirectory() + "/Android/data/com.oppo.screenrecorder/cache/", Environment.getExternalStorageDirectory() + "/Android/data/com.vivo.screenrecorder/cache/", Environment.getExternalStorageDirectory() + "/Android/data/com.samsung.android.app.screenrecorder/cache/"};
    private static final String PERMISSION_READ_STORAGE = "android.permission.READ_EXTERNAL_STORAGE";
    private final Context mAppContext;
    private OnRecordStateChangeListener mStateListener;
    private final Handler mMainHandler;
    private Handler mBgHandler;
    private boolean mIsRecording = false;
    private long mLastEventTimestamp = 0L;
    private ContentObserver mVideoContentObserver;
    private List<FileObserver> mFileObservers = new ArrayList<FileObserver>();
    private long mLastRecordStopTime = 0L;

    public ScreenRecordDetector(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null!");
        }
        this.mAppContext = context.getApplicationContext();
        this.mMainHandler = new Handler(Looper.getMainLooper());
        HandlerThread bgThread = new HandlerThread("ScreenRecordDetector-Thread");
        bgThread.start();
        this.mBgHandler = new Handler(bgThread.getLooper());
        this.initVideoContentObserver();
    }

    private void initVideoContentObserver() {
        this.mVideoContentObserver = new ContentObserver(this.mBgHandler){

            public void onChange(boolean selfChange, Uri uri) {
                super.onChange(selfChange, uri);
                if (uri == null || !ScreenRecordDetector.this.isVideoUri(uri)) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - ScreenRecordDetector.this.mLastEventTimestamp < 3000L || currentTime - ScreenRecordDetector.this.mLastRecordStopTime < 5000L) {
                    Log.d((String)ScreenRecordDetector.TAG, (String)("\u8fc7\u6ee4\u91cd\u590d/\u5f55\u5c4f\u505c\u6b62\u540e\u7684\u4e8b\u4ef6\uff1auri=" + uri));
                    return;
                }
                Log.d((String)ScreenRecordDetector.TAG, (String)("MediaStore onChange: uri=" + uri + ", \u4e3b\u7ebf\u7a0b=" + (Looper.getMainLooper() == Looper.myLooper())));
                ScreenRecordDetector.this.mLastEventTimestamp = currentTime;
                ScreenRecordDetector.this.mBgHandler.postDelayed(() -> ScreenRecordDetector.this.checkIfScreenRecordFile(uri), 500L);
            }
        };
    }

    public void setOnRecordStateChangeListener(OnRecordStateChangeListener listener2) {
        this.mStateListener = listener2;
    }

    public void startDetection() {
        if (Build.VERSION.SDK_INT < 33 && !this.hasStoragePermission()) {
            Log.w((String)TAG, (String)"Android 13- \u9700\u8981 READ_EXTERNAL_STORAGE \u6743\u9650");
        }
        this.registerVideoContentObserver();
        this.mBgHandler.post(() -> {
            this.initAndStartFileObservers();
            this.scanRecentRecordFiles();
        });
        Log.d((String)TAG, (String)"\u5f55\u5c4f\u68c0\u6d4b\u5df2\u542f\u52a8");
    }

    public void stopDetection() {
        this.unregisterVideoContentObserver();
        this.stopFileObservers();
        this.mFileObservers.clear();
        this.mBgHandler.removeCallbacksAndMessages(null);
        this.mStateListener = null;
        this.resetRecordingState();
        Log.d((String)TAG, (String)"\u5f55\u5c4f\u68c0\u6d4b\u5df2\u505c\u6b62");
    }

    private void initAndStartFileObservers() {
        String[] allMonitorDirs;
        for (final String dirPath : allMonitorDirs = this.mergeDirArrays(COMMON_RECORD_DIRS, TEMP_RECORD_DIRS)) {
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileObserver observer = new FileObserver(dir.getAbsolutePath(), 386){

                public void onEvent(int event, String path) {
                    boolean isTargetFile;
                    Log.d((String)ScreenRecordDetector.TAG, (String)("FileObserver \u6355\u6349\u5230\u6587\u4ef6\u4e8b\u4ef6\uff1aevent=" + event + ", path=" + path));
                    if (path == null) {
                        return;
                    }
                    String lowerPath = path.toLowerCase();
                    boolean bl = isTargetFile = lowerPath.endsWith(".mp4") || lowerPath.endsWith(".mov") || lowerPath.endsWith(".tmp") || lowerPath.endsWith(".part");
                    if (!isTargetFile) {
                        return;
                    }
                    String fullPath = dirPath + File.separator + path;
                    Log.d((String)ScreenRecordDetector.TAG, (String)("FileObserver \u6355\u6349\u5230\u6587\u4ef6\u4e8b\u4ef6\uff1aevent=" + event + ", fullPath=" + fullPath));
                    if (System.currentTimeMillis() - ScreenRecordDetector.this.mLastRecordStopTime < 5000L) {
                        Log.d((String)ScreenRecordDetector.TAG, (String)("\u8fc7\u6ee4\u5f55\u5c4f\u505c\u6b62\u540e\u7684\u6587\u4ef6\u4e8b\u4ef6\uff1a" + fullPath));
                        return;
                    }
                    ScreenRecordDetector.this.checkRecordingFile(fullPath);
                }
            };
            this.mFileObservers.add(observer);
            observer.startWatching();
        }
        Log.d((String)TAG, (String)("\u6587\u4ef6\u76d1\u542c\u5668\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u5171\u76d1\u542c " + this.mFileObservers.size() + " \u4e2a\u76ee\u5f55"));
    }

    private void stopFileObservers() {
        for (FileObserver observer : this.mFileObservers) {
            observer.stopWatching();
        }
    }

    private void scanRecentRecordFiles() {
        if (Build.VERSION.SDK_INT < 33 && !this.hasStoragePermission()) {
            Log.e((String)TAG, (String)"\u7f3a\u5c11 READ_EXTERNAL_STORAGE \u6743\u9650\uff0c\u8df3\u8fc7\u5386\u53f2\u6587\u4ef6\u626b\u63cf");
            return;
        }
        String[] projection = this.getProjection();
        Uri[] queryUris = new Uri[]{MediaStore.Video.Media.EXTERNAL_CONTENT_URI, MediaStore.Video.Media.INTERNAL_CONTENT_URI};
        long currentTimeMs = System.currentTimeMillis();
        boolean[] found = new boolean[]{false};
        for (Uri queryUri : queryUris) {
            try (Cursor cursor = this.mAppContext.getContentResolver().query(queryUri, projection, null, null, "date_added DESC");){
                if (cursor == null || cursor.getCount() == 0) {
                    Log.d((String)TAG, (String)("\u626b\u63cf\u5386\u53f2\u6587\u4ef6\uff1aURI=" + queryUri + " \u65e0\u6570\u636e"));
                    continue;
                }
                for (int index = 0; cursor.moveToNext() && index < 5; ++index) {
                    String filePath = this.getValidFilePath(cursor, queryUri);
                    String fileName = cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
                    long createTimeMs = cursor.getLong(cursor.getColumnIndexOrThrow("date_added")) * 1000L;
                    long duration = (currentTimeMs - createTimeMs) / 1000L;
                    if (duration > 30L || createTimeMs < this.mLastRecordStopTime) {
                        Log.d((String)TAG, (String)("\u626b\u63cf\u5386\u53f2\u6587\u4ef6\uff1a" + fileName + " \u521b\u5efa\u65f6\u95f4\u8fc7\u4e45/\u5df2\u505c\u6b62\uff0c\u8df3\u8fc7"));
                        continue;
                    }
                    Log.d((String)TAG, (String)("\u626b\u63cf\u5386\u53f2\u6587\u4ef6\uff1afile=" + fileName + ", path=" + filePath + ", \u5927\u5c0f\u8fbe\u6807=" + this.isValidFile(filePath, false) + ", \u662f\u5f55\u5c4f\u6587\u4ef6=" + this.isScreenRecordFile(filePath, fileName) + ", \u6b63\u5728\u5f55\u5236=" + this.mIsRecording));
                    if (!this.isValidFile(filePath, false) || !this.isScreenRecordFile(filePath, fileName) || this.mIsRecording) continue;
                    this.checkFileGrowing(filePath, isGrowing -> {
                        if (isGrowing) {
                            Log.d((String)TAG, (String)("\u626b\u63cf\u5386\u53f2\u6587\u4ef6\uff1a\u627e\u5230\u6b63\u5728\u5f55\u5236\u7684\u5f55\u5c4f\u6587\u4ef6=" + fileName));
                            this.mIsRecording = true;
                            this.notifyRecordStarted();
                            this.checkRecordStatus(filePath);
                            found[0] = true;
                        }
                    });
                    if (!found[0]) continue;
                    break;
                }
                if (!found[0]) continue;
                break;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("\u626b\u63cf\u5386\u53f2\u6587\u4ef6\u5931\u8d25\uff1aURI=" + queryUri), (Throwable)e);
            }
        }
    }

    private void checkIfScreenRecordFile(Uri triggerUri) {
        Log.d((String)TAG, (String)("checkIfScreenRecordFile: triggerUri=" + triggerUri));
        String[] projection = this.getProjection();
        long currentTimeMs = System.currentTimeMillis();
        boolean isSingleFileUri = triggerUri.getPath().matches(".*/media/\\d+$");
        if (isSingleFileUri) {
            try (Cursor cursor = this.mAppContext.getContentResolver().query(triggerUri, projection, null, null, null);){
                if (cursor != null && cursor.moveToFirst()) {
                    String filePath = this.getValidFilePath(cursor, triggerUri);
                    String fileName = cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
                    long createTimeMs = cursor.getLong(cursor.getColumnIndexOrThrow("date_added")) * 1000L;
                    long duration = (currentTimeMs - createTimeMs) / 1000L;
                    Log.d((String)TAG, (String)("\u5355\u4e2a\u6587\u4ef6URI\u67e5\u8be2\uff1afile=" + fileName + ", path=" + filePath + ", \u521b\u5efa\u65f6\u95f4=" + duration + "\u79d2, isValidFile=" + this.isValidFile(filePath, false) + ", isScreenRecordFile=" + this.isScreenRecordFile(filePath, fileName) + ", mIsRecording=" + this.mIsRecording));
                    if (duration <= 60L && this.isValidFile(filePath, false) && this.isScreenRecordFile(filePath, fileName) && !this.mIsRecording && createTimeMs >= this.mLastRecordStopTime) {
                        this.checkFileGrowing(filePath, isGrowing -> {
                            if (isGrowing) {
                                Log.d((String)TAG, (String)"\u5355\u4e2a\u6587\u4ef6URI\u67e5\u8be2\uff1a\u547d\u4e2d\u6b63\u5728\u5f55\u5236\u7684\u5f55\u5c4f\u6587\u4ef6");
                                this.mIsRecording = true;
                                this.notifyRecordStarted();
                                this.checkRecordStatus(filePath);
                            } else {
                                Log.d((String)TAG, (String)"\u5355\u4e2a\u6587\u4ef6URI\u67e5\u8be2\uff1a\u6587\u4ef6\u5df2\u505c\u6b62\u589e\u957f\uff0c\u89c6\u4e3a\u5df2\u7ed3\u675f\u5f55\u5c4f");
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("\u5355\u4e2a\u6587\u4ef6URI\u67e5\u8be2\u5931\u8d25\uff1auri=" + triggerUri), (Throwable)e);
            }
        }
    }

    private void checkRecordingFile(String filePath) {
        boolean isTempFile;
        File file = new File(filePath);
        if (!file.exists()) {
            Log.d((String)TAG, (String)("\u4e34\u65f6\u6587\u4ef6\u68c0\u6d4b\uff1a\u6587\u4ef6\u4e0d\u5b58\u5728=" + filePath));
            return;
        }
        String fileName = file.getName();
        if (!this.isScreenRecordFile(filePath, fileName)) {
            return;
        }
        long fileSize = file.length();
        Log.d((String)TAG, (String)("\u4e34\u65f6\u6587\u4ef6\u68c0\u6d4b\uff1afile=" + fileName + ", path=" + filePath + ", \u5927\u5c0f=" + fileSize + "\u5b57\u8282"));
        boolean bl = isTempFile = fileName.toLowerCase().endsWith(".tmp") || fileName.toLowerCase().endsWith(".part");
        if (isTempFile) {
            if (fileSize < 1024L) {
                Log.d((String)TAG, (String)"\u4e34\u65f6\u6587\u4ef6\u68c0\u6d4b\uff1a\u5927\u5c0f\u672a\u8fbe\u9608\u503c\uff0c\u5ef6\u8fdf500ms\u518d\u68c0\u67e5");
                this.mBgHandler.postDelayed(() -> {
                    if (!this.mIsRecording && file.exists() && file.length() > 1024L) {
                        this.checkFileGrowing(filePath, isGrowing -> {
                            if (isGrowing) {
                                Log.d((String)TAG, (String)"\u4e34\u65f6\u6587\u4ef6\u68c0\u6d4b\uff1a\u6587\u4ef6\u6301\u7eed\u589e\u957f\uff0c\u786e\u8ba4\u662f\u5f55\u5236\u4e2d\u5f55\u5c4f");
                                this.mIsRecording = true;
                                this.notifyRecordStarted();
                                this.checkRecordStatus(filePath);
                            }
                        });
                    }
                }, 500L);
            } else {
                this.checkFileGrowing(filePath, isGrowing -> {
                    if (isGrowing && !this.mIsRecording) {
                        Log.d((String)TAG, (String)"\u4e34\u65f6\u6587\u4ef6\u68c0\u6d4b\uff1a\u5927\u5c0f\u8fbe\u6807\u4e14\u6301\u7eed\u589e\u957f\uff0c\u547d\u4e2d\u5f55\u5236\u4e2d\u5f55\u5c4f");
                        this.mIsRecording = true;
                        this.notifyRecordStarted();
                        this.checkRecordStatus(filePath);
                    }
                });
            }
        } else {
            long createTime = file.lastModified();
            long currentTime = System.currentTimeMillis();
            if (currentTime - createTime > 5000L) {
                Log.d((String)TAG, (String)"\u6700\u7ec8\u6587\u4ef6\u68c0\u6d4b\uff1a\u521b\u5efa\u65f6\u95f4\u8d85\u8fc75\u79d2\uff0c\u89c6\u4e3a\u5df2\u505c\u6b62\u5f55\u5c4f");
                return;
            }
            this.checkFileGrowing(filePath, isGrowing -> {
                if (isGrowing && !this.mIsRecording) {
                    Log.d((String)TAG, (String)"\u6700\u7ec8\u6587\u4ef6\u68c0\u6d4b\uff1a5\u79d2\u5185\u521b\u5efa\u4e14\u6301\u7eed\u589e\u957f\uff0c\u547d\u4e2d\u65b0\u5f55\u5c4f");
                    this.mIsRecording = true;
                    this.notifyRecordStarted();
                    this.checkRecordStatus(filePath);
                } else {
                    Log.d((String)TAG, (String)"\u6700\u7ec8\u6587\u4ef6\u68c0\u6d4b\uff1a\u5df2\u505c\u6b62\u589e\u957f\uff0c\u89c6\u4e3a\u5f55\u5c4f\u7ed3\u675f");
                }
            });
        }
    }

    private void checkRecordStatus(String filePath) {
        File targetFile = new File(filePath);
        if (!targetFile.exists() || !this.mIsRecording) {
            this.resetRecordingState();
            return;
        }
        long size1 = targetFile.length();
        this.mBgHandler.postDelayed(() -> {
            if (!this.mIsRecording || !targetFile.exists()) {
                this.resetRecordingState();
                return;
            }
            long size2 = targetFile.length();
            if (Math.abs(size2 - size1) <= 1024L) {
                Log.d((String)TAG, (String)("\u5f55\u5c4f\u505c\u6b62\uff1a\u6587\u4ef6\u5927\u5c0f\u65e0\u53d8\u5316\uff08" + size1 + "\u2192" + size2 + "\uff09"));
                this.resetRecordingState();
            } else {
                this.checkRecordStatus(filePath);
            }
        }, 1000L);
    }

    private void resetRecordingState() {
        this.mIsRecording = false;
        this.mLastEventTimestamp = 0L;
        this.mLastRecordStopTime = System.currentTimeMillis();
        this.notifyRecordStopped();
        Log.d((String)TAG, (String)("\u5f55\u5c4f\u72b6\u6001\u5df2\u91cd\u7f6e\uff0c\u53ef\u91cd\u65b0\u68c0\u6d4b\uff08\u505c\u6b62\u65f6\u95f4\uff1a" + this.mLastRecordStopTime + "\uff09"));
    }

    private void notifyRecordStarted() {
        this.mMainHandler.post(() -> {
            if (this.mStateListener != null && this.mIsRecording) {
                this.mStateListener.onRecordStart();
                Log.d((String)TAG, (String)"\u56de\u8c03\u5f55\u5c4f\u542f\u52a8\u4e8b\u4ef6");
            }
        });
    }

    private void notifyRecordStopped() {
        this.mMainHandler.post(() -> {
            if (this.mStateListener != null && !this.mIsRecording) {
                this.mStateListener.onRecordStop();
                Log.d((String)TAG, (String)"\u56de\u8c03\u5f55\u5c4f\u7ed3\u675f\u4e8b\u4ef6");
            }
        });
    }

    private void checkFileGrowing(String filePath, OnFileGrowingListener listener2) {
        File file = new File(filePath);
        if (!file.exists()) {
            listener2.onResult(false);
            return;
        }
        long size1 = file.length();
        this.mBgHandler.postDelayed(() -> {
            if (!file.exists()) {
                listener2.onResult(false);
                return;
            }
            long size2 = file.length();
            boolean isGrowing = Math.abs(size2 - size1) > 1024L;
            Log.d((String)TAG, (String)("\u6587\u4ef6\u589e\u957f\u68c0\u67e5\uff1a" + filePath + "\uff08" + size1 + "\u2192" + size2 + "\uff09\uff0c\u662f\u5426\u589e\u957f\uff1a" + isGrowing));
            listener2.onResult(isGrowing);
        }, 500L);
    }

    private String[] getProjection() {
        if (Build.VERSION.SDK_INT >= 29) {
            return new String[]{"_id", "_data", "relative_path", "_display_name", "date_added"};
        }
        return new String[]{"_id", "_data", "_display_name", "date_added"};
    }

    private String getValidFilePath(Cursor cursor, Uri queryUri) {
        String filePath = null;
        int dataIndex = cursor.getColumnIndexOrThrow("_data");
        if (!cursor.isNull(dataIndex)) {
            filePath = cursor.getString(dataIndex);
            Log.d((String)TAG, (String)("getValidFilePath: DATA=" + filePath));
            if (this.isValidFile(filePath, true)) {
                return filePath;
            }
        }
        return filePath;
    }

    private boolean isScreenRecordFile(String filePath, String fileName) {
        String lowerFileName = fileName.toLowerCase();
        if (!(lowerFileName.endsWith(".mp4") || lowerFileName.endsWith(".mov") || lowerFileName.endsWith(".tmp") || lowerFileName.endsWith(".part"))) {
            return false;
        }
        String fullName = (filePath + File.separator + fileName).toLowerCase(Locale.ENGLISH);
        for (String keyword : RECORD_FILE_KEYWORDS) {
            if (!fullName.contains(keyword.toLowerCase(Locale.ENGLISH))) continue;
            Log.d((String)TAG, (String)("isScreenRecordFile: \u5339\u914d\u5173\u952e\u8bcd=" + keyword));
            return true;
        }
        return false;
    }

    private boolean isValidFile(String filePath, boolean isStrict) {
        if (filePath == null || filePath.isEmpty()) {
            return false;
        }
        File file = new File(filePath);
        if (isStrict) {
            return file.exists();
        }
        long minSize = file.getName().toLowerCase().contains(".tmp") || file.getName().toLowerCase().contains(".part") ? 1024L : 10240L;
        return file.exists() && file.length() > minSize;
    }

    private boolean isVideoUri(Uri uri) {
        return uri.toString().contains(MediaStore.Video.Media.EXTERNAL_CONTENT_URI.toString());
    }

    private String[] mergeDirArrays(String[] arr1, String[] arr2) {
        String[] result = new String[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }

    private boolean hasStoragePermission() {
        return ContextCompat.checkSelfPermission((Context)this.mAppContext, (String)PERMISSION_READ_STORAGE) == 0;
    }

    private void registerVideoContentObserver() {
        this.mAppContext.getContentResolver().registerContentObserver(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, true, this.mVideoContentObserver);
    }

    private void unregisterVideoContentObserver() {
        this.mAppContext.getContentResolver().unregisterContentObserver(this.mVideoContentObserver);
    }

    public static interface OnRecordStateChangeListener {
        public void onRecordStart();

        public void onRecordStop();
    }

    private static interface OnFileGrowingListener {
        public void onResult(boolean var1);
    }
}

