/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyutils.lifecycle;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.baijiayun.bjyutils.log.LPLogger;
import java.util.LinkedList;

public class DoWhenVisible
implements LifecycleObserver {
    private static final String TAG = "DoWhenVisible";
    private LinkedList<Runnable> queue = new LinkedList();
    private Lifecycle lifecycle;
    private boolean resumeLastAction;

    public DoWhenVisible(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        lifecycle.addObserver((LifecycleObserver)this);
    }

    public DoWhenVisible(Lifecycle lifecycle, boolean resumeLastAction) {
        this.resumeLastAction = resumeLastAction;
        this.lifecycle = lifecycle;
        lifecycle.addObserver((LifecycleObserver)this);
    }

    public void post(Runnable runnable) {
        if (this.lifecycle.getCurrentState().isAtLeast(Lifecycle.State.RESUMED)) {
            LPLogger.i(TAG, "currentState is: " + this.lifecycle.getCurrentState() + " just do.");
            runnable.run();
        } else {
            LPLogger.i(TAG, "currentState is: " + this.lifecycle.getCurrentState() + " add to queue.");
            if (this.resumeLastAction) {
                this.queue.poll();
            }
            this.queue.offer(runnable);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    private void onResume() {
        Runnable runnable;
        LPLogger.i(TAG, "onResume action size:" + this.queue.size());
        while ((runnable = this.queue.poll()) != null) {
            runnable.run();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    private void onDestroy() {
        this.queue.clear();
    }
}

