/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine;

import com.baijiayun.bjyrtcengine.VideoBaseProps;
import com.baijiayun.utils.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class VideoEncConfig {
    private static final String TAG = "VideoEncConfig";
    public static final int MIN_FRAME_RATE = 5;
    protected List<VideoBaseProps> lstVideoProps;
    protected VideoBaseProps selectedProp;

    public VideoEncConfig() {
        VideoEncConfig videoEncConfig = videoBaseProps2;
        videoEncConfig.lstVideoProps = new ArrayList<VideoBaseProps>();
        videoEncConfig.initSupportedVideoPropList();
        Collections.sort(videoEncConfig.lstVideoProps);
        videoEncConfig.printSupportedVideoProps();
        ((VideoEncConfig)((Object)videoBaseProps2)).selectedProp = videoEncConfig.lstVideoProps.get(0);
        if (((VideoEncConfig)((Object)videoBaseProps2)).selectedProp == null) {
            VideoBaseProps.VideoResolution videoResolution;
            VideoBaseProps videoBaseProps;
            VideoEncConfig videoEncConfig2 = videoBaseProps2;
            VideoBaseProps videoBaseProps2 = videoBaseProps;
            VideoBaseProps.VideoResolution videoResolution2 = videoResolution;
            videoResolution = new VideoBaseProps.VideoResolution(320, 240);
            videoBaseProps = new VideoBaseProps(videoResolution2, 15, 100);
            videoEncConfig2.selectedProp = videoBaseProps2;
        }
    }

    protected abstract void initSupportedVideoPropList();

    public void updateVideoPropByName(int n, int n2, int n3, int n4, int n5) {
        for (VideoBaseProps videoBaseProps : ((VideoEncConfig)this).lstVideoProps) {
            VideoBaseProps.VideoResolution videoResolution = videoBaseProps.resolution;
            if (videoResolution.width != n || videoResolution.height != n2) continue;
            int n6 = videoBaseProps.bitRate;
            if (n3 <= 0) {
                n3 = n6;
            }
            videoBaseProps.bitRate = n3;
            videoBaseProps.frameRate = Math.max(n4, 5);
            videoBaseProps.updateProps();
            LogUtil.i((Object)TAG, (String)("Video param updated: " + videoBaseProps));
            break;
        }
    }

    public VideoBaseProps getSelectedVideoProp() {
        return this.selectedProp;
    }

    public VideoBaseProps getVideoProp(int n, int n2) {
        for (VideoBaseProps videoBaseProps : this.lstVideoProps) {
            VideoBaseProps.VideoResolution videoResolution = videoBaseProps.resolution;
            if (videoResolution.width != n || videoResolution.height != n2) continue;
            return videoBaseProps;
        }
        return this.lstVideoProps.get(0);
    }

    public void printSupportedVideoProps() {
        LogUtil.i((Object)TAG, (String)"Supported video configuration: ");
        Iterator<VideoBaseProps> iterator = ((VideoEncConfig)((Object)iterator)).lstVideoProps.iterator();
        while (iterator.hasNext()) {
            LogUtil.i((Object)TAG, (String)((VideoBaseProps)iterator.next()).toString());
        }
    }

    public boolean selectVideoByResolution(int n, int n2) {
        boolean bl = false;
        for (VideoBaseProps videoBaseProps : this.lstVideoProps) {
            VideoBaseProps.VideoResolution videoResolution = videoBaseProps.resolution;
            if (videoResolution.width != n || videoResolution.height != n2) continue;
            bl = true;
            this.selectedProp = videoBaseProps;
            break;
        }
        if (!bl) {
            n *= n2;
            for (VideoBaseProps videoBaseProps : this.lstVideoProps) {
                if (videoBaseProps.resolution.pixels > n) break;
                this.selectedProp = videoBaseProps;
                bl = true;
            }
        }
        if (!bl) {
            this.selectedProp = this.lstVideoProps.get(0);
        }
        return true;
    }
}

