/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine.player;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.bjyrtcengine.player.MeasureHelper;
import com.baijiayun.bjyrtcengine.player.RtmpView;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tv.danmaku.ijk.media.bjplayer.IMediaPlayer;
import tv.danmaku.ijk.media.bjplayer.ISurfaceTextureHolder;
import tv.danmaku.ijk.media.bjplayer.ISurfaceTextureHost;

@TargetApi(value=14)
public class TextureRenderView
extends TextureView
implements RtmpView {
    private static final String TAG = "TextureRenderView";
    private MeasureHelper mMeasureHelper;
    private SurfaceCallback mSurfaceCallback;

    public TextureRenderView(Context context) {
        TextureRenderView textureRenderView = this;
        super(context);
        textureRenderView.initView(context);
    }

    public TextureRenderView(Context context, AttributeSet attributeSet) {
        TextureRenderView textureRenderView = this;
        super(context, attributeSet);
        textureRenderView.initView(context);
    }

    public TextureRenderView(Context context, AttributeSet attributeSet, int n) {
        TextureRenderView textureRenderView = this;
        super(context, attributeSet, n);
        textureRenderView.initView(context);
    }

    @TargetApi(value=21)
    public TextureRenderView(Context context, AttributeSet attributeSet, int n, int n2) {
        TextureRenderView textureRenderView = this;
        super(context, attributeSet, n, n2);
        textureRenderView.initView(context);
    }

    private void initView(Context object) {
        SurfaceCallback surfaceCallback;
        MeasureHelper measureHelper;
        object = measureHelper;
        measureHelper = new MeasureHelper((View)this);
        this.mMeasureHelper = object;
        object = surfaceCallback;
        surfaceCallback = new SurfaceCallback(this);
        this.mSurfaceCallback = object;
        this.setSurfaceTextureListener((TextureView.SurfaceTextureListener)object);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public boolean shouldWaitForResize() {
        return false;
    }

    protected void onDetachedFromWindow() {
        TextureRenderView textureRenderView = this;
        textureRenderView.mSurfaceCallback.willDetachFromWindow();
        super.onDetachedFromWindow();
        textureRenderView.mSurfaceCallback.didDetachFromWindow();
    }

    @Override
    public void setVideoSize(int n, int n2) {
        if (n > 0 && n2 > 0) {
            TextureRenderView textureRenderView = this;
            textureRenderView.mMeasureHelper.setVideoSize(n, n2);
            textureRenderView.requestLayout();
        }
    }

    @Override
    public void setVideoSampleAspectRatio(int n, int n2) {
        if (n > 0 && n2 > 0) {
            TextureRenderView textureRenderView = this;
            textureRenderView.mMeasureHelper.setVideoSampleAspectRatio(n, n2);
            textureRenderView.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int n) {
        this.mMeasureHelper.setVideoRotation(n);
        this.setRotation(n);
    }

    @Override
    public void setAspectRatio(int n) {
        TextureRenderView textureRenderView = this;
        textureRenderView.mMeasureHelper.setAspectRatio(n);
        textureRenderView.requestLayout();
    }

    protected void onMeasure(int n, int n2) {
        TextureRenderView textureRenderView = this;
        textureRenderView.mMeasureHelper.doMeasure(n, n2);
        textureRenderView.setMeasuredDimension(textureRenderView.mMeasureHelper.getMeasuredWidth(), this.mMeasureHelper.getMeasuredHeight());
    }

    public RtmpView.ISurfaceHolder getSurfaceHolder() {
        TextureRenderView textureRenderView = textureRenderView2;
        TextureRenderView textureRenderView2 = textureRenderView.mSurfaceCallback.mSurfaceTexture;
        return new InternalSurfaceHolder(textureRenderView, (SurfaceTexture)textureRenderView2, textureRenderView.mSurfaceCallback);
    }

    @Override
    public void addRenderCallback(RtmpView.IRenderCallback iRenderCallback) {
        this.mSurfaceCallback.addRenderCallback(iRenderCallback);
    }

    @Override
    public void removeRenderCallback(RtmpView.IRenderCallback iRenderCallback) {
        this.mSurfaceCallback.removeRenderCallback(iRenderCallback);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)TextureRenderView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)TextureRenderView.class.getName());
    }

    private static final class SurfaceCallback
    implements TextureView.SurfaceTextureListener,
    ISurfaceTextureHost {
        private SurfaceTexture mSurfaceTexture;
        private boolean mIsFormatChanged;
        private int mWidth;
        private int mHeight;
        private boolean mOwnSurfaceTexture = true;
        private boolean mWillDetachFromWindow = false;
        private boolean mDidDetachFromWindow = false;
        private WeakReference<TextureRenderView> mWeakRenderView;
        private Map<RtmpView.IRenderCallback, Object> mRenderCallbackMap;

        public SurfaceCallback(@NonNull TextureRenderView textureRenderView) {
            WeakReference<TextureRenderView> weakReference;
            ConcurrentHashMap concurrentHashMap;
            Object object = concurrentHashMap;
            concurrentHashMap = new ConcurrentHashMap();
            v1.mRenderCallbackMap = object;
            object = weakReference;
            weakReference = new WeakReference<TextureRenderView>(textureRenderView);
            v1.mWeakRenderView = object;
        }

        public void setOwnSurfaceTexture(boolean bl) {
            this.mOwnSurfaceTexture = bl;
        }

        public void addRenderCallback(@NonNull RtmpView.IRenderCallback iRenderCallback) {
            SurfaceCallback surfaceCallback = this;
            RtmpView.IRenderCallback iRenderCallback2 = iRenderCallback;
            surfaceCallback.mRenderCallbackMap.put(iRenderCallback2, iRenderCallback2);
            InternalSurfaceHolder internalSurfaceHolder = null;
            if (surfaceCallback.mSurfaceTexture != null) {
                InternalSurfaceHolder internalSurfaceHolder2;
                SurfaceCallback surfaceCallback2 = this;
                internalSurfaceHolder = internalSurfaceHolder2;
                SurfaceCallback surfaceCallback3 = this;
                TextureRenderView textureRenderView = (TextureRenderView)surfaceCallback3.mWeakRenderView.get();
                internalSurfaceHolder2 = new InternalSurfaceHolder(textureRenderView, surfaceCallback3.mSurfaceTexture, this);
                int n = surfaceCallback2.mWidth;
                int n2 = surfaceCallback2.mHeight;
                iRenderCallback.onSurfaceCreated(internalSurfaceHolder, n, n2);
            }
            if (this.mIsFormatChanged) {
                if (internalSurfaceHolder == null) {
                    InternalSurfaceHolder internalSurfaceHolder3;
                    internalSurfaceHolder = internalSurfaceHolder3;
                    SurfaceCallback surfaceCallback4 = this;
                    TextureRenderView textureRenderView = (TextureRenderView)surfaceCallback4.mWeakRenderView.get();
                    internalSurfaceHolder3 = new InternalSurfaceHolder(textureRenderView, surfaceCallback4.mSurfaceTexture, this);
                }
                SurfaceCallback surfaceCallback5 = this;
                int n = surfaceCallback5.mWidth;
                int n3 = surfaceCallback5.mHeight;
                iRenderCallback.onSurfaceChanged(internalSurfaceHolder, 0, n, n3);
            }
        }

        public void removeRenderCallback(@NonNull RtmpView.IRenderCallback iRenderCallback) {
            this.mRenderCallbackMap.remove(iRenderCallback);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            InternalSurfaceHolder internalSurfaceHolder;
            ((SurfaceCallback)((Object)iterator)).mSurfaceTexture = surfaceTexture;
            ((SurfaceCallback)((Object)iterator)).mIsFormatChanged = false;
            ((SurfaceCallback)((Object)iterator)).mWidth = 0;
            ((SurfaceCallback)((Object)iterator)).mHeight = 0;
            InternalSurfaceHolder internalSurfaceHolder2 = internalSurfaceHolder;
            internalSurfaceHolder = new InternalSurfaceHolder((TextureRenderView)((SurfaceCallback)((Object)iterator)).mWeakRenderView.get(), surfaceTexture, (ISurfaceTextureHost)iterator);
            Iterator<RtmpView.IRenderCallback> iterator = ((SurfaceCallback)((Object)iterator)).mRenderCallbackMap.keySet().iterator();
            while (iterator.hasNext()) {
                ((RtmpView.IRenderCallback)iterator.next()).onSurfaceCreated(internalSurfaceHolder2, 0, 0);
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            InternalSurfaceHolder internalSurfaceHolder;
            SurfaceCallback surfaceCallback = iterator;
            surfaceCallback.mSurfaceTexture = surfaceTexture;
            surfaceCallback.mIsFormatChanged = true;
            ((SurfaceCallback)((Object)iterator)).mWidth = n;
            ((SurfaceCallback)((Object)iterator)).mHeight = n2;
            InternalSurfaceHolder internalSurfaceHolder2 = internalSurfaceHolder;
            internalSurfaceHolder = new InternalSurfaceHolder((TextureRenderView)((SurfaceCallback)((Object)iterator)).mWeakRenderView.get(), surfaceTexture, (ISurfaceTextureHost)iterator);
            Iterator<RtmpView.IRenderCallback> iterator = ((SurfaceCallback)((Object)iterator)).mRenderCallbackMap.keySet().iterator();
            while (iterator.hasNext()) {
                ((RtmpView.IRenderCallback)iterator.next()).onSurfaceChanged(internalSurfaceHolder2, 0, n, n2);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
            InternalSurfaceHolder internalSurfaceHolder;
            this.mSurfaceTexture = object;
            this.mIsFormatChanged = false;
            this.mWidth = 0;
            this.mHeight = 0;
            InternalSurfaceHolder internalSurfaceHolder2 = internalSurfaceHolder;
            internalSurfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), (SurfaceTexture)object, this);
            object = this.mRenderCallbackMap.keySet().iterator();
            while (object.hasNext()) {
                ((RtmpView.IRenderCallback)object.next()).onSurfaceDestroyed(internalSurfaceHolder2);
            }
            Log.d((String)TextureRenderView.TAG, (String)("onSurfaceTextureDestroyed: destroy: " + this.mOwnSurfaceTexture));
            return this.mOwnSurfaceTexture;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        public void releaseSurfaceTexture(SurfaceTexture surfaceTexture) {
            if (surfaceTexture == null) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: null");
            } else if (this.mDidDetachFromWindow) {
                if (surfaceTexture != this.mSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): release different SurfaceTexture");
                    surfaceTexture.release();
                } else if (!this.mOwnSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): release detached SurfaceTexture");
                    surfaceTexture.release();
                } else {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): already released by TextureView");
                }
            } else if (this.mWillDetachFromWindow) {
                if (surfaceTexture != this.mSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): release different SurfaceTexture");
                    surfaceTexture.release();
                } else if (!this.mOwnSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): re-attach SurfaceTexture to TextureView");
                    this.setOwnSurfaceTexture(true);
                } else {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): will released by TextureView");
                }
            } else if (surfaceTexture != this.mSurfaceTexture) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: release different SurfaceTexture");
                surfaceTexture.release();
            } else if (!this.mOwnSurfaceTexture) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: re-attach SurfaceTexture to TextureView");
                this.setOwnSurfaceTexture(true);
            } else {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: will released by TextureView");
            }
        }

        public void willDetachFromWindow() {
            Log.d((String)TextureRenderView.TAG, (String)"willDetachFromWindow()");
            this.mWillDetachFromWindow = true;
        }

        public void didDetachFromWindow() {
            Log.d((String)TextureRenderView.TAG, (String)"didDetachFromWindow()");
            this.mDidDetachFromWindow = true;
        }
    }

    private static final class InternalSurfaceHolder
    implements RtmpView.ISurfaceHolder {
        private TextureRenderView mTextureView;
        private SurfaceTexture mSurfaceTexture;
        private ISurfaceTextureHost mSurfaceTextureHost;

        public InternalSurfaceHolder(@NonNull TextureRenderView textureRenderView, @Nullable SurfaceTexture surfaceTexture, @NonNull ISurfaceTextureHost iSurfaceTextureHost) {
            this.mTextureView = textureRenderView;
            this.mSurfaceTexture = surfaceTexture;
            this.mSurfaceTextureHost = iSurfaceTextureHost;
        }

        @Override
        @TargetApi(value=16)
        public void bindToMediaPlayer(IMediaPlayer iMediaPlayer) {
            if (iMediaPlayer == null) {
                return;
            }
            if (iMediaPlayer instanceof ISurfaceTextureHolder) {
                iMediaPlayer = (ISurfaceTextureHolder)iMediaPlayer;
                this.mTextureView.mSurfaceCallback.setOwnSurfaceTexture(false);
                SurfaceTexture surfaceTexture = iMediaPlayer.getSurfaceTexture();
                if (surfaceTexture != null) {
                    this.mTextureView.setSurfaceTexture(surfaceTexture);
                } else {
                    iMediaPlayer.setSurfaceTexture(this.mSurfaceTexture);
                    iMediaPlayer.setSurfaceTextureHost((ISurfaceTextureHost)this.mTextureView.mSurfaceCallback);
                }
            } else {
                iMediaPlayer.setSurface(this.openSurface());
            }
        }

        @Override
        @NonNull
        public RtmpView getRenderView() {
            return this.mTextureView;
        }

        @Override
        @Nullable
        public SurfaceHolder getSurfaceHolder() {
            return null;
        }

        @Override
        @Nullable
        public SurfaceTexture getSurfaceTexture() {
            return this.mSurfaceTexture;
        }

        @Override
        @Nullable
        public Surface openSurface() {
            if (this.mSurfaceTexture == null) {
                return null;
            }
            return new Surface(this.mSurfaceTexture);
        }
    }
}

