/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine.Tools;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.Size;
import com.baijiayun.MediaCodecVideoEncoder;
import com.baijiayun.utils.LogUtil;
import java.util.Arrays;
import java.util.List;

public class DeviceInfoHelper {
    private static final String TAG = "bjyrtc-DeviceInfoHelper";
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedEncoderColorList = new int[]{19, 21, 2141391872, 2141391876};
    private static final List<Integer> supportedDecoderColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    private static int mMaxH264EncoderInstanceSupported = 8;
    private static int mMaxVP8EncoderInstanceSupported = 8;
    private static int mMaxVP9EncoderInstanceSupported = 8;
    private static int mMaxH265EncoderInstanceSupported = 8;

    public static String printDeviceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\u4e3b\u677f\uff1a" + Build.BOARD);
        stringBuffer.append("\n\u7cfb\u7edf\u542f\u52a8\u7a0b\u5e8f\u7248\u672c\u53f7\uff1a" + Build.BOOTLOADER);
        stringBuffer.append("\n\u7cfb\u7edf\u5b9a\u5236\u5546\uff1a" + Build.BRAND);
        stringBuffer.append("\nCPU\u6307\u4ee4\u96c6\uff1a" + Build.CPU_ABI);
        stringBuffer.append("\nCPU\u6307\u4ee4\u96c62\uff1a" + Build.CPU_ABI2);
        stringBuffer.append("\n\u8bbe\u7f6e\u53c2\u6570\uff1a" + Build.DEVICE);
        stringBuffer.append("\n\u663e\u793a\u5c4f\u53c2\u6570\uff1a" + Build.DISPLAY);
        stringBuffer.append("\n\u65e0\u7ebf\u7535\u56fa\u4ef6\u7248\u672c\uff1a" + Build.getRadioVersion());
        stringBuffer.append("\n\u786c\u4ef6\u8bc6\u522b\u7801\uff1a" + Build.FINGERPRINT);
        stringBuffer.append("\n\u786c\u4ef6\u540d\u79f0\uff1a" + Build.HARDWARE);
        stringBuffer.append("\nHOST:" + Build.HOST);
        stringBuffer.append("\n\u4fee\u8ba2\u7248\u672c\u5217\u8868\uff1a" + Build.ID);
        stringBuffer.append("\n\u786c\u4ef6\u5236\u9020\u5546\uff1a" + Build.MANUFACTURER);
        stringBuffer.append("\n\u7248\u672c\uff1a" + Build.MODEL);
        stringBuffer.append("\n\u786c\u4ef6\u5e8f\u5217\u53f7\uff1a" + Build.SERIAL);
        stringBuffer.append("\n\u624b\u673a\u5236\u9020\u5546\uff1a" + Build.PRODUCT);
        stringBuffer.append("\n\u63cf\u8ff0Build\u7684\u6807\u7b7e\uff1a" + Build.TAGS);
        stringBuffer.append("\nTIME:" + Build.TIME);
        stringBuffer.append("\nBuild\u7c7b\u578b\uff1a" + Build.TYPE);
        stringBuffer.append("\nUSER:" + Build.USER);
        stringBuffer.append("\n\u7cfb\u7edfSDK\u7248\u672c:" + Build.VERSION.SDK_INT);
        LogUtil.w((Object)TAG, (String)stringBuffer.toString());
        return stringBuffer.toString();
    }

    public static String printMediaCodecInfo() {
        int n;
        String string;
        int n2;
        try {
            n2 = MediaCodecList.getCodecCount();
            string = "";
        }
        catch (Exception exception) {
            LogUtil.e((Object)TAG, (String)"##### Failed to get codec count!");
            exception.printStackTrace();
            return "Failed to get codec count!";
        }
        for (n = 0; n < n2; n += 1) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogUtil.e((Object)TAG, (String)("Cannot retrieve decoder codec info" + illegalArgumentException.getMessage()));
            }
            if (mediaCodecInfo == null) continue;
            MediaCodecInfo mediaCodecInfo2 = mediaCodecInfo;
            String string2 = mediaCodecInfo2.getName();
            String string3 = "\n" + string2 + ", [";
            for (String string4 : mediaCodecInfo2.getSupportedTypes()) {
                Object object;
                int n3;
                string3 = string3 + string4 + ",";
                try {
                    string4 = mediaCodecInfo.getCapabilitiesForType(string4);
                    n3 = Build.VERSION.SDK_INT;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LogUtil.e((Object)TAG, (String)("Cannot retrieve decoder capabilities for (" + string2 + ", " + string4 + "), " + illegalArgumentException.getMessage()));
                }
                if (n3 >= 21 && (object = string4.getVideoCapabilities()) != null) {
                    Size size;
                    Size size2 = size;
                    size = new Size(((Integer)object.getSupportedWidths().getUpper()).intValue(), ((Integer)object.getSupportedHeights().getUpper()).intValue());
                    string3 = string3 + " supported size:" + size2;
                }
                if (n3 >= 23) {
                    n3 = string4.getMaxSupportedInstances();
                    string3 = string3 + " max inst:" + n3 + ",";
                    object = string2.toLowerCase();
                    if (!((String)object).contains("google") && (((String)object).endsWith("decoder.avc") || ((String)object).endsWith("AVC.Decoder"))) {
                        mMaxH264EncoderInstanceSupported = n3;
                    }
                    if (!((String)object).contains("google") && (((String)object).endsWith("decoder.vp8") || ((String)object).endsWith("VP8.Decoder"))) {
                        mMaxVP8EncoderInstanceSupported = n3;
                    }
                    if (!((String)object).contains("google") && (((String)object).endsWith("decoder.hevc") || ((String)object).endsWith("HEVC.Decoder"))) {
                        mMaxH265EncoderInstanceSupported = n3;
                    }
                    if (!((String)object).contains("google") && (((String)object).endsWith("decoder.vp9") || ((String)object).endsWith("VP9.Decoder"))) {
                        mMaxVP9EncoderInstanceSupported = n3;
                    }
                }
                String string5 = string4;
                string4 = "";
                int[] nArray = ((MediaCodecInfo.CodecCapabilities)string5).colorFormats;
                int n4 = ((MediaCodecInfo.CodecCapabilities)string5).colorFormats.length;
                for (int i = 0; i < n4; ++i) {
                    string4 = string4 + " 0x" + Integer.toHexString(nArray[i]);
                }
                string3 = string3 + string4 + "] [";
            }
            string = string + string3;
            LogUtil.w((Object)TAG, (String)string3);
        }
        n2 = MediaCodecVideoEncoder.isVp8HwSupported() ? 1 : 0;
        n = MediaCodecVideoEncoder.isVp9HwSupported() ? 1 : 0;
        boolean bl = MediaCodecVideoEncoder.isH264HwSupported();
        String string6 = "\nWebRTC codec support: HwVP8=" + (n2 != 0) + ", HwVP9=" + (n != 0) + ", Hw264=" + bl;
        if (bl) {
            string6 = string6 + ", Hw264HighProfile=" + MediaCodecVideoEncoder.isH264HighProfileHwSupported();
        }
        LogUtil.w((Object)TAG, (String)string6);
        return string + string6;
    }

    public static boolean checkDecoderMaxInstances(int n, String string) {
        String string2 = string;
        string2.hashCode();
        int n2 = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 2194729: {
                if (!string.equals("H265")) break;
                n2 = 3;
                break;
            }
            case 2194728: {
                if (!string.equals("H264")) break;
                n2 = 2;
                break;
            }
            case 85183: {
                if (!string.equals("VP9")) break;
                n2 = 1;
                break;
            }
            case 85182: {
                if (!string.equals("VP8")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return false;
            }
            case 3: {
                return mMaxH265EncoderInstanceSupported > n + 1;
            }
            case 2: {
                return mMaxH264EncoderInstanceSupported > n + 1;
            }
            case 1: {
                return mMaxVP9EncoderInstanceSupported > n + 1;
            }
            case 0: 
        }
        return mMaxVP8EncoderInstanceSupported > n + 1;
    }
}

