/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine.EventHandler;

import android.os.Bundle;
import com.baijiayun.bjyrtcengine.BJYRtcEventObserver;
import com.baijiayun.bjyrtcengine.BRTCAdapter;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcErrors;
import com.baijiayun.bjyrtcengine.Defines.BRTCPeer;
import com.baijiayun.bjyrtcengine.Enums;
import com.baijiayun.utils.LogUtil;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.brtc.sdk.BRTCDef;
import org.brtc.sdk.BRTCListener;
import org.brtc.sdk.model.output.BRTCStatistics;

public class BRTCSdkEventHandler
extends BRTCListener {
    private static final String TAG = "bjyrtc-BRTCEventHandler";
    private BJYRtcEventObserver mRtcEventObserver = null;
    private BRTCAdapter mBRTCAdapter;
    private BRTCPeer mLocalUserPeer;
    private final ConcurrentHashMap<Integer, BRTCPeer> mAllPeers;
    private boolean isJoined;

    public BRTCSdkEventHandler(BRTCAdapter bRTCAdapter) {
        ConcurrentHashMap concurrentHashMap;
        Object object = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.mAllPeers = object;
        v1.isJoined = false;
        v1.mBRTCAdapter = bRTCAdapter;
    }

    public void setRtcEngineObserver(BJYRtcEventObserver bJYRtcEventObserver) {
        this.mRtcEventObserver = bJYRtcEventObserver;
    }

    public void setLocalUserId(String string) {
        LogUtil.i((Object)TAG, (String)("setLocalUserId: " + string));
        this.mLocalUserPeer = new BRTCPeer(Integer.parseInt(string));
    }

    public boolean getJoinRoomState() {
        return this.isJoined;
    }

    public void onEnterRoom(long l) {
        if (((BRTCSdkEventHandler)((Object)bRTCAdapter)).mRtcEventObserver != null) {
            BRTCSdkEventHandler bRTCSdkEventHandler = bRTCAdapter;
            LogUtil.i((Object)TAG, (String)("onEnterRoom, roomId: " + l));
            bRTCSdkEventHandler.mRtcEventObserver.onJoinRoomResult(0);
            bRTCSdkEventHandler.isJoined = true;
            BRTCAdapter bRTCAdapter = bRTCSdkEventHandler.mBRTCAdapter;
            if (bRTCAdapter != null) {
                bRTCAdapter.updateRoomConfigAfterJoined();
            }
        }
    }

    public void onExitRoom(int n) {
        LogUtil.i((Object)TAG, (String)("onLeaveRoom, reason: " + n));
        this.mAllPeers.clear();
        this.isJoined = false;
    }

    public void onRemoteUserEnterRoom(String string) {
        int n = Enums.userIdToUid(string);
        if (!this.mAllPeers.containsKey(n)) {
            BRTCPeer bRTCPeer;
            BRTCPeer bRTCPeer2 = bRTCPeer;
            bRTCPeer = new BRTCPeer(n);
            this.mAllPeers.put(n, bRTCPeer2);
            LogUtil.i((Object)TAG, (String)("onUserJoined, uid= " + n + ", current peers count:" + this.mAllPeers.size()));
        }
    }

    public void onRemoteUserLeaveRoom(String string, int n) {
        BRTCSdkEventHandler bRTCSdkEventHandler = this;
        int n2 = Enums.userIdToUid(string);
        String string2 = Enums.convertBRTCUidToBJYUid(n2);
        LogUtil.i((Object)TAG, (String)("onUserLeave, uid: " + n2 + ", bjyUid: " + string2));
        int n3 = Enums.getSessionTypeFromUserId(n2);
        bRTCSdkEventHandler.mBRTCAdapter.unsubscribe(string2, n3, false);
        if (bRTCSdkEventHandler.mRtcEventObserver != null) {
            BRTCSdkEventHandler bRTCSdkEventHandler2 = this;
            bRTCSdkEventHandler2.mAllPeers.remove(n2);
            bRTCSdkEventHandler2.mRtcEventObserver.onUnpublishResult(n3, string2);
        }
    }

    public void onFirstVideoFrame(String string, int n, int n2, int n3) {
        int n4 = Enums.userIdToUid(string);
        int n5 = Enums.getSessionTypeFromUserId(n4);
        String string2 = Enums.convertBRTCUidToBJYUid(n4);
        LogUtil.i((Object)TAG, (String)("onFirstVideoFrameRendered, uid=" + n4 + ", width=" + n2 + ", height=" + n3));
        BJYRtcEventObserver bJYRtcEventObserver = this.mRtcEventObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onFirstFrameAvailable(string2, n5);
        }
    }

    public void onSendFirstLocalAudioFrame() {
        LogUtil.d((Object)TAG, (String)"onSendFirstLocalAudioFrame Success!");
        if (this.mRtcEventObserver != null && !this.mLocalUserPeer.hasFiredPublishResult()) {
            this.mLocalUserPeer.setHasFiredPublishResult(true);
        }
    }

    public void onSendFirstLocalVideoFrame(int n) {
        LogUtil.d((Object)TAG, (String)("onSendFirstLocalVideoFrame, uid=" + n));
        if (this.mRtcEventObserver != null && !this.mLocalUserPeer.hasFiredPublishResult()) {
            this.mLocalUserPeer.setHasFiredPublishResult(true);
        }
    }

    public void onFirstAudioFrame(String string) {
        if (object.mRtcEventObserver != null) {
            Object object;
            int n = Enums.userIdToUid(string);
            if (!object.mAllPeers.containsKey(n)) {
                BRTCPeer bRTCPeer;
                BRTCSdkEventHandler bRTCSdkEventHandler = object;
                object = bRTCPeer;
                bRTCPeer = new BRTCPeer(n);
                bRTCSdkEventHandler.mAllPeers.put(n, (BRTCPeer)object);
            }
            int n2 = n;
            object = Enums.convertBRTCUidToBJYUid(n2);
            LogUtil.d((Object)TAG, (String)("[callback] onFirstRemoteAudioFrame, uid=" + (String)object + ", sessType=" + Enums.getSessionTypeFromUserId(n2)));
        }
    }

    public void onUserAudioAvailable(String string, boolean bl) {
        int n = Enums.userIdToUid(string);
        int n2 = Enums.getSessionTypeFromUserId(n);
        String string2 = Enums.convertBRTCUidToBJYUid(n);
        BRTCPeer bRTCPeer = this.mAllPeers.get(n);
        if (bRTCPeer == null) {
            BRTCPeer bRTCPeer2;
            LogUtil.d((Object)TAG, (String)("onUserAudioAvailable(uid:" + string2 + ", sessType: " + n2 + ", new BRTCPeer()"));
            bRTCPeer = bRTCPeer2;
            bRTCPeer2 = new BRTCPeer(n);
            this.mAllPeers.put(n, bRTCPeer);
        }
        bRTCPeer.setAudioAttach(bl);
        LogUtil.d((Object)TAG, (String)("onUserAudioAvailable(uid:" + string2 + ", sessType: " + n2 + ", available: " + bl + "), isVideoAttach: " + bRTCPeer.isVideoAttach()));
        BJYRtcEventObserver bJYRtcEventObserver = this.mRtcEventObserver;
        if (bJYRtcEventObserver != null) {
            if (bl) {
                if (!bRTCPeer.hasFiredPublishResult()) {
                    bRTCPeer.setHasFiredPublishResult(true);
                    this.mRtcEventObserver.onPublishResult(n2, string2);
                }
                this.mRtcEventObserver.onRemoteAudioAvailable(String.valueOf(n), n2, true);
            } else {
                bJYRtcEventObserver.onRemoteAudioAvailable(String.valueOf(n), n2, false);
                if (!bRTCPeer.isVideoAttach()) {
                    bRTCPeer.setHasFiredPublishResult(false);
                    this.mAllPeers.remove(n);
                }
            }
        }
    }

    public void onUserVideoAvailable(String string, boolean bl) {
        int n = Enums.userIdToUid(string);
        int n2 = Enums.getSessionTypeFromUserId(n);
        String string2 = Enums.convertBRTCUidToBJYUid(n);
        BRTCPeer bRTCPeer = this.mAllPeers.get(n);
        if (bRTCPeer == null) {
            BRTCPeer bRTCPeer2;
            LogUtil.d((Object)TAG, (String)("onUserVideoAvailable(uid:" + string2 + ", new BRTCPeer()"));
            bRTCPeer = bRTCPeer2;
            bRTCPeer2 = new BRTCPeer(n);
            this.mAllPeers.put(n, bRTCPeer);
        }
        bRTCPeer.setVideoAttach(bl);
        LogUtil.d((Object)TAG, (String)("onUserVideoAvailable(uid:" + string2 + ", sessType: " + n2 + ", available: " + bl + "), isAudioAttach: " + bRTCPeer.isAudioAttach()));
        if (this.mRtcEventObserver != null) {
            if (bl) {
                LogUtil.d((Object)TAG, (String)("[callback] onPublishResult, uid=" + string2 + ", sessType=" + n2 + ", from onUserVideoAvailable"));
                if (!bRTCPeer.hasFiredPublishResult()) {
                    bRTCPeer.setHasFiredPublishResult(true);
                    this.mRtcEventObserver.onPublishResult(n2, string2);
                }
                this.mRtcEventObserver.onRemoteVideoAvailable(string2, n2, true);
            } else {
                LogUtil.d((Object)TAG, (String)("uid=" + string2 + ", sessType=" + n2 + ", from onUserVideoAvailable. brtcPeer.isAudioAttach()" + bRTCPeer.isAudioAttach()));
                this.mRtcEventObserver.onRemoteVideoAvailable(string2, n2, false);
                if (!bRTCPeer.isAudioAttach()) {
                    bRTCPeer.setHasFiredPublishResult(false);
                    this.mAllPeers.remove(n);
                }
            }
        }
    }

    public void onUserSubStreamAvailable(String string, boolean bl) {
        LogUtil.d((Object)TAG, (String)("onUserSubStreamAvailable(uid:" + string + ", available: " + bl));
    }

    public void onLocalVideoFallback(boolean bl) {
    }

    public void onRemoteVideoFallback(String string, boolean bl) {
    }

    public void onError(int n, String string, Bundle bundle) {
        LogUtil.i((Object)TAG, (String)("onError: " + n + ", errMsg=" + string));
        Object object = object.mRtcEventObserver;
        if (object != null) {
            BJYRtcErrors bJYRtcErrors;
            BRTCSdkEventHandler bRTCSdkEventHandler = object;
            object = bJYRtcErrors;
            bJYRtcErrors = new BJYRtcErrors(n, string);
            ((BJYRtcEventObserver)((Object)bRTCSdkEventHandler)).onOccurError((BJYRtcErrors)object);
        }
    }

    public void onConnectionLost() {
    }

    public void onTryToReconnect() {
    }

    public void onConnectionRecovery() {
    }

    public void onStatistics(BRTCStatistics bRTCStatistics) {
        BRTCStatistics bRTCStatistics2 = bRTCStatistics;
        Object object = bRTCStatistics2.localArray;
        for (Object object2 : bRTCStatistics2.remoteArray) {
            BJYRtcEventObserver.RemoteStreamStats remoteStreamStats;
            BJYRtcEventObserver.RemoteStreamStats remoteStreamStats2;
            String string = ((BRTCStatistics.BRTCRemoteStatistics)object2).userId;
            BJYRtcEventObserver.RemoteStreamStats remoteStreamStats3 = remoteStreamStats2 = remoteStreamStats;
            remoteStreamStats2();
            remoteStreamStats2.uid = string;
            remoteStreamStats2.fps = ((BRTCStatistics.BRTCRemoteStatistics)object2).frameRate;
            remoteStreamStats2.height = ((BRTCStatistics.BRTCRemoteStatistics)object2).height;
            remoteStreamStats2.receivedVideoBitrate = ((BRTCStatistics.BRTCRemoteStatistics)object2).videoBitrate;
            remoteStreamStats2.receivedAudioBitrate = ((BRTCStatistics.BRTCRemoteStatistics)object2).audioBitrate;
            remoteStreamStats3.width = ((BRTCStatistics.BRTCRemoteStatistics)object2).width;
            remoteStreamStats3.sessType = BJYRtcCommon.BJYSessionType.BJY_SESSION_CAMERA_MASTER;
            remoteStreamStats.receivedVideoLostRate = ((BRTCStatistics.BRTCRemoteStatistics)object2).finalLoss;
            object2 = this.mRtcEventObserver;
            if (object2 == null) continue;
            ((BJYRtcEventObserver)object2).onRemoteStreamStats(string, remoteStreamStats2);
        }
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            BJYRtcEventObserver.LocalStreamStats localStreamStats;
            Object object2;
            Object object3 = (BRTCStatistics.BRTCLocalStatistics)object.next();
            object2 = localStreamStats;
            Object object4 = object2;
            Object object5 = object2;
            ((BJYRtcEventObserver.LocalStreamStats)object2)();
            ((BJYRtcEventObserver.LocalStreamStats)object2).audioBitrateSent = ((BRTCStatistics.BRTCLocalStatistics)object3).audioBitrate;
            ((BJYRtcEventObserver.LocalStreamStats)object2).videoBitrateSent = ((BRTCStatistics.BRTCLocalStatistics)object3).videoBitrate;
            ((BJYRtcEventObserver.LocalStreamStats)object2).fpsSent = ((BRTCStatistics.BRTCLocalStatistics)object3).frameRate;
            ((BJYRtcEventObserver.LocalStreamStats)object2).width = ((BRTCStatistics.BRTCLocalStatistics)object3).width;
            object5.height = ((BRTCStatistics.BRTCLocalStatistics)object3).height;
            object5.sessionType = BJYRtcCommon.BJYSessionType.BJY_SESSION_CAMERA_MASTER;
            int n = bRTCStatistics.upLoss;
            object4.videoPacketsLostRateSent = n;
            object4.uploadLossRate = n;
            localStreamStats.downloadLossRate = bRTCStatistics.downLoss;
            object3 = this.mRtcEventObserver;
            if (object3 == null) continue;
            ((BJYRtcEventObserver)object3).onLocalStreamStats((BJYRtcEventObserver.LocalStreamStats)object2);
        }
    }

    public void onUserVoiceVolume(ArrayList<BRTCDef.BRTCVolumeInfo> arrayList, int n) {
    }

    public void onMissCustomCmdMsg(String string, int n, int n2, int n3) {
    }

    public void onSwitchRole(int n, String string) {
    }

    public void onAudioRouteChange(BRTCDef.BRTCAudioRoute bRTCAudioRoute) {
    }

    public void onCameraDidReady() {
    }

    public void onMicDidReady() {
    }

    public void onAudioRecordSilencedNotify(boolean bl) {
    }

    public void onScreenCaptureStarted() {
        BJYRtcEventObserver bJYRtcEventObserver = ((BRTCSdkEventHandler)((Object)bJYRtcEventObserver)).mRtcEventObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onScreenCaptureStarted();
        }
    }

    public void onScreenCapturePaused() {
        BJYRtcEventObserver bJYRtcEventObserver = ((BRTCSdkEventHandler)((Object)bJYRtcEventObserver)).mRtcEventObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onScreenCapturePaused();
        }
    }

    public void onScreenCaptureResumed() {
        BJYRtcEventObserver bJYRtcEventObserver = ((BRTCSdkEventHandler)((Object)bJYRtcEventObserver)).mRtcEventObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onScreenCaptureResumed();
        }
    }

    public void onScreenCaptureStoped(int n) {
        BJYRtcEventObserver bJYRtcEventObserver = ((BRTCSdkEventHandler)((Object)bJYRtcEventObserver)).mRtcEventObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onScreenCaptureStoped(n);
        }
    }

    public void onRecvSEIMsg(String string, byte[] byArray) {
    }

    public void onRecvCustomCmdMsg(String string, int n, int n2, byte[] byArray) {
    }

    public void onStartTranscode(String string) {
    }

    public void onStopTranscode(String string) {
    }
}

