/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.baijiayun.bjyrtcengine.BJYRtcEngine;
import com.baijiayun.bjyrtcengine.BJYRtcEventObserver;
import com.baijiayun.bjyrtcengine.BRTCVideoEncConfig;
import com.baijiayun.bjyrtcengine.BaseAdapter;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.baijiayun.bjyrtcengine.Enums;
import com.baijiayun.bjyrtcengine.EventHandler.BRTCSdkEventHandler;
import com.baijiayun.bjyrtcengine.R;
import com.baijiayun.bjyrtcengine.Tools.Utility;
import com.baijiayun.bjyrtcengine.VideoBaseProps;
import com.baijiayun.bjyrtcengine.VideoEncConfig;
import com.baijiayun.bjyrtcengine.player.RtmpEngine;
import com.baijiayun.utils.LogUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.brtc.sdk.BRTC;
import org.brtc.sdk.BRTCDef;
import org.brtc.sdk.BRTCListener;

public class BRTCAdapter
extends BaseAdapter {
    private static final String TAG = "bjyrtc-BRTCAdapter";
    private BRTC mBRTCEngine;
    private BRTCDef.BRTCParams mBRTCParams;
    private String mAppId;
    private String mUid;
    private String mRoomId;
    private BJYRtcCommon.BJYEngineType mEngineType = BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_TRTC;
    private BRTCSdkEventHandler mBRTCSdkEventHandler;
    private boolean mFrontCamera = true;
    private boolean mOldStatus = false;
    private int mWebrtcType = 1;
    private int mStreamType = 1;
    private int[] mVideoLossRate = new int[]{20, 20};
    private int[] mAudioLossRate = new int[]{30, 30};
    private int[] mPubFps = new int[]{5, 5};
    private int[] mSubFps = new int[]{5, 5};
    private int[] mWin = new int[]{6, 6};
    private boolean isStartLocalPreview = false;
    private boolean isMusicModeOn = false;
    private BRTCDef.BRTCVideoEncParam smallVideoParam = new BRTCDef.BRTCVideoEncParam();
    private BJYRtcCommon.DualStreamType defaultVideoStreamType = BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH;
    private BRTCDef.BRTCVideoRotation localRotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_0;
    private BRTCDef.BRTCVideoResolutionMode resolutionMode = BRTCDef.BRTCVideoResolutionMode.BRTCVideoResolutionModeLandscape;
    private Gson gson = new Gson();
    private JsonParser jsonParser = new JsonParser();
    private Map<String, BJYRtcCommon.DualStreamType> streamTypeMap = new HashMap<String, BJYRtcCommon.DualStreamType>();
    BRTCDef.BRTCRenderParams renderParams = new BRTCDef.BRTCRenderParams();
    private boolean isStartLocalAudio = false;
    private boolean isLiveEE = false;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public BRTCAdapter(Context context) {
        super(context);
        this.mContext = context;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJson(int n, Context object) {
        StringBuilder stringBuilder;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        Closeable closeable = object.getResources().openRawResource(n);
        if (closeable == null) {
            return "";
        }
        object = inputStreamReader;
        inputStreamReader = new InputStreamReader((InputStream)closeable);
        closeable = bufferedReader;
        bufferedReader = new BufferedReader((Reader)object);
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        while (true) {
            Object object2;
            String string;
            try {
                string = ((BufferedReader)closeable).readLine();
                if (string == null) break;
            }
            catch (IOException iOException) {
                return null;
            }
            {
                Object object3 = object;
                object2 = object3;
                ((StringBuilder)object3).append(string);
            }
            {
                ((StringBuilder)object2).append('\n');
            }
        }
        return ((StringBuilder)object).toString();
    }

    private boolean isGoodJsonString(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        try {
            new JsonParser().parse(string);
        }
        catch (JsonParseException jsonParseException) {
            return false;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            return false;
        }
        return true;
    }

    private void initDomain(Context context) {
        int n = context.getSharedPreferences("brtc", 0).getInt("kDeployType", 0);
        String string = n != 1 ? (n != 2 ? "https://brtc-api.baijiayun.com" : "https://brtc-apitest.baijiayun.com") : "https://brtc-apibeta.baijiayun.com";
        this.mBRTCEngine.callExperimentalAPI("{\"brtc.global.config\":{\"api_url\":\"" + string + "\"}}");
    }

    private BRTCDef.BRTCVideoStreamType getBRTCStreamType(String string) {
        BRTCAdapter bRTCAdapter = this;
        BJYRtcCommon.DualStreamType dualStreamType = bRTCAdapter.defaultVideoStreamType;
        if (bRTCAdapter.streamTypeMap.containsKey(string)) {
            dualStreamType = this.streamTypeMap.get(string);
        }
        return dualStreamType == BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH ? BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeBig : BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeSmall;
    }

    private void startLocalAudio() {
        BRTCAdapter bRTCAdapter = bRTCAdapter2;
        BRTCAdapter bRTCAdapter2 = bRTCAdapter.mBRTCEngine;
        BRTCDef.BRTCAudioQuality bRTCAudioQuality = bRTCAdapter.isMusicModeOn ? BRTCDef.BRTCAudioQuality.BRTCAudioQualityMusic : BRTCDef.BRTCAudioQuality.BRTCAudioQualityDefault;
        bRTCAdapter2.startLocalAudio(bRTCAudioQuality);
    }

    private void stopLocalAudio() {
        this.mBRTCEngine.stopLocalAudio();
    }

    private void firstPublishVideo() {
        BRTCAdapter bRTCAdapter = this;
        BRTCDef.BRTCVideoEncParam bRTCVideoEncParam = ((BRTCVideoEncConfig.BRTCVideoProps)bRTCAdapter.mVideoEncConfig.getSelectedVideoProp()).brtcVideoParam;
        ((BRTCVideoEncConfig.BRTCVideoProps)bRTCAdapter.mVideoEncConfig.getSelectedVideoProp()).brtcVideoParam.resolutionMode = this.resolutionMode;
        bRTCAdapter.mBRTCEngine.setVideoEncoderParam(bRTCVideoEncParam);
        bRTCAdapter.mBRTCEngine.muteLocalVideo(false);
        bRTCAdapter.isStartLocalPreview = true;
    }

    private void updateVideoResolution(int n, int n2) {
        VideoEncConfig videoEncConfig = this.mVideoEncConfig;
        if (videoEncConfig == null) {
            return;
        }
        if (!videoEncConfig.selectVideoByResolution(n, n2)) {
            return;
        }
        BRTCVideoEncConfig.BRTCVideoProps bRTCVideoProps = (BRTCVideoEncConfig.BRTCVideoProps)this.mVideoEncConfig.getSelectedVideoProp();
        if (bRTCVideoProps != null && this.mBRTCEngine != null && (bRTCVideoProps = bRTCVideoProps.brtcVideoParam) != null) {
            BRTCDef.BRTCVideoEncParam bRTCVideoEncParam;
            BRTCDef.BRTCVideoEncParam bRTCVideoEncParam2 = bRTCVideoEncParam;
            bRTCVideoEncParam2();
            bRTCVideoEncParam2.bandWidth = ((BRTCDef.BRTCVideoEncParam)bRTCVideoProps).bandWidth;
            bRTCVideoEncParam2.resolutionMode = ((BRTCDef.BRTCVideoEncParam)bRTCVideoProps).resolutionMode;
            bRTCVideoEncParam2.fps = ((BRTCDef.BRTCVideoEncParam)bRTCVideoProps).fps;
            bRTCVideoEncParam2.width = ((BRTCDef.BRTCVideoEncParam)bRTCVideoProps).width;
            bRTCVideoEncParam2.height = ((BRTCDef.BRTCVideoEncParam)bRTCVideoProps).height;
            LogUtil.i((Object)TAG, (String)("change video resolution: " + bRTCVideoEncParam2.width + "x" + bRTCVideoEncParam2.height + "@" + bRTCVideoEncParam2.fps + ", bitrate_mode:" + bRTCVideoEncParam2.bandWidth));
            bRTCVideoEncParam.resolutionMode = this.resolutionMode;
            if (this.isLiveEE && this.mEngineType == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_VLOUD) {
                this.handleBV(bRTCVideoEncParam2);
            }
            BRTCAdapter bRTCAdapter = this;
            LogUtil.i((Object)TAG, (String)("change video resolution: " + bRTCVideoEncParam2.width + "x" + bRTCVideoEncParam2.height + "@" + bRTCVideoEncParam2.fps + ", bitrate_mode:" + bRTCVideoEncParam2.bandWidth));
            bRTCAdapter.mBRTCEngine.setVideoEncoderParam(bRTCVideoEncParam2);
            bRTCAdapter.setEncVideoMirrorMode(bRTCAdapter.mVideoEncMirrorMode);
        }
    }

    private void handleBV(BRTCDef.BRTCVideoEncParam bRTCVideoEncParam) {
        BRTCDef.BRTCVideoEncParam bRTCVideoEncParam2 = bRTCVideoEncParam;
        int n = bRTCVideoEncParam2.width;
        bRTCVideoEncParam2.width = bRTCVideoEncParam2.height;
        bRTCVideoEncParam2.height = n;
    }

    @Override
    public boolean isPublished() {
        return super.isPublished();
    }

    @Override
    public boolean isAudioAttached() {
        return this.isAudioAttached;
    }

    @Override
    public void setPublished(boolean bl) {
        super.setPublished(bl);
    }

    @Override
    public void enableLogReport(boolean bl) {
        super.enableLogReport(bl);
    }

    @Override
    public String getSdkVersion() {
        if (this.mBRTCEngine == null) {
            this.mBRTCEngine = BRTC.sharedInstance((Context)this.mContext);
        }
        return this.mBRTCEngine.getSDKVersion();
    }

    @Override
    public boolean initEngine(Map<String, Object> map) {
        Object object;
        BRTCAdapter bRTCAdapter = this;
        bRTCAdapter.mBRTCSdkEventHandler = new BRTCSdkEventHandler(this);
        bRTCAdapter.mBRTCEngine = BRTC.sharedInstance((Context)bRTCAdapter.mContext);
        LogUtil.i((Object)TAG, (String)("BRTC instance: " + this.mBRTCEngine));
        bRTCAdapter.mBRTCEngine.setListener((BRTCListener)this.mBRTCSdkEventHandler);
        bRTCAdapter.mBRTCEngine.setConsoleEnabled(true);
        bRTCAdapter.mBRTCEngine.setLogLevel(BRTCDef.BRTCLogLevel.BRTCLogLevelDebug);
        bRTCAdapter.mBRTCEngine.setLogDirPath(this.mContext.getExternalFilesDir(null) + "/bjyLogFile/log/brtc");
        bRTCAdapter.mBRTCEngine.getDeviceManager().setSystemVolumeType(BRTCDef.BRTCSystemVolumeType.BRTCSystemVolumeTypeVOIP);
        bRTCAdapter.mBRTCEngine.setGSensorMode(BRTCDef.BRTCGSensorMode.BRTC_GSENSOR_MODE_UIAUTOLAYOUT);
        String string = BRTCAdapter.getJson(R.raw.brtc_extra_params, this.mContext);
        if (map.get("extra_params") != null && this.isGoodJsonString((String)(object = String.valueOf(map.get("extra_params"))))) {
            JsonObject jsonObject;
            JsonObject jsonObject2 = jsonObject;
            jsonObject = new JsonObject();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                string = this.jsonParser.parse(string).getAsJsonObject();
                for (String string2 : string.keySet()) {
                    jsonObject2.add(string2, string.get(string2));
                }
            }
            string = this.jsonParser.parse((String)object).getAsJsonObject();
            for (Object object2 : string.keySet()) {
                jsonObject2.add((String)object2, string.get((String)object2));
            }
            string = this.gson.toJson((JsonElement)jsonObject2);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mBRTCEngine.callExperimentalAPI(string);
        }
        BRTCAdapter bRTCAdapter2 = this;
        this.mToken = String.valueOf(map.get("token"));
        this.mAppId = String.valueOf(map.get("appId"));
        bRTCAdapter2.mEngineType = (BJYRtcCommon.BJYEngineType)((Object)map.get("engine_type"));
        bRTCAdapter2.mVideoEncConfig = new BRTCVideoEncConfig();
        LogUtil.cleanLogFile();
        bRTCAdapter2.initDomain(bRTCAdapter2.mContext);
        return true;
    }

    @Override
    public boolean setBlockConfig(List<Map<String, Object>> list) {
        for (int i = 0; i < list.size(); ++i) {
            int n;
            Map<String, Object> map;
            block27: {
                map = list.get(i);
                BRTCAdapter bRTCAdapter = this;
                int n2 = (int)Double.parseDouble(String.valueOf(map.get("webrtcType")));
                bRTCAdapter.mWebrtcType = n2;
                n = (int)Double.parseDouble(String.valueOf(map.get("streamType")));
                this.mStreamType = n;
                if (this.mWebrtcType != 2) continue;
                if (n != 1) break block27;
                BRTCAdapter bRTCAdapter2 = this;
                BRTCAdapter bRTCAdapter3 = bRTCAdapter2;
                BRTCAdapter bRTCAdapter4 = bRTCAdapter2;
                BRTCAdapter bRTCAdapter5 = bRTCAdapter2;
                BRTCAdapter bRTCAdapter6 = bRTCAdapter2;
                int[] nArray = bRTCAdapter2.mVideoLossRate;
                n = 0;
                int n3 = (int)Double.parseDouble(String.valueOf(map.get("videoLossRate")));
                nArray[n] = n3;
                int[] nArray2 = bRTCAdapter4.mAudioLossRate;
                n = 0;
                int n4 = (int)Double.parseDouble(String.valueOf(map.get("audioLossRate")));
                nArray2[n] = n4;
                int[] nArray3 = bRTCAdapter5.mPubFps;
                n = 0;
                int n5 = (int)Double.parseDouble(String.valueOf(map.get("pubFps")));
                nArray3[n] = n5;
                int[] nArray4 = bRTCAdapter6.mSubFps;
                n = 0;
                int n6 = (int)Double.parseDouble(String.valueOf(map.get("subFps")));
                nArray4[n] = n6;
                int[] nArray5 = bRTCAdapter3.mWin;
                int n7 = 0;
                int n8 = (int)Double.parseDouble(String.valueOf(map.get("win")));
                nArray5[n7] = n8;
                continue;
            }
            if (n != 2) continue;
            BRTCAdapter bRTCAdapter = this;
            BRTCAdapter bRTCAdapter7 = bRTCAdapter;
            BRTCAdapter bRTCAdapter8 = bRTCAdapter;
            BRTCAdapter bRTCAdapter9 = bRTCAdapter;
            BRTCAdapter bRTCAdapter10 = bRTCAdapter;
            int[] nArray = bRTCAdapter.mVideoLossRate;
            n = 1;
            int n9 = (int)Double.parseDouble(String.valueOf(map.get("videoLossRate")));
            nArray[n] = n9;
            int[] nArray6 = bRTCAdapter8.mAudioLossRate;
            n = 1;
            int n10 = (int)Double.parseDouble(String.valueOf(map.get("audioLossRate")));
            nArray6[n] = n10;
            int[] nArray7 = bRTCAdapter9.mPubFps;
            n = 1;
            int n11 = (int)Double.parseDouble(String.valueOf(map.get("pubFps")));
            nArray7[n] = n11;
            int[] nArray8 = bRTCAdapter10.mSubFps;
            n = 1;
            int n12 = (int)Double.parseDouble(String.valueOf(map.get("subFps")));
            nArray8[n] = n12;
            int[] nArray9 = bRTCAdapter7.mWin;
            int n13 = 1;
            int n14 = (int)Double.parseDouble(String.valueOf(map.get("win")));
            try {
                nArray9[n13] = n14;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.mStreamType = 0;
                numberFormatException.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        BRTCSdkEventHandler bRTCSdkEventHandler;
        if (this.mBRTCEngine != null && (bRTCSdkEventHandler = this.mBRTCSdkEventHandler) != null && bRTCSdkEventHandler.getJoinRoomState()) {
            BRTCAdapter bRTCAdapter = this;
            bRTCAdapter.mBRTCEngine.muteLocalVideo(true);
            bRTCAdapter.mBRTCEngine.stopLocalAudio();
            bRTCAdapter.mBRTCEngine.muteAllRemoteVideoStreams(true);
            bRTCAdapter.mBRTCEngine.muteAllRemoteAudio(true);
            bRTCAdapter.mBRTCEngine.exitRoom();
        }
        BRTCAdapter bRTCAdapter = this;
        bRTCAdapter.mRtcEventObserver = null;
        bRTCAdapter.executor.execute(BRTC::destroySharedInstance);
        bRTCAdapter.mBRTCEngine = null;
        bRTCAdapter.mBRTCSdkEventHandler.setRtcEngineObserver(null);
        bRTCAdapter.mBRTCSdkEventHandler = null;
    }

    @Override
    public boolean isH264VideoCodecSupported() {
        return false;
    }

    @Override
    public String getMediaServers() {
        return null;
    }

    @Override
    public boolean switchMediaServer(String string) {
        return false;
    }

    @Override
    public int joinRoom(Map<String, Object> object) {
        if (this.mBRTCEngine != null) {
            String string;
            BRTCAdapter bRTCAdapter = this;
            this.mRoomId = String.valueOf(object.get("roomid"));
            bRTCAdapter.mUid = string = String.valueOf(object.get("uid"));
            bRTCAdapter.mLocalUserId = string;
            BRTCAdapter bRTCAdapter2 = this;
            string = bRTCAdapter2.mAppId;
            Object object2 = bRTCAdapter2.mRoomId;
            String string2 = bRTCAdapter2.mUid;
            String string3 = bRTCAdapter2.mToken;
            String string4 = string;
            string = BRTCDef.BRTCRoleType.BRTCRoleAudience;
            bRTCAdapter.mBRTCParams = new BRTCDef.BRTCParams(string4, (String)object2, string2, string3, (BRTCDef.BRTCRoleType)string);
            boolean bl = false;
            object2 = (Map)object.get("webrtc_info");
            if (object2 != null && (object2 = (Map)object2.get("webrtc_ext")) != null) {
                bl = this.parseWebrtcExt((Map<String, Object>)object2);
            }
            Object object3 = object.get("support_live_definition");
            if (!bl && object3 != null) {
                this.parseLiveDefinitionConfig((JsonObject)object3);
            }
            object3 = object.get("small_stream_ratio");
            object2 = object.get("small_stream_height");
            if (object3 != null && object2 != null) {
                VideoBaseProps.VideoResolution videoResolution;
                int n;
                BRTCAdapter bRTCAdapter3 = this;
                this.mSmallStreamRatio = Integer.parseInt(String.valueOf(object3));
                bRTCAdapter3.mSmallStreamHeight = n = Integer.parseInt(String.valueOf(object2));
                VideoBaseProps.VideoResolution videoResolution2 = videoResolution = Utility.getSmallVideoResolution(bRTCAdapter3.mSmallStreamRatio, n);
                int n2 = videoResolution2.width;
                object3 = (BRTCVideoEncConfig.BRTCVideoProps)bRTCAdapter3.mVideoEncConfig.getVideoProp(n2, videoResolution2.height);
                if (object3 != null) {
                    this.smallVideoParam = ((BRTCVideoEncConfig.BRTCVideoProps)object3).brtcVideoParam;
                }
            }
            if ((object3 = this.mBRTCSdkEventHandler) != null) {
                ((BRTCSdkEventHandler)((Object)object3)).setLocalUserId(this.mLocalUserId);
            }
            if (object.containsKey("usernumber")) {
                object = String.valueOf(object.get("usernumber"));
                LogUtil.d((Object)TAG, (String)("joinRoom. usernumber: " + (String)object));
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    JsonObject jsonObject;
                    JsonObject jsonObject2;
                    object = "user_number=" + (String)object + "0";
                    LogUtil.d((Object)TAG, (String)("joinRoom. comments: " + (String)object));
                    object3 = jsonObject2;
                    new JsonObject().addProperty("comments", (String)object);
                    object = jsonObject;
                    new JsonObject().add("brtc.app.config", (JsonElement)object3);
                    this.mBRTCEngine.callExperimentalAPI(object.toString());
                }
            }
            this.mBRTCEngine.enterRoom(this.mBRTCParams);
        }
        return 0;
    }

    @Override
    public void publish(boolean bl, boolean bl2) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null) {
            bRTC.switchRole(BRTCDef.BRTCRoleType.BRTCRoleAnchor);
            if (bl2) {
                if (!this.isStartLocalPreview) {
                    this.firstPublishVideo();
                } else {
                    this.mBRTCEngine.muteLocalVideo(false);
                }
            }
            if (bl) {
                BRTCAdapter bRTCAdapter = this;
                bRTC = bRTCAdapter.mBRTCEngine;
                BRTCDef.BRTCAudioQuality bRTCAudioQuality = bRTCAdapter.isMusicModeOn ? BRTCDef.BRTCAudioQuality.BRTCAudioQualityMusic : BRTCDef.BRTCAudioQuality.BRTCAudioQualityDefault;
                bRTC.startLocalAudio(bRTCAudioQuality);
                this.mBRTCEngine.muteLocalAudio(false);
            }
            this.mSelfPublished = true;
            this.isVideoAttached = bl2;
            this.isAudioAttached = bl;
            if (this.mRtcEventObserver != null) {
                LogUtil.i((Object)TAG, (String)("[callback] onPublishResult, self publish, uid=" + this.mLocalUserId));
                int n = Enums.SessionTypeToInteger(Enums.BJYSessionType.BJY_SESSION_CAMERA_MASTER);
                this.mRtcEventObserver.onPublishResult(n, this.mLocalUserId);
            }
        }
    }

    @Override
    public void publish(boolean bl, boolean bl2, boolean bl3) {
    }

    @Override
    public void unpublish() {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null) {
            BRTCAdapter bRTCAdapter = this;
            bRTC.muteLocalVideo(true);
            bRTCAdapter.mBRTCEngine.stopLocalPreview();
            bRTCAdapter.mBRTCEngine.muteLocalAudio(true);
            bRTCAdapter.mBRTCEngine.stopLocalAudio();
            bRTCAdapter.isStartLocalAudio = false;
        }
        this.mSelfPublished = false;
        this.isVideoAttached = false;
        this.isAudioAttached = false;
        if (this.mRtcEventObserver != null) {
            LogUtil.i((Object)TAG, (String)("[callback] onUnpublishResult, uid=" + this.mLocalUserId));
            int n = Enums.SessionTypeToInteger(Enums.BJYSessionType.BJY_SESSION_CAMERA_MASTER);
            this.mRtcEventObserver.onUnpublishResult(n, this.mLocalUserId);
        }
    }

    @Override
    public void subscribe(String string, boolean bl, boolean bl2, int n) {
        if (((BRTCAdapter)((Object)bJYRtcEventObserver)).mBRTCEngine != null) {
            BRTCAdapter bRTCAdapter = bJYRtcEventObserver;
            String string2 = Enums.convertUid(string, n);
            LogUtil.d((Object)TAG, (String)("subscribe uid: " + string + " type: " + n + " brtcId: " + string2));
            BRTCDef.BRTCVideoStreamType bRTCVideoStreamType = BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeBig;
            bRTCAdapter.mBRTCEngine.muteRemoteVideoStream(string2, bRTCVideoStreamType, bl2 ^ true);
            bRTCAdapter.mBRTCEngine.setRemoteVideoStreamType(string2, ((BRTCAdapter)((Object)bJYRtcEventObserver)).getBRTCStreamType(string));
            bRTCAdapter.mBRTCEngine.muteRemoteAudio(string2, bl ^ true);
            BJYRtcEventObserver bJYRtcEventObserver = bRTCAdapter.mRtcEventObserver;
            if (bJYRtcEventObserver != null) {
                bJYRtcEventObserver.onSubscribeResult(n, string, null);
            }
        }
    }

    @Override
    public void unsubscribe(String string, int n) {
        this.unsubscribe(string, n, true);
    }

    @Override
    public void unsubscribe(String string, int n, boolean bl) {
        if (this.mBRTCEngine != null) {
            BRTCAdapter bRTCAdapter = this;
            String string2 = Enums.convertUid(string, n);
            bRTCAdapter.mBRTCEngine.muteRemoteAudio(string2, true);
            bRTCAdapter.mBRTCEngine.stopRemoteView(string2, this.getBRTCStreamType(string));
            if (bRTCAdapter.mRtcEventObserver != null && bl) {
                LogUtil.d((Object)TAG, (String)("[callback] onUnsubscribeResult, uid=" + string + ", type=" + n));
                this.mRtcEventObserver.onUnsubscribeResult(n, string);
            }
        }
    }

    @Override
    public void play(String string, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas, int n) {
        String string2 = Enums.convertUid(string, n);
        bJYVideoCanvas.setSessionType(n);
        if (bRTCAdapter.mBRTCEngine != null) {
            LogUtil.i((Object)TAG, (String)("startRemoteView, id=" + string2));
            BRTCAdapter bRTCAdapter = bRTCAdapter.getBRTCStreamType(string);
            bRTCAdapter.mBRTCEngine.startRemoteView(string2, (BRTCDef.BRTCVideoStreamType)bRTCAdapter, bJYVideoCanvas.getBRTCCanvas());
        }
    }

    @Override
    public int muteLocalMic(boolean bl) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC == null) {
            return -1;
        }
        this.isAudioAttached = bl ^ true;
        if (!bl && !this.isStartLocalAudio) {
            BRTCDef.BRTCAudioQuality bRTCAudioQuality = this.isMusicModeOn ? BRTCDef.BRTCAudioQuality.BRTCAudioQualityMusic : BRTCDef.BRTCAudioQuality.BRTCAudioQualityDefault;
            bRTC.startLocalAudio(bRTCAudioQuality);
            this.isStartLocalAudio = true;
        }
        this.mBRTCEngine.muteLocalAudio(bl);
        return 0;
    }

    @Override
    public int muteLocalCamera(boolean bl) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC == null) {
            return -1;
        }
        this.isVideoAttached = bl ^ true;
        bRTC.muteLocalVideo(bl);
        return 0;
    }

    @Override
    public int enableSpeakerphone(boolean bl) {
        return 0;
    }

    @Override
    public int switchCamera() {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null) {
            this.mFrontCamera ^= true;
            bRTC.getDeviceManager().switchCamera(this.mFrontCamera);
        }
        return 0;
    }

    @Override
    public void setRtcEngineObserver(BJYRtcEventObserver bJYRtcEventObserver) {
        object.mRtcEventObserver = bJYRtcEventObserver;
        Object object = object.mBRTCSdkEventHandler;
        if (object != null) {
            ((BRTCSdkEventHandler)((Object)object)).setRtcEngineObserver(bJYRtcEventObserver);
        }
    }

    @Override
    public void setAudioFrameListener(BRTCListener.BRTCAudioFrameListener bRTCAudioFrameListener) {
        this.mBRTCEngine.setAudioFrameListener(bRTCAudioFrameListener);
    }

    @Override
    public void startPreview(boolean bl, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null) {
            this.mFrontCamera = bl;
            bRTC.startLocalPreview(bl, bJYVideoCanvas.getBRTCCanvas());
        }
    }

    @Override
    public void startPreview(BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas) {
        this.startPreview(true, bJYVideoCanvas);
    }

    @Override
    public void stopPreview() {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.stopLocalPreview();
        }
    }

    @Override
    public BJYRtcEngine.BJYVideoCanvas createVideoCanvas(String string, boolean bl) {
        BRTCAdapter bRTCAdapter = bRTCAdapter2;
        BRTCAdapter bRTCAdapter2 = bRTCAdapter.mContext;
        BJYRtcCommon.BJYEngineType bJYEngineType = bRTCAdapter.mEngineType;
        BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas2 = new BJYRtcEngine.BJYVideoCanvas((Context)bRTCAdapter2, string, bl, bJYEngineType);
        bJYVideoCanvas2.addVideoRenderModeChangedListener((bJYVideoCanvas, bJYRtcRenderMode) -> {
            if (TextUtils.equals((CharSequence)this.mLocalUserId, (CharSequence)bJYVideoCanvas.getUid())) {
                bJYVideoCanvas = this.mBRTCEngine;
                if (bJYVideoCanvas != null) {
                    BRTCDef.BRTCRenderParams bRTCRenderParams = this.renderParams;
                    this.renderParams.rotation = this.localRotation;
                    if (bJYRtcRenderMode == BJYRtcCommon.BJYRtcRenderMode.BJYRtcRenderModeFill) {
                        bRTCRenderParams.fillMode = BRTCDef.BRTCVideoFillMode.BRTCVideoFillMode_Fill;
                    } else if (bJYRtcRenderMode == BJYRtcCommon.BJYRtcRenderMode.BJYRtcRenderModeFit) {
                        bRTCRenderParams.fillMode = BRTCDef.BRTCVideoFillMode.BRTCVideoFillMode_Fit;
                    }
                    bJYVideoCanvas.setLocalRenderParams(bRTCRenderParams);
                }
            } else {
                BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas2 = bJYVideoCanvas;
                int n = bJYVideoCanvas2.getSessionType();
                String string = Enums.convertUid(bJYVideoCanvas2.getUid(), n);
                if (this.mBRTCEngine != null) {
                    BRTCDef.BRTCRenderParams bRTCRenderParams;
                    BRTCDef.BRTCRenderParams bRTCRenderParams2 = bRTCRenderParams;
                    bRTCRenderParams = new BRTCDef.BRTCRenderParams();
                    if (bJYRtcRenderMode == BJYRtcCommon.BJYRtcRenderMode.BJYRtcRenderModeFill) {
                        bRTCRenderParams2.fillMode = BRTCDef.BRTCVideoFillMode.BRTCVideoFillMode_Fill;
                    } else if (bJYRtcRenderMode == BJYRtcCommon.BJYRtcRenderMode.BJYRtcRenderModeFit) {
                        bRTCRenderParams2.fillMode = BRTCDef.BRTCVideoFillMode.BRTCVideoFillMode_Fit;
                    }
                    this.mBRTCEngine.setRemoteRenderParams(string, BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeBig, bRTCRenderParams2);
                }
            }
        });
        return bJYVideoCanvas2;
    }

    @Override
    public void muteRemoteAudio(String string, boolean bl, int n) {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.muteRemoteAudio(string, bl);
        }
    }

    @Override
    public void muteRemoteVideo(String string, boolean bl, int n) {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.muteRemoteVideoStream(string, BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeBig, bl);
        }
    }

    @Override
    public void unmuteRemoteVideo(String string, BJYRtcEngine.BJYVideoCanvas bJYVideoCanvas, int n) {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.muteRemoteVideoStream(string, BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeBig, false);
        }
    }

    @Override
    public void muteAllRemoteAudio(boolean bl) {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.muteAllRemoteAudio(bl);
        }
    }

    @Override
    public void muteAllRemoteVideo(boolean bl) {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.muteAllRemoteVideoStreams(bl);
        }
    }

    @Override
    public boolean getRemoteStreamStatus(String string, int n) {
        return false;
    }

    @Override
    public void changeVideoResolutionByLevel(int n) {
        VideoBaseProps.VideoResolution videoResolution = Utility.getVideoResolutionByLevel(n);
        int n2 = videoResolution.width;
        this.updateVideoResolution(n2, videoResolution.height);
    }

    @Override
    public void changeVideoResolutionByLevel(int n, int n2) {
        this.updateVideoResolution(n, n2);
    }

    @Override
    public void saveScreenshot(String string, int n) {
    }

    @Override
    public boolean isVideoAttached() {
        return this.isVideoAttached;
    }

    @Override
    public void phoneStateChanged(boolean bl) {
        BRTCSdkEventHandler bRTCSdkEventHandler = this.mBRTCSdkEventHandler;
        if (bRTCSdkEventHandler != null && !bRTCSdkEventHandler.getJoinRoomState()) {
            return;
        }
        LogUtil.d((Object)TAG, (String)("Phone state:" + bl));
        if (bl) {
            BRTCAdapter bRTCAdapter = this;
            bRTCAdapter.mOldStatus = bRTCAdapter.isAudioAttached;
            if (bRTCAdapter.mBRTCEngine != null) {
                BRTCAdapter bRTCAdapter2 = this;
                bRTCAdapter2.stopLocalAudio();
                bRTCAdapter2.mBRTCEngine.muteAllRemoteAudio(true);
            }
        } else if (this.mBRTCEngine != null) {
            if (!this.mOldStatus && !this.isAudioAttached) {
                this.stopLocalAudio();
            } else {
                this.startLocalAudio();
            }
            this.mBRTCEngine.muteAllRemoteAudio(false);
        }
        RtmpEngine.getInstance(this.mContext).stopOrRestartAvStream(bl, null);
    }

    @Override
    public void setRtcLagConfigs(int n, int n2, int n3, int n4) {
    }

    @Override
    public void setLocalVideoMirror(BJYRtcCommon.VideoMirrorMode videoMirrorMode) {
        BRTC bRTC = bRTCAdapter.mBRTCEngine;
        if (bRTC != null) {
            BRTCAdapter bRTCAdapter = bRTCAdapter.renderParams;
            bRTCAdapter.renderParams.rotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_0;
            bRTCAdapter.renderParams.mirrorType = BRTCDef.BRTCVideoMirrorType.BRTCVideoMirrorTypeDisable;
            if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.HORIZONTAL_MIRROR) {
                ((BRTCDef.BRTCRenderParams)bRTCAdapter).mirrorType = BRTCDef.BRTCVideoMirrorType.BRTCVideoMirrorTypeEnable;
            } else if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.VERTICAL_MIRROR) {
                BRTCAdapter bRTCAdapter2 = bRTCAdapter;
                ((BRTCDef.BRTCRenderParams)bRTCAdapter2).rotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_180;
                ((BRTCDef.BRTCRenderParams)bRTCAdapter2).mirrorType = BRTCDef.BRTCVideoMirrorType.BRTCVideoMirrorTypeEnable;
            } else if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.HORIZONTAL_VERTICAL_MIRROR) {
                ((BRTCDef.BRTCRenderParams)bRTCAdapter).rotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_180;
            }
            bRTC.setLocalRenderParams((BRTCDef.BRTCRenderParams)bRTCAdapter);
        }
    }

    @Override
    public void setEncVideoMirrorMode(BJYRtcCommon.VideoMirrorMode videoMirrorMode) {
        VideoEncConfig videoEncConfig = this.mVideoEncConfig;
        if (videoEncConfig == null) {
            return;
        }
        if ((BRTCVideoEncConfig.BRTCVideoProps)videoEncConfig.getSelectedVideoProp() != null && (videoEncConfig = this.mBRTCEngine) != null) {
            this.mVideoEncMirrorMode = videoMirrorMode;
            int n = 0;
            if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.HORIZONTAL_MIRROR) {
                n = 1;
            } else if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.VERTICAL_MIRROR) {
                n = 2;
            } else if (videoMirrorMode == BJYRtcCommon.VideoMirrorMode.HORIZONTAL_VERTICAL_MIRROR) {
                n = 3;
            }
            videoEncConfig.callExperimentalAPI("{\"brtc.video.params\":{\"enc_mirror\":" + n + "}}");
            this.mBRTCEngine.setGSensorMode(BRTCDef.BRTCGSensorMode.BRTC_GSENSOR_MODE_UIAUTOLAYOUT);
        }
    }

    @Override
    public BJYRtcCommon.VideoMirrorMode getEncVideoMirrorMode() {
        return super.getEncVideoMirrorMode();
    }

    @Override
    public int enableDualStreamMode(boolean bl) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null) {
            return bRTC.enableEncSmallVideoStream(bl, this.smallVideoParam);
        }
        return -1;
    }

    @Override
    public int setRemoteVideoStreamType(String string, int n, BJYRtcCommon.DualStreamType dualStreamType) {
        BRTCAdapter bRTCAdapter = bRTCAdapter2;
        bRTCAdapter.streamTypeMap.put(string, dualStreamType);
        BRTCAdapter bRTCAdapter2 = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter2 != null) {
            BRTCDef.BRTCVideoStreamType bRTCVideoStreamType = dualStreamType == BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH ? BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeBig : BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeSmall;
            bRTCAdapter2.setRemoteVideoStreamType(string, bRTCVideoStreamType);
        }
        return -1;
    }

    @Override
    public int setRemoteDefaultVideoStreamType(BJYRtcCommon.DualStreamType dualStreamType) {
        this.defaultVideoStreamType = dualStreamType;
        return super.setRemoteDefaultVideoStreamType(dualStreamType);
    }

    @Override
    public boolean isFrontCamera() {
        return this.mFrontCamera;
    }

    @Override
    public void setLocalViewRotation(BJYRtcCommon.VideoRotation videoRotation) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null) {
            BRTCDef.BRTCRenderParams bRTCRenderParams = this.renderParams;
            this.renderParams.rotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_0;
            if (videoRotation == BJYRtcCommon.VideoRotation.Rotation_90) {
                bRTCRenderParams.rotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_90;
            } else if (videoRotation == BJYRtcCommon.VideoRotation.Rotation_180) {
                bRTCRenderParams.rotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_180;
            } else if (videoRotation == BJYRtcCommon.VideoRotation.Rotation_270) {
                bRTCRenderParams.rotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_270;
            }
            this.localRotation = bRTCRenderParams.rotation;
            bRTC.setLocalRenderParams(bRTCRenderParams);
        }
    }

    @Override
    public void setVideoEncoderRotation(BJYRtcCommon.VideoRotation videoRotation) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null) {
            BRTCDef.BRTCVideoRotation bRTCVideoRotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_0;
            if (videoRotation == BJYRtcCommon.VideoRotation.Rotation_90) {
                bRTCVideoRotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_90;
            } else if (videoRotation == BJYRtcCommon.VideoRotation.Rotation_180) {
                bRTCVideoRotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_180;
            } else if (videoRotation == BJYRtcCommon.VideoRotation.Rotation_270) {
                bRTCVideoRotation = BRTCDef.BRTCVideoRotation.BRTCVideoRotation_270;
            }
            bRTC.setVideoEncoderRotation(bRTCVideoRotation);
            this.mBRTCEngine.setGSensorMode(BRTCDef.BRTCGSensorMode.BRTC_GSENSOR_MODE_UIAUTOLAYOUT);
        }
    }

    @Override
    public void setVideoResolutionMode(BJYRtcCommon.VideoResolutionMode videoResolutionMode) {
        this.resolutionMode = videoResolutionMode == BJYRtcCommon.VideoResolutionMode.VIDEO_MODE_LANDSCAPE ? BRTCDef.BRTCVideoResolutionMode.BRTCVideoResolutionModeLandscape : BRTCDef.BRTCVideoResolutionMode.BRTCVideoResolutionModePortrait;
    }

    @Override
    public void startScreenCapture(int n, int n2, View view) {
        if (bRTCAdapter2.mBRTCEngine != null) {
            VideoBaseProps.VideoResolution videoResolution;
            VideoBaseProps.VideoResolution videoResolution2 = videoResolution = Utility.getVideoResolutionByLevel(n2);
            int n3 = videoResolution2.width;
            BRTCVideoEncConfig.BRTCVideoProps bRTCVideoProps = (BRTCVideoEncConfig.BRTCVideoProps)bRTCAdapter2.mVideoEncConfig.getVideoProp(n3, videoResolution2.height);
            if (bRTCVideoProps != null) {
                BRTCDef.BRTCScreenShareParams bRTCScreenShareParams;
                BRTCAdapter bRTCAdapter = bRTCAdapter2;
                BRTCAdapter bRTCAdapter2 = bRTCVideoProps.brtcVideoParam;
                bRTCVideoProps = bRTCScreenShareParams;
                bRTCVideoProps();
                bRTCScreenShareParams.floatingView = view;
                bRTCAdapter.mBRTCEngine.startScreenCapture(n, null, (BRTCDef.BRTCVideoEncParam)bRTCAdapter2, (BRTCDef.BRTCScreenShareParams)bRTCVideoProps);
            }
        }
    }

    @Override
    public void stopScreenCapture() {
        this.stopScreenCapture(true);
    }

    @Override
    public void stopScreenCapture(boolean bl) {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.stopScreenCapture();
        }
    }

    @Override
    public void pauseScreenCapture() {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.pauseScreenCapture();
        }
    }

    @Override
    public void resumeScreenCapture() {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.resumeScreenCapture();
        }
    }

    @Override
    public void setBeautyLevel(float f) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null && bRTC.getBeautyManager() != null) {
            this.mBRTCEngine.getBeautyManager().setBeautyLevel(f);
        }
    }

    @Override
    public void setWhitenessLevel(float f) {
        BRTC bRTC = this.mBRTCEngine;
        if (bRTC != null && bRTC.getBeautyManager() != null) {
            this.mBRTCEngine.getBeautyManager().setWhitenessLevel(f);
        }
    }

    @Override
    public void changeMusicMode(boolean bl) {
        this.isMusicModeOn = bl;
    }

    @Override
    public boolean isMusicModeOn() {
        return this.isMusicModeOn;
    }

    @Override
    public void setEncVideoMirrorModeLandScape(boolean bl) {
        this.isLiveEE = bl ^ true;
    }

    @Override
    public void setDefaultStreamRecvMode(boolean bl, boolean bl2) {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.setDefaultStreamRecvMode(bl, bl2);
        }
    }

    @Override
    public void callExperimentalApi(String string) {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.callExperimentalAPI(string);
        }
    }

    @Override
    public void setNetworkQosPreference(int n, BJYRtcCommon.NetworkQosPreference networkQosPreference) {
        if (this.mBRTCEngine != null) {
            BRTCDef.BRTCVideoStreamType bRTCVideoStreamType = n == 0 ? BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeBig : BRTCDef.BRTCVideoStreamType.BRTCVideoStreamTypeSub;
            BJYRtcCommon.NetworkQosPreference networkQosPreference2 = networkQosPreference;
            BRTCDef.BRTCVideoQosPreference bRTCVideoQosPreference = networkQosPreference2 == BJYRtcCommon.NetworkQosPreference.CLEAR ? BRTCDef.BRTCVideoQosPreference.BRTCVideoQosPreferenceClear : BRTCDef.BRTCVideoQosPreference.BRTCVideoQosPreferenceSmooth;
            networkQosPreference = new BRTCDef.BRTCNetworkQosParam(bRTCVideoQosPreference, bRTCVideoStreamType);
            this.mBRTCEngine.setNetworkQosParam((BRTCDef.BRTCNetworkQosParam)networkQosPreference);
        }
    }

    public void updateRoomConfigAfterJoined() {
        BRTCAdapter bRTCAdapter = bRTCAdapter.mBRTCEngine;
        if (bRTCAdapter != null) {
            bRTCAdapter.getDeviceManager().enableAutoRequestAudioFocus(false);
        }
    }
}

