/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine;

import android.content.Context;
import android.view.SurfaceView;
import android.view.View;
import com.baijiayun.bjyrtcengine.BJYRtcEngineImpl;
import com.baijiayun.bjyrtcengine.BJYRtcEventObserver;
import com.baijiayun.bjyrtcengine.BaseAdapter;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.util.List;
import java.util.Map;
import org.brtc.sdk.BRTCListener;
import org.brtc.sdk.BRTCVideoView;
import org.brtc.sdk.adapter.BRTCAdaptCanvas;

public abstract class BJYRtcEngine {
    private static BJYRtcEngineImpl mInstance;
    protected BaseAdapter mEngineAdapter = null;
    protected BJYRtcEventObserver mObserver = null;
    private BJYRtcCommon.BJYEngineType mEngineType = BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_VLOUD;
    protected String mExternalExtraParams;

    protected BJYRtcEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BJYRtcEngineImpl getInstance() {
        if (mInstance != null) return mInstance;
        Class<BJYRtcEngineImpl> clazz = BJYRtcEngineImpl.class;
        synchronized (BJYRtcEngineImpl.class) {
            if (mInstance != null) return mInstance;
            mInstance = new BJYRtcEngineImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public boolean initEngine(Context object, Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        this.mEngineType = (BJYRtcCommon.BJYEngineType)((Object)map.get("engine_type"));
        object = map.get("extra_params");
        if (object != null) {
            this.mExternalExtraParams = String.valueOf(object);
        }
        return true;
    }

    public BJYRtcCommon.BJYEngineType getEngineType() {
        return this.mEngineType;
    }

    public abstract void setRtcEngineObserver(BJYRtcEventObserver var1);

    public abstract void setAudioFrameListener(BRTCListener.BRTCAudioFrameListener var1);

    public abstract BJYVideoCanvas createVideoCanvas(String var1, boolean var2);

    public abstract String getSdkVersion();

    public abstract boolean checkH264VideoCodecSupported();

    public abstract String getMediaServers();

    public abstract void switchMediaServer(String var1);

    public abstract int joinRoom(Map<String, Object> var1);

    public abstract void startPreview(boolean var1, BJYVideoCanvas var2);

    public abstract void startPreview(BJYVideoCanvas var1);

    public abstract void stopPreview();

    public abstract void dispose();

    public abstract void publish(boolean var1, boolean var2);

    public abstract void unpublish();

    public abstract void subscribe(String var1, boolean var2, boolean var3, int var4);

    public abstract void unsubscribe(String var1, int var2);

    public abstract boolean getRemoteStreamStatus(String var1, int var2);

    public abstract void play(String var1, BJYVideoCanvas var2, int var3);

    public abstract boolean isAudioAttached();

    public abstract boolean isVideoAttached();

    public abstract int muteLocalMic(boolean var1);

    public abstract int muteLocalCamera(boolean var1);

    public abstract int enableSpeakerphone(boolean var1);

    public abstract int switchCamera();

    public abstract boolean isFrontCamera();

    public abstract boolean isPublished();

    public abstract void setVideoResolution(int var1);

    public abstract void setVideoResolution(int var1, int var2);

    public abstract BJYVideoResolution getVideoResolution();

    public abstract void muteRemoteAudio(String var1, boolean var2, int var3);

    public abstract void muteRemoteVideo(String var1, boolean var2, int var3);

    public abstract void unmuteRemoteVideo(String var1, BJYVideoCanvas var2, int var3);

    public abstract void muteAllRemoteAudio(boolean var1);

    public abstract void muteAllRemoteVideo(boolean var1);

    public abstract void saveScreenshot(String var1, int var2);

    public abstract void enableLogReport(boolean var1);

    public abstract void setRtcLagConfigs(int var1, int var2, int var3, int var4);

    public abstract void setLocalVideoMirror(BJYRtcCommon.VideoMirrorMode var1);

    public abstract void setEncVideoMirrorMode(BJYRtcCommon.VideoMirrorMode var1);

    public abstract void setEncVideoMirrorModeLandScape(boolean var1);

    public abstract BJYRtcCommon.VideoMirrorMode getEncVideoMirrorMode();

    public abstract int enableDualStreamMode(boolean var1);

    public abstract int setRemoteVideoStreamType(String var1, int var2, BJYRtcCommon.DualStreamType var3);

    public abstract int setRemoteDefaultVideoStreamType(BJYRtcCommon.DualStreamType var1);

    public abstract boolean setBlockConfig(List<Map<String, Object>> var1);

    public abstract void setVideoResolutionMode(BJYRtcCommon.VideoResolutionMode var1);

    public abstract void setLocalViewRotation(BJYRtcCommon.VideoRotation var1);

    public abstract void setVideoEncoderRotation(BJYRtcCommon.VideoRotation var1);

    public abstract void startScreenCapture(int var1, int var2, View var3);

    public abstract void stopScreenCapture();

    public abstract void stopScreenCapture(boolean var1);

    public abstract void pauseScreenCapture();

    public abstract void resumeScreenCapture();

    public abstract void setBeautyLevel(float var1);

    public abstract void setWhitenessLevel(float var1);

    public abstract void changeMusicMode(boolean var1);

    public abstract boolean isMusicModeOn();

    public abstract void setDefaultStreamRecvMode(boolean var1, boolean var2);

    public abstract void callExperimentalApi(String var1);

    public abstract void setNetworkQosPreference(int var1, BJYRtcCommon.NetworkQosPreference var2);

    public static class BJYVideoCanvas {
        protected View mCanvas;
        private int mSessionType = 0;
        private onVideoRenderModeChangedListener mListener;
        private BJYRtcCommon.BJYRtcRenderMode mRenderMode;
        private BJYRtcCommon.BJYEngineType mEngineType;
        private SurfaceView mTencentSurfaceView;
        private BRTCVideoView mBRTCCanvas;
        private String uid;

        public BJYVideoCanvas(Context context, String string, boolean bl, BJYRtcCommon.BJYEngineType bJYEngineType) {
            bJYVideoCanvas2.mEngineType = bJYEngineType;
            bJYVideoCanvas2.uid = string;
            if (bJYEngineType == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_TENCENT) {
                bJYVideoCanvas2.mTencentSurfaceView = new SurfaceView(context);
                bJYVideoCanvas2.mCanvas = new TXCloudVideoView(bJYVideoCanvas2.mTencentSurfaceView);
                bJYVideoCanvas2.mTencentSurfaceView.setVisibility(0);
            }
            if (bJYEngineType == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_TRTC || bJYEngineType == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_VLOUD) {
                BRTCAdaptCanvas bRTCAdaptCanvas;
                BJYVideoCanvas bJYVideoCanvas = bJYVideoCanvas2;
                BJYVideoCanvas bJYVideoCanvas2 = bRTCAdaptCanvas;
                bJYVideoCanvas.mBRTCCanvas = new BRTCAdaptCanvas(context);
                bJYVideoCanvas.mCanvas = bJYVideoCanvas2.getView();
            }
        }

        public TXCloudVideoView getTXCloudVideoView() {
            View view = this.mCanvas;
            if (view != null && this.mEngineType == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_TENCENT) {
                return (TXCloudVideoView)view;
            }
            return null;
        }

        public BRTCVideoView getBRTCCanvas() {
            BJYRtcCommon.BJYEngineType bJYEngineType;
            if (this.mCanvas != null && ((bJYEngineType = this.mEngineType) == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_TRTC || bJYEngineType == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_BRTC_VLOUD)) {
                return this.mBRTCCanvas;
            }
            return null;
        }

        public View getCanvas() {
            if (this.mEngineType == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_TENCENT) {
                return this.getRenderView();
            }
            return this.mCanvas;
        }

        public View getRenderView() {
            if (bJYVideoCanvas.mEngineType == BJYRtcCommon.BJYEngineType.BJY_ENGINE_TYPE_TENCENT) {
                Object object = bJYVideoCanvas.mTencentSurfaceView;
                if (object != null) {
                    return object;
                }
                object = bJYVideoCanvas.mCanvas;
                if (object != null) {
                    object = ((TXCloudVideoView)object).getSurfaceView();
                    BJYVideoCanvas bJYVideoCanvas = ((TXCloudVideoView)bJYVideoCanvas.mCanvas).getVideoView();
                    if (object == null) {
                        object = bJYVideoCanvas;
                    }
                    return object;
                }
            }
            return null;
        }

        public String getUid() {
            return this.uid;
        }

        public int getSessionType() {
            return this.mSessionType;
        }

        public BJYRtcCommon.BJYRtcRenderMode getRenderMode() {
            return this.mRenderMode;
        }

        public void addVideoRenderModeChangedListener(onVideoRenderModeChangedListener onVideoRenderModeChangedListener2) {
            this.mListener = onVideoRenderModeChangedListener2;
        }

        public void dispose() {
            this.mCanvas = null;
        }

        public void setRenderMode(BJYRtcCommon.BJYRtcRenderMode bJYRtcRenderMode) {
            onVideoRenderModeChangedListener onVideoRenderModeChangedListener2;
            if (this.mCanvas == null) {
                return;
            }
            this.mRenderMode = bJYRtcRenderMode;
            int n = 1.$SwitchMap$com$baijiayun$bjyrtcengine$Defines$BJYRtcCommon$BJYEngineType[this.mEngineType.ordinal()];
            if ((n == 1 || n == 2 || n == 3) && (onVideoRenderModeChangedListener2 = this.mListener) != null) {
                onVideoRenderModeChangedListener2.onRenderModeChanged(this, bJYRtcRenderMode);
            }
        }

        public void setSessionType(int n) {
            this.mSessionType = n;
        }

        public static interface onVideoRenderModeChangedListener {
            public void onRenderModeChanged(BJYVideoCanvas var1, BJYRtcCommon.BJYRtcRenderMode var2);
        }
    }

    public static class BJYVideoResolution {
        public int width;
        public int height;

        public BJYVideoResolution(int n, int n2) {
            this.width = n;
            this.height = n2;
        }
    }
}

