/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine.player;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.baijiayun.bjyrtcengine.player.MediaPlayerObserver;
import com.baijiayun.bjyrtcengine.player.RtmpView;
import com.google.gson.JsonObject;
import tv.danmaku.ijk.media.bjplayer.IMediaPlayer;
import tv.danmaku.ijk.media.bjplayer.IjkMediaPlayer;

public class MediaPlayer {
    private static final String TAG = "bjyrtc-bjyMediaPlayer";
    private IMediaPlayer mPlayer;
    private PLAYER_STATE mState;
    private MediaPlayerObserver mObserver;
    private boolean mEnableMediaCodec;
    private AVParameters mParams;
    private long mPrepareStartTime = 0L;
    private long mPrepareEndTime = 0L;
    private RtmpView mRenderView;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mVideoRotationDegree;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private RtmpView.ISurfaceHolder mSurfaceHolder = null;
    RtmpView.IRenderCallback mSHCallback = new RtmpView.IRenderCallback(){

        @Override
        public void onSurfaceChanged(@NonNull RtmpView.ISurfaceHolder iSurfaceHolder, int n, int n2, int n3) {
            if (iSurfaceHolder.getRenderView() != MediaPlayer.this.mRenderView) {
                Log.e((String)MediaPlayer.TAG, (String)"onSurfaceChanged: unmatched render callback\n");
                return;
            }
            1 v0 = this;
            Log.d((String)MediaPlayer.TAG, (String)("surface changed, w=" + n2 + ",h=" + n3));
            MediaPlayer.access$102(v0.MediaPlayer.this, n2);
            MediaPlayer.access$202(v0.MediaPlayer.this, n3);
            v0.MediaPlayer.this.mRenderView.getView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        }

        @Override
        public void onSurfaceCreated(@NonNull RtmpView.ISurfaceHolder iSurfaceHolder, int n, int n2) {
            if (iSurfaceHolder.getRenderView() != MediaPlayer.this.mRenderView) {
                Log.e((String)MediaPlayer.TAG, (String)"onSurfaceCreated: unmatched render callback\n");
                return;
            }
            1 v0 = this;
            MediaPlayer.access$302(v0.MediaPlayer.this, iSurfaceHolder);
            if (v0.MediaPlayer.this.mPlayer != null) {
                iSurfaceHolder.bindToMediaPlayer(MediaPlayer.this.mPlayer);
            }
        }

        @Override
        public void onSurfaceDestroyed(@NonNull RtmpView.ISurfaceHolder iSurfaceHolder) {
            if (iSurfaceHolder.getRenderView() != MediaPlayer.this.mRenderView) {
                Log.e((String)MediaPlayer.TAG, (String)"onSurfaceDestroyed: unmatched render callback\n");
                return;
            }
            1 v0 = this;
            MediaPlayer.access$302(v0.MediaPlayer.this, null);
            if (v0.MediaPlayer.this.mPlayer != null) {
                MediaPlayer.this.mPlayer.setDisplay(null);
            }
        }
    };

    public MediaPlayer(AVParameters aVParameters) {
        this.mState = PLAYER_STATE.INIT;
        this.mParams = aVParameters;
    }

    private String getPullUrl() {
        return this.mParams.url;
    }

    private String infoToString(int n, int n2) {
        block14: {
            String string;
            StringBuilder stringBuilder;
            Object object = "Unknown info [" + n + "," + n2 + "]";
            switch (n) {
                default: {
                    break block14;
                }
                case 10002: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_AUDIO_RENDERING_START:";
                    break;
                }
                case 10001: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_VIDEO_ROTATION_CHANGED:";
                    break;
                }
                case 902: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_SUBTITLE_TIMED_OUT:";
                    break;
                }
                case 901: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_UNSUPPORTED_SUBTITLE:";
                    break;
                }
                case 802: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_METADATA_UPDATE:";
                    break;
                }
                case 801: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_NOT_SEEKABLE:";
                    break;
                }
                case 800: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_BAD_INTERLEAVING:";
                    break;
                }
                case 703: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_NETWORK_BANDWIDTH: ";
                    break;
                }
                case 702: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_BUFFERING_END:";
                    break;
                }
                case 701: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_BUFFERING_START:";
                    break;
                }
                case 700: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_VIDEO_TRACK_LAGGING:";
                    break;
                }
                case 3: {
                    stringBuilder = new StringBuilder();
                    string = "MEDIA_INFO_VIDEO_RENDERING_START:";
                }
            }
            object = stringBuilder.append(string).append(n2).toString();
        }
        return object;
    }

    private void setEnableMediaCodec(IjkMediaPlayer ijkMediaPlayer, boolean bl) {
        IjkMediaPlayer ijkMediaPlayer2 = ijkMediaPlayer;
        long l = (long)bl;
        ijkMediaPlayer2.setOption(4, "mediacodec", l);
        ijkMediaPlayer2.setOption(4, "mediacodec-auto-rotate", l);
        ijkMediaPlayer2.setOption(4, "mediacodec-handle-resolution-change", l);
    }

    private IMediaPlayer createPlayer(Context object, float f) {
        IjkMediaPlayer ijkMediaPlayer;
        MediaPlayer mediaPlayer = this;
        IjkMediaPlayer ijkMediaPlayer2 = ijkMediaPlayer;
        new IjkMediaPlayer(object).setOption(4, "framedrop", 0L);
        ijkMediaPlayer2.setOption(4, "packet-buffering", 0L);
        ijkMediaPlayer2.setOption(4, "reconnect", 1L);
        ijkMediaPlayer2.setOption(4, "infbuf", 1L);
        ijkMediaPlayer2.setOption(1, "http-detect-range-support", 0L);
        ijkMediaPlayer2.setOption(1, "analyzemaxduration", 100L);
        ijkMediaPlayer2.setOption(1, "analyzeduration", 1L);
        ijkMediaPlayer2.setOption(1, "probesize", 200L);
        ijkMediaPlayer2.setOption(1, "flush_packets", 1L);
        ijkMediaPlayer2.setOption(4, "max-buffer-size", 0L);
        ijkMediaPlayer2.setOption(4, "max_cached_duration", 30L);
        ijkMediaPlayer2.setOption(4, "fast", 1L);
        ijkMediaPlayer2.setOption(4, "min-frames", 2L);
        ijkMediaPlayer2.setOption(4, "soundtouch", 1L);
        ijkMediaPlayer2.setOption(2, "skip_loop_filter", 48L);
        ijkMediaPlayer2.setVolume(1.0f, 1.0f);
        IjkMediaPlayer.native_setLogLevel((int)8);
        mediaPlayer.setEnableMediaCodec(ijkMediaPlayer2, mediaPlayer.mEnableMediaCodec);
        object = mediaPlayer.mParams;
        if (object != null) {
            if (!object.enableVideo) {
                ijkMediaPlayer2.setOption(4, "vn", 1L);
            }
            if (!this.mParams.enableAudio) {
                ijkMediaPlayer2.setOption(4, "an", 1L);
            }
        }
        return ijkMediaPlayer2;
    }

    static /* synthetic */ int access$102(MediaPlayer mediaPlayer, int n) {
        mediaPlayer.mSurfaceWidth = n;
        return n;
    }

    static /* synthetic */ int access$202(MediaPlayer mediaPlayer, int n) {
        mediaPlayer.mSurfaceHeight = n;
        return n;
    }

    static /* synthetic */ RtmpView.ISurfaceHolder access$302(MediaPlayer mediaPlayer, RtmpView.ISurfaceHolder iSurfaceHolder) {
        mediaPlayer.mSurfaceHolder = iSurfaceHolder;
        return iSurfaceHolder;
    }

    static /* synthetic */ long access$502(MediaPlayer mediaPlayer, long l) {
        mediaPlayer.mPrepareEndTime = l;
        return l;
    }

    static /* synthetic */ PLAYER_STATE access$802(MediaPlayer mediaPlayer, PLAYER_STATE pLAYER_STATE) {
        mediaPlayer.mState = pLAYER_STATE;
        return pLAYER_STATE;
    }

    static /* synthetic */ int access$1002(MediaPlayer mediaPlayer, int n) {
        mediaPlayer.mVideoWidth = n;
        return n;
    }

    static /* synthetic */ int access$902(MediaPlayer mediaPlayer, int n) {
        mediaPlayer.mVideoHeight = n;
        return n;
    }

    static /* synthetic */ int access$1102(MediaPlayer mediaPlayer, int n) {
        mediaPlayer.mVideoSarNum = n;
        return n;
    }

    static /* synthetic */ int access$1202(MediaPlayer mediaPlayer, int n) {
        mediaPlayer.mVideoSarDen = n;
        return n;
    }

    public void setObserver(MediaPlayerObserver mediaPlayerObserver) {
        this.mObserver = mediaPlayerObserver;
    }

    public PLAYER_STATE getState() {
        return this.mState;
    }

    public String getId() {
        AVParameters aVParameters = ((MediaPlayer)((Object)aVParameters)).mParams;
        if (aVParameters != null) {
            return aVParameters.uid;
        }
        return "";
    }

    public boolean init(Context context) {
        String string;
        if (this.mParams.url.isEmpty()) {
            Log.e((String)TAG, (String)"av url not set, cannot init bjy media player");
            return false;
        }
        MediaPlayer mediaPlayer = this;
        this.mPrepareStartTime = System.currentTimeMillis();
        new JsonObject();
        try {
            this.mState = PLAYER_STATE.CREATING;
            mediaPlayer.mPlayer = mediaPlayer.createPlayer(context, this.mParams.buffer_tcp_default);
            string = mediaPlayer.getPullUrl();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        mediaPlayer.mPlayer.setOnPreparedListener(new IMediaPlayer.OnPreparedListener(){

            public void onPrepared(IMediaPlayer iMediaPlayer) {
                2 v0 = this;
                MediaPlayer.access$502(v0.MediaPlayer.this, System.currentTimeMillis());
                Log.i((String)MediaPlayer.TAG, (String)("onPrepared, elapse time:" + (MediaPlayer.this.mPrepareEndTime - MediaPlayer.this.mPrepareStartTime)));
                v0.MediaPlayer.this.mPlayer.start();
                if (v0.MediaPlayer.this.mObserver != null) {
                    MediaPlayer.this.mObserver.onPrepared();
                }
                MediaPlayer.access$802(MediaPlayer.this, PLAYER_STATE.PREPARED);
            }
        });
        mediaPlayer.mPlayer.setOnVideoSizeChangedListener(new IMediaPlayer.OnVideoSizeChangedListener(){

            public void onVideoSizeChanged(IMediaPlayer iMediaPlayer, int n, int n2, int n3, int n4) {
                Log.d((String)MediaPlayer.TAG, (String)("video size changed, w=" + n + " h=" + n2 + " n=" + n3 + " d=" + n4));
                if ((n2 > 0 && MediaPlayer.this.mVideoHeight != n2 || n > 0 && MediaPlayer.this.mVideoWidth != n) && MediaPlayer.this.mObserver != null) {
                    MediaPlayer.this.mObserver.onVideoSizeChanged(n, n2);
                }
                3 v0 = this;
                MediaPlayer.access$1002(v0.MediaPlayer.this, n);
                MediaPlayer.access$902(v0.MediaPlayer.this, n2);
                MediaPlayer.access$1102(v0.MediaPlayer.this, iMediaPlayer.getVideoSarNum());
                MediaPlayer.access$1202(v0.MediaPlayer.this, iMediaPlayer.getVideoSarDen());
                if (v0.MediaPlayer.this.mVideoWidth != 0 && MediaPlayer.this.mVideoHeight != 0 && MediaPlayer.this.mRenderView != null) {
                    3 v1 = this;
                    v1.MediaPlayer.this.mRenderView.setVideoSize(MediaPlayer.this.mVideoWidth, MediaPlayer.this.mVideoHeight);
                    v1.MediaPlayer.this.mRenderView.setVideoSampleAspectRatio(MediaPlayer.this.mVideoSarNum, MediaPlayer.this.mVideoSarDen);
                }
            }
        });
        mediaPlayer.mPlayer.setOnCompletionListener(new IMediaPlayer.OnCompletionListener(){

            public void onCompletion(IMediaPlayer iMediaPlayer) {
                Log.i((String)MediaPlayer.TAG, (String)"onCompletion");
                MediaPlayer.this.mObserver.onCompletion();
            }
        });
        mediaPlayer.mPlayer.setOnErrorListener(new IMediaPlayer.OnErrorListener(){

            public boolean onError(IMediaPlayer iMediaPlayer, int n, int n2) {
                Log.e((String)MediaPlayer.TAG, (String)("bjy media player got a error: [" + n + ", " + n2 + "]"));
                if (MediaPlayer.this.mObserver != null && n != -10001) {
                    MediaPlayer.this.mObserver.onError(n, n2);
                }
                return true;
            }
        });
        mediaPlayer.mPlayer.setOnInfoListener(new IMediaPlayer.OnInfoListener(){

            public boolean onInfo(IMediaPlayer iMediaPlayer, int n, int n2) {
                Log.i((String)MediaPlayer.TAG, (String)("onInfo, " + MediaPlayer.this.infoToString(n, n2)));
                return true;
            }
        });
        mediaPlayer.mPlayer.setOnSeekCompleteListener(new IMediaPlayer.OnSeekCompleteListener(){

            public void onSeekComplete(IMediaPlayer iMediaPlayer) {
                if (MediaPlayer.this.mObserver != null) {
                    MediaPlayer.this.mObserver.onSeekComplete();
                }
            }
        });
        mediaPlayer.mPlayer.setOnBufferingUpdateListener(new IMediaPlayer.OnBufferingUpdateListener(){

            public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int n) {
                if (MediaPlayer.this.mObserver != null) {
                    MediaPlayer.this.mObserver.onBufferingUpdate(n);
                }
            }
        });
        mediaPlayer.mPlayer.setDataSource(context, Uri.parse((String)string));
        mediaPlayer.mPlayer.prepareAsync();
        return true;
    }

    public void setMixedStreamDisplayMode(int n) {
        RtmpView rtmpView = ((MediaPlayer)((Object)rtmpView)).mRenderView;
        if (rtmpView != null) {
            rtmpView.setAspectRatio(n);
        }
    }

    public void setRenderView(RtmpView rtmpView) {
        int n;
        if (this.mRenderView != null) {
            IMediaPlayer iMediaPlayer = this.mPlayer;
            if (iMediaPlayer != null) {
                iMediaPlayer.setDisplay(null);
            }
            this.mRenderView.removeRenderCallback(this.mSHCallback);
            this.mRenderView = null;
        }
        if (rtmpView == null) {
            return;
        }
        this.mRenderView = rtmpView;
        int n2 = this.mVideoWidth;
        if (n2 > 0 && (n = this.mVideoHeight) > 0) {
            rtmpView.setVideoSize(n2, n);
        }
        if ((n2 = this.mVideoSarNum) > 0 && (n = this.mVideoSarDen) > 0) {
            rtmpView.setVideoSampleAspectRatio(n2, n);
        }
        MediaPlayer mediaPlayer = this;
        mediaPlayer.mRenderView.getView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        Log.d((String)TAG, (String)("setRenderView mVideoWidth=" + this.mVideoWidth + " mVideoHeight=" + this.mVideoHeight + " mVideoSarNum" + this.mVideoSarNum + " mVideoSarDen" + this.mVideoSarDen));
        mediaPlayer.mRenderView.addRenderCallback(this.mSHCallback);
        mediaPlayer.mRenderView.setVideoRotation(this.mVideoRotationDegree);
    }

    public void setVolume(int n, int n2) {
        Log.i((String)TAG, (String)("setVolume: " + n + ", " + n2));
        float f = n;
        this.mPlayer.setVolume(f, (float)n2);
    }

    public void enableMediaCodec(boolean bl) {
        this.mEnableMediaCodec = bl;
    }

    public int getVideoWidth() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            return mediaPlayer.getVideoWidth();
        }
        return 0;
    }

    public int getVideoHeight() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            return mediaPlayer.getVideoHeight();
        }
        return 0;
    }

    public void setSpeed(float f) {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.setSpeed(f);
        }
    }

    public void seekTo(int n) {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.seekTo(n);
        }
    }

    public long getCurrentPosition() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            return mediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    public void resume() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.start();
        }
    }

    public void pause() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.pause();
        }
    }

    public long getDuration() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            return mediaPlayer.getDuration();
        }
        return 0L;
    }

    public boolean isVideoQueueEmpty() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            return ((IjkMediaPlayer)mediaPlayer).isVideoQueueEmpty() == 1;
        }
        return false;
    }

    public boolean isAudioQueueEmpty() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            return ((IjkMediaPlayer)mediaPlayer).isAudioQueueEmpty() == 1;
        }
        return false;
    }

    public float getVideoOutputFps() {
        MediaPlayer mediaPlayer = mediaPlayer.mPlayer;
        if (mediaPlayer != null) {
            return ((IjkMediaPlayer)mediaPlayer).getVideoOutputFramesPerSecond();
        }
        return 0.0f;
    }

    public void dispose() {
        this.mState = PLAYER_STATE.STOPPING;
        if (this.mPlayer != null) {
            MediaPlayer mediaPlayer = this;
            Log.i((String)TAG, (String)"---=== Dispose bjy media player");
            try {
                mediaPlayer.mPlayer.stop();
            }
            catch (IllegalStateException illegalStateException) {
                Log.e((String)TAG, (String)("Dispose bjy media player state exception:" + illegalStateException.getMessage()));
                illegalStateException.printStackTrace();
            }
            this.mPlayer.release();
            this.mPlayer = null;
            this.mState = PLAYER_STATE.DISPOSED;
        }
    }

    public static enum PLAYER_STATE {
        UINT,
        INIT,
        CREATING,
        PREPARED,
        COMPLETE,
        STOPPING,
        DISPOSED;

    }

    public static class AVParameters {
        public String uid;
        public String url;
        public RtmpView view;
        public int sessType;
        public boolean enableAudio;
        public boolean enableVideo;
        public boolean enableMediaCodec;
        public boolean isAutoClose;
        public float buffer_tcp_default;

        public AVParameters(String string, String string2, RtmpView rtmpView, int n, boolean bl, boolean bl2, boolean bl3, float f) {
            this.uid = string;
            this.url = string2;
            this.enableAudio = bl;
            this.enableVideo = bl2;
            this.enableMediaCodec = bl3;
            this.view = rtmpView;
            this.sessType = n;
            this.isAutoClose = false;
            this.buffer_tcp_default = f;
        }
    }
}

