/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine.EventHandler;

import android.os.Bundle;
import android.text.TextUtils;
import com.baijiayun.bjyrtcengine.BJYRtcEventObserver;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcErrors;
import com.baijiayun.bjyrtcengine.Defines.TencentPeer;
import com.baijiayun.bjyrtcengine.Enums;
import com.baijiayun.bjyrtcengine.TcAdapter;
import com.baijiayun.utils.LogUtil;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import com.tencent.trtc.TRTCStatistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TcEngineEventListenerImpl
extends TRTCCloudListener {
    private static final String TAG = "bjyrtc-BJYRtcEngineImpl";
    private TcAdapter tcAdapter;
    private BJYRtcEventObserver mObserver;
    private TencentPeer mLocalUserPeer;
    private final Map<Integer, TencentPeer> mAllPeers;

    public TcEngineEventListenerImpl(TcAdapter tcAdapter) {
        HashMap hashMap;
        TencentPeer tencentPeer;
        Object object = tencentPeer;
        tencentPeer = new TencentPeer(-1);
        v1.mLocalUserPeer = object;
        object = hashMap;
        hashMap = new HashMap();
        v1.mAllPeers = object;
        v1.tcAdapter = tcAdapter;
    }

    public void onRemoteUserEnterRoom(String string) {
        LogUtil.i((Object)TAG, (String)("onRemoteUserEnterRoom " + string));
        int n = Enums.userIdToUid(string);
        if (!this.mAllPeers.containsKey(n)) {
            TencentPeer tencentPeer;
            TcEngineEventListenerImpl tcEngineEventListenerImpl = this;
            TencentPeer tencentPeer2 = tencentPeer;
            tencentPeer = new TencentPeer(n);
            tcEngineEventListenerImpl.mAllPeers.put(n, tencentPeer2);
            if (tcEngineEventListenerImpl.mObserver != null) {
                int n2 = n;
                String string2 = Enums.convertBRTCUidToBJYUid(n2);
                int n3 = Enums.getSessionTypeFromUserId(n2);
                TencentPeer tencentPeer3 = this.mLocalUserPeer;
                if (tencentPeer3 != null) {
                    tencentPeer3.setHasFiredPublishResult(true);
                }
                LogUtil.i((Object)TAG, (String)("[callback] onPublishResult, uid=" + string2 + ", sessType=" + n3 + ", from onUserJoined"));
                this.mObserver.onPublishResult(n3, string2);
            }
        }
    }

    public void onUserSubStreamAvailable(String string, boolean bl) {
        LogUtil.i((Object)TAG, (String)("onUserSubStreamAvailable : The uid is [" + string + "] publish or unpub " + bl));
    }

    public void onRemoteUserLeaveRoom(String string, int n) {
        LogUtil.i((Object)TAG, (String)("onRemoteUserLeaveRoom : uid is [" + string + "]  var2: " + n));
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        if (n2 == -1) {
            return;
        }
        int n3 = n2;
        String string2 = Enums.convertTencentUidToBJYUid(n3);
        int n4 = Enums.getSessionTypeFromUserId(n3);
        if (this.mObserver != null && n4 == 0) {
            TcEngineEventListenerImpl tcEngineEventListenerImpl = this;
            tcEngineEventListenerImpl.mAllPeers.remove(n2);
            tcEngineEventListenerImpl.tcAdapter.unsubscribe(string2, n4, false);
            tcEngineEventListenerImpl.mObserver.onUnpublishResult(n4, string2);
        }
    }

    public void onError(int n, String string, Bundle bundle) {
        LogUtil.i((Object)TAG, (String)("onError: status code is " + string));
        if (n == -1308) {
            object.tcAdapter.stopScreenCapture();
        }
        if ((object = object.mObserver) != null) {
            BJYRtcErrors bJYRtcErrors;
            TcEngineEventListenerImpl tcEngineEventListenerImpl = object;
            Object object = bJYRtcErrors;
            bJYRtcErrors = new BJYRtcErrors(n, string);
            ((BJYRtcEventObserver)((Object)tcEngineEventListenerImpl)).onOccurError((BJYRtcErrors)object);
        }
    }

    public void onWarning(int n, String string, Bundle bundle) {
    }

    public void onEnterRoom(long l) {
        LogUtil.i((Object)TAG, (String)("onEnterRoomResult: status code is " + l));
        BJYRtcEventObserver bJYRtcEventObserver = ((TcEngineEventListenerImpl)((Object)bJYRtcEventObserver)).mObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onJoinRoomResult(0);
        }
    }

    public void onExitRoom(int n) {
        LogUtil.i((Object)TAG, (String)("onExitRoomResult: status code is " + n));
        this.mAllPeers.clear();
    }

    public void onUserEnter(String string) {
    }

    public void onUserExit(String string, int n) {
    }

    public void onUserVideoAvailable(String string, boolean bl) {
        TencentPeer tencentPeer;
        int n = Integer.parseInt(string);
        if (this.mAllPeers.containsKey(n)) {
            tencentPeer = this.mAllPeers.get(n);
        } else {
            TencentPeer tencentPeer2;
            tencentPeer = tencentPeer2;
            tencentPeer2 = new TencentPeer(n);
            this.mAllPeers.put(n, tencentPeer);
        }
        int n2 = n;
        tencentPeer.setVideoAttach(bl);
        LogUtil.i((Object)TAG, (String)("Current peers count is :[" + this.mAllPeers.size() + "]"));
        String string2 = Enums.convertTencentUidToBJYUid(n2);
        int n3 = Enums.getSessionTypeFromUserId(n2);
        LogUtil.i((Object)TAG, (String)("onUserVideoAvailable: The userId is:[" + string2 + "] Session Type is : [" + n3 + "] available :[" + bl + "]"));
        if (this.mObserver != null) {
            if (bl) {
                if (!tencentPeer.hasFiredPublishResult()) {
                    LogUtil.i((Object)TAG, (String)("[callback] onPublishResult : The userId is:[" + string2 + "] Session Type is : [" + n3));
                    tencentPeer.setHasFiredPublishResult(true);
                    this.mObserver.onPublishResult(n3, string2);
                }
                this.onRemoteVideoAvailable(string2, n3, true);
            } else {
                this.onRemoteVideoAvailable(string2, n3, false);
                if (tencentPeer.hasFiredPublishResult() && !tencentPeer.isAudioAttach()) {
                    tencentPeer.setHasFiredPublishResult(false);
                    this.mAllPeers.remove(Integer.parseInt(string2));
                }
            }
        }
    }

    public void onUserAudioAvailable(String string, boolean bl) {
        TencentPeer tencentPeer;
        int n = Integer.parseInt(string);
        if (this.mAllPeers.containsKey(n)) {
            tencentPeer = this.mAllPeers.get(n);
        } else {
            TencentPeer tencentPeer2;
            tencentPeer = tencentPeer2;
            tencentPeer2 = new TencentPeer(n);
            this.mAllPeers.put(n, tencentPeer);
        }
        if (tencentPeer != null) {
            tencentPeer.setAudioAttach(bl);
        }
        if (!this.mAllPeers.containsKey(n)) {
            this.mAllPeers.put(n, tencentPeer);
        }
        int n2 = n;
        String string2 = Enums.convertTencentUidToBJYUid(n2);
        int n3 = Enums.getSessionTypeFromUserId(n2);
        LogUtil.i((Object)TAG, (String)("onUserAudioAvailable: The userId is:[" + string2 + "] Session Type is : [" + n3 + "] available :[" + bl + "]"));
        if (bl) {
            if (!tencentPeer.hasFiredPublishResult()) {
                tencentPeer.setHasFiredPublishResult(true);
                this.mObserver.onPublishResult(n3, string2);
            }
            this.mObserver.onRemoteAudioAvailable(string2, n3, true);
        } else {
            this.mObserver.onRemoteAudioAvailable(string2, n3, false);
            if (tencentPeer.hasFiredPublishResult() && !tencentPeer.isVideoAttach()) {
                tencentPeer.setHasFiredPublishResult(false);
                this.mAllPeers.remove(Integer.parseInt(string2));
            }
        }
    }

    public void onUserVoiceVolume(ArrayList<TRTCCloudDef.TRTCVolumeInfo> arrayList, int n) {
    }

    public void onNetworkQuality(TRTCCloudDef.TRTCQuality tRTCQuality, ArrayList<TRTCCloudDef.TRTCQuality> arrayList) {
    }

    public void onStatistics(TRTCStatistics tRTCStatistics) {
        Object object;
        for (Object object2 : tRTCStatistics.remoteArray) {
            BJYRtcEventObserver.RemoteStreamStats remoteStreamStats;
            BJYRtcEventObserver.RemoteStreamStats remoteStreamStats2;
            if (this.mObserver == null) continue;
            TcEngineEventListenerImpl tcEngineEventListenerImpl = this;
            object = ((TRTCStatistics.TRTCRemoteStatistics)object2).userId;
            tcEngineEventListenerImpl.mAllPeers.get(Integer.valueOf((String)object));
            BJYRtcEventObserver.RemoteStreamStats remoteStreamStats3 = remoteStreamStats2 = remoteStreamStats;
            remoteStreamStats2();
            remoteStreamStats2.fps = ((TRTCStatistics.TRTCRemoteStatistics)object2).frameRate;
            remoteStreamStats2.height = ((TRTCStatistics.TRTCRemoteStatistics)object2).height;
            remoteStreamStats2.receivedVideoBitrate = ((TRTCStatistics.TRTCRemoteStatistics)object2).videoBitrate;
            remoteStreamStats2.receivedAudioBitrate = ((TRTCStatistics.TRTCRemoteStatistics)object2).audioBitrate;
            remoteStreamStats2.width = ((TRTCStatistics.TRTCRemoteStatistics)object2).width;
            remoteStreamStats3.uid = object;
            remoteStreamStats3.sessType = BJYRtcCommon.BJYSessionType.BJY_SESSION_CAMERA_MASTER;
            remoteStreamStats.receivedVideoLostRate = ((TRTCStatistics.TRTCRemoteStatistics)object2).finalLoss;
            object2 = tcEngineEventListenerImpl.mObserver;
            if (object2 == null) continue;
            ((BJYRtcEventObserver)object2).onRemoteStreamStats((String)object, remoteStreamStats2);
        }
        for (Object object2 : tRTCStatistics.localArray) {
            BJYRtcEventObserver.LocalStreamStats localStreamStats;
            if (this.mObserver == null) continue;
            object = localStreamStats;
            ((BJYRtcEventObserver.LocalStreamStats)object)();
            ((BJYRtcEventObserver.LocalStreamStats)object).audioBitrateSent = ((TRTCStatistics.TRTCLocalStatistics)object2).audioBitrate;
            ((BJYRtcEventObserver.LocalStreamStats)object).videoBitrateSent = ((TRTCStatistics.TRTCLocalStatistics)object2).videoBitrate;
            ((BJYRtcEventObserver.LocalStreamStats)object).fpsSent = ((TRTCStatistics.TRTCLocalStatistics)object2).frameRate;
            ((BJYRtcEventObserver.LocalStreamStats)object).width = ((TRTCStatistics.TRTCLocalStatistics)object2).width;
            localStreamStats.height = ((TRTCStatistics.TRTCLocalStatistics)object2).height;
            localStreamStats.sessionType = BJYRtcCommon.BJYSessionType.BJY_SESSION_CAMERA_MASTER;
            int n = tRTCStatistics.upLoss;
            if (n != 100) {
                ((BJYRtcEventObserver.LocalStreamStats)object).videoPacketsLostRateSent = n;
                ((BJYRtcEventObserver.LocalStreamStats)object).uploadLossRate = n;
            }
            ((BJYRtcEventObserver.LocalStreamStats)object).downloadLossRate = tRTCStatistics.downLoss;
            object2 = this.mObserver;
            if (object2 == null) continue;
            ((BJYRtcEventObserver)object2).onLocalStreamStats((BJYRtcEventObserver.LocalStreamStats)object);
        }
    }

    public void onFirstAudioFrame(String string) {
    }

    public void onFirstVideoFrame(String string, int n, int n2, int n3) {
        LogUtil.i((Object)TAG, (String)("[call back] onFirstVideoFrame: userId == [" + string + "]streamType == [" + n + "] width=" + n2 + ", height=" + n3));
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = String.valueOf(this.mLocalUserPeer.getUid());
        }
        TcEngineEventListenerImpl tcEngineEventListenerImpl = this;
        int n4 = Integer.parseInt(string);
        String string2 = Enums.convertTencentUidToBJYUid(n4);
        n2 = Enums.getSessionTypeFromUserId(n4);
        TencentPeer tencentPeer = tcEngineEventListenerImpl.mAllPeers.get(n4);
        if (tcEngineEventListenerImpl.mObserver != null && tencentPeer != null) {
            tencentPeer.setmHasFiredFirstVideoFrame(true);
            this.mObserver.onFirstFrameAvailable(string2, n2);
        }
    }

    public void onSendFirstLocalVideoFrame(int n) {
        LogUtil.i((Object)TAG, (String)("onSendFirstLocalVideoFrame:Code is [" + n + "]"));
        if (this.mObserver != null && !this.mLocalUserPeer.hasFiredPublishResult()) {
            this.mLocalUserPeer.setHasFiredPublishResult(true);
        }
    }

    public void onSendFirstLocalAudioFrame() {
        LogUtil.i((Object)TAG, (String)"onSendFirstLocalAudioFrame Success!");
        if (this.mObserver != null && !this.mLocalUserPeer.hasFiredPublishResult()) {
            this.mLocalUserPeer.setHasFiredPublishResult(true);
        }
    }

    public void onScreenCaptureStarted() {
        BJYRtcEventObserver bJYRtcEventObserver = ((TcEngineEventListenerImpl)((Object)bJYRtcEventObserver)).mObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onScreenCaptureStarted();
        }
    }

    public void onScreenCapturePaused() {
        BJYRtcEventObserver bJYRtcEventObserver = ((TcEngineEventListenerImpl)((Object)bJYRtcEventObserver)).mObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onScreenCapturePaused();
        }
    }

    public void onScreenCaptureResumed() {
        BJYRtcEventObserver bJYRtcEventObserver = ((TcEngineEventListenerImpl)((Object)bJYRtcEventObserver)).mObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onScreenCaptureResumed();
        }
    }

    public void onScreenCaptureStopped(int n) {
        BJYRtcEventObserver bJYRtcEventObserver = ((TcEngineEventListenerImpl)((Object)bJYRtcEventObserver)).mObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onScreenCaptureStoped(n);
        }
    }

    public void onSubscribedResult(int n, String string) {
        LogUtil.i((Object)TAG, (String)("onSubscribeResult : sType is [" + n + "] uid is [" + string + "]"));
        BJYRtcEventObserver bJYRtcEventObserver = ((TcEngineEventListenerImpl)((Object)bJYRtcEventObserver)).mObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onSubscribeResult(n, string, null);
        }
    }

    public void setEngineObserver(BJYRtcEventObserver bJYRtcEventObserver) {
        this.mObserver = bJYRtcEventObserver;
    }

    public void setLocalUserId(String string) {
        TcEngineEventListenerImpl tcEngineEventListenerImpl;
        object.mLocalUserPeer = new TencentPeer(Integer.parseInt(string));
        TcEngineEventListenerImpl tcEngineEventListenerImpl2 = object;
        Object object = Integer.valueOf(string);
        tcEngineEventListenerImpl.mAllPeers.put((Integer)object, tcEngineEventListenerImpl2.mLocalUserPeer);
    }

    public void onRemoteVideoAvailable(String string, int n, boolean bl) {
        LogUtil.i((Object)TAG, (String)("onRemoteVideoAvailable , uid:[" + string + "], sType :[" + n + "]"));
        try {
            int n2 = Integer.parseInt(Enums.convertUid(string, n));
            BJYRtcEventObserver bJYRtcEventObserver = ((TcEngineEventListenerImpl)((Object)this)).mObserver;
            if (bJYRtcEventObserver != null) {
                bJYRtcEventObserver.onRemoteVideoAvailable(string, n, bl);
                if (bl && ((TcEngineEventListenerImpl)((Object)this)).mAllPeers.containsKey(n2) && (this = ((TcEngineEventListenerImpl)((Object)this)).mAllPeers.get(n2)) != null && !((TencentPeer)this).hasFiredFirstVideoFrame()) {
                    ((TencentPeer)this).setmHasFiredFirstVideoFrame(true);
                }
            }
            return;
        }
        catch (Exception exception) {
            LogUtil.i((Object)TAG, (String)"uid convert error!!!");
            exception.printStackTrace();
            return;
        }
    }

    public void setTcAdapter(TcAdapter tcAdapter) {
        this.tcAdapter = tcAdapter;
    }

    public void unsubscribed(int n, String string) {
        TcEngineEventListenerImpl tcEngineEventListenerImpl = this;
        LogUtil.i((Object)TAG, (String)("onUnsubscribeResult: uid = [" + string + "] sType = [" + n + ""));
        int n2 = Integer.parseInt(Enums.convertUid(string, n));
        tcEngineEventListenerImpl.mAllPeers.put(n2, new TencentPeer(n2));
        BJYRtcEventObserver bJYRtcEventObserver = tcEngineEventListenerImpl.mObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onUnsubscribeResult(n, string);
        }
    }

    public void onUnpublishResult(int n, String string) {
        LogUtil.i((Object)TAG, (String)("onUnpublishResult: uid = [" + string + "] sType = [" + n + ""));
        BJYRtcEventObserver bJYRtcEventObserver = ((TcEngineEventListenerImpl)((Object)bJYRtcEventObserver)).mObserver;
        if (bJYRtcEventObserver != null) {
            bJYRtcEventObserver.onUnpublishResult(n, string);
        }
    }

    public void onPublishResult(int n, String string) {
        if (this.mObserver != null) {
            TencentPeer tencentPeer = this.mLocalUserPeer;
            if (tencentPeer != null) {
                tencentPeer.setHasFiredPublishResult(true);
            }
            this.mObserver.onPublishResult(n, string);
        }
    }
}

