/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.bjyrtcengine.player;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.bjyrtcengine.player.MeasureHelper;
import com.baijiayun.bjyrtcengine.player.RtmpView;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tv.danmaku.ijk.media.bjplayer.IMediaPlayer;
import tv.danmaku.ijk.media.bjplayer.ISurfaceTextureHolder;

public class SurfaceRenderView
extends SurfaceView
implements RtmpView {
    private MeasureHelper mMeasureHelper;
    private SurfaceCallback mSurfaceCallback;

    public SurfaceRenderView(Context context) {
        SurfaceRenderView surfaceRenderView = this;
        super(context);
        surfaceRenderView.initView(context);
    }

    public SurfaceRenderView(Context context, AttributeSet attributeSet) {
        SurfaceRenderView surfaceRenderView = this;
        super(context, attributeSet);
        surfaceRenderView.initView(context);
    }

    public SurfaceRenderView(Context context, AttributeSet attributeSet, int n) {
        SurfaceRenderView surfaceRenderView = this;
        super(context, attributeSet, n);
        surfaceRenderView.initView(context);
    }

    @TargetApi(value=21)
    public SurfaceRenderView(Context context, AttributeSet attributeSet, int n, int n2) {
        SurfaceRenderView surfaceRenderView = this;
        super(context, attributeSet, n, n2);
        surfaceRenderView.initView(context);
    }

    private void initView(Context context) {
        SurfaceRenderView surfaceRenderView = this;
        surfaceRenderView.mMeasureHelper = new MeasureHelper((View)this);
        surfaceRenderView.mSurfaceCallback = new SurfaceCallback(this);
        surfaceRenderView.getHolder().addCallback((SurfaceHolder.Callback)this.mSurfaceCallback);
        surfaceRenderView.getHolder().setType(0);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public boolean shouldWaitForResize() {
        return true;
    }

    @Override
    public void setVideoSize(int n, int n2) {
        if (n > 0 && n2 > 0) {
            SurfaceRenderView surfaceRenderView = this;
            surfaceRenderView.mMeasureHelper.setVideoSize(n, n2);
            surfaceRenderView.getHolder().setFixedSize(n, n2);
            surfaceRenderView.requestLayout();
        }
    }

    @Override
    public void setVideoSampleAspectRatio(int n, int n2) {
        if (n > 0 && n2 > 0) {
            SurfaceRenderView surfaceRenderView = this;
            surfaceRenderView.mMeasureHelper.setVideoSampleAspectRatio(n, n2);
            surfaceRenderView.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int n) {
        Log.e((String)"", (String)("SurfaceView doesn't support rotation (" + n + ")!\n"));
    }

    @Override
    public void setAspectRatio(int n) {
        SurfaceRenderView surfaceRenderView = this;
        surfaceRenderView.mMeasureHelper.setAspectRatio(n);
        surfaceRenderView.requestLayout();
    }

    protected void onMeasure(int n, int n2) {
        SurfaceRenderView surfaceRenderView = this;
        surfaceRenderView.mMeasureHelper.doMeasure(n, n2);
        surfaceRenderView.setMeasuredDimension(surfaceRenderView.mMeasureHelper.getMeasuredWidth(), this.mMeasureHelper.getMeasuredHeight());
    }

    @Override
    public void addRenderCallback(RtmpView.IRenderCallback iRenderCallback) {
        this.mSurfaceCallback.addRenderCallback(iRenderCallback);
    }

    @Override
    public void removeRenderCallback(RtmpView.IRenderCallback iRenderCallback) {
        this.mSurfaceCallback.removeRenderCallback(iRenderCallback);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)SurfaceRenderView.class.getName());
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        if (Build.VERSION.SDK_INT >= 14) {
            accessibilityNodeInfo.setClassName((CharSequence)SurfaceRenderView.class.getName());
        }
    }

    private static final class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceHolder mSurfaceHolder;
        private boolean mIsFormatChanged;
        private int mFormat;
        private int mWidth;
        private int mHeight;
        private WeakReference<SurfaceRenderView> mWeakSurfaceView;
        private Map<RtmpView.IRenderCallback, Object> mRenderCallbackMap;

        public SurfaceCallback(@NonNull SurfaceRenderView surfaceRenderView) {
            WeakReference<SurfaceRenderView> weakReference;
            ConcurrentHashMap concurrentHashMap;
            Object object = concurrentHashMap;
            concurrentHashMap = new ConcurrentHashMap();
            v1.mRenderCallbackMap = object;
            object = weakReference;
            weakReference = new WeakReference<SurfaceRenderView>(surfaceRenderView);
            v1.mWeakSurfaceView = object;
        }

        public void addRenderCallback(@NonNull RtmpView.IRenderCallback iRenderCallback) {
            SurfaceCallback surfaceCallback = this;
            RtmpView.IRenderCallback iRenderCallback2 = iRenderCallback;
            surfaceCallback.mRenderCallbackMap.put(iRenderCallback2, iRenderCallback2);
            InternalSurfaceHolder internalSurfaceHolder = null;
            if (surfaceCallback.mSurfaceHolder != null) {
                InternalSurfaceHolder internalSurfaceHolder2;
                SurfaceCallback surfaceCallback2 = this;
                internalSurfaceHolder = internalSurfaceHolder2;
                SurfaceCallback surfaceCallback3 = this;
                SurfaceRenderView surfaceRenderView = (SurfaceRenderView)surfaceCallback3.mWeakSurfaceView.get();
                internalSurfaceHolder2 = new InternalSurfaceHolder(surfaceRenderView, surfaceCallback3.mSurfaceHolder);
                int n = surfaceCallback2.mWidth;
                int n2 = surfaceCallback2.mHeight;
                iRenderCallback.onSurfaceCreated(internalSurfaceHolder, n, n2);
            }
            if (this.mIsFormatChanged) {
                if (internalSurfaceHolder == null) {
                    InternalSurfaceHolder internalSurfaceHolder3;
                    internalSurfaceHolder = internalSurfaceHolder3;
                    SurfaceCallback surfaceCallback4 = this;
                    SurfaceRenderView surfaceRenderView = (SurfaceRenderView)surfaceCallback4.mWeakSurfaceView.get();
                    internalSurfaceHolder3 = new InternalSurfaceHolder(surfaceRenderView, surfaceCallback4.mSurfaceHolder);
                }
                SurfaceCallback surfaceCallback5 = this;
                int n = surfaceCallback5.mFormat;
                int n3 = surfaceCallback5.mWidth;
                int n4 = surfaceCallback5.mHeight;
                iRenderCallback.onSurfaceChanged(internalSurfaceHolder, n, n3, n4);
            }
        }

        public void removeRenderCallback(@NonNull RtmpView.IRenderCallback iRenderCallback) {
            this.mRenderCallbackMap.remove(iRenderCallback);
        }

        public void surfaceCreated(SurfaceHolder object) {
            SurfaceCallback surfaceCallback;
            InternalSurfaceHolder internalSurfaceHolder;
            ((SurfaceCallback)((Object)iterator)).mSurfaceHolder = object;
            ((SurfaceCallback)((Object)iterator)).mIsFormatChanged = false;
            ((SurfaceCallback)((Object)iterator)).mFormat = 0;
            ((SurfaceCallback)((Object)iterator)).mWidth = 0;
            ((SurfaceCallback)((Object)iterator)).mHeight = 0;
            object = internalSurfaceHolder;
            SurfaceCallback surfaceCallback2 = iterator;
            Iterator<RtmpView.IRenderCallback> iterator = (SurfaceRenderView)surfaceCallback2.mWeakSurfaceView.get();
            internalSurfaceHolder = new InternalSurfaceHolder((SurfaceRenderView)((Object)iterator), surfaceCallback2.mSurfaceHolder);
            iterator = surfaceCallback.mRenderCallbackMap.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next().onSurfaceCreated((RtmpView.ISurfaceHolder)object, 0, 0);
            }
        }

        public void surfaceDestroyed(SurfaceHolder object) {
            SurfaceCallback surfaceCallback;
            InternalSurfaceHolder internalSurfaceHolder;
            ((SurfaceCallback)((Object)iterator)).mSurfaceHolder = null;
            ((SurfaceCallback)((Object)iterator)).mIsFormatChanged = false;
            ((SurfaceCallback)((Object)iterator)).mFormat = 0;
            ((SurfaceCallback)((Object)iterator)).mWidth = 0;
            ((SurfaceCallback)((Object)iterator)).mHeight = 0;
            object = internalSurfaceHolder;
            SurfaceCallback surfaceCallback2 = iterator;
            Iterator<RtmpView.IRenderCallback> iterator = (SurfaceRenderView)surfaceCallback2.mWeakSurfaceView.get();
            internalSurfaceHolder = new InternalSurfaceHolder((SurfaceRenderView)((Object)iterator), surfaceCallback2.mSurfaceHolder);
            iterator = surfaceCallback.mRenderCallbackMap.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next().onSurfaceDestroyed((RtmpView.ISurfaceHolder)object);
            }
        }

        public void surfaceChanged(SurfaceHolder object, int n, int n2, int n3) {
            SurfaceCallback surfaceCallback;
            InternalSurfaceHolder internalSurfaceHolder;
            SurfaceCallback surfaceCallback2 = iterator;
            surfaceCallback2.mSurfaceHolder = object;
            surfaceCallback2.mIsFormatChanged = true;
            ((SurfaceCallback)((Object)iterator)).mFormat = n;
            ((SurfaceCallback)((Object)iterator)).mWidth = n2;
            ((SurfaceCallback)((Object)iterator)).mHeight = n3;
            object = internalSurfaceHolder;
            SurfaceCallback surfaceCallback3 = iterator;
            Iterator<RtmpView.IRenderCallback> iterator = (SurfaceRenderView)surfaceCallback3.mWeakSurfaceView.get();
            internalSurfaceHolder = new InternalSurfaceHolder((SurfaceRenderView)((Object)iterator), surfaceCallback3.mSurfaceHolder);
            iterator = surfaceCallback.mRenderCallbackMap.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next().onSurfaceChanged((RtmpView.ISurfaceHolder)object, n, n2, n3);
            }
        }
    }

    private static final class InternalSurfaceHolder
    implements RtmpView.ISurfaceHolder {
        private SurfaceRenderView mSurfaceView;
        private SurfaceHolder mSurfaceHolder;

        public InternalSurfaceHolder(@NonNull SurfaceRenderView surfaceRenderView, @Nullable SurfaceHolder surfaceHolder) {
            this.mSurfaceView = surfaceRenderView;
            this.mSurfaceHolder = surfaceHolder;
        }

        @Override
        public void bindToMediaPlayer(IMediaPlayer iMediaPlayer) {
            if (iMediaPlayer != null) {
                if (iMediaPlayer instanceof ISurfaceTextureHolder) {
                    ((ISurfaceTextureHolder)iMediaPlayer).setSurfaceTexture(null);
                }
                iMediaPlayer.setDisplay(this.mSurfaceHolder);
            }
        }

        @Override
        @NonNull
        public RtmpView getRenderView() {
            return this.mSurfaceView;
        }

        @Override
        @Nullable
        public SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        @Override
        @Nullable
        public SurfaceTexture getSurfaceTexture() {
            return null;
        }

        @Override
        @Nullable
        public Surface openSurface() {
            InternalSurfaceHolder internalSurfaceHolder = internalSurfaceHolder.mSurfaceHolder;
            if (internalSurfaceHolder == null) {
                return null;
            }
            return internalSurfaceHolder.getSurface();
        }
    }
}

